package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusiCardApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiCardApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiCardApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiCardApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 名片申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Api(tags = "名片申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tBusiCardApply")
@Slf4j
public class TBusiCardApplyController {

private final TBusiCardApplyService tBusiCardApplyService;

    /**
     * 名片申请-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @GlobalTransactional
    @ApiOperation("名片申请-新增")
    public TwOutputUtil<TBusiCardApplyVO> insert(@RequestBody TBusiCardApplyPayload payload){
         return TwOutputUtil.ok(tBusiCardApplyService.insert(payload));
    }

    /**
     * 名片申请-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("名片申请-更新")
    public TwOutputUtil<TBusiCardApplyVO> update(@RequestBody TBusiCardApplyPayload payload){
        return TwOutputUtil.ok(tBusiCardApplyService.update(payload));
    }

    /**
     * 名片申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("名片申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TBusiCardApplyPayload payload){
        return TwOutputUtil.ok(tBusiCardApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 名片申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("名片申请-主键查询")
    public TwOutputUtil<TBusiCardApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tBusiCardApplyService.queryByKey(key));
    }

    /**
     * 名片申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("名片申请-分页")
    public TwOutputUtil<PagingVO<TBusiCardApplyVO>> paging(TBusiCardApplyQuery query) {
        return TwOutputUtil.ok(tBusiCardApplyService.queryPaging(query));
    }

    /**
     * 名片申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("名片申请-查询列表")
    public TwOutputUtil<List<TBusiCardApplyVO>> queryList(TBusiCardApplyQuery query) {
        return TwOutputUtil.ok(tBusiCardApplyService.queryListDynamic(query));
    }

    /**
     * 名片申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("名片申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tBusiCardApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

