package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TBusiSignetApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiSignetApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiSignetApplyVO;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiSignetApplyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 用印申请
 *
 * @folder 用印申请
 * @author wangly
 * @date 2023-09-14
 */
@Api(tags = "用印申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tBusiSignetApply")
@Slf4j
public class TBusiSignetApplyController {

private final TBusiSignetApplyService tBusiSignetApplyService;

    /**
     * 用印申请-新增
     *
     * @folder 用印申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("用印申请-新增")
    public TwOutputUtil<TBusiSignetApplyVO> insert(@RequestBody TBusiSignetApplyPayload payload){
         return TwOutputUtil.ok(tBusiSignetApplyService.insert(payload));
    }

    /**
     * 用印申请-更新
     *
         * @folder 用印申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("用印申请-更新")
    public TwOutputUtil<TBusiSignetApplyVO> update(@RequestBody TBusiSignetApplyPayload payload){
        return TwOutputUtil.ok(tBusiSignetApplyService.update(payload));
    }

    /**
     * 用印申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 用印申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("用印申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TBusiSignetApplyPayload payload){
        return TwOutputUtil.ok(tBusiSignetApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 用印申请-主键查询
     *
     * @folder 用印申请
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("用印申请-主键查询")
    public TwOutputUtil<TBusiSignetApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tBusiSignetApplyService.queryByKey(key));
    }

    /**
     * 用印申请-分页
     *
         * @folder 用印申请
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("用印申请-分页")
    public TwOutputUtil<PagingVO<TBusiSignetApplyVO>> paging(TBusiSignetApplyQuery query) {
        return TwOutputUtil.ok(tBusiSignetApplyService.queryPaging(query));
    }

    /**
     * 用印申请-查询列表
     *
     * @folder 用印申请
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("用印申请-查询列表")
    public TwOutputUtil<List<TBusiSignetApplyVO>> queryList(TBusiSignetApplyQuery query) {
        return TwOutputUtil.ok(tBusiSignetApplyService.queryListDynamic(query));
    }

    /**
     * 用印申请-删除
     *
         * @folder 用印申请
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("用印申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tBusiSignetApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}

