package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceNormalDateSpecialDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.time.LocalDate;

@Repository
@RequiredArgsConstructor
public class TAttendanceNormalDateSpecialDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QTAttendanceNormalDateSpecialDO qdo = QTAttendanceNormalDateSpecialDO.tAttendanceNormalDateSpecialDO;


    public Long isAttendAnceSpecial(LocalDate date) {
        return jpaQueryFactory.select(qdo.count())
                .from(qdo)
                .where(qdo.attendanceDate.eq(date))
                .fetchOne();
    }

    public Long selectAttendAnceSpectalId(Long ruleId, LocalDate date) {
        return jpaQueryFactory.select(qdo.id)
                .from(qdo)
                .where(qdo.attendanceRuleId.eq(ruleId).and(qdo.attendanceDate.eq(date)))
                .fetchOne();
    }
    
}
