package com.elitesland.tw.tw5.server.prd.my.entity;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "t_business_rules", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_business_rules", comment = "业务规则表-自定义业务规则加载sql判断条件")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TBusinessRulesDO extends BaseModel {

    @Comment("表达式类型")
    @Column()
    private String proType;

    @Comment("算法名称")
    @Column(nullable = false)
    private String proName;

    @Comment("算法编码")
    @Column()
    private String proCode;

    @Comment("算法规则表达式")
    @Column(nullable = false)
    private String proExpression;

    @Comment("算法是否启用")
    @Column(nullable = false)
    private int enable;

    public void copy(TBusinessRulesDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
