package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分级策略模型指标配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Entity
@Table(name = "business_model_index_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_model_index_setting", comment = "分级策略模型指标配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessModelIndexSettingDO extends BaseModel implements Serializable  {
    /** 模型id business_strategy_model.id */
    @Comment("模型id business_strategy_model.id")
    @Column()
    private Long modelId;
    /** 指标id business_strategy_model_index.id */
    @Comment("指标id business_strategy_model_index.id")
    @Column()
    private Long indexId;
    /** 指标名称 */
    @Comment("指标名称")
    @Column()
    private String indexName;
    /** 数据源字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] */
    @Comment("数据源字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    @Column()
    private String sourceFiled;
    /** 数据源字段选项 (系统下拉选择项) */
    @Comment("数据源字段选项 (系统下拉选择项)")
    @Column()
    private String sourceFiledOption;

    /** 数据源字段选项 (系统下拉选择项) */
    @Comment("数据源字段选项 (系统下拉选择项)")
    @Column()
    private String sourceFiledOptionDesc;
    /** 选项分数 */
    @Comment("选项分数")
    @Column()
    private BigDecimal optionScore;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessModelIndexSettingDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
