package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaCheckPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaCheckQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsMaCheckService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaCheckVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 项目经理任务书核对
 *
 * @author carl
 * @date 2023-09-19
 */
@Api(tags = "项目经理任务书核对")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsMaCheck")
@Slf4j
public class PmsMaCheckController {

    private final PmsMaCheckService pmsMaCheckService;

    /**
     * 项目经理任务书核对-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目经理任务书核对-新增或修改")
    public TwOutputUtil<PmsMaCheckVO> insertOrUpdate(@RequestBody PmsMaCheckPayload payload) {
        return TwOutputUtil.ok(pmsMaCheckService.insertOrUpdate(payload));
    }

    /**
     * 项目经理任务书核对-批量新增或修改
     *
     * @param payloads 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/batchInsertOrUpdate")
    @ApiOperation("项目经理任务书核对-批量新增或修改")
    public TwOutputUtil<PmsMaCheckVO> batchInsertOrUpdate(@RequestBody List<PmsMaCheckPayload> payloads) {
        pmsMaCheckService.batchInsertOrUpdate(payloads);
        return TwOutputUtil.ok();
    }
//    /**
//     * 项目经理任务书核对-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("项目经理任务书核对-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsMaCheckPayload payload) {
//        return TwOutputUtil.ok(pmsMaCheckService.updateByKeyDynamic(payload));
//    }

    /**
     * 项目经理任务书核对-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("项目经理任务书核对-主键查询")
    public TwOutputUtil<PmsMaCheckVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsMaCheckService.queryByKey(key));
    }

    /**
     * 项目经理任务书核对-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("项目经理任务书核对-分页")
    public TwOutputUtil<PagingVO<PmsMaCheckVO>> paging(PmsMaCheckQuery query) {
        return TwOutputUtil.ok(pmsMaCheckService.queryPaging(query));
    }

    /**
     * 项目经理任务书核对-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("项目经理任务书核对-查询列表")
    public TwOutputUtil<List<PmsMaCheckVO>> queryList(PmsMaCheckQuery query) {
        return TwOutputUtil.ok(pmsMaCheckService.queryListDynamic(query));
    }


}

