package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

;

/**
 * 项目模板
 *
 * @author xxb
 * @date 2023-08-02
 */
@Entity
@Table(name = "pms_project_template", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_template", comment = "项目模板")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectTemplateDO extends BaseModel implements Serializable {

    /**
     * 模板名称
     */
    @Comment("模板名称")
    @Column()
    private String templateName;
    /**
     * 适用项目类型
     */
    @FieldUpdateLog(fieldName = "适用项目类型", selectionKey = "salecon:work_type")
    @FieldCreateLog(fieldName = "适用项目类型", selectionKey = "salecon:work_type")
    @Comment("适用项目类型")
    @Column()
    private String suitProjectType;

    /**
     * 适用BU类型
     */
    @FieldUpdateLog(fieldName = "适用BU类型", selectionKey = "BU:SUIT_TYPY")
    @FieldCreateLog(fieldName = "适用BU类型", selectionKey = "BU:SUIT_TYPY")
    @Comment("适用BU类型")
    @Column()
    private String tmplType;

    /**
     * 科目模板
     */
    @Comment("科目模板")
    @Column()
    private Long subjectTemplateId;

    /**
     * 是否启用  0:禁用，1：启用
     */
    @Comment("是否启用  0:禁用，1：启用")
    @Column()
    private Integer templateStatus;

    @Comment("资源规划周期: WEEK周 MONTH月")
    @Column()
    private String resourcePlanningCycle;


    /**
     * 适用bu
     */
    @Comment("适用bu")
    @Column
    private String baseBu;

    /**
     * 适用buId
     */
    @Comment("适用buId")
    @Column
    private Long baseBuId;


    public void copy(PmsProjectTemplateDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
