package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectBriefPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectReportPlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectBriefQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectReportPlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectReportPlanService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectBriefVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectReportPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchInvdtlService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConWorkTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectBriefConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectReportPlanConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectBriefDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectBriefDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectBriefRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目汇报管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectBriefServiceImpl extends BaseServiceImpl implements PmsProjectBriefService {
    private final WorkflowUtil workflowUtil;
    private final PmsProjectBriefRepo pmsProjectBriefRepo;
    private final PmsProjectBriefDAO pmsProjectBriefDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PrdSystemRoleService roleService;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PmsProjectReportPlanService pmsProjectReportPlanService;
    private BeanSearcher beanSearcher;
    private final ExcelUtil excelUtil;
    private final UdcUtil udcUtil;
    private final ConInvBatchService invBatchService;
    private final ConInvBatchInvdtlService invBatchInvdtlService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT_BRIEF);
    }

    /**
     * 手动添加项目汇报接口
     *
     * @param payload 单据数据
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectBriefVO insertOrUpdate(PmsProjectBriefPayload payload) {
        /**
         * 先初始化合同数据到汇报数据里，保证数据最新
         */
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(payload.getProjId());
        /**
         * 1.判断是手动汇报还是自动汇报
         * 2.如果是手动汇报要判断可不可以汇报
         */
        int autoReportFlag = autoReportFlag(pmsProjectVO.getWorkType());
        payload.setAutoReportFlag(autoReportFlag);
        if (autoReportFlag == -1) {
            throw TwException.error("", "工作类型不需要进行项目汇报");
        }
        if (autoReportFlag == 1) {
            throw TwException.error("", "工作类型为自动汇报策略");
        }

        //合同总金额
        BigDecimal amt = pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt();
        //税率
        BigDecimal taxRate = pmsProjectVO.getTaxRate() == null ? BigDecimal.ZERO : pmsProjectVO.getTaxRate();

        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setSaleConId(pmsProjectVO.getContractId());
        //收款计划
        List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(query);
        // 计算实际收款金额
        BigDecimal actualReceivedAmt = recvPlanViews.stream()
                .map(ConReceivablePlanVO::getActualRecvAmt)
                .filter(Objects::nonNull)
                .reduce(BigDecimal::add)
                .orElse(BigDecimal.ZERO);
        // 计算已开票金额
        BigDecimal invoicedAmt = recvPlanViews.stream()
                .map(ConReceivablePlanVO::getAlreadyInvAmt)
                .filter(Objects::nonNull)
                .reduce(BigDecimal::add)
                .orElse(BigDecimal.ZERO);

        payload.setProjAmt(amt);
        payload.setTaxRate(taxRate);
        payload.setRecvedAmt(actualReceivedAmt);
        payload.setInvoicedAmt(invoicedAmt);
        payload.setProjName(pmsProjectVO.getProjName());
        //手动汇报
        if (payload.getId() != null) {
            PmsProjectBriefVO pmsProjectBriefVO = pmsProjectBriefDAO.queryByKey(payload.getId());
            if (pmsProjectBriefVO.getBriefStatus().equals("CREATE")) {
                //重新赋值流程实例id
                payload.setProcInstId(pmsProjectBriefVO.getProcInstId());
                payload.setApplyDate(pmsProjectBriefVO.getApplyDate());
                payload.setCreateUserId(pmsProjectBriefVO.getCreateUserId());
                payload.setCreateTime(pmsProjectBriefVO.getCreateTime());
            } else {
                throw TwException.error("", "流程已存在不可再次提交");
            }
        } else {
            //生成编号
            String code = generateSeqNum("PMS_PROJ_REPORT");
            payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
            payload.setApplyDate(LocalDate.now());
        }
        //数据验证
        noAutoReport(payload, pmsProjectVO);
        payload.setBriefStatus("REPORTING");
        payload.setApprStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        payload.setApplyUserId(GlobalUtil.getLoginUserId());

        PmsProjectBriefDO entityDo = PmsProjectBriefConvert.INSTANCE.toDo(payload);
        entityDo = pmsProjectBriefRepo.save(entityDo);
        payload.setId(entityDo.getId());
        if (payload.getProcInstId() == null) {
            //创建流程实例	P09.项目测试0821-项目汇报-2023-08
            int isCheck = 0;
            if (payload.getProjProcessStatus().equals("CLOSED") || payload.getProjProcessStatus().equals("END")) {
                isCheck = 1;
            }
            List<Long> userIds = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_MANAGER.getCode());
            HashMap<String, Object> variables = new HashMap<>();
            variables.put("Activity_02stcs3", CollUtil.newArrayList(pmsProjectVO.getDeliUserId()));
            variables.put("Activity_071j89d", CollUtil.newArrayList(userIds));
            variables.put("isCheck", isCheck);

            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    PmsProcDefKey.PMS_PROJECT_REPORT.name(),
                    "P06.项目汇报-" + payload.getFinPeriodDate().getYear() + "-" + payload.getFinPeriodDate().getMonthValue() + "-" + pmsProjectVO.getProjName(),
                    entityDo.getId() + "",
                    variables)
            );
            //流程实例状态
            String apprStatus = processInfo.getProcInstStatus().name();
            String briefStatus = "REPORTING";
            //流程实例id
            String procInstId = processInfo.getProcInstId();
            if (apprStatus.equals(ProcInstStatus.APPROVED.name())) {
                briefStatus = "FINISHED";
                procInstId = null;
            }
            PmsProjectBriefPayload payload0 = new PmsProjectBriefPayload();
            payload0.setProcInstId(procInstId);
            payload0.setId(entityDo.getId());
            payload0.setApprStatus(apprStatus);
            payload0.setBriefStatus(briefStatus);
            //开启事务执行修改，主要是修改审批状态
            transactionUtilService.executeWithRunnable(() -> {
                pmsProjectBriefDAO.updateWorkFlow(payload0);
//                //修改手动汇报项目最近汇报时间
//                PmsProjectPayload projectPayload = new PmsProjectPayload();
//                projectPayload.setId(payload.getProjId());
//                projectPayload.setReportTime(LocalDateTime.now());
//                pmsProjectDAO.updateByKeyDynamic(projectPayload);
            });
        }
        return PmsProjectBriefConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectBriefVO autoInsert(PmsProjectBriefPayload payload) {
        //自动汇报
        payload.setProjProcessStatus("SUP");
        payload.setBriefStatus("FINISHED");
        payload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        payload.setCreateUserId(0L);
        payload.setApplyUserId(0L);
        PmsProjectBriefDO entityDo = PmsProjectBriefConvert.INSTANCE.toDo(payload);
        entityDo = pmsProjectBriefRepo.save(entityDo);

        //修改手动汇报时间项目最完工百分比和进度状态
        PmsProjectPayload projectPayload = new PmsProjectPayload();
        projectPayload.setId(payload.getProjId());
        projectPayload.setReportTime(LocalDateTime.now());
        projectPayload.setCompPercent(payload.getReprotCompPercent());
        projectPayload.setProjProcessStatus(payload.getProjProcessStatus());
        pmsProjectDAO.updateByKeyDynamic(projectPayload);

        return PmsProjectBriefConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        PmsProjectBriefVO pmsProjectBriefVO = pmsProjectBriefDAO.queryByKey(Long.valueOf(businessKey));
        if (pmsProjectBriefVO != null) {
            PmsProjectBriefPayload projectBriefPayload = new PmsProjectBriefPayload();
            projectBriefPayload.setId(Long.parseLong(businessKey));
            projectBriefPayload.setApprStatus(procInstStatus.name());
            projectBriefPayload.setBriefStatus("REPORTING");
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    projectBriefPayload.setBriefStatus("CREATE");
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    projectBriefPayload.setBriefStatus("CREATE");
                    projectBriefPayload.setProcInstId(null);
                    projectBriefPayload.setNullFields(List.of("procInstId"));
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据

                    projectBriefPayload.setDeleteFlag(1);
                    projectBriefPayload.setBriefStatus("CREATE");
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    projectBriefPayload.setBriefStatus("CREATE");
                    break;
                case APPROVED:
                    projectBriefPayload.setBriefStatus("FINISHED");
                    projectBriefPayload.setProcInstId(null);
                    break;
                case APPROVING:

                    break;
            }

            pmsProjectBriefDAO.updateWorkFlow(projectBriefPayload);
            if (projectBriefPayload.getBriefStatus().equals("FINISHED")) {
                //修改手动汇报项目最完工百分比和进度状态
                PmsProjectPayload projectPayload = new PmsProjectPayload();
                projectPayload.setId(pmsProjectBriefVO.getProjId());
                projectPayload.setReportTime(LocalDateTime.now());
                projectPayload.setCompPercent(pmsProjectBriefVO.getReprotCompPercent());
                projectPayload.setProjProcessStatus(pmsProjectBriefVO.getProjProcessStatus());
                pmsProjectDAO.updateByKeyDynamic(projectPayload);
            }
        }
    }


    /**
     * 手动汇报操作
     */
    void noAutoReport(PmsProjectBriefPayload payload, PmsProjectVO pmsProjectVO) {
        /**
         * 1.判断项目状态是否为激活
         * 2.判断期间是否在项目起始范围内
         * 3.判断是否存在区间重复汇报
         * 4.判断是否存在未完成汇报
         */
        //判断项目状态是否为激活
        if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
            //判断期间是否在项目起始范围内
            boolean isTrue = false;
            LocalDate finPeriodDate = payload.getFinPeriodDate();
            int year = finPeriodDate.getYear();
            int monthValue = finPeriodDate.getMonthValue();
            LocalDate planStartDate = pmsProjectVO.getPlanStartDate();
            int year1 = planStartDate.getYear();
            if (year >= year1) {
                int monthValue1 = planStartDate.getMonthValue();
                if (monthValue >= monthValue1 || year > year1) {
                    LocalDate planEndDate = pmsProjectVO.getPlanEndDate();
                    int year2 = planEndDate.getYear();
                    if (year2 >= year) {
                        int monthValue2 = planEndDate.getMonthValue();
                        if (monthValue2 >= monthValue || year2 > year) {
                            isTrue = true;
                        }
                    }
                }
            }
            if (isTrue) {
                PmsProjectBriefVO pmsProjectBriefVO = pmsProjectBriefDAO.queryByProjectId(payload.getProjId(), null);
                if (!ObjectUtils.isEmpty(pmsProjectBriefVO)) {
                    //仅判断非自己数据
                    if (payload.getId() == null || payload.getId().longValue() != pmsProjectBriefVO.getId().longValue()) {
                        // 判断是否存在区间重复汇报
                        LocalDate finPeriodDate1 = pmsProjectBriefVO.getFinPeriodDate();
                        int year3 = finPeriodDate1.getYear();
                        int monthValue3 = finPeriodDate1.getMonthValue();
                        if (year == year3 && monthValue == monthValue3) {
                            throw TwException.error("", "同一项目在同一个期间内只能汇报一次");
                        }
                        //判断是否存在未完成汇报
                        if (!pmsProjectBriefVO.getBriefStatus().equals("FINISHED")) {
                            throw TwException.error("", "该项目存在未完成的项目汇报，请先完成以前的项目汇报");
                        }
                    }
                }
            } else {
                throw TwException.error("", "汇报期间不在项目预计起止日期范围内，请先变更项目预计起止日期");
            }
        } else {
            throw TwException.error("", "只有激活状态项目才能汇报");
        }
    }

    /**
     * 判断是不是自动汇报
     * -1:不用汇报
     * 0：手动汇报
     * 1：自动汇报
     *
     * @param workType
     * @return
     */
    int autoReportFlag(String workType) {
        int autoReportFlag = -1;
        List<String> cods0 = Arrays.asList(SaleConWorkTypeEnum.DELIVERY.getCode(), SaleConWorkTypeEnum.DEVELOP.getCode());
        if (cods0.contains(workType)) {
            autoReportFlag = 0;
        }
        List<String> cods = Arrays.asList(SaleConWorkTypeEnum.OPERATION.getCode(), SaleConWorkTypeEnum.PURETRADE.getCode(), SaleConWorkTypeEnum.INDEPENDENT.getCode(), SaleConWorkTypeEnum.CONSULT.getCode(), SaleConWorkTypeEnum.TM.getCode());
        if (cods.contains(workType)) {
            autoReportFlag = 1;
        }
        return autoReportFlag;
    }

    @Override
    public PmsProjectBriefVO queryBriefInfo(Long projectId) {
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projectId);
        //判断是否自动汇报
        int autoReportFlag = autoReportFlag(pmsProjectVO.getWorkType());
        if (autoReportFlag == -1) {
            throw TwException.error("", "工作类型不需要进行项目汇报");
        }
        if (autoReportFlag == 1) {
            throw TwException.error("", "工作类型为自动汇报策略");
        }
        PmsProjectBriefVO projBriefView = operitonBriefData(pmsProjectVO);
        //获取上次汇报数据
        PmsProjectBriefVO lastPeriodBrief = pmsProjectBriefDAO.queryByProjectId(projectId, "FINISHED");
        if (lastPeriodBrief != null) {
            //完善数据
            updateProjectBriefVO(lastPeriodBrief);
        }
        projBriefView.setLastPeriodBrief(lastPeriodBrief);

        return projBriefView;
    }

    @Override
    public PmsProjectBriefVO operitonBriefData(PmsProjectVO pmsProjectVO) {
        //合同总金额
        BigDecimal amt = pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt();
        //税率
        BigDecimal taxRate = pmsProjectVO.getTaxRate() == null ? BigDecimal.ZERO : pmsProjectVO.getTaxRate();
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setSaleConId(pmsProjectVO.getContractId());
        //收款计划
        List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(query);
        // 计算实际收款金额
        BigDecimal actualReceivedAmt = recvPlanViews.stream()
                .map(ConReceivablePlanVO::getActualRecvAmt)
                .filter(Objects::nonNull)
                .reduce(BigDecimal::add)
                .orElse(BigDecimal.ZERO);

        // 计算已开票金额
        BigDecimal invoicedAmt = recvPlanViews.stream()
                .map(ConReceivablePlanVO::getAlreadyInvAmt)
                .filter(Objects::nonNull)
                .reduce(BigDecimal::add)
                .orElse(BigDecimal.ZERO);

        //不含税总金额
        BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
        //计算未收款金额
        BigDecimal notReceivedAmt = amt.subtract(actualReceivedAmt);

        // 计算开票未收款金额
        BigDecimal invoicedNotReceivedAmt = invoicedAmt.subtract(actualReceivedAmt);
        // 计算未开票应收款金额
        BigDecimal notInvoicedReceivedAmt = notReceivedAmt.subtract(invoicedNotReceivedAmt);
        // 计算实际收款百分比
        BigDecimal actualReceivedRate = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(amt) != 0) {
            actualReceivedRate = actualReceivedAmt.divide(amt, 4, RoundingMode.HALF_UP).movePointRight(2);
        }
        // 费用总预算
        BigDecimal feeBudgetAmt = pmsProjectVO.getTotalReimbursement() == null ? BigDecimal.ZERO : pmsProjectVO.getTotalReimbursement();
        // 当量总数
        BigDecimal totalEqva = pmsProjectVO.getTotalEqva();
        if (totalEqva == null) {
            totalEqva = BigDecimal.ZERO;
        }
        // 当量总费用
        BigDecimal eqvaBudgetAmt = BigDecimal.ZERO;
        if (pmsProjectVO.getEqvaPrice() != null) {
            eqvaBudgetAmt = totalEqva.multiply(pmsProjectVO.getEqvaPrice());
        }
        PmsProjectBriefVO projBriefView = new PmsProjectBriefVO();
        projBriefView.setProjId(pmsProjectVO.getId());
        projBriefView.setProjName(pmsProjectVO.getProjName());
        projBriefView.setWorkType(pmsProjectVO.getWorkType());
        projBriefView.setProjAmt(amt);//税前的金额  -- 前端还用 不可随意改
        projBriefView.setProjAmtNoTax(notTaxAmt);// 税后  --新增字段
        projBriefView.setRecvedAmt(actualReceivedAmt);
        projBriefView.setNotReceivedAmt(notReceivedAmt);
        projBriefView.setInvoicedAmt(invoicedAmt);
        projBriefView.setInvoicedNotReceivedAmt(invoicedNotReceivedAmt);
        projBriefView.setNotInvoicedReceivedAmt(notInvoicedReceivedAmt);
        projBriefView.setActualReceivedRate(actualReceivedRate);
        projBriefView.setSubsidyAmt(pmsProjectVO.getSubsidyAmt());
        projBriefView.setTaxRate(taxRate);
        projBriefView.setFeeBudgetAmt(feeBudgetAmt);
        projBriefView.setEqvaBudgetCnt(totalEqva);
        projBriefView.setEqvaBudgetAmt(eqvaBudgetAmt);
        projBriefView.setRecvPlanViews(recvPlanViews);

        return projBriefView;
    }

    @Override
    public PmsProjectBriefVO queryByKey(Long key) {
        PmsProjectBriefVO pmsProjectBriefVO = pmsProjectBriefDAO.queryByKey(key);
        if (pmsProjectBriefVO != null) {
            //完善数据
            updateProjectBriefVO(pmsProjectBriefVO);
            transferData(pmsProjectBriefVO);
            LocalDate lastFinPeriodDate = pmsProjectBriefVO.getFinPeriodDate().minusMonths(1);
            //获取上次汇报数据
            PmsProjectBriefVO lastPeriodBrief = pmsProjectBriefDAO.queryByProjectIdAndDate(pmsProjectBriefVO.getProjId(), lastFinPeriodDate);
            if (lastPeriodBrief != null && lastPeriodBrief.getProjAmt() != null) {
                //完善数据
                updateProjectBriefVO(lastPeriodBrief);
            }
            pmsProjectBriefVO.setLastPeriodBrief(lastPeriodBrief);
        }
        return pmsProjectBriefVO;
    }

    /**
     * 完善汇报返回数据
     */
    void updateProjectBriefVO(PmsProjectBriefVO lastPeriodBrief) {
        BigDecimal projAmt = lastPeriodBrief.getProjAmt() == null ? BigDecimal.ZERO : lastPeriodBrief.getProjAmt();
        //税率
        BigDecimal lastTaxRate = lastPeriodBrief.getTaxRate() == null ? BigDecimal.ZERO : lastPeriodBrief.getTaxRate();
        //不含税总金额
        BigDecimal lastNotTaxAmt = projAmt.divide(BigDecimal.ONE.add(lastTaxRate), 2, RoundingMode.HALF_UP);
        //计算未收款金额
        BigDecimal lastNotReceivedAmt = projAmt.subtract(lastPeriodBrief.getRecvedAmt());
        // 计算开票未收款金额
        BigDecimal lastInvoicedNotReceivedAmt = lastPeriodBrief.getInvoicedAmt().subtract(lastPeriodBrief.getRecvedAmt());
        // 计算未开票应收款金额
        BigDecimal lastNotInvoicedReceivedAmt = lastNotReceivedAmt.subtract(lastInvoicedNotReceivedAmt);

        lastPeriodBrief.setProjAmtNoTax(lastNotTaxAmt);
        lastPeriodBrief.setNotReceivedAmt(lastNotReceivedAmt);
        lastPeriodBrief.setInvoicedNotReceivedAmt(lastInvoicedNotReceivedAmt);
        lastPeriodBrief.setNotInvoicedReceivedAmt(lastNotInvoicedReceivedAmt);
    }

    @Override
    public PagingVO<PmsProjectBriefVO> queryPaging(PmsProjectBriefQuery query) {
        PagingVO<PmsProjectBriefVO> pmsProjectBriefVOPagingVO = pmsProjectBriefDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty(pmsProjectBriefVOPagingVO)) {
            pmsProjectBriefVOPagingVO.getRecords().forEach(this::transferData);
        }
        return pmsProjectBriefVOPagingVO;
    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(PmsProjectBriefVO vo) {
        vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));
    }

    @Override
    public List<PmsProjectBriefVO> queryListDynamic(PmsProjectBriefQuery query) {
        return pmsProjectBriefDAO.queryListDynamic(query);
    }

    @Override
    public void downloadBatch(HttpServletResponse response, PmsProjectBriefQuery query) {

        ClassPathResource classPathResource = new ClassPathResource("template/pmsProjectBrief.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("项目汇报数据");
            String fileName = "项目汇报数据-" + LocalDate.now();
            //数据导出
            MapBuilder mapBuilder = this.pageWhereBuilder(query);
            List<PmsProjectBriefVO> result = beanSearcher.searchList(PmsProjectBriefVO.class, mapBuilder.build());
            if (!ObjectUtils.isEmpty(result)) {
                //result.forEach(this::transferData);

                result = udcUtil.translateList(result);
                int nextRow = 1;
                for (PmsProjectBriefVO projectBriefVO : result) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, projectBriefVO.getBriefNo()); // 汇报编号
                    excelUtil.setCellValue(row, 1, projectBriefVO.getBriefStatusDesc());// 汇报状态
                    excelUtil.setCellValue(row, 2, projectBriefVO.getProjName());// 名项目称
                    excelUtil.setCellValue(row, 3, projectBriefVO.getReferCode());// 参考合同号

                    if (projectBriefVO.getFinPeriodDate() != null) {
                        int year = projectBriefVO.getFinPeriodDate().getYear();
                        int monthValue = projectBriefVO.getFinPeriodDate().getMonthValue();
                        String month = "" + monthValue;
                        if (monthValue < 10) {
                            month = "0" + monthValue;
                        }
                        excelUtil.setCellValue(row, 4, year + "-" + month);// 财务期间
                    }


                    excelUtil.setCellValue(row, 5, projectBriefVO.getProjProcessStatusDesc());// 项目进度状态
                    excelUtil.setCellValue(row, 6, projectBriefVO.getContractStatusDesc());// 合同状态
                    if (projectBriefVO.getReprotCompPercent() != null) {
                        excelUtil.setCellValue(row, 7, projectBriefVO.getReprotCompPercent() + "%");// 完工百分比
                    }

                    excelUtil.setCellValue(row, 8, projectBriefVO.getConfirmAmt());// 当期确认收入
                    excelUtil.setCellValue(row, 9, projectBriefVO.getApplyUserDesc());// 汇报人

                    excelUtil.setCellValue(row, 10, projectBriefVO.getApplyDate());// 汇报日期
                    excelUtil.setCellValue(row, 11, projectBriefVO.getDeliBuName());// 交付bu
                    excelUtil.setCellValue(row, 12, projectBriefVO.getSignBuName());// 签单bu
//                    excelUtil.setCellValue(row, 13, projectBriefVO.getSumAmt());// 含税合同总金额
//                    excelUtil.setCellValue(row, 14, projectBriefVO.getInvoicedAmt());// 已开票金额

                    nextRow++;
                }
            }
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public PmsProjectBriefVO update(PmsProjectBriefPayload payload) {
//        PmsProjectBriefDO entity = pmsProjectBriefRepo.findById(payload.getId()).orElseGet(PmsProjectBriefDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        PmsProjectBriefDO entityDo = PmsProjectBriefConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
//        return PmsProjectBriefConvert.INSTANCE.toVo(pmsProjectBriefRepo.save(entity));
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public long updateByKeyDynamic(PmsProjectBriefPayload payload) {
//        PmsProjectBriefDO entity = pmsProjectBriefRepo.findById(payload.getId()).orElseGet(PmsProjectBriefDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        long result = pmsProjectBriefDAO.updateByKeyDynamic(payload);
//        return result;
//    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsProjectBriefVO> pmsProjectBriefVOS = pmsProjectBriefDAO.queryByKeys(keys);
            if (!ObjectUtils.isEmpty(pmsProjectBriefVOS)) {
                List<Long> ids = pmsProjectBriefVOS.stream().filter(BriefVO -> BriefVO.getBriefStatus().equals("CREATE")).map(PmsProjectBriefVO::getId).collect(Collectors.toList());
                if (ids == null || ids.size() < pmsProjectBriefVOS.size()) {
                    throw TwException.error("", "仅支持新建汇报删除");
                }

                pmsProjectBriefDAO.deleteSoft(ids);
            }

        }
    }

    @Override
    public List<PmsProjectBriefVO> projectBriefWork(List<Long> projectIds) {
        if (ObjectUtils.isEmpty(projectIds)) {
            return new ArrayList<>();
        }
        List<Map<String, Object>> maps = pmsProjectBriefRepo.projectBriefWork(projectIds);
        //  List<PmsProjectBriefDO> pmsProjectBriefDOS = pmsProjectBriefRepo.projectBriefWork(projectIds);
        if (maps.size() > 0) {
            List<PmsProjectBriefVO> collect = maps.stream().map(brief -> {
                PmsProjectBriefVO pmsProjectBriefVO = new PmsProjectBriefVO();
                pmsProjectBriefVO.setId(Long.valueOf(brief.get("id") + ""));
                pmsProjectBriefVO.setConfirmedAmt((BigDecimal) brief.get("confirmed_amt"));
                pmsProjectBriefVO.setProjId(Long.valueOf(brief.get("proj_id") + ""));
                Date fin_period_date = (Date) brief.get("fin_period_date");
                pmsProjectBriefVO.setFinPeriodDate(fin_period_date.toLocalDate());
                pmsProjectBriefVO.setProjProcessStatus(brief.get("proj_process_status") + "");
                pmsProjectBriefVO.setReprotCompPercent(brief.get("reprot_comp_percent") == null ? BigDecimal.ZERO : (BigDecimal) brief.get("reprot_comp_percent"));
                return pmsProjectBriefVO;
            }).collect(Collectors.toList());
            return collect;
        } else {
            return new ArrayList<>();
        }
    }

    /**
     * 定时任务自动汇报保存
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void projectBriefJobHandler(String date) {
        LocalDate briefDate = LocalDate.now();
        if (StringUtils.hasText(date)) {
            briefDate = LocalDate.parse(date);
        }
        log.info("-----开始执行项目自动汇报------");
        List<String> workTypes = new ArrayList<>(Arrays.asList(SaleConWorkTypeEnum.OPERATION.getCode(), SaleConWorkTypeEnum.PURETRADE.getCode(), SaleConWorkTypeEnum.INDEPENDENT.getCode(), SaleConWorkTypeEnum.CONSULT.getCode(), SaleConWorkTypeEnum.TM.getCode()));
        PmsProjectQuery query = new PmsProjectQuery();
        query.setWorkTypes(workTypes);
        query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        query.setProjStatusType("1");

        List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.projectBriefWork(query);
        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
            //翻译项目map
            Map<Long, PmsProjectVO> mapProjects = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getId, Function.identity()));
            //获取上个月第一天
            LocalDate starDate = briefDate.minusMonths(1).with(TemporalAdjusters.firstDayOfMonth());
            //获取上个月最后一天
            LocalDate endDate = briefDate.minusMonths(1).with(TemporalAdjusters.lastDayOfMonth());
            //处理运维项目
            List<Long> projIds = pmsProjectVOS.stream().filter(vo -> vo.getWorkType().equals(SaleConWorkTypeEnum.OPERATION.getCode()) && (vo.getChangeFlag() == null || vo.getChangeFlag() == 0)).map(PmsProjectVO::getId).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(projIds)) {
                PmsProjectReportPlanQuery queryPlan = new PmsProjectReportPlanQuery();
                queryPlan.setProjIds(projIds);
                queryPlan.setStartDate(starDate);
                queryPlan.setEndDate(endDate);
                //获取上个月范围内的汇报计划
                List<PmsProjectReportPlanVO> pmsProjectReportPlanVOS = pmsProjectReportPlanService.queryListDynamic(queryPlan);
                if (!ObjectUtils.isEmpty(pmsProjectReportPlanVOS)) {
                    List<PmsProjectReportPlanPayload> payloadList = new ArrayList<>();
                    //3. 检索 在上月有汇报计划 的项目
                    List<Long> collect0 = pmsProjectReportPlanVOS.stream().map(PmsProjectReportPlanVO::getProjId).collect(Collectors.toList());
                    //需获取汇报累计金额
                    List<PmsProjectBriefVO> pmsProjectBriefVOS = projectBriefWork(collect0);
                    //翻译项目汇报map
                    Map<Long, PmsProjectBriefVO> mapBriefs;
                    if (ObjectUtils.isEmpty(pmsProjectBriefVOS)) {
                        mapBriefs = new HashMap<>();
                    } else {
                        mapBriefs = pmsProjectBriefVOS.stream().collect(Collectors.toMap(PmsProjectBriefVO::getProjId, Function.identity()));
                    }
                    for (int i = 0; i < pmsProjectReportPlanVOS.size(); i++) {
                        PmsProjectReportPlanVO planVO = pmsProjectReportPlanVOS.get(i);
                        if (projIds.contains(planVO.getProjId())) {
                            PmsProjectBriefVO projectBriefVO = mapBriefs.get(planVO.getProjId());
                            if (projectBriefVO == null || projectBriefVO.getFinPeriodDate().compareTo(planVO.getPeriodDate()) < 0) {
                                //未发生过汇报或汇报期间小于计划期间的
                                PmsProjectVO pmsProjectVO = mapProjects.get(planVO.getProjId());
                                BigDecimal confirmedAmt = (projectBriefVO == null ? BigDecimal.ZERO : projectBriefVO.getConfirmedAmt()).add(planVO.getAmt());
                                //获取汇报其他数据
                                PmsProjectBriefVO pmsProjectBriefVO = operitonBriefData(pmsProjectVO);

                                PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                                //生成编号
                                String code = generateSeqNum("PMS_PROJ_REPORT");
                                payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                                payload.setFinPeriodDate(planVO.getPeriodDate());
                                payload.setProjId(planVO.getProjId());
                                payload.setProjName(pmsProjectBriefVO.getProjName());
                                payload.setProjAmt(pmsProjectBriefVO.getProjAmt());
                                payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                                payload.setInvoicedAmt(pmsProjectBriefVO.getInvoicedAmt());
                                payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                                payload.setConfirmedAmt(confirmedAmt);
                                payload.setConfirmAmt(planVO.getAmt());
                                payload.setAutoReportFlag(1);

                                if (pmsProjectBriefVO.getProjAmtNoTax().compareTo(BigDecimal.ZERO) > 0) {
                                    BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100));
                                    payload.setReprotCompPercent(divide);
                                } else {
                                    payload.setReprotCompPercent(BigDecimal.ZERO);
                                }

                                //保存项目汇报
                                PmsProjectBriefVO pmsProjectBriefVO1 = autoInsert(payload);
                                planVO.setBriefId(pmsProjectBriefVO1.getId());
                                planVO.setBriefNo(pmsProjectBriefVO1.getBriefNo());

                                PmsProjectReportPlanPayload pmsProjectReportPlanPayload = PmsProjectReportPlanConvert.INSTANCE.toPayload(planVO);
                                payloadList.add(pmsProjectReportPlanPayload);
                            }

                        }
                    }
                    if (payloadList.size() > 0) {
                        //更新计划
                        pmsProjectReportPlanService.batchInsert(payloadList);
                    }
                }
            }
            //处理非运维项目汇报
            workTypes.remove(SaleConWorkTypeEnum.OPERATION.getCode());
            //获取合同ids
            List<Long> contractIds = pmsProjectVOS.stream().filter(vo -> workTypes.contains(vo.getWorkType())).map(PmsProjectVO::getContractId).filter(Objects::nonNull).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(contractIds)) {
                List<LocalDate> invDate = new ArrayList<>();
                invDate.add(starDate);
                invDate.add(endDate);
                ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
                queryReceivablePlan.setSaleConIds(contractIds);
                queryReceivablePlan.setInvDate(invDate);
                //收款计划
                List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(queryReceivablePlan);
                //4. 合同开票的开票日期在红冲的时候时不变的，获取核算月退票的开票相关的项目
                ConInvBatchQuery invBatchQuery = new ConInvBatchQuery();
                //开票详情的创建时间作为退票时间
                invBatchQuery.setRefundDate(invDate);
                invBatchQuery.setBatchStatus("10");
                invBatchQuery.setInvStatus("CHARGEOFF");
                List<ConInvBatchVO> conInvBatchVOS = invBatchService.queryListDynamic(invBatchQuery);
                List<Long> returnedContractIds = conInvBatchVOS.stream().filter(e -> e.getSaleContractId() != null).map(e -> e.getSaleContractId()).collect(Collectors.toList());

                if (!ObjectUtils.isEmpty(recvPlanViews) || !CollectionUtils.isEmpty(returnedContractIds)) {
                    //翻译项目map
                    Map<Long, PmsProjectVO> mapContractProjects = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, Function.identity()));
                    //在上月有开票的合同
                    List<Long> newContractIds = ObjectUtils.isEmpty(recvPlanViews) ? new ArrayList<>() : recvPlanViews.stream().map(ConReceivablePlanVO::getSaleConId).distinct().collect(Collectors.toList());
                    //3. 检索 在上月有开票 的项目
                    List<Long> collect0 = CollectionUtils.isEmpty(newContractIds) ? new ArrayList<>() : pmsProjectVOS.stream().filter(vo -> newContractIds.contains(vo.getContractId())).map(PmsProjectVO::getId).collect(Collectors.toList());
                    List<Long> collect1 = pmsProjectVOS.stream().filter(vo -> returnedContractIds.contains(vo.getContractId())).map(PmsProjectVO::getId).collect(Collectors.toList());
                    collect0.addAll(collect1);


                    newContractIds.addAll(returnedContractIds);
                    //去重
                    List<Long> distinctNewContractIds = newContractIds.stream().distinct().collect(Collectors.toList());
                    //需获取汇报累计金额
                    List<PmsProjectBriefVO> pmsProjectBriefVOS = projectBriefWork(collect0);
                    //翻译项目汇报map
                    Map<Long, PmsProjectBriefVO> mapBriefs;
                    if (ObjectUtils.isEmpty(pmsProjectBriefVOS)) {
                        mapBriefs = new HashMap<>();
                    } else {
                        mapBriefs = pmsProjectBriefVOS.stream().collect(Collectors.toMap(PmsProjectBriefVO::getProjId, Function.identity()));
                    }

                    distinctNewContractIds.forEach(contractId -> {
                        PmsProjectVO pmsProjectVO = mapContractProjects.get(contractId);
//                        if(ObjectUtils.isEmpty(pmsProjectVO)){
//                            log.info("为对应上的合同id是：：："+contractId);
//                            // 如果没查到当前项目，重写查询合同关联的项目，可能涉及到退票的项目
//                            pmsProjectVO = pmsProjectDAO.queryByContractId(contractId);
//                            log.info("查询结果是：：："+contractId);
//                        }
                        if (!ObjectUtils.isEmpty(pmsProjectVO)) {
                            //获取累计金额
                            PmsProjectBriefVO projectBriefVO = mapBriefs.get(pmsProjectVO.getId());
                            if (projectBriefVO == null || projectBriefVO.getFinPeriodDate().compareTo(starDate) < 0) {
                                //未发生过汇报或汇报期间小于上个月第一天的
                                //获取汇报其他数据
                                PmsProjectBriefVO pmsProjectBriefVO = operitonBriefData(pmsProjectVO);
                                //计算上月开票金额
                                BigDecimal invoicedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId))
                                        .map(ConReceivablePlanVO::getAlreadyInvAmt)
                                        .filter(Objects::nonNull)
                                        .reduce(BigDecimal::add)
                                        .orElse(BigDecimal.ZERO);

                                // 获取一个合同下本月退票的金额
                                BigDecimal returnedInvoicedAmt = BigDecimal.ZERO;
                                for (ConInvBatchVO invBatchVO : conInvBatchVOS) {
                                    if (invBatchVO.getSaleContractId() != null && invBatchVO.getSaleContractId().equals(contractId)) {
                                        // 重写查询一遍当前开票所有的当月的开票明细，包括开票和退票
                                        ConInvBatchInvdtlQuery conInvBatchInvdtlQuery = new ConInvBatchInvdtlQuery();
                                        conInvBatchInvdtlQuery.setInvbatchId(invBatchVO.getId());
                                        // conInvBatchInvdtlQuery.setInvStatus("CHARGEOFF"); 对所有状态加总，不仅仅是CHARGEOFF的
                                        conInvBatchInvdtlQuery.setCreateTimeStart(LocalDateTime.of(starDate, LocalTime.MIN));
                                        conInvBatchInvdtlQuery.setCreateTimeEnd(LocalDateTime.of(endDate.plusDays(1), LocalTime.MIN));
                                        List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS = invBatchInvdtlService.queryListDynamic(conInvBatchInvdtlQuery);
                                        //                                    List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS = invBatchVO.getConInvBatchInvdtlVOS();
                                        // 按category属性分组，并取每组中的第一个值
                                        BigDecimal returnedInvoicedAmtChild = conInvBatchInvdtlVOS.stream()
                                                .map(entry -> entry.getInvAmt())
                                                .filter(Objects::nonNull)
                                                .reduce(BigDecimal::add)
                                                .orElse(BigDecimal.ZERO);
                                        returnedInvoicedAmt = returnedInvoicedAmt.add(returnedInvoicedAmtChild);
                                    }
                                }
                                log.info("合同号" + contractId + "的invoicedAmt::::::::::::::::::" + invoicedAmt);
                                log.info("合同号" + contractId + "的returnedInvoicedAmt::::::::::::::::::" + returnedInvoicedAmt);
                                // 本合同下上个月的开票金额-上个月退票发票的金额=真实汇报的开票金额
                                invoicedAmt = invoicedAmt.add(returnedInvoicedAmt);

                                //不含税开票金额
                                BigDecimal notTaxInvoicedAmt = invoicedAmt.divide(BigDecimal.ONE.add(pmsProjectBriefVO.getTaxRate()), 2, RoundingMode.HALF_UP);
                                BigDecimal confirmedAmt = (projectBriefVO == null ? BigDecimal.ZERO : projectBriefVO.getConfirmedAmt()).add(notTaxInvoicedAmt);
                                //需要补齐历史汇报
                                PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                                //生成编号
                                String code = generateSeqNum("PMS_PROJ_REPORT");
                                payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                                payload.setFinPeriodDate(starDate);
                                payload.setProjId(pmsProjectVO.getId());
                                payload.setProjName(pmsProjectBriefVO.getProjName());
                                payload.setProjAmt(pmsProjectBriefVO.getProjAmt());
                                payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                                payload.setInvoicedAmt(invoicedAmt);
                                payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                                payload.setConfirmedAmt(confirmedAmt);
                                payload.setConfirmAmt(notTaxInvoicedAmt);
                                payload.setAutoReportFlag(1);
                                if (pmsProjectVO.getWorkType().equals(SaleConWorkTypeEnum.TM.getCode())) {
                                    // - 子合同工作类型为T&M项目的收款，只要开了一次票，累计完工百分比进度就按100%算，多次开票多次汇报每次也都是100%。
                                    payload.setReprotCompPercent(BigDecimal.valueOf(100));
                                } else {
                                    BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100));
                                    payload.setReprotCompPercent(divide);
                                }
                                PmsProjectBriefVO pmsProjectBriefVO1 = autoInsert(payload);
                            }
                        }
                    });
                }

            }
        }
        log.info("-----结束执行项目自动汇报------");
    }

    /**
     * 自动补充历史期间项目汇报
     *
     * @param projectId
     */
    @Override
    public void autoSupplementBierf(Long projectId) {
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projectId);
        if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
            List<String> cods = Arrays.asList(SaleConWorkTypeEnum.OPERATION.getCode(), SaleConWorkTypeEnum.PURETRADE.getCode(), SaleConWorkTypeEnum.INDEPENDENT.getCode(), SaleConWorkTypeEnum.CONSULT.getCode(), SaleConWorkTypeEnum.TM.getCode());
            PmsProjectBriefVO pmsProjectBriefVO = operitonBriefData(pmsProjectVO);
            if (cods.contains(pmsProjectVO.getWorkType())) {
                LocalDate localDate = pmsProjectVO.getCreateTime().toLocalDate();
                //获取上个月的最后一天
                LocalDate with = localDate.minusMonths(1).with(TemporalAdjusters.lastDayOfMonth());
                //判断是否要为运维项目自动补齐历史区间汇报
                if (pmsProjectVO.getWorkType().equals(SaleConWorkTypeEnum.OPERATION.getCode())) {
                    PmsProjectReportPlanQuery query = new PmsProjectReportPlanQuery();
                    query.setProjId(projectId);
                    query.setEndDate(with);
                    List<PmsProjectReportPlanVO> pmsProjectReportPlanVOS = pmsProjectReportPlanService.queryListDynamic(query);
                    if (pmsProjectReportPlanVOS != null) {
                        List<PmsProjectReportPlanPayload> payloadList = new ArrayList<>();

                        List<PmsProjectReportPlanVO> collect = pmsProjectReportPlanVOS.stream().sorted(Comparator.comparing(PmsProjectReportPlanVO::getPeriodDate)).collect(Collectors.toList());
                        //1. 项目的创建月份晚于项目预计开始月份，需要在项目激活后，直接补齐「自动汇报计划」中历史期间的汇报。
                        //2. 历史数据只补一次，因合同的起止日志变更而导致项目期间发生变化，差异的期间的汇报数据不补；因汇报计划变更导致期间向前推移的汇报数据不补。

                        BigDecimal confirmedAmt = BigDecimal.ZERO;
                        for (int i = 0; i < collect.size(); i++) {
                            PmsProjectReportPlanVO planVO = collect.get(i);
                            int b = DateUtil.differenceMonth(planVO.getPeriodDate(), localDate);
                            if (b > 0) {
                                confirmedAmt = confirmedAmt.add(planVO.getAmt());
                                //需要补齐历史汇报
                                PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                                //生成编号
                                String code = generateSeqNum("PMS_PROJ_REPORT");
                                payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                                payload.setFinPeriodDate(planVO.getPeriodDate());
                                payload.setProjId(projectId);
                                payload.setProjName(pmsProjectVO.getProjName());
                                payload.setProjAmt(pmsProjectVO.getSumAmt());
                                payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                                payload.setInvoicedAmt(pmsProjectBriefVO.getInvoicedAmt());
                                payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                                payload.setConfirmedAmt(confirmedAmt);
                                payload.setConfirmAmt(planVO.getAmt());

                                BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100));
                                payload.setReprotCompPercent(divide);

                                PmsProjectBriefVO pmsProjectBriefVO1 = autoInsert(payload);
                                planVO.setBriefId(pmsProjectBriefVO1.getId());
                                planVO.setBriefNo(pmsProjectBriefVO1.getBriefNo());
                                planVO.setRemark("历史汇报数据自动补齐");
                                PmsProjectReportPlanPayload pmsProjectReportPlanPayload = PmsProjectReportPlanConvert.INSTANCE.toPayload(planVO);
                                payloadList.add(pmsProjectReportPlanPayload);
                            }
                        }
                        if (payloadList.size() > 0) {
                            pmsProjectReportPlanService.batchInsert(payloadList);
                        }
                    }
                } else {
                    //判断非运维项目自动汇报的汇报数据补齐
//                            1. 项目的创建月份晚于项目预计开始月份，需要在项目激活后，直接补齐「收款计划」中历史已开票月份汇报。
//                            2. 历史数据只补一次，因合同的起止日志变更而导致项目期间发生变化，差异的期间的汇报数据不补。
                    int b = DateUtil.differenceMonth(pmsProjectVO.getPlanStartDate(), localDate);
                    if (b > 0) {
//                                //当前月开始第一天
//                                LocalDate star = pmsProjectVO.getPlanStartDate().with(TemporalAdjusters.firstDayOfMonth());
//                                //相差月份最后一天
//                                LocalDate end = pmsProjectVO.getPlanStartDate().plusMonths(b - 1).with(TemporalAdjusters.lastDayOfMonth());
//                                List<LocalDate> invDate = new ArrayList<>();
//                                invDate.add(star);
//                                invDate.add(end);
//                                ConReceivablePlanQuery query = new ConReceivablePlanQuery();
//                                query.setSaleConId(pmsProjectVO.getContractId());
//                                query.setInvDate(invDate);
//                                //收款计划
//                                List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(query);
                        //收款计划
                        List<ConReceivablePlanVO> recvPlanViews = pmsProjectBriefVO.getRecvPlanViews();
                        //需要补齐历史汇报
                        if (!ObjectUtils.isEmpty(recvPlanViews)) {
                            BigDecimal confirmedAmt = BigDecimal.ZERO;
                            for (int i = 0; i < b; i++) {

                                LocalDate localDate1 = pmsProjectVO.getPlanStartDate().plusMonths(i);
                                //计算该月上一个开票金额
                                BigDecimal invoicedAmt = recvPlanViews.stream().filter(recvPlanView -> DateUtil.differenceMonth(recvPlanView.getInvDate(), localDate1) == 1)
                                        .map(ConReceivablePlanVO::getAlreadyInvAmt)
                                        .filter(Objects::nonNull)
                                        .reduce(BigDecimal::add)
                                        .orElse(BigDecimal.ZERO);
                                if (invoicedAmt.compareTo(BigDecimal.ZERO) > 0) {
                                    //不含税开票金额
                                    BigDecimal notTaxInvoicedAmt = invoicedAmt.divide(BigDecimal.ONE.add(pmsProjectBriefVO.getTaxRate()), 2, RoundingMode.HALF_UP);

                                    //上月有开票数据的才生成汇报
                                    confirmedAmt = confirmedAmt.add(notTaxInvoicedAmt);

                                    PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                                    //生成编号
                                    String code = generateSeqNum("PMS_PROJ_REPORT");
                                    payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                                    payload.setFinPeriodDate(localDate1);
                                    payload.setProjId(projectId);
                                    payload.setProjName(pmsProjectVO.getProjName());
                                    payload.setProjAmt(pmsProjectVO.getSumAmt());
                                    payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                                    payload.setInvoicedAmt(pmsProjectBriefVO.getInvoicedAmt());
                                    payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                                    payload.setConfirmedAmt(confirmedAmt);
                                    payload.setConfirmAmt(notTaxInvoicedAmt);
                                    if (pmsProjectVO.getWorkType().equals(SaleConWorkTypeEnum.TM.getCode())) {
                                        // - 子合同工作类型为T&M项目的收款，只要开了一次票，累计完工百分比进度就按100%算，多次开票多次汇报每次也都是100%。
                                        payload.setReprotCompPercent(BigDecimal.valueOf(100));
                                    } else {
                                        BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100));
                                        payload.setReprotCompPercent(divide);
                                    }
                                    PmsProjectBriefVO pmsProjectBriefVO1 = autoInsert(payload);
                                }

                            }
                        }

                    }
                }
            }
        }
    }

    /**
     * 查询分页权限
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link PmsProjectBriefVO}>
     */
    @Override
    public PagingVO<PmsProjectBriefVO> queryPagingPermission(PmsProjectBriefQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PmsProjectBriefVO.class, mapBuilder.build());
        long total = (long) totalNum;
        if (total == 0) {
            return PagingVO.empty();
        }
        List<PmsProjectBriefVO> pmsProjectBriefVOList = beanSearcher.searchList(PmsProjectBriefVO.class, mapBuilder.build());
        if (!ObjectUtils.isEmpty(pmsProjectBriefVOList)) {
            pmsProjectBriefVOList.forEach(this::transferData);
        }
        return PagingVO.<PmsProjectBriefVO>builder().records(pmsProjectBriefVOList).total(total).build();
    }

    /**
     * 分页权限 条件封装
     *
     * @param query 查询
     * @return {@link MapBuilder}
     */
    private MapBuilder pageWhereBuilder(PmsProjectBriefQuery query) {
        MapBuilder builder = MapUtils.builder();
        /** 汇报编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getBriefNo())) {
            builder.field(PmsProjectBriefVO::getBriefNo, query.getBriefNo()).op(FieldOps.Contain);
        }
        /** 汇报状态 精确 */
        if (!ObjectUtils.isEmpty(query.getBriefStatus())) {
            builder.field(PmsProjectBriefVO::getBriefStatus, query.getBriefStatus()).op(FieldOps.Equal);
        }
        /** 汇报日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            builder.field(PmsProjectBriefVO::getApplyDate, query.getApplyDate()).op(FieldOps.Equal);
        }
        /** 财务期间 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriodDate())) {
            builder.field(PmsProjectBriefVO::getFinPeriodDate, query.getFinPeriodDate()).op(FieldOps.Equal);
        }
        /** 创建人userid 精确 */
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            builder.field(PmsProjectBriefVO::getCreateUserId, query.getCreateUserId()).op(FieldOps.Equal);
        }
        /** 项目 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjSearch())) {
            String likeStr = "%" + query.getProjSearch() + "%";
            builder.field(PmsProjectBriefVO::getProjName, PmsProjectBriefVO::getProjNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        /** 合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getContractStatus())) {
            builder.field(PmsProjectBriefVO::getContractStatus, query.getContractStatus()).op(FieldOps.Equal);
        }
        /** 交付BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            builder.field(PmsProjectBriefVO::getDeliBuId, query.getDeliBuId()).op(FieldOps.Equal);
        }
        /** 签单BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSignBuId())) {
            builder.field(PmsProjectBriefVO::getSignBuId, query.getSignBuId()).op(FieldOps.Equal);
        }
        /** 项目进度状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProjProcessStatus())) {
            builder.field(PmsProjectBriefVO::getProjProcessStatus, query.getProjProcessStatus()).op(FieldOps.Equal);
        }
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }
}
