package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetCommonService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanDaysPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanRolePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanDaysQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanRoleQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanDaysService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanDaysVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanRoleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ResourcePlanningCycleEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsResourcePlanRoleConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanRoleDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsResourcePlanRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsResourcePlanRoleRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus.*;

/**
 * 资源计划角色明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsResourcePlanRoleServiceImpl extends BaseServiceImpl implements PmsResourcePlanRoleService {

    private final PmsResourcePlanRoleRepo pmsResourcePlanRoleRepo;
    private final PmsResourcePlanRoleDAO pmsResourcePlanRoleDAO;

    private final PmsResourcePlanDAO pmsResourcePlanDAO;

    private final CacheUtil cacheUtil;

    private final PrdCompositeAbilityService prdCompositeAbilityService;

    private final PrdAbilityLevelService prdAbilityLevelService;

    private final PmsResourcePlanDaysService pmsResourcePlanDaysService;

    private final PmsProjectMembersService pmsProjectMembersService;

    private final PmsProjectDAO pmsProjectDAO;
    private final PmsTimesheetCommonService pmsTimesheetCommonService;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    //@Override
    public PagingVO<PmsResourcePlanRoleVO> queryPaging(PmsResourcePlanRoleQuery query) {
        if (ObjectUtils.isEmpty(query.getPlanId())) {
            throw TwException.error("", "关联资源计划ID不能为空!");
        }
        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByKey(query.getPlanId());
        if (ObjectUtils.isEmpty(planVO)) {
            throw TwException.error("", "关联资源计划不存在!");
        }
        PagingVO<PmsResourcePlanRoleVO> page = pmsResourcePlanRoleDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty(page.getRecords())) {
            transSysSelectionAndName(planVO, page.getRecords());
        }
        return page;
    }

    //@Override
    public List<PmsResourcePlanRoleVO> queryList(PmsResourcePlanRoleQuery query) {
        if (ObjectUtils.isEmpty(query.getPlanId())) {
            throw TwException.error("", "关联资源计划ID不能为空!");
        }
        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByKey(query.getPlanId());
        if (ObjectUtils.isEmpty(planVO)) {
            throw TwException.error("", "关联资源计划不存在!");
        }
        List<PmsResourcePlanRoleVO> list = pmsResourcePlanRoleDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(list)) {
            transSysSelectionAndName(planVO, list);
        }
        return list;
    }

    //@Override
    public List<PmsResourcePlanRoleVO> queryListByPlanIdList(PmsResourcePlanRoleQuery query) {
        if (ObjectUtils.isEmpty(query.getPlanIdList())) {
            throw TwException.error("", "关联资源计划ID不能为空!");
        }
        List<PmsResourcePlanRoleVO> list = pmsResourcePlanRoleDAO.queryListDynamic(query);
        return list;
    }


    //@Override
    public List<PmsResourcePlanRoleVO> querySimpleList(PmsResourcePlanRoleQuery query) {
        List<PmsResourcePlanRoleVO> list = pmsResourcePlanRoleDAO.queryListDynamic(query);
        if (list.size() > 0) {
            List<Long> planIds = list.stream().map(PmsResourcePlanRoleVO::getPlanId).distinct().collect(Collectors.toList());
            List<PmsResourcePlanVO> pmsResourcePlanVOS = pmsResourcePlanDAO.queryByKeys(planIds);


            List<Long> roleDetailIds = list.stream().map(PmsResourcePlanRoleVO::getId).collect(Collectors.toList());
            // 查询 资源计划人天明细
            PmsResourcePlanDaysQuery daysQuery = new PmsResourcePlanDaysQuery();
            daysQuery.setRoleDetailIds(roleDetailIds);
            List<PmsResourcePlanDaysVO> pmsResourcePlanDaysList = null;//pmsResourcePlanDaysService.queryListDynamic(daysQuery);
            if (!ObjectUtils.isEmpty(pmsResourcePlanDaysList)) {
                Map<Long, List<PmsResourcePlanDaysVO>> daysInfo = new HashMap<>(roleDetailIds.size());
                Map<Long, List<PmsResourcePlanDaysVO>> groupByRole = pmsResourcePlanDaysList.stream().collect(Collectors.groupingBy(b -> b.getRoleDetailId()));
                for (Long roleDetailId : roleDetailIds) {
                    // 根据开始时间排序
                    List<PmsResourcePlanDaysVO> daysVOS = groupByRole.get(roleDetailId);
                    if (!ObjectUtils.isEmpty(daysVOS)) {
                        Collections.sort(daysVOS, Comparator.comparing(PmsResourcePlanDaysVO::getStartDate));
                        daysInfo.put(roleDetailId, daysVOS);
                    }
                }

                list.forEach(v -> {
                    Optional<PmsResourcePlanVO> first = pmsResourcePlanVOS.stream().filter(planVO -> planVO.getId().equals(v.getPlanId())).findFirst();
                    if (first.isPresent()) {
                        PmsResourcePlanVO pmsResourcePlanVO = first.get();
                        v.setObjId(pmsResourcePlanVO.getObjId());
                        v.setObjName(pmsResourcePlanVO.getObjName());
                    }
                    List<PmsResourcePlanDaysVO> daysVOS = daysInfo.get(v.getId());
                    if (!ObjectUtils.isEmpty(daysVOS)) {
                        v.setDaysInfo(daysVOS);
                    } else {
                        v.setTotalDays(BigDecimal.ZERO);
                        v.setTotalEqva(BigDecimal.ZERO);
                    }
                });
            }
        }

        return list;
    }

    //@Override
    public PmsResourcePlanVO queryResourcePlanVOByObj(Long objId, String planType) {
        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByObjId(objId, planType);
        List<PmsResourcePlanRoleVO> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(planVO)) {
            PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
            pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
            list = pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);
        }
        if (!ObjectUtils.isEmpty(list)) {
            transSysSelectionAndName(planVO, list);
            planVO.setResourcePlanRoleVOS(list);
        }
        return planVO;
    }

    //@Override
    public List<PmsResourcePlanRoleVO> queryByObj(Long objId, String planType) {
        List<PmsResourcePlanRoleVO> list = new ArrayList<>();
        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByObjId(objId, planType);
        if (!ObjectUtils.isEmpty(planVO)) {
            PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
            pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
            list = pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);
        }
        if (!ObjectUtils.isEmpty(list)) {
            transSysSelectionAndName(planVO, list);
        }
        return list;
    }

    //@Override
    public PmsResourcePlanRoleVO queryByKey(Long key) {
        PmsResourcePlanRoleDO entity = pmsResourcePlanRoleRepo.findById(key).orElseGet(PmsResourcePlanRoleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsResourcePlanRoleVO vo = PmsResourcePlanRoleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public PmsResourcePlanRoleVO insert(PmsResourcePlanRolePayload payload) {
        PmsResourcePlanRoleDO entityDo = PmsResourcePlanRoleConvert.INSTANCE.toDo(payload);
        return PmsResourcePlanRoleConvert.INSTANCE.toVo(pmsResourcePlanRoleRepo.save(entityDo));
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public PmsResourcePlanRoleVO update(PmsResourcePlanRolePayload payload) {
        PmsResourcePlanRoleDO entity = pmsResourcePlanRoleRepo.findById(payload.getId()).orElseGet(PmsResourcePlanRoleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsResourcePlanRoleDO entityDo = PmsResourcePlanRoleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsResourcePlanRoleConvert.INSTANCE.toVo(pmsResourcePlanRoleRepo.save(entity));
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsResourcePlanRolePayload payload) {
        PmsResourcePlanRoleDO entity = pmsResourcePlanRoleRepo.findById(payload.getId()).orElseGet(PmsResourcePlanRoleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsResourcePlanRoleDAO.updateByKeyDynamic(payload);
        return result;
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            // TODO 某条数据的历史周和本周的人天规划 存在>0 的数据，不可删除，提示“过去存在资源规划”
            // pmsResourcePlanRoleDAO.deleteSoft(keys);
            keys.stream().forEach(id -> {
                Optional<PmsResourcePlanRoleDO> optional = pmsResourcePlanRoleRepo.findById(id);
                if (!optional.isEmpty()) {
                    PmsResourcePlanRoleDO entity = optional.get();
                    // 查找工时数据，判断是否存在 已审批、审批通过、已结算的工时数据，存在的话不让删除
                    // 根据计划id查找事由id、事由类型
                    PmsResourcePlanVO pmsResourcePlanVO = pmsResourcePlanDAO.queryByKey(entity.getPlanId());
                    Assert.notNull(pmsResourcePlanVO, "计划不存在");
                    Long objId = pmsResourcePlanVO.getObjId();
                    String planType = pmsResourcePlanVO.getPlanType();

                    TimesheetQuery timesheetQuery = new TimesheetQuery();
                    timesheetQuery.setReasonId(objId);
                    timesheetQuery.setReasonType(planType);
                    timesheetQuery.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
                    timesheetQuery.setTsUserId(entity.getResId());
                    long count = pmsTimesheetCommonService.count(timesheetQuery);
                    if (count > 0) {
                        throw TwException.error("", "存在此项目的工时数据，不可删除");
                    }
                }
            });
            pmsResourcePlanRoleDAO.deleteSoft(keys);
        }
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void hiddenRole(List<Long> keys, Integer hiddenFlag) {
        if (ObjectUtils.isEmpty(hiddenFlag)) {
            throw TwException.error("", "隐藏标志不能为空!");
        }
        if (!keys.isEmpty()) {
            pmsResourcePlanRoleDAO.hiddenRole(keys, hiddenFlag);
        }
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void importPlanRole(PmsResourcePlanRoleQuery query) {
        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByKey(query.getPlanId());
        if (ObjectUtils.isEmpty(planVO)) {
            throw TwException.error("", "关联资源计划不存在!");
        }
        List<PmsResourcePlanRoleVO> list = pmsResourcePlanRoleDAO.queryListDynamic(query);
        List<Long> resIds = list.stream().filter(v -> !ObjectUtils.isEmpty(v.getResId())).map(v -> v.getResId()).collect(Collectors.toList());
        //查询资源ID
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(planVO.getPlanType())) {
            PmsProjectMembersQuery membersQuery = new PmsProjectMembersQuery();
            membersQuery.setProjId(planVO.getObjId());
            List<PmsProjectMembersVO> membersVOS = pmsProjectMembersService.queryListDynamic(membersQuery);
            if (!ObjectUtils.isEmpty(membersVOS)) {
                // 1.成员中“资源”不为空的数据  2.不重复
                membersVOS = membersVOS.stream().filter(v -> !ObjectUtils.isEmpty(v.getResId()) && !resIds.contains(v.getResId())).collect(Collectors.toList());
                List<PmsResourcePlanRoleDO> addList = new ArrayList<>();
                LocalDate now = LocalDate.now();
                for (PmsProjectMembersVO vo : membersVOS) {
                    PmsResourcePlanRoleDO roleVO = new PmsResourcePlanRoleDO();
                    roleVO.setHiddenFlag(0);
                    roleVO.setPlanId(query.getPlanId());
                    roleVO.setRole(vo.getRole());
                    roleVO.setResId(vo.getResId());
                    roleVO.setStartDate(vo.getPlanStartDate());
                    roleVO.setEndDate(vo.getPlanEndDate());
                    roleVO.setCapasetLevelId(vo.getCapasetLevelId());
                    roleVO.setTotalDays(BigDecimal.ZERO);
                    roleVO.setTotalEqva(BigDecimal.ZERO);
                    //初始化当量系数
                    BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(vo.getResId(), null);
                    roleVO.setDistributeRate(eqvaRatio);
                    if (!ObjectUtils.isEmpty(vo.getEqvaRatio())) {
                        roleVO.setDistributeRate(vo.getEqvaRatio());
                    }
                    addList.add(roleVO);
                }
                if (!ObjectUtils.isEmpty(addList)) {
                    pmsResourcePlanRoleRepo.saveAll(addList);
                }
            }
        }
    }


    /**
     * 新增或修改
     *
     * @param payload
     */
    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void insertOrUpdate(PmsResourcePlanRolePayload payload) {
        if (ObjectUtils.isEmpty(payload.getPlanId())) {
            throw TwException.error("", "关联资源计划ID不能为空!");
        }
        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByKey(payload.getPlanId());
        if (ObjectUtils.isEmpty(payload.getRole())) {
            throw TwException.error("", "角色不能为空!");
        }
        // 检查复合能力不能为空
        if (ObjectUtils.isEmpty(payload.getCapasetLevelId())) {
            throw TwException.error("", payload.getRole() + "：复合能力不能为空!");
        }
        // 派发系数不能为空
        if (ObjectUtils.isEmpty(payload.getDistributeRate())) {
            throw TwException.error("", payload.getRole() + "：派发系数不能为空!");
        }
        // 开始日期不能大于结束日期
        if (payload.getStartDate() != null && payload.getEndDate() != null) {
            if (payload.getStartDate().isAfter(payload.getEndDate())) {
                throw TwException.error("", payload.getRole() + "：入场日期不能大于离场日期!");
            }
        }
        BigDecimal[] days = payload.getDays();
        if (ObjectUtils.isEmpty(days)) {
            throw TwException.error("", payload.getRole() + "：天数不能为空!");
        }
        if (!ObjectUtils.isEmpty(payload.getResId())) {
            PmsResourcePlanRoleQuery query = new PmsResourcePlanRoleQuery();
            query.setPlanId(payload.getPlanId());
            query.setResId(payload.getResId());
            List<PmsResourcePlanRoleVO> list = pmsResourcePlanRoleDAO.queryListDynamic(query);
            if (!ObjectUtils.isEmpty(list)) {
                if (ObjectUtils.isEmpty(payload.getId())) {
                    throw TwException.error("", "一个人在资源规划中只能有一行");
                } else {
                    if (!payload.getId().equals(list.get(0).getId())) {
                        throw TwException.error("", "一个人在资源规划中只能有一行");
                    }
                }
            }

        }
        if (ObjectUtils.isEmpty(payload.getHiddenFlag())) {
            payload.setHiddenFlag(0);
        }

        BigDecimal totalDays = BigDecimal.ZERO;
        List<PmsResourcePlanDaysPayload> daysPayloads = new ArrayList<>();
        String resourcePlanningCycle = planVO.getResourcePlanningCycle();
        LocalDate start = planVO.getStartDate();
        LocalDate end = planVO.getEndDate();
        if (ResourcePlanningCycleEnum.WEEK.getCode().equals(resourcePlanningCycle)) {
            // 根据开始时间、结束时间 算出有多少周，及每周的周一是哪天
            List<LocalDate> weeks = calculateWeeksBetweenLocalDates(start, end);
            if (days.length != weeks.size()) {
                throw TwException.error("", "计算的持续周数不对");
            }
            int num = weeks.size();
            for (int i = 0; i < num; i++) {
                BigDecimal day = (days[i] == null ? BigDecimal.ZERO : days[i]);
                if (day.compareTo(BigDecimal.ZERO) < 0) {
                    throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "周的天数要大于等于0！");
                }
                if (day.compareTo(new BigDecimal(7)) > 0) {
                    throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "周的天数要小于等于7！");
                }
                LocalDate time = weeks.get(i);
                if (i == 0) {
                    // 从开始日期到周天的天数
                    int daysBetween = daysBetween(start, start.with(DayOfWeek.SUNDAY));
                    if (day.compareTo(new BigDecimal(daysBetween)) > 0) {
                        throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "周的天数要小于等于" + daysBetween + "！");
                    }
                } else if (i == num - 1) {
                    // 从本周一到结束日期的天数
                    int daysBetween = daysBetween(time, end);
                    if (day.compareTo(new BigDecimal(daysBetween)) > 0) {
                        throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "周的天数要小于等于" + daysBetween + "！");
                    }
                }
                totalDays = totalDays.add(day);
                PmsResourcePlanDaysPayload daysDetail = new PmsResourcePlanDaysPayload();
                daysDetail.setDays(day);
                daysDetail.setStartDate(time);
                daysPayloads.add(daysDetail);
            }
        } else {
            // 根据开始时间、结束时间 算出具体月份
            List<LocalDate> months = calculateMonthsBetweenLocalDates(start, end);
            if (days.length != months.size()) {
                throw TwException.error("", "计算的持续月数不对");
            }
            int num = months.size();
            for (int i = 0; i < num; i++) {
                BigDecimal day = days[i];
                if (day.compareTo(BigDecimal.ZERO) < 0) {
                    throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "月的天数要大于等于0！");
                }
                LocalDate time = months.get(i);
                if (i == 0) {
                    // 从开始日期到下个月初的天数
                    long daysBetween = daysBetween(start, time.plusMonths(1).plusDays(-1));
                    if (day.compareTo(new BigDecimal(daysBetween)) > 0) {
                        throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "月的天数要小于等于" + daysBetween + "！");
                    }
                } else if (i == num - 1) {
                    // 从本月初到结束日期的天数
                    long daysBetween = daysBetween(time, end);
                    // 根据结束时间 计算出 从月初到现在的天数
                    if (day.compareTo(new BigDecimal(daysBetween)) > 0) {
                        throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "月的天数要小于等于" + daysBetween + "！");
                    }
                } else {
                    long daysBetween = time.lengthOfMonth();
                    if (day.compareTo(new BigDecimal(daysBetween)) > 0) {
                        throw TwException.error("", "角色 " + payload.getRole() + ":第" + (i + 1) + "月的天数要小于等于" + daysBetween + "！");
                    }
                }
                totalDays = totalDays.add(day);
                PmsResourcePlanDaysPayload daysDetail = new PmsResourcePlanDaysPayload();
                daysDetail.setDays(day);
                daysDetail.setStartDate(months.get(i));
                daysPayloads.add(daysDetail);
            }
        }
        payload.setTotalDays(totalDays);
        payload.setTotalEqva(payload.getDistributeRate().multiply(totalDays));

        //保存 资源计划角色明细
        Long roleDetailId = payload.getId();
        if (ObjectUtils.isEmpty(roleDetailId)) {
            PmsResourcePlanRoleVO roleVO = insert(payload);
            roleDetailId = roleVO.getId();
        } else {
            pmsResourcePlanRoleDAO.updateByKeyDynamic(payload);
            // 删除 旧的资源计划人天明细
            //  pmsResourcePlanDaysService.deleteSoftByRoleDetailId(roleDetailId);
        }
        // 保存 资源计划人天明细
        for (PmsResourcePlanDaysPayload daysDetail : daysPayloads) {
            daysDetail.setPlanId(payload.getPlanId());
            daysDetail.setRoleDetailId(roleDetailId);
        }
        if (!ObjectUtils.isEmpty(daysPayloads)) {
//            pmsResourcePlanDaysService.batchInsert(daysPayloads);
        }
        // 修改资源规划的更新时间
        PmsResourcePlanPayload planPayload = new PmsResourcePlanPayload();
        planPayload.setId(payload.getPlanId());
        pmsResourcePlanDAO.updateByKeyDynamic(planPayload);
        //修改项目资源规划更新日期
        PmsProjectPayload payloadProject = new PmsProjectPayload();
        payloadProject.setId(planVO.getObjId());
        payloadProject.setPlanUpdateDate(LocalDateTime.now());
        pmsProjectDAO.updateByKeyDynamic(payloadProject);
    }

    /**
     * 添加 复合能力  和  资源计划人天明细
     *
     * @param list
     */
    private void transSysSelectionAndName(PmsResourcePlanVO planVO, List<PmsResourcePlanRoleVO> list) {
        List<PmsResourcePlanDaysVO> initDaysData = initDaysData(planVO.getStartDate(), planVO.getEndDate(), planVO.getResourcePlanningCycle());
        List<Long> roleDetailIds = new ArrayList<>();
        List<Long> capasetLevelIds = new ArrayList<>();
        list.forEach(v -> {
            roleDetailIds.add(v.getId());
            if (!ObjectUtils.isEmpty(v.getCapasetLevelId())) {
                capasetLevelIds.add(v.getCapasetLevelId());
            }
            v.setDaysInfo(initDaysData);

            // 查询工时
            if (!ObjectUtils.isEmpty(v.getResId())) {
                TimesheetQuery timesheetQuery = new TimesheetQuery();
                timesheetQuery.setReasonId(planVO.getObjId());
                timesheetQuery.setReasonType(planVO.getPlanType());
                timesheetQuery.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
                timesheetQuery.setTsUserId(v.getResId());
                long count = pmsTimesheetCommonService.count(timesheetQuery);
                if (count > 0) {
                    v.setTimeSheetFlag(true);
                }
            }
        });

        if (!ObjectUtils.isEmpty(capasetLevelIds)) {
            // 先查询能力级别
            PrdAbilityLevelQuery abilityLevelQuery = new PrdAbilityLevelQuery();
            abilityLevelQuery.setIds(capasetLevelIds);
            List<PrdAbilityLevelVO> abilityLevelVOS = prdAbilityLevelService.getList(abilityLevelQuery);

            Map<Long, String> levelMap = new HashMap<>();
            Map<Long, Long> abilityMap = new HashMap<>();
            for (PrdAbilityLevelVO levelVO : abilityLevelVOS) {
                levelMap.put(levelVO.getId(), levelVO.getLevelDtlName());
                abilityMap.put(levelVO.getId(), levelVO.getAbilityId());
            }

            List<Long> abilityIds = abilityLevelVOS.stream().map(e -> e.getAbilityId()).collect(Collectors.toList());
            // 查询 复合能力
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setIds(abilityIds);
            List<PrdCompositeAbilityVO> levelVOS = prdCompositeAbilityService.getList(prdCompositeAbilityQuery);

            Map<Long, String> compositeAbilityMap = new HashMap<>();
            for (PrdCompositeAbilityVO compositeAbilityVO : levelVOS) {
                compositeAbilityMap.put(compositeAbilityVO.getId(), compositeAbilityVO.getName());
            }

            list.forEach(v -> {
                Long capasetLevelId = v.getCapasetLevelId();
                if (!ObjectUtils.isEmpty(capasetLevelId)) {
                    //级别
                    String levelDesc = levelMap.get(capasetLevelId);
                    //复合能力
                    Long compositeAbilityId = abilityMap.get(capasetLevelId);
                    if (compositeAbilityId != null) {
                        String compositeAbilityName = compositeAbilityMap.get(compositeAbilityId);
                        v.setCapasetLevelDesc(compositeAbilityName + "-" + levelDesc);
                    }
                }
            });
        }

        // 查询 资源计划人天明细
        PmsResourcePlanDaysQuery daysQuery = new PmsResourcePlanDaysQuery();
        daysQuery.setPlanId(planVO.getId());
        daysQuery.setRoleDetailIds(roleDetailIds);
//        List<PmsResourcePlanDaysVO> pmsResourcePlanDaysList = pmsResourcePlanDaysService.queryListDynamic(daysQuery);
//        if (!ObjectUtils.isEmpty(pmsResourcePlanDaysList)) {
//            Map<Long, List<PmsResourcePlanDaysVO>> daysInfo = new HashMap<>(roleDetailIds.size());
//            Map<Long, List<PmsResourcePlanDaysVO>> groupByRole = pmsResourcePlanDaysList.stream().collect(Collectors.groupingBy(b -> b.getRoleDetailId()));
//            for (Long roleDetailId : roleDetailIds) {
//                // 根据开始时间排序
//                List<PmsResourcePlanDaysVO> daysVOS = groupByRole.get(roleDetailId);
//                if (!ObjectUtils.isEmpty(daysVOS)) {
//                    Collections.sort(daysVOS, Comparator.comparing(PmsResourcePlanDaysVO::getStartDate));
//                    daysInfo.put(roleDetailId, daysVOS);
//                }
//            }
//
//            list.forEach(v -> {
//                List<PmsResourcePlanDaysVO> daysVOS = daysInfo.get(v.getId());
//                if (!ObjectUtils.isEmpty(daysVOS)) {
//                    v.setDaysInfo(daysVOS);
//                    if (v.getTotalEqva() == null) {
//                        if (v.getDistributeRate() == null) {
//                            //初始化当量系数
//                            BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(v.getResId(), null);
//                            v.setDistributeRate(eqvaRatio);
//                        }
//                        v.setTotalEqva(v.getTotalDays().multiply(v.getDistributeRate()));
//                    }
//                } else {
//                    v.setTotalDays(BigDecimal.ZERO);
//                    v.setTotalEqva(BigDecimal.ZERO);
//                }
//            });
//        }
    }


    //@Override
    public List<LocalDate> calculateWeeksBetweenLocalDates(LocalDate start, LocalDate end) {
        List<LocalDate> mondays = new ArrayList<>();
        mondays.add(getMondayOfCurrentWeek(start));
        mondays.add(getMondayOfCurrentWeek(end));
        LocalDate current = start;
        while (current.isBefore(end)) {
            if (current.getDayOfWeek() == DayOfWeek.MONDAY) {
                if (!mondays.contains(current)) {
                    mondays.add(current);
                }
            }
            current = current.plusDays(1);
        }
        // 排序
        Collections.sort(mondays);
        return mondays;
    }

    public static LocalDate getMondayOfCurrentWeek(LocalDate currentDate) {
        int dayOfWeek = currentDate.getDayOfWeek().getValue();
        return currentDate.minusDays(dayOfWeek - 1);
    }

    //@Override
    public List<LocalDate> calculateMonthsBetweenLocalDates(LocalDate start, LocalDate end) {
        List<LocalDate> months = new ArrayList<>();
        months.add(start);
        months.add(end);
        LocalDate current = start;
        while (current.isBefore(end)) {
            months.add(current);
            current = current.plusMonths(1);
        }
        // 获取每个月的第一天  并且去重
        List<LocalDate> result = new ArrayList<>();
        for (LocalDate time : months) {
            LocalDate newTime = time.withDayOfMonth(1);
            if (!result.contains(newTime)) {
                result.add(newTime);
            }
        }
        // 排序
        Collections.sort(result);
        return result;
    }

    //@Override
    public List<PmsResourcePlanDaysVO> initDaysData(LocalDate start, LocalDate end, String resourcePlanningCycle) {
        List<PmsResourcePlanDaysVO> planDaysVOS = new ArrayList<>();
        if (ResourcePlanningCycleEnum.WEEK.getCode().equals(resourcePlanningCycle)) {
            // 根据开始时间、结束时间 算出有多少周，及每周的周一是哪天
            List<LocalDate> weeks = calculateWeeksBetweenLocalDates(start, end);
            int num = weeks.size();
            for (int i = 0; i < num; i++) {
                PmsResourcePlanDaysVO daysDetail = new PmsResourcePlanDaysVO();
                LocalDate time = weeks.get(i);
                daysDetail.setStartDate(time);
//                if (i == 0) {
//                    // 从开始日期到周天的天数
//                    daysDetail.setDays(BigDecimal.valueOf(daysBetween(start, start.with(DayOfWeek.SUNDAY))));
//                } else if (i == num - 1) {8
//                    // 从本周一到结束日期的天数
//                    daysDetail.setDays(BigDecimal.valueOf(daysBetween(time, end)));
//                } else {
//                    daysDetail.setDays(BigDecimal.valueOf(7));
//                }
                daysDetail.setDays(BigDecimal.ZERO);
                planDaysVOS.add(daysDetail);
            }
        } else {
            // 根据开始时间、结束时间 算出具体月份
            List<LocalDate> months = calculateMonthsBetweenLocalDates(start, end);
            int num = months.size();
            for (int i = 0; i < num; i++) {
                PmsResourcePlanDaysVO daysDetail = new PmsResourcePlanDaysVO();
                LocalDate time = months.get(i);
                daysDetail.setStartDate(time);
//                if (i == 0) {
//                    daysDetail.setDays(BigDecimal.valueOf(daysBetween(start, time.plusMonths(1).plusDays(-1))));
//                } else if (i == num - 1) {
//                    daysDetail.setDays(BigDecimal.valueOf(daysBetween(time, end)));
//                } else {
//                    daysDetail.setDays(BigDecimal.valueOf(time.lengthOfMonth()));
//                }
                daysDetail.setDays(BigDecimal.ZERO);
                planDaysVOS.add(daysDetail);
            }
        }
        return planDaysVOS;
    }

    public int daysBetween(LocalDate start, LocalDate end) {
        List<LocalDate> dateRange = new ArrayList<>();
        dateRange.add(start);
        dateRange.add(end);

        LocalDate currentDate = start;

        while (!currentDate.isAfter(end)) {
            dateRange.add(currentDate);
            currentDate = currentDate.plusDays(1);
        }

        // 去重
        Set<LocalDate> uniqueDateSet = dateRange.stream().collect(Collectors.toSet());
        return uniqueDateSet.size();
    }


    //@Override
    public PmsResourcePlanRoleVO getByObjectIdAndUserId(Long objId, Long userId, String objType) {
        Assert.notNull(objId, "关联对象ID不能为空");
        Assert.notNull(userId, "用户ID不能为空");
        Assert.notNull(objType, "关联对象类型不能为空");

        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByObjId(objId, objType);
        if (null == planVO) {
            throw TwException.error("", "资源计划不存在");
        }
        PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
        pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
        pmsResourcePlanRoleQuery.setResId(userId);
        List<PmsResourcePlanRoleVO> pmsResourcePlanRoleVOS = pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);

        // 正常情况下 一个资源只能有一个规划数据，这里查询兼容下多条的情况
        if (!CollectionUtils.isEmpty(pmsResourcePlanRoleVOS)) {
            if (pmsResourcePlanRoleVOS.size() > 1) {
                log.error("资源规划数据异常，匹配到多条计划; objId:{};userId:{};objType:{}", objId, userId, objType);
                log.error("资源规划数据异常，匹配到多条计划", pmsResourcePlanRoleVOS);
                throw TwException.error("", "资源规划数据异常，匹配到多条计划");
            }
            PmsResourcePlanRoleVO pmsResourcePlanRoleVO = pmsResourcePlanRoleVOS.get(0);
            return pmsResourcePlanRoleVO;
        }
        return null;
    }

    //@Override
    public BigDecimal getByObjectId(Long objId, String objType) {
        Assert.notNull(objId, "关联对象ID不能为空");
        Assert.notNull(objType, "关联对象类型不能为空");

        PmsResourcePlanVO planVO = pmsResourcePlanDAO.queryByObjId(objId, objType);
        if (null == planVO) {
            throw TwException.error("", "资源计划不存在");
        }
        PmsResourcePlanRoleQuery pmsResourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
        pmsResourcePlanRoleQuery.setPlanId(planVO.getId());
        List<PmsResourcePlanRoleVO> pmsResourcePlanRoleVOS = pmsResourcePlanRoleDAO.queryListDynamic(pmsResourcePlanRoleQuery);

        if (!CollectionUtils.isEmpty(pmsResourcePlanRoleVOS)) {
            BigDecimal totalDays = pmsResourcePlanRoleVOS.stream()
                    .map(PmsResourcePlanRoleVO::getTotalDays)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal::add)
                    .orElse(BigDecimal.ZERO);
            return totalDays;
        }
        return BigDecimal.ZERO;
    }

}
