package com.elitesland.tw.tw5.server.prd.purchase.purenum;

import com.elitesland.tw.tw5.server.common.TwException;
import lombok.Getter;

/**
 * @author likunpeng
 * @date 2023/12/22
 * 采购合同枚举类
 */
public interface PurchaseContractEnum {

    /**
     * 采购合同类型
     */
    @Getter
    enum PurchaseConType implements PurchaseContractEnum {
        PURCHASING_AGENT("PURCHASING_AGENT", "代采购"),
        AGENCY_FEE("AGENCY_FEE", "代理费"),
        OUTSOURCING("OUTSOURCING", "外包"),
        PROJECT_RENT("PROJECT_RENT", "项目房租"),
        PROJECT_COST("PROJECT_COST", "项目成本"),
        OPERATION_SUPPORT("OPERATION_SUPPORT", "运营支撑"),
        ;

        private final String code;
        private final String desc;

        PurchaseConType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PurchaseConType match(String code) {
            for (PurchaseConType purchaseConType : PurchaseConType.values()) {
                if (purchaseConType.getCode().equals(code)) {
                    return purchaseConType;
                }
            }
            throw TwException.error("", "未找到相关的采购合同类型，请检查");
        }
    }

    /**
     * 业务性质类型
     */
    @Getter
    enum PurchaseBusinessType implements PurchaseContractEnum {
        PURCHASING_AGENT("PURCHASING_AGENT", "代采购"),
        AGENCY_FEE("AGENCY_FEE", "代理费"),
        OUTSOURCING("OUTSOURCING", "外包"),
        PROJECT_RENT("PROJECT_RENT", "项目房租"),
        PROJECT_COST("PROJECT_COST", "项目成本"),
        OPERATION_SUPPORT("OPERATION_SUPPORT", "运营支撑"),
        ;

        private final String code;
        private final String desc;

        PurchaseBusinessType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PurchaseBusinessType match(String purBusinessTypeCode) {
            for (PurchaseBusinessType purchaseBusinessType : PurchaseBusinessType.values()) {
                if (purchaseBusinessType.getCode().equals(purBusinessTypeCode)) {
                    return purchaseBusinessType;
                }
            }
            throw TwException.error("", "未找到相关的业务性质类型，请检查");
        }
    }
}
