package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ContractNodeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BatchStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.ReceStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.product.entity.QPrdProductDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConInvBatchDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConReceivablePlanDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Repository
@RequiredArgsConstructor
public class ConReceivablePlanDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConReceivablePlanRepo repo;
    private final QConReceivablePlanDO qdo = QConReceivablePlanDO.conReceivablePlanDO;
    private final QSaleConContractDO qdoSaleCon = QSaleConContractDO.saleConContractDO;
    private final QSaleConContractDO qdoSaleCon1 = new QSaleConContractDO("qdoSaleCon1");
    private final QPmsProjectDO qdoProject = QPmsProjectDO.pmsProjectDO;
    //客户表
    //  private final QCrmCustomerDO qdoCrmCust = QCrmCustomerDO.crmCustomerDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QConInvBatchDO qdoInvBatch = QConInvBatchDO.conInvBatchDO;
    // private final QPrdOrgCompanyDO qdocompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdProductDO qdoProduct = QPrdProductDO.prdProductDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessPartnerDO qBusinessPartnerOuDO = new QBusinessPartnerDO("qBusinessPartnerOuDO");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConReceivablePlanVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConReceivablePlanVO.class,
                        qdo.id,
                        qdo.remark,
                        qdo.createUserId,
                        qdo.creator,
                        qdo.createTime,
                        qdo.modifyUserId,
                        qdo.updater,
                        qdo.modifyTime,
                        // 收款号
                        qdo.receNo,
                        // 收款阶段
                        qdo.receStage,
                        // 当期收款金额
                        qdo.receAmt,
                        // 当期收款比例
                        qdo.receRatio,
                        // 预计收款日期
                        qdo.expectReceDate,
                        // 收款状态
                        qdo.receStatus,
                        // 预计开票日期
                        qdo.expectInvDate,
//                // 开票状态
//                qdo.invStatus,
                        // 开票状态
                        qdoInvBatch.batchStatus.as("invStatus"),
                        // 合同税率
                        qdoSaleCon.taxRate,
                        // 开票税率
                        qdoInvBatch.taxRate.as("invTaxRate"),
                        // 实际开票日期
                        qdoInvBatch.batchDate.as("invDate"),
                        // 已开票金额
                        qdo.alreadyInvAmt,
                        // 未开票金额
                        qdo.notInvAmt,
                        // 已收款金额
                        qdo.alreadyReceAmt,
                        // 实际收款日期
                        qdo.actualReceDate,
                        // 未收款金额
                        //qdo.notReceAmt,
                        // 已确认金额
                        qdo.confirmedAmt,
//                qdo.actualRecvAmt.subtract(qdo.confirmedAmt).as("distAmt"),
                        // 确认收入日期
                        qdo.confirmedAmtDate,
                        // 子合同ID
                        qdo.saleConId,
                        // 子合同名称
                        qdoSaleCon.name.as("saleConName"),
                        // 子合同号
                        qdoSaleCon.code.as("saleConCode"),
                        // 产品大类
                        qdoSaleCon.productClass,
                        // 工作类型
                        qdoSaleCon.workType,
                        // 项目
                        qdoProject.id.as("projId"),
                        // 项目名称
                        qdoProject.projName,
                        // 项目编号
                        qdoProject.projNo,
                        // 项目经理
                        qdoProject.pmResId.as("pmUserId"),
                        // 客户ID
                        qdoSaleCon.custId,
                        // 客户名称
                        qBusinessPartnerDO.partnerName.as("custName"),
                        // 客户地址簿id
                        qBusinessPartnerDO.bookId.as("custBookId"),
                        qBusinessPartnerDO.id.as("partnerId"),
                        //jde编号
                        //     qBusinessCustomerInfoDO.customerNo,
                        // 主合同名称
                        qdoSaleCon1.name.as("parentName"),
                        qdoSaleCon1.id.as("parentId"),
                        // 参考合同号
                        qdoSaleCon.referCode,
                        // 子合同状态
                        qdoSaleCon.status.as("saleConStatus"),
                        // 产品
                        qdoProduct.prodName,
                        // 合同开始日期
                        qdoSaleCon.startDate,
                        // 合同结束日期
                        qdoSaleCon.endDate,
                        // 交付BU_ID
                        qdoSaleCon.deliBuId,
                        // 交付负责人ID
                        qdoSaleCon.deliUserId,
                        // 签单buID
                        qdoSaleCon.signBuId,
                        // 副签单BU
                        qdoSaleCon.coSignBuId,
                        // 副签单负责人
                        qdoSaleCon.coSignUserId,
                        // 销售人员用户ID
                        qdoSaleCon.saleManUserId,
                        // PMO用户ID
                        qdoSaleCon.pmoUserId,
                        qdo.receivePlanIdV4,
                        qdoSaleCon.contractIdV4.as("saleConIdV4"),
                        //主合同签约公司id
                        // qdoSaleCon1.ouId,
                        //统一用ouBookId
                        qdoSaleCon1.ouBookId,
                        qBusinessPartnerOuDO.partnerName.as("ouName"),
                        qdo.relApplyNo,
                        qdo.actualRecvAmt,// 实际收款金额
                        //qdo.receAmt.subtract(qdo.actualRecvAmt).as("notReceAmt"),
                        qdo.actualRecvDate,
                        qdo.invBatchId,
                        qdoInvBatch.batchNo.as("invBatchNo"),
                        qdoSaleCon.remark.as("contractRemark"),
                        // 发票号
                        //   qConInvBatchInvdtlDO.invNo,
                        // 发票抬头
                        qdoInvBatch.invTitle,
                        qdoInvBatch.jdeDocumentNo,
                        qdoInvBatch.jdeCompany,
                        qdoInvBatch.jdePaymentItem,
                        qdoInvBatch.jdeInvoiceVoucher,
                        qdoInvBatch.jdeDocumentType
                )).from(qdo)
                .leftJoin(qdoSaleCon).on(qdo.saleConId.longValue().eq(qdoSaleCon.id.longValue()))
                .leftJoin(qdoProduct).on(qdoSaleCon.product.longValue().eq(qdoProduct.id.longValue()))
                .leftJoin(qdoSaleCon1).on(qdoSaleCon.parentId.longValue().eq(qdoSaleCon1.id.longValue()))
                .leftJoin(qBusinessPartnerDO).on(qdoSaleCon.custId.longValue().eq(qBusinessPartnerDO.bookId.longValue()))
                //     .leftJoin(qBusinessCustomerInfoDO).on(qBusinessCustomerInfoDO.partnerId.eq(qBusinessPartnerDO.id).and(qBusinessCustomerInfoDO.deleteFlag.eq(0)))
                .leftJoin(qdoProject).on(qdoProject.contractId.longValue().eq(qdoSaleCon.id.longValue()))
                .leftJoin(qdoRef).on(qdoSaleCon.saleManUserId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoInvBatch).on(qdoInvBatch.id.longValue().eq(qdo.invBatchId))
                //     .leftJoin(qConInvBatchInvdtlDO).on(qConInvBatchInvdtlDO.invbatchId.eq(qdoInvBatch.id).and(qConInvBatchInvdtlDO.deleteFlag.eq(0)))
                //todo wly
                .leftJoin(qBusinessPartnerOuDO).on(qBusinessPartnerOuDO.bookId.longValue().eq(qdoSaleCon1.ouBookId.longValue()));
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConReceivablePlanVO> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(Projections.bean(ConReceivablePlanVO.class,
                        qdo.id
                )).from(qdo)
                .leftJoin(qdoSaleCon).on(qdo.saleConId.longValue().eq(qdoSaleCon.id.longValue()))
                .leftJoin(qdoProduct).on(qdoSaleCon.product.longValue().eq(qdoProduct.id.longValue()))
                .leftJoin(qdoSaleCon1).on(qdoSaleCon.parentId.longValue().eq(qdoSaleCon1.id.longValue()))
                .leftJoin(qBusinessPartnerDO).on(qdoSaleCon.custId.longValue().eq(qBusinessPartnerDO.bookId.longValue()))
                //   .leftJoin(qBusinessCustomerInfoDO).on(qBusinessCustomerInfoDO.partnerId.eq(qBusinessPartnerDO.id).and(qBusinessCustomerInfoDO.deleteFlag.eq(0)))
                .leftJoin(qdoProject).on(qdoProject.contractId.longValue().eq(qdoSaleCon.id.longValue()))
                .leftJoin(qdoRef).on(qdoSaleCon.saleManUserId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoInvBatch).on(qdoInvBatch.id.longValue().eq(qdo.invBatchId))
                //     .leftJoin(qConInvBatchInvdtlDO).on(qConInvBatchInvdtlDO.invbatchId.eq(qdoInvBatch.id).and(qConInvBatchInvdtlDO.deleteFlag.eq(0)))
                //todo wly
                .leftJoin(qBusinessPartnerOuDO).on(qBusinessPartnerOuDO.bookId.longValue().eq(qdoSaleCon1.ouBookId.longValue()));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConReceivablePlanVO> getJpaQueryWhere(ConReceivablePlanQuery query) {
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        jpaQuery.groupBy(qdo.id);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConReceivablePlanVO> getJpaQueryCountWhere(ConReceivablePlanQuery query) {
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQuerySelectCount();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        jpaQuery.groupBy(qdo.id);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConReceivablePlanQuery query) {
//        long total = jpaQueryFactory
//            .select(qdo.count())
//            .from(qdo)
//            .from(qdoSaleCon)
//            .from(qdoSaleCon1)
//            .from(qdoCrmCust)
//            .where(where(query))
//            .fetchOne();
        long total = getJpaQueryCountWhere(query).fetch().size();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConReceivablePlanQuery query) {
        List<Predicate> list = new ArrayList<>();
        list.add(qdo.deleteFlag.eq(0));
        list.add(qdoSaleCon.deleteFlag.eq(0));
        list.add(qBusinessPartnerDO.deleteFlag.eq(0));
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 记录唯一ID列表 精确 */
        if (!CollectionUtils.isEmpty(query.getIds())) {
            list.add(qdo.id.in(query.getIds()));
        }
        /** 收款号 模糊 */
        if (!ObjectUtils.isEmpty(query.getReceNo())) {
            list.add(qdo.receNo.like(SqlUtil.toSqlLikeString(query.getReceNo())));
        }
        /** 收款阶段 精确 */
        if (!ObjectUtils.isEmpty(query.getReceStage())) {
            list.add(qdo.receStage.eq(query.getReceStage()));
        }
        /** 当期收款金额 精确 */
        if (!ObjectUtils.isEmpty(query.getReceAmt())) {
            list.add(qdo.receAmt.eq(query.getReceAmt()));
        }
        /** 当期收款比例 精确 */
        if (!ObjectUtils.isEmpty(query.getReceRatio())) {
            list.add(qdo.receRatio.eq(query.getReceRatio()));
        }
        /** 收款状态 精确 */
        if (!ObjectUtils.isEmpty(query.getReceStatus())) {
            list.add(qdo.receStatus.eq(query.getReceStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getReceStatusList())) {
            list.add(qdo.receStatus.in(query.getReceStatusList()));
        }
        /*预计开票日期 结束日期 */
        if (!ObjectUtils.isEmpty(query.getExpectInvDateEnd())) {
            list.add(qdo.expectInvDate.before(query.getExpectInvDateEnd()));
        }
        /** 预计开票日期 精确 */
        if (!CollectionUtils.isEmpty(query.getExpectInvDate()) && query.getExpectInvDate().size() == 2) {
            list.add(qdo.expectInvDate.between(query.getExpectInvDate().get(0), query.getExpectInvDate().get(1)));
        }
        /** 开票状态 精确 */
        if (!ObjectUtils.isEmpty(query.getInvStatus())) {
            list.add(qdo.invStatus.eq(query.getInvStatus()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 已开票金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAlreadyInvAmt())) {
            list.add(qdo.alreadyInvAmt.eq(query.getAlreadyInvAmt()));
        }
        /** 未开票金额 精确 */
        if (!ObjectUtils.isEmpty(query.getNotInvAmt())) {
            list.add(qdo.notInvAmt.eq(query.getNotInvAmt()));
        }
        /** 已收款金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAlreadyReceAmt())) {
            list.add(qdo.alreadyReceAmt.eq(query.getAlreadyReceAmt()));
        }
        /** 未收款金额 精确 */
        if (!ObjectUtils.isEmpty(query.getNotReceAmt())) {
            list.add(qdo.notReceAmt.eq(query.getNotReceAmt()));
        }
        /** 已确认金额 精确 */
//        if (!ObjectUtils.isEmpty(query.getConfirmedAmt())) {
//            list.add(qdo.confirmedAmt.eq(query.getConfirmedAmt()));
//        }
        if (!CollectionUtils.isEmpty(query.getConfirmedAmt()) && query.getConfirmedAmt().size() == 2) {
            switch (query.getConfirmedAmt().get(0)) {
                case "=":
                    list.add(qdo.confirmedAmt.eq(BigDecimal.valueOf(Long.valueOf(query.getConfirmedAmt().get(1)))));
                    break;
                case "<":
                    list.add(qdo.confirmedAmt.lt(BigDecimal.valueOf(Long.valueOf(query.getConfirmedAmt().get(1)))));
                    break;
                case ">":
                    list.add(qdo.confirmedAmt.gt(BigDecimal.valueOf(Long.valueOf(query.getConfirmedAmt().get(1)))));
                    break;
                case "!=":
                    list.add(qdo.confirmedAmt.ne(BigDecimal.valueOf(Long.valueOf(query.getConfirmedAmt().get(1)))));
                    break;
            }
        }
        if (!CollectionUtils.isEmpty(query.getDistAmt()) && query.getDistAmt().size() == 2) {
            switch (query.getDistAmt().get(0)) {
                case "=":
                    list.add((qdo.actualRecvAmt.subtract(qdo.confirmedAmt)).eq(BigDecimal.valueOf(Long.valueOf(query.getDistAmt().get(1)))));
                    break;
                case "<":
                    list.add((qdo.actualRecvAmt.subtract(qdo.confirmedAmt)).lt(BigDecimal.valueOf(Long.valueOf(query.getDistAmt().get(1)))));
                    break;
                case ">":
                    list.add((qdo.actualRecvAmt.subtract(qdo.confirmedAmt)).gt(BigDecimal.valueOf(Long.valueOf(query.getDistAmt().get(1)))));
                    break;
                case "!=":
                    list.add((qdo.actualRecvAmt.subtract(qdo.confirmedAmt)).ne(BigDecimal.valueOf(Long.valueOf(query.getDistAmt().get(1)))));
                    break;
            }
        }
        /** 确认收入日期 精确 */
        if (!ObjectUtils.isEmpty(query.getConfirmedAmtDate())) {
            list.add(qdo.confirmedAmtDate.eq(query.getConfirmedAmtDate()));
        }
        /** 子合同ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleConId())) {
            list.add(qdo.saleConId.eq(query.getSaleConId()));
        }
        if (!CollectionUtils.isEmpty(query.getSaleConIds())) {
            list.add(qdo.saleConId.in(query.getSaleConIds()));
        }
        /** 客户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qdoSaleCon.custId.eq(query.getCustId()));
        }
        /** 子合同号 模糊 */
        if (!ObjectUtils.isEmpty(query.getSaleConCode())) {
            list.add(qdoSaleCon.code.like(SqlUtil.toSqlLikeString(query.getSaleConCode())));
        }
        /** 子合同名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getSaleConName())) {
            list.add(qdoSaleCon.name.like(SqlUtil.toSqlLikeString(query.getSaleConName())));
        }
        /** 主合同名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getParentName())) {
            list.add(qdoSaleCon1.name.like(SqlUtil.toSqlLikeString(query.getParentName())));
        }
        /** 主合同签约客户名称  */
        if (!ObjectUtils.isEmpty(query.getOuBookId())) {
            list.add(qdoSaleCon1.ouBookId.eq(query.getOuBookId()));
        }
        /** 参考合同号 模糊 */
        if (!ObjectUtils.isEmpty(query.getReferCode())) {
            list.add(qdoSaleCon.referCode.like(SqlUtil.toSqlLikeString(query.getReferCode())));
        }
        /** 子合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleConStatus())) {
            list.add(qdoSaleCon.status.eq(query.getSaleConStatus()));
        }
        /** 子合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleConStatusIn())) {
            list.add(qdoSaleCon.status.in(query.getSaleConStatusIn()));
        }
        /** 交付BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdoSaleCon.deliBuId.eq(query.getDeliBuId()));
        }
        /** 销售人员ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleManUserId())) {
            list.add(qdoSaleCon.saleManUserId.eq(query.getSaleManUserId()));
        }
        /** BU负责人ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            list.add(qdoSaleCon.deliUserId.eq(query.getDeliUserId()));
        }
        /** PMO 精确 */
        if (!ObjectUtils.isEmpty(query.getPmoUserId())) {
            list.add(qdoSaleCon.pmoUserId.eq(query.getPmoUserId()));
        }
        /** 预计收款日期 范围 */
        if (!ObjectUtils.isEmpty(query.getExpectReceDate())) {
            list.add(qdo.expectReceDate.between(query.getExpectReceDate().get(0), query.getExpectReceDate().get(1)));
        }
        /** 预计收款日期 结束值 */
        if (!ObjectUtils.isEmpty(query.getExpectRecvDateEnd())) {
            list.add(qdo.expectReceDate.before(query.getExpectRecvDateEnd()));
        }
        if (!ObjectUtils.isEmpty(query.getSignBuId())) {
            list.add(qdoSaleCon.signBuId.eq(query.getSignBuId()));
        }
        /** 开票日期 范围 */
        if (!ObjectUtils.isEmpty(query.getInvDate())) {
            list.add(qdo.invDate.between(query.getInvDate().get(0), query.getInvDate().get(1)));
        }
        /** 开票日期 范围 */
        if (!ObjectUtils.isEmpty(query.getInvOuId())) {
            list.add(qdoInvBatch.invOuId.eq(query.getInvOuId()));
        }
        /** 实际收款日期 范围 */
        if (!ObjectUtils.isEmpty(query.getActualRecvDate())) {
            list.add(qdo.actualRecvDate.between(query.getActualRecvDate().get(0), query.getActualRecvDate().get(1)));
        }
        /** BU负责人ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvBatchId())) {
            list.add(qdo.invBatchId.eq(query.getInvBatchId()));
        }
        if (!CollectionUtils.isEmpty(query.getInvBatchIds())) {
            list.add(qdo.invBatchId.in(query.getInvBatchIds()));
        }
        /**
         * 收款号查询
         */
        if (!CollectionUtils.isEmpty(query.getReceNos())) {
            list.add(qdo.receNo.in(query.getReceNos()));
        }
        /**
         * 回收标志
         */
        if (!ObjectUtils.isEmpty(query.getRecycleSettleFlag())) {
            list.add(qdoInvBatch.recycleSettleFlag.eq(query.getRecycleSettleFlag()));
        }
        /**
         *  自动收款/手动收款查询
         * 自动收款传1  查询未开票 已开票 且 开票状态是已开票代收款 空
         * 手动收款传2  不查询已全额收款 且 开票状态是已开票代收款  收款中 空
         */
        if (!ObjectUtils.isEmpty(query.getReceiveAccountFlag())) {
            if (query.getReceiveAccountFlag() == 1) {
                list.add(qdo.receStatus.in(Arrays.asList(ReceStatusEnum.NO_INVOICE.getCode(), ReceStatusEnum.OK_INVOICE.getCode())));
                list.add(qdoInvBatch.batchStatus.isNull().or(qdoInvBatch.batchStatus.eq(BatchStatusEnum.APPROVETORECV.getCode())));
            }
            if (query.getReceiveAccountFlag() == 2) {
                list.add(qdo.receStatus.notIn(Arrays.asList(ReceStatusEnum.FULL_PAYMENT.getCode())));
                list.add(qdoInvBatch.batchStatus.isNull().or(qdoInvBatch.batchStatus.in(Arrays.asList(BatchStatusEnum.RECVING.getCode(), BatchStatusEnum.APPROVETORECV.getCode()))));
            }
        }

        /**
         * 关于列表权限
         */
        if ((!CollectionUtils.isEmpty(query.getOrgIdsByPermission()) || (!CollectionUtils.isEmpty(query.getUserIdsByPermission())))) {
            list.add(qdoSaleCon.deliBuId.in(query.getOrgIdsByPermission()).or(qdoSaleCon.signBuId.in(query.getOrgIdsByPermission())).or(qdoRef.orgId.in(query.getOrgIdsByPermission()))
                    .or(qdoSaleCon.saleManUserId.in(query.getUserIdsByPermission())).or(qdoSaleCon.deliUserId.in(query.getUserIdsByPermission())).or(qdoSaleCon.createUserId.in(query.getUserIdsByPermission()))
                    .or(qdoProject.pmResId.in(query.getUserIdsByPermission()))
            );
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConReceivablePlanVO queryByKey(Long id) {
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据开票批次id查询
     *
     * @param invBatchId 主键
     * @return 结果
     */
    public ConReceivablePlanVO queryByInvBatchId(Long invBatchId) {
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.invBatchId.eq(invBatchId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConReceivablePlanVO> queryListDynamic(ConReceivablePlanQuery query) {
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConReceivablePlanVO> queryPaging(ConReceivablePlanQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQueryWhere(query);
        List<ConReceivablePlanVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConReceivablePlanVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConReceivablePlanDO save(ConReceivablePlanDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConReceivablePlanDO> saveAll(List<ConReceivablePlanDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConReceivablePlanPayload payload) {
        JPAUpdateClause update = null;
        if (!CollectionUtils.isEmpty(payload.getIds())) {
            update = jpaQueryFactory.update(qdo).where(qdo.id.in(payload.getIds()));
        } else {
            update = jpaQueryFactory.update(qdo).where(qdo.id.eq(payload.getId()));
        }
        if (payload.getReceStatus() != null) {
            update.set(qdo.receStatus, payload.getReceStatus());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("invBatchId")) {
                update.setNull(qdo.invBatchId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    public long updateStatusAndRemarkByKeys(List<Long> ids, String status, String remark) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.receStatus, status)
                .set(qdo.remark, remark)
                .where(qdo.id.in(ids));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public long updateInvAmt(List<Long> ids, LocalDate invDate) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.receStatus, "4")
                .set(qdo.alreadyInvAmt, qdo.actualRecvAmt)
                .set(qdo.invDate, invDate)
                .where(qdo.id.in(ids));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据合同id查询收款计划
     *
     * @param saleConId
     * @return List<ConReceivablePlanVO>
     */
    public List<ConReceivablePlanVO> queryBySaleConId(Long saleConId) {
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.saleConId.eq(saleConId)
                        .and(qdo.deleteFlag.eq(0)))
                .groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 将开票批次写回收款计划表
     *
     * @param invBatchId           开票批次ID
     * @param conReceivablePlanIds 收款计划ID集合
     */
    public void setInvBatchId(Long invBatchId, List<Long> conReceivablePlanIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.invBatchId, invBatchId)
                .where(qdo.id.in(conReceivablePlanIds));
        // 拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        update.execute();
    }

    public long updateExpectReceDate(Long id, LocalDate date) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.expectReceDate, date)
                .where(qdo.id.eq(id));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据合同Id查询约束合同节点
     *
     * @param saleConId 合同Id
     */
    public List<ContractNodeVO> findConNodeByConId(Long saleConId) {
        JPAQuery<ContractNodeVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ContractNodeVO.class,
                        // 收款计划ID
                        qdo.id.as("contractNode"),
                        // 收款计划阶段
                        qdo.receStage,
                        // 合同收款计划状态
                        qdo.receStatus.as("receStatus"),
                        // 当期应收款金额
                        qdo.receAmt,
                        // 已收款金额
                        qdo.actualRecvAmt
                )).from(qdo)
                .where(qdo.deleteFlag.eq(0)
                        .and(qdo.saleConId.eq(saleConId)));
        return jpaQuery.fetch();
    }

    /**
     * 查询需要发送提醒的收款计划
     *
     * @param endDate 预计付款日期在此之前
     * @return 付款计划
     */
    public List<ConReceivablePlanVO> findByExpectReceDate(LocalDate endDate) {
        JPAQuery<ConReceivablePlanVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdoSaleCon.deleteFlag.eq(0)
                .and(qdo.deleteFlag.eq(0))
                .and(qBusinessPartnerDO.deleteFlag.eq(0)));
        // 排除掉已全额收款
        jpaQuery.where(qdo.receStatus.ne(ReceStatusEnum.FULL_PAYMENT.getCode()));
        // 查询预计付款日期在此之前的付款计划
        jpaQuery.where(qdo.expectInvDate.before(endDate));
        // 排除掉子合同备注为异常的
        jpaQuery.where(qdoSaleCon.remark.ne("项目异常"));
        // 排除掉未开票的
        jpaQuery.where(qdo.receStatus.ne(ReceStatusEnum.NO_INVOICE.getCode()));
        // 排除掉催款流程正在审批的

        return jpaQuery.fetch();
    }

    public void updateReceivablePlan(ConReceivablePlanPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        if (payload.getNotReceAmt() != null) {
            update.set(qdo.notReceAmt, payload.getNotReceAmt());
        }
        if (payload.getAlreadyReceAmt() != null) {
            update.set(qdo.alreadyReceAmt, payload.getAlreadyReceAmt());
        }
        if (payload.getReceStatus() != null) {
            update.set(qdo.receStatus, payload.getReceStatus());
        }
        if (payload.getActualReceDate() != null) {
            update.set(qdo.actualReceDate, payload.getActualReceDate());
        }
        if (payload.getActualRecvDate() != null) {
            update.set(qdo.actualRecvDate, payload.getActualRecvDate());
        }
        if (payload.getActualRecvAmt() != null) {
            update.set(qdo.actualRecvAmt, payload.getActualRecvAmt());
        }
        if (StringUtils.hasText(payload.getInvStatus())) {
            update.set(qdo.invStatus, payload.getInvStatus());
        } else {
            update.setNull(qdo.invStatus);
        }
        if (payload.getActualReceDateFlag() != null && payload.getActualReceDateFlag()) {
            update.setNull(qdo.actualReceDate);
            update.setNull(qdo.actualRecvDate);
        }
        update.where(qdo.id.eq(payload.getId()));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        update.execute();
    }

    public void flush() {
        repo.flush();
    }
}

