package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Entity
@Table(name = "con_receivable_plan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_receivable_plan", comment = "收款计划")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConReceivablePlanDO extends BaseModel implements Serializable  {
    /** 收款号 */
    @Comment("收款号")
    @Column()
    private String receNo;
    /** 收款阶段 */
    @Comment("收款阶段")
    @Column()
    private String receStage;
    /** 当期收款金额 */
    @Comment("当期收款金额")
    @Column()
    private BigDecimal receAmt;
    /** 当期收款比例 */
    @Comment("当期收款比例")
    @Column()
    private BigDecimal receRatio;
    /** 预计收款日期 */
    @Comment("预计收款日期")
    @Column()
    private LocalDate expectReceDate;
    /** 开票批次ID[con_inv_batch] */
    @Comment("开票批次ID[con_inv_batch]")
    @Column()
    private Long invBatchId;
    /** 收款状态 */
    @Comment("收款状态")
    @Column()
    private String receStatus;
    /** 预计开票日期 */
    @Comment("预计开票日期")
    @Column()
    private LocalDate expectInvDate;
    /** 开票状态 */
    @Comment("开票状态")
    @Column()
    private String invStatus;
    /** 税率 */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /** 开票日期 */
    @Comment("开票日期")
    @Column()
    private LocalDate invDate;
    /** 已开票金额 */
    @Comment("已开票金额")
    @Column()
    private BigDecimal alreadyInvAmt;
    /** 未开票金额 */
    @Comment("未开票金额")
    @Column()
    private BigDecimal notInvAmt;
    /** 已收款金额 */
    @Comment("已收款金额")
    @Column()
    private BigDecimal alreadyReceAmt;
    /** 实际收款日期 */
    @Comment("实际收款日期")
    @Column()
    private LocalDate actualReceDate;
    /** 未收款金额 */
    @Comment("未收款金额")
    @Column()
    private BigDecimal notReceAmt;
    /** 已确认金额 */
    @Comment("已确认金额")
    @Column()
    private BigDecimal confirmedAmt;
    /** 确认收入日期 */
    @Comment("确认收入日期")
    @Column()
    private LocalDate confirmedAmtDate;
    /** 合同ID */
    @Comment("合同ID")
    @Column()
    private Long saleConId;

    @Comment("tw4.0收款计划ID")
    @Column(name = "receive_plan_id_v4")
    private Long receivePlanIdV4;

    /** 客户申请单号 */
    @Comment("客户申请单号")
    @Column()
    private String relApplyNo;

    /** 已收款金额 */
    @Comment("已收款金额")
    @Column()
    private BigDecimal actualRecvAmt;

    /** 实际收款日期 */
    @Comment("实际收款日期")
    @Column()
    private LocalDate actualRecvDate;

    public void copy(ConReceivablePlanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
