package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.*;
import com.elitesland.tw.tw5.api.prd.salecon.vo.*;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.PurchaseDemandTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.SaleConContractPaperStatusEnum;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.util.TwAssert;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationNoticeEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationTypeEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.SaleConContractConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import com.elitesland.tw.tw5.server.yeedocref.YeedocUtils;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SaleConContractServiceImpl extends BaseServiceImpl implements SaleConContractService {

    private final SaleConContractRepo repo;
    private final SaleConContractDAO dao;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final ConReceivablePlanService conReceivablePlanService;
    private final CacheUtil cacheUtil;
    private final YeedocUtils yeedocUtils;
    private final PrdSystemLogService logService;

    private final PrdSystemRoleDAO systemRoleDAO;
    @Autowired
    private ConEpibolyCostConService costConService;
    @Autowired
    private ConPurchaseDemandService demandService;
    @Autowired
    private ConPurchaseDemandDService demandDService;
    @Autowired
    private CrmOpportunityService opportunityService;

    private final TransactionUtilService transactionUtilService;

    private final FileUtil fileUtil;

    private final UdcUtil udcUtil;

    private final WorkflowUtil workflowUtil;

    private final PrdOrgOrganizationDAO daoOrg;

    private final PrdOrgOrganizationService orgService;

    private final PrdOrgSyncLogDAO daoLog;

    private final ConReceivablePlanRepo conReceivablePlanRepo;
    private final BusinessPartnerService businessPartnerService;

    @Autowired
    private PurchaseContractManagerService purchaseContractManagerService;

    private final PrdSystemRoleService roleService;
    @Autowired
    @Lazy
    private PmsProjectService pmsProjectService;
//    @Value("${tw4.url}")
//    private String tw4_url;

    @Value("${tw4.sale.contract}")
    private String saleContract;

    @Value("${tw4.sale.contractHistory}")
    private String saleContractHistory;

    @Value("${tw4.sale.contractSyncFlag}")
    private String contractSyncFlag;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Value("${tw5.jde.syncJdeContractUrl}")
    private String syncJdeContractUrl;

    @Value("${tw5.jde.count:3}")
    private Integer count;
    /**
     * yeedoc属性配置
     */
    private final YeedocProperties yeedocProperties;

    private final YeedocService yeedocService;

    private final CrmCustomerOperationService crmCustomerOperationService;

    private final ApiRequestLogService apiRequestLogService;

    private final ComChangeService changeService;

    //private final CrmCustomerOperationAutoService crmCustomerOperationAutoService;
    // private final CrmCustomerService crmCustomerService;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.SALE_CON_CONTRACT);
    }

    @Override
    public PagingVO<SaleConContractVO> paging(SaleConContractQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(SaleConContractVO.class, mapBuilder.build());
        long total = (long) totalNum;
        if (total == 0) {
            return PagingVO.empty();
        }
        List<SaleConContractVO> saleConContractVOS = beanSearcher.searchList(SaleConContractVO.class, mapBuilder.build());
        //获取审批记录
        computeAmount(saleConContractVOS);
        return PagingVO.<SaleConContractVO>builder().records(saleConContractVOS).total(total).build();
    }

    /**
     * 分页权限 条件封装
     *
     * @param query 查询
     * @return {@link MapBuilder}
     */
    private MapBuilder pageWhereBuilder(SaleConContractQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty(query.getId())) {
            builder.field(SaleConContractVO::getId, query.getId()).op(FieldOps.Equal);
        }
        /** 记录唯一ID 精确 */
        if (!CollectionUtils.isEmpty(query.getIds())) {
            builder.field(SaleConContractVO::getId, query.getIds()).op(FieldOps.InList);
        }
        /** 合同编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getCode())) {
            builder.field(SaleConContractVO::getCode, query.getCode()).op(FieldOps.Contain);
        }
        /** 合同名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getName())) {
            builder.field(SaleConContractVO::getName, query.getName()).op(FieldOps.Contain);
        }
        /** 合同名称 精确 */
        if (!ObjectUtils.isEmpty(query.getEqName())) {
            builder.field(SaleConContractVO::getName, query.getEqName()).op(FieldOps.Equal);
        }
        /** 合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getStatus())) {
            builder.field(SaleConContractVO::getStatus, query.getStatus()).op(FieldOps.Equal);
        }
        /** 合同状态 精确 */
        if (!CollectionUtils.isEmpty(query.getStatusList()) && query.getStatusList().size() == 2) {
            log.info("query getStatusList is {}", query.getStatusList());
            if ("0".equals(query.getStatusList().get(0))) {
                //list.add(qdo.status.eq(query.getStatusList().get(1)));
                builder.field(SaleConContractVO::getStatus, query.getStatusList().get(1)).op(FieldOps.Equal);
            } else if ("1".equals(query.getStatusList().get(0))) {
                // list.add(qdo.status.notEqualsIgnoreCase(query.getStatusList().get(1)));
                builder.field(SaleConContractVO::getStatus, query.getStatusList().get(1)).op(FieldOps.NotEqual);
            }
        }
        /** 签约公司ID 精确 */
        if (!ObjectUtils.isEmpty(query.getOuBookId())) {
            builder.field(SaleConContractVO::getOuBookId, query.getOuBookId()).op(FieldOps.Equal);
            // list.add(qdo.ouBookId.eq(query.getOuBookId()));
        }
        /** 参考合同号 模糊 */
        if (!ObjectUtils.isEmpty(query.getReferCode())) {
//            list.add(qdo.referCode.like(SqlUtil.toSqlLikeString(query.getReferCode())));
            builder.field(SaleConContractVO::getReferCode, query.getReferCode()).op(FieldOps.Contain);
        }

        /** 商机ID 精确 */
        if (!ObjectUtils.isEmpty(query.getOppoId())) {
//            list.add(qdo.oppoId.eq(query.getOppoId()));
            builder.field(SaleConContractVO::getOppoId, query.getOppoId()).op(FieldOps.Equal);
        }
        /** 客户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            builder.field(SaleConContractVO::getCustId, query.getCustId()).op(FieldOps.Equal);
//            list.add(qdo.custId.eq(query.getCustId()));
        }
        /** 客户ID集合 精确 */
        if (!CollectionUtils.isEmpty(query.getCustIdList())) {
//            list.add(qdo.custId.in(query.getCustIdList()));
            builder.field(SaleConContractVO::getCustId, query.getCustIdList()).op(FieldOps.InList);
        }

        /** 签约时客户名称 精确 */
        if (!ObjectUtils.isEmpty(query.getCustName())) {
//            list.add(qdo.custName.eq(query.getCustName()));
            builder.field(SaleConContractVO::getCustName, query.getCustName()).op(FieldOps.Equal);
        }
        /** 关联合同ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedContractId())) {
//            list.add(qdo.relatedContractId.eq(query.getRelatedContractId()));
            builder.field(SaleConContractVO::getRelatedContractId, query.getRelatedContractId()).op(FieldOps.Equal);
        }
        /** 新客户标志，0：新客户，1：老客户 精确 */
        if (!ObjectUtils.isEmpty(query.getCustFlag())) {
//            list.add(qdo.custFlag.eq(query.getCustFlag()));
            builder.field(SaleConContractVO::getCustFlag, query.getCustFlag()).op(FieldOps.Equal);
        }
        /** 签订日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSignDate())) {
//            list.add(qdo.signDate.eq(query.getSignDate()));
            builder.field(SaleConContractVO::getSignDate, query.getSignDate()).op(FieldOps.Equal);
        }
        /** 签订日期范围 精确 */
        if (!ObjectUtils.isEmpty(query.getSignDateStart()) && !ObjectUtils.isEmpty(query.getSignDateEnd())) {
            builder.field(SaleConContractVO::getSignDate, query.getSignDateStart(), query.getSignDateEnd()).op(FieldOps.Between);
            //jpaQuery.where(qdo.workDate.between(query.getWorkDateBetween().get(0), query.getWorkDateBetween().get(1)));
        }
        /** 签订年度 精确 */
        if (!ObjectUtils.isEmpty(query.getSignYear())) {
            // list.add(qdo.signDate.year().eq(query.getSignYear().intValue()));
            builder.field(SaleConContractVO::getSignDate).sql("year( $1 ) = ?", query.getSignYear().intValue());
        }
        /** 特别关注点 精确 */
        if (!ObjectUtils.isEmpty(query.getSpecialConcerned())) {
//            list.add(qdo.specialConcerned.eq(query.getSpecialConcerned()));
            builder.field(SaleConContractVO::getSpecialConcerned, query.getSpecialConcerned()).op(FieldOps.Equal);
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            builder.field(SaleConContractVO::getCurrCode, query.getCurrCode()).op(FieldOps.Equal);
        }
        /** 关闭原因 精确 */
        if (!ObjectUtils.isEmpty(query.getCloseReason())) {
            builder.field(SaleConContractVO::getCloseReason, query.getCloseReason()).op(FieldOps.Equal);
        }
        /** 客户项目 精确 */
        if (!ObjectUtils.isEmpty(query.getCustProj())) {
            builder.field(SaleConContractVO::getCustProj, query.getCustProj()).op(FieldOps.Equal);
        }
        /** 销售内容 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleContent())) {
            builder.field(SaleConContractVO::getSaleContent, query.getSaleContent()).op(FieldOps.Equal);
        }
        /** 产品大类 精确 */
        if (!ObjectUtils.isEmpty(query.getProductClass())) {
            builder.field(SaleConContractVO::getProductClass, query.getProductClass()).op(FieldOps.Equal);
        }
        /** 产品小类 精确 */
        if (!ObjectUtils.isEmpty(query.getProductSubClass())) {
            builder.field(SaleConContractVO::getProductSubClass, query.getProductSubClass()).op(FieldOps.Equal);
        }
        /** 交付地点 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliveryAddress())) {
            builder.field(SaleConContractVO::getDeliveryAddress, query.getDeliveryAddress()).op(FieldOps.Equal);
        }
        /** 财务期间ID 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriodId())) {
            builder.field(SaleConContractVO::getFinPeriodId, query.getFinPeriodId()).op(FieldOps.Equal);
        }
        /** 合同总金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAmt())) {
            builder.field(SaleConContractVO::getAmt, query.getAmt()).op(FieldOps.Equal);
        }
        /** 其它费用 精确 */
        if (!ObjectUtils.isEmpty(query.getExtraAmt())) {
            builder.field(SaleConContractVO::getExtraAmt, query.getExtraAmt()).op(FieldOps.Equal);
        }
        /** 有效合同金额 精确 */
        if (!ObjectUtils.isEmpty(query.getEffectiveAmt())) {
            builder.field(SaleConContractVO::getEffectiveAmt, query.getEffectiveAmt()).op(FieldOps.Equal);
        }
        /** 毛利 精确 */
        if (!ObjectUtils.isEmpty(query.getGrossProfit())) {
            builder.field(SaleConContractVO::getGrossProfit, query.getGrossProfit()).op(FieldOps.Equal);
        }
        /** 销售区域BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRegionBuId())) {
            builder.field(SaleConContractVO::getRegionBuId, query.getRegionBuId()).op(FieldOps.Equal);
        }
        /** 销售区域负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getRegionUserId())) {
            builder.field(SaleConContractVO::getRegionUserId, query.getRegionUserId()).op(FieldOps.Equal);
        }
        /** 签单BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSignBuId())) {
            builder.field(SaleConContractVO::getSignBuId, query.getSignBuId()).op(FieldOps.Equal);
        }
        /** 销售人员用户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleManUserId())) {
            builder.field(SaleConContractVO::getSaleManUserId, query.getSaleManUserId()).op(FieldOps.Equal);
        }
        /** 副签单BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCoSignBuId())) {
            builder.field(SaleConContractVO::getCoSignBuId, query.getCoSignBuId()).op(FieldOps.Equal);
        }
        /** 副签单用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getCoSignUserId())) {
            builder.field(SaleConContractVO::getCoSignUserId, query.getCoSignUserId()).op(FieldOps.Equal);
        }
        /** 交付BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            builder.field(SaleConContractVO::getDeliBuId, query.getDeliBuId()).op(FieldOps.Equal);
        }
        /** 交付用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            builder.field(SaleConContractVO::getDeliUserId, query.getDeliUserId()).op(FieldOps.Equal);
        }
        /** 副交付BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCodeliBuId())) {
            builder.field(SaleConContractVO::getCodeliBuId, query.getCodeliBuId()).op(FieldOps.Equal);
        }
        /** 副交付用户id 精确 */
        if (!ObjectUtils.isEmpty(query.getCodeliUserId())) {
            builder.field(SaleConContractVO::getCodeliUserId, query.getCodeliUserId()).op(FieldOps.Equal);
        }
        /** 平台合同类型 精确 */
        if (!ObjectUtils.isEmpty(query.getPlatType())) {
            builder.field(SaleConContractVO::getPlatType, query.getPlatType()).op(FieldOps.Equal);
            //  list.add(qdo.platType.eq(query.getPlatType()));
        } else {
            // 默认隐藏虚拟合同
//            list.add(qdo.platType.ne(SaleConEnum.FICTITIOUS.getCode()));
            builder.field(SaleConContractVO::getPlatType, SaleConEnum.FICTITIOUS.getCode()).op(FieldOps.NotEqual);
        }
        /** 主合同类型 精确 */
        if (!ObjectUtils.isEmpty(query.getMainType())) {
            builder.field(SaleConContractVO::getMainType, query.getMainType()).op(FieldOps.Equal);
        }
        /** PMO用户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getPmoUserId())) {
            builder.field(SaleConContractVO::getPmoUserId, query.getPmoUserId()).op(FieldOps.Equal);
        }
        /** 来源类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            builder.field(SaleConContractVO::getSourceType, query.getSourceType()).op(FieldOps.Equal);
        }
        /** 外部来源 精确 */
        if (!ObjectUtils.isEmpty(query.getExternalIden())) {
            builder.field(SaleConContractVO::getExternalIden, query.getExternalIden()).op(FieldOps.Equal);
        }
        /** 外部来源人 精确 */
        if (!ObjectUtils.isEmpty(query.getExternalName())) {
            builder.field(SaleConContractVO::getExternalName, query.getExternalName()).op(FieldOps.Equal);
        }
        /** 外部来源电话 精确 */
        if (!ObjectUtils.isEmpty(query.getExternalPhone())) {
            builder.field(SaleConContractVO::getExternalPhone, query.getExternalPhone()).op(FieldOps.Equal);
        }
        /** 内部来源BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInternalBuId())) {
            builder.field(SaleConContractVO::getInternalBuId, query.getInternalBuId()).op(FieldOps.Equal);
        }
        /** 利益承诺 精确 */
        if (!ObjectUtils.isEmpty(query.getProfitDesc())) {
            builder.field(SaleConContractVO::getProfitDesc, query.getProfitDesc()).op(FieldOps.Equal);
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            builder.field(SaleConContractVO::getTaxRate, query.getTaxRate()).op(FieldOps.Equal);
        }
        /** 内部来源用户ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInternalUserId())) {
            builder.field(SaleConContractVO::getInternalUserId, query.getInternalUserId()).op(FieldOps.Equal);
        }
        /** 合同开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            builder.field(SaleConContractVO::getStartDate, query.getStartDate()).op(FieldOps.Equal);
        }
        /** 合同结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            builder.field(SaleConContractVO::getEndDate, query.getEndDate()).op(FieldOps.Equal);
        }
        /** 纸质合同状态描述 精确 */
        if (!ObjectUtils.isEmpty(query.getPaperDesc())) {
            builder.field(SaleConContractVO::getPaperDesc, query.getPaperDesc()).op(FieldOps.Equal);
        }
        /** 纸质合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getPaperStatus())) {
            builder.field(SaleConContractVO::getPaperStatus, query.getPaperStatus()).op(FieldOps.Equal);
        }
        /** 合同激活时间 精确 */
        if (!ObjectUtils.isEmpty(query.getAcitveDate())) {
            builder.field(SaleConContractVO::getAcitveDate, query.getAcitveDate()).op(FieldOps.Equal);
        }
        /** 产品 精确 */
        if (!ObjectUtils.isEmpty(query.getProduct())) {
            builder.field(SaleConContractVO::getProduct, query.getProduct()).op(FieldOps.Equal);
        }
        /** 简要说明 精确 */
        if (!ObjectUtils.isEmpty(query.getBriefDesc())) {
            builder.field(SaleConContractVO::getBriefDesc, query.getBriefDesc()).op(FieldOps.Equal);
        }
        /** 工作类型 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            builder.field(SaleConContractVO::getWorkType, query.getWorkType()).op(FieldOps.Equal);
        }
        /** 促销类型 精确 */
        if (!ObjectUtils.isEmpty(query.getPromotionType())) {
            builder.field(SaleConContractVO::getPromotionType, query.getPromotionType()).op(FieldOps.Equal);
        }
        /** 范围性质 精确 */
        if (!ObjectUtils.isEmpty(query.getRangeProp())) {
            builder.field(SaleConContractVO::getRangeProp, query.getRangeProp()).op(FieldOps.Equal);
        }
        /** 半开口说明 精确 */
        if (!ObjectUtils.isEmpty(query.getHalfOpenDesc())) {
            builder.field(SaleConContractVO::getHalfOpenDesc, query.getHalfOpenDesc()).op(FieldOps.Equal);
        }
        /** 供应主体类别 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierType())) {
            builder.field(SaleConContractVO::getSupplierType, query.getSupplierType()).op(FieldOps.Equal);
        }
        /** 提成类别 精确 */
        if (!ObjectUtils.isEmpty(query.getCommissionType())) {
            builder.field(SaleConContractVO::getCommissionType, query.getCommissionType()).op(FieldOps.Equal);
        }
        /** 交易方式 精确 */
        if (!ObjectUtils.isEmpty(query.getTransactionMethod())) {
            builder.field(SaleConContractVO::getTransactionMethod, query.getTransactionMethod()).op(FieldOps.Equal);
        }
        /** 交易性质 精确 */
        if (!ObjectUtils.isEmpty(query.getTransactionNature())) {
            builder.field(SaleConContractVO::getTransactionNature, query.getTransactionNature()).op(FieldOps.Equal);
        }
        /** 需求类别 精确 */
        if (!ObjectUtils.isEmpty(query.getDemandType())) {
            builder.field(SaleConContractVO::getDemandType, query.getDemandType()).op(FieldOps.Equal);
        }
        /** 销售分类 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleClass())) {
            builder.field(SaleConContractVO::getSaleClass, query.getSaleClass()).op(FieldOps.Equal);
        }
        /** 客户承担差旅费 精确 */
        if (!ObjectUtils.isEmpty(query.getCustBarExpense())) {
            builder.field(SaleConContractVO::getCustBarExpense, query.getCustBarExpense()).op(FieldOps.Equal);
        }
        /** 报销政策说明 精确 */
        if (!ObjectUtils.isEmpty(query.getReimbursementDesc())) {
            builder.field(SaleConContractVO::getReimbursementDesc, query.getReimbursementDesc()).op(FieldOps.Equal);
        }
        /** 额定当量 精确 */
        if (!ObjectUtils.isEmpty(query.getRatedEqva())) {
            builder.field(SaleConContractVO::getRatedEqva, query.getRatedEqva()).op(FieldOps.Equal);
        }
        /** 额定费用 精确 */
        if (!ObjectUtils.isEmpty(query.getRatedExpense())) {
            builder.field(SaleConContractVO::getRatedExpense, query.getRatedExpense()).op(FieldOps.Equal);
        }
        /** 合同打印方 精确 */
        if (!ObjectUtils.isEmpty(query.getContractPrinter())) {
            builder.field(SaleConContractVO::getContractPrinter, query.getContractPrinter()).op(FieldOps.Equal);
        }
        /** 打印份数 精确 */
        if (!ObjectUtils.isEmpty(query.getPrintCount())) {
            builder.field(SaleConContractVO::getPrintCount, query.getPrintCount()).op(FieldOps.Equal);
        }
        /** 盖章类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSealType())) {
            builder.field(SaleConContractVO::getSealType, query.getSealType()).op(FieldOps.Equal);
        }
        /** 和发票一起邮寄，0：是，1：否 精确 */
        if (!ObjectUtils.isEmpty(query.getSendWithInvoiceFlag())) {
            builder.field(SaleConContractVO::getSendWithInvoiceFlag, query.getSendWithInvoiceFlag()).op(FieldOps.Equal);
        }
        /** 邮寄地址 模糊 */
        if (!ObjectUtils.isEmpty(query.getMailingAddress())) {
            builder.field(SaleConContractVO::getMailingAddress, SqlUtil.toSqlLikeString(query.getMailingAddress())).op(FieldOps.Contain);
            // list.add(qdo.mailingAddress.like(SqlUtil.toSqlLikeString(query.getMailingAddress())));
        }
        /** 父ID 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            builder.field(SaleConContractVO::getParentId, query.getParentId()).op(FieldOps.Equal);
        }
        /** 关闭时间 精确 */
        if (!ObjectUtils.isEmpty(query.getCloseDate())) {
            builder.field(SaleConContractVO::getCloseDate, query.getCloseDate()).op(FieldOps.Equal);
        }
        /** 售前BU 精确 */
        if (!ObjectUtils.isEmpty(query.getPreSaleBuId())) {
            builder.field(SaleConContractVO::getPreSaleBuId, query.getPreSaleBuId()).op(FieldOps.Equal);
        }
        /** 售前负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getPreSaleUserId())) {
            builder.field(SaleConContractVO::getPreSaleUserId, query.getPreSaleUserId()).op(FieldOps.Equal);
        }
        /** 合同金额范围 区间 */
        if (!ObjectUtils.isEmpty(query.getAmtScope())) {
            // list.add(qdo.amt.between(query.getAmtScope().get(0), query.getAmtScope().get(1)));
            builder.field(SaleConContractVO::getAmt, query.getAmtScope().get(0), query.getAmtScope().get(1)).op(FieldOps.Between);
        }
        /** 业绩统计状态 精确 */
        if ("handled".equals(query.getAchieveStatus())) {
//            list.add(qConAchieve.id.isNotNull());
            builder.field(SaleConContractVO::getCaId).sql("$1 is not null");
        }
        /** 业绩统计状态 精确 */
        if ("unhandled".equals(query.getAchieveStatus())) {
//            list.add(qConAchieve.id.isNull());
            builder.field(SaleConContractVO::getCaId).sql("$1 is  null");
        }

        /** 业绩统计部门ID 精确 */
        if (!ObjectUtils.isEmpty(query.getAchieveBuId())) {

            builder.field(SaleConContractVO::getAchieveBuId).sql("$1 =? ", query.getAchieveBuId());
//            list.add(qConAchieveD.buId.eq(query.getAchieveBuId()));
        }
        /** 价值角色 精确 */
        if (!ObjectUtils.isEmpty(query.getValueRole())) {
//            list.add(qConAchieveD.valueRole.eq(query.getValueRole()));
            builder.field(SaleConContractVO::getValueRole).sql("$1  =? ", query.getValueRole());
        }
        /** 部门归属人员ID 精确 */
        if (!ObjectUtils.isEmpty(query.getChargeResId())) {
//            list.add(qConAchieveD.chargeResId.eq(query.getChargeResId()));
            builder.field(SaleConContractVO::getChargeResId).sql("$1 =? ", query.getChargeResId());
        }
        /** 合同归档标志 精确 */
        if (!ObjectUtils.isEmpty(query.getFilingFlag())) {
//            list.add(qdo.filingFlag.eq(query.getFilingFlag()));
            builder.field(SaleConContractVO::getFilingFlag, query.getFilingFlag()).op(FieldOps.Equal);
        }
        /** 项目是否创建 */
        if (!ObjectUtils.isEmpty(query.getIsProjectCreate())) {
            if (Integer.valueOf(0).compareTo(query.getIsProjectCreate()) == 0) {
                //    list.add(projectDO.projNo.isNull());
                builder.field(SaleConContractVO::getProjCode).sql("$1 is null");
            } else if (Integer.valueOf(1).compareTo(query.getIsProjectCreate()) == 0) {
//                list.add(projectDO.projNo.isNotNull());
                builder.field(SaleConContractVO::getProjCode).sql("$1 is not null");
            }
        }
        // 合同是否创建执行情况
        if (!ObjectUtils.isEmpty(query.getConConditionFlag())) {
            if (0 == query.getConConditionFlag()) {
                builder.field(SaleConContractVO::getScecContractId).sql("$1 is  null");
//                list.add(conConditionDO.contractId.isNull());
            } else {
//                list.add(conConditionDO.contractId.isNotNull());
                builder.field(SaleConContractVO::getScecContractId).sql("$1 is not null");
            }
        }

        //List<OrderItem> orderse = new ArrayList<>();
//        orderse.add(OrderItem.desc("workDate"));
//        query.setOrders(orderse);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    /**
     * 查询目前都用的这个方法
     *
     * @param query 条件
     * @return
     */
    @Override
    public PagingVO<SaleConContractVO> queryPaging(SaleConContractQuery query) {
        // 权限处理
        getPermissionParams(query);
        log.info("销售合同分页service层入参合同名称 is {},合同状态 is {}", query.getName(), query.getStatusList());
        PagingVO<SaleConContractVO> saleConContractVOPagingVO = dao.queryPaging(query);
//        List<SaleConContractVO> records = saleConContractVOPagingVO.getRecords();
//        Map<String, BigDecimal> map;
//        for (SaleConContractVO record : records) {
//            if ("MAIN".equals(record.getMainType())) {
//                map = this.amountOfMoney(record.getId(),"MAIN");
//            }else {
//                map = this.amountOfMoney(record.getId());
//            }
//            // 调用计算合同开票金额和收款金额方法
//            BigDecimal invoicingAmount = map.get("InvoicingAmount");
//            BigDecimal amountCollected = map.get("AmountCollected");
//            record.setAmountCollected(amountCollected);
//            record.setInvoicingAmount(invoicingAmount);
//        }
//        // 翻译
//        saleConContractVOPagingVO.stream().forEach(this::transfer);
        computeAmount(saleConContractVOPagingVO.getRecords());
        return saleConContractVOPagingVO;
    }

    // 统计个数
    @Override
    public Long count(SaleConContractQuery query) {
        // 权限处理
        getPermissionParams(query);
        return dao.count(query);
    }

    /**
     * 计算合同开票金额、收款金额 --- 外加翻译
     */
    private void computeAmount(List<SaleConContractVO> saleConContractVOS) {
        // 列表主合同集合
        List<SaleConContractVO> mainConVOList = saleConContractVOS.stream()
                .filter(vo -> Objects.equals(vo.getMainType(), SaleConEnum.MAIN.getCode()))
                .toList();
        // 列表子合同集合
        List<SaleConContractVO> subConVOList = saleConContractVOS.stream()
                .filter(vo -> Objects.equals(vo.getMainType(), SaleConEnum.SUB.getCode()))
                .toList();
        // 列表子合同ID集合
        List<Long> subConListIds = subConVOList.stream()
                .map(SaleConContractVO::getId).toList();
        // 列表主合同ID集合
        List<Long> mainConListIds = mainConVOList.stream()
                .map(SaleConContractVO::getId).toList();
        // 列表主合同下的子合同列表
        List<SaleConContractDO> subConDOSByMainConList = repo.findByDeleteFlagAndParentIdIn(0, mainConListIds);
        // 列表主合同下所有子合同ID
        List<Long> subConIdsByMainCon = subConDOSByMainConList.stream().map(SaleConContractDO::getId).toList();
        // 列表主合同下子合同ID + 列表子合同ID
        List<Long> allSubConIds = new ArrayList<>();
        allSubConIds.addAll(subConListIds);
        allSubConIds.addAll(subConIdsByMainCon);
        // 查询出所有子合同所有的收款计划
        List<ConReceivablePlanDO> conReceivablePlanDOS = conReceivablePlanRepo.findAllByDeleteFlagAndSaleConIdIn(0, allSubConIds);
        // 子合同收款开票金额Map集合
        Map<Long, BigDecimal> receivableAmountMap = new HashMap<>();
        Map<Long, BigDecimal> invoicingAmountMap = new HashMap<>();
        // 遍历收款计划列表，将收款金额和开票金额按销售合同ID存储到Map中
        for (ConReceivablePlanDO conReceivablePlanDO : conReceivablePlanDOS) {
            Long saleConId = conReceivablePlanDO.getSaleConId();
            // 已收款金额
            BigDecimal alreadyReceAmt = conReceivablePlanDO.getActualRecvAmt() != null ? conReceivablePlanDO.getActualRecvAmt() : BigDecimal.ZERO;
            // 已开票金额
            BigDecimal alreadyInvAmt = conReceivablePlanDO.getAlreadyInvAmt() != null ? conReceivablePlanDO.getAlreadyInvAmt() : BigDecimal.ZERO;
            BigDecimal collectedAmount = receivableAmountMap.getOrDefault(saleConId, BigDecimal.ZERO);
            collectedAmount = collectedAmount.add(alreadyReceAmt);
            receivableAmountMap.put(saleConId, collectedAmount);
            BigDecimal invoicedAmount = invoicingAmountMap.getOrDefault(saleConId, BigDecimal.ZERO);
            invoicedAmount = invoicedAmount.add(alreadyInvAmt);
            invoicingAmountMap.put(saleConId, invoicedAmount);
        }
        for (SaleConContractVO saleConContractVO : saleConContractVOS) {
            BigDecimal invoicingAmount = BigDecimal.ZERO;  // 开票金额
            BigDecimal amountCollected = BigDecimal.ZERO;  // 收款金额
            // 计算子合同开票收款金额
            if (!SaleConEnum.MAIN.getCode().equalsIgnoreCase(saleConContractVO.getMainType())) {
                invoicingAmount = invoicingAmountMap.getOrDefault(saleConContractVO.getId(), invoicingAmount);
                amountCollected = receivableAmountMap.getOrDefault(saleConContractVO.getId(), amountCollected);
            } else {
                // 计算主合同的收款开票金额
                for (SaleConContractDO subCon : subConDOSByMainConList) {
                    if (subCon.getParentId().equals(saleConContractVO.getId())) {
                        invoicingAmount = invoicingAmount.add(invoicingAmountMap.getOrDefault(subCon.getId(), BigDecimal.ZERO));
                        amountCollected = amountCollected.add(receivableAmountMap.getOrDefault(subCon.getId(), BigDecimal.ZERO));
                    }
                }
            }
            saleConContractVO.setAmountCollected(amountCollected);
            saleConContractVO.setInvoicingAmount(invoicingAmount);
            // 翻译
            transfer(saleConContractVO);
        }

    }


    @Override
    public void getPermissionParams(SaleConContractQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        // 获取角色
        List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(loginUserId);
        // 销售副总裁(SALES_VP)、销售合同管理员(SALES_CONTRACT_ADMIN)、系统管理员(SYS)、财务负责人(FIN_PIC)、商务负责人(BUSINESS_MANAGER)、合同归档管理员(CONTRACT_FILING)、平台财务负责人(PLAT_FIN_PIC)、运营总裁(OPERATION_PRESIDENT)、财务核定(FIN_CHECK_PIC)可以看到全部
        List<String> roles = Arrays.asList("SALES_VP", "SALES_CONTRACT_ADMIN", "SYS", "FIN_PIC", "BUSINESS_MANAGER", "CONTRACT_FILING", "PLAT_FIN_PIC", "OPERATION_PRESIDENT", "FIN_CHECK_PIC", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        if ((!CollectionUtils.isEmpty(userSystemRoleCodes)) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            return;
        }
        // 查看当前登录人是哪个bu的leader
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.MAX_VALUE);
        PagingVO<PrdOrgOrganizationVO> paging = orgService.paging(orgQuery);
        List<PrdOrgOrganizationVO> records = paging.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> orgIds = records.stream().map(PrdOrgOrganizationVO::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList<Long>());
        }
        // 设置负责人是当前登录人
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }

    @Override
    public List<SaleConContractVO> queryList(SaleConContractQuery query) {
        List<SaleConContractVO> saleConContractVOS = SaleConContractConvert.INSTANCE.toVoList(
                repo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
        // 翻译
        saleConContractVOS.stream().forEach(e -> transfer(e));
        return saleConContractVOS;
    }


    @Override
    public List<SaleConContractVO> queryContractListDynamic(SaleConContractQuery query) {
        List<SaleConContractVO> saleConContractVOS = dao.queryContractListDynamic(query);
        return saleConContractVOS;
    }

    @Override
    public List<SaleConContractListVO> queryListDynamic(SaleConContractQuery query) {
        List<SaleConContractListVO> saleConContractVOS = dao.queryListDynamic(query);
        return saleConContractVOS;
    }

    @Override
    public SaleConContractVO queryByKey(Long key, Boolean... auth) {
        SaleConContractVO vo = dao.queryByKey(key);
        Assert.notNull(vo.getId(), "不存在");
        // 不含税金额= 含税总金额/(1+税率)
        BigDecimal amt = vo.getAmt() == null ? BigDecimal.ZERO : vo.getAmt();   //合同总金额
        BigDecimal taxRate = vo.getTaxRate() == null ? BigDecimal.ZERO : vo.getTaxRate();   //税率
        BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);    //不含税总金额
        vo.setNotTaxAmt(notTaxAmt);
//        if(vo.getSysGross() != null){vo.setSysGross(vo.getSysGross().multiply(new BigDecimal(100)).setScale(2,BigDecimal.ROUND_HALF_UP));}
//        // 查询其他应减费用（外包总费用）
//        ConEpibolyCostConVO conEpibolyCostConVO = costConService.queryByContractId(vo.getId());
//        BigDecimal costTotalAmt = BigDecimal.ZERO;
//        List<ConEpibolyCostConDVO> conEpibolyCostConDVOS = conEpibolyCostConVO.getConEpibolyCostConDVOS();
//        if (!CollectionUtils.isEmpty(conEpibolyCostConDVOS)) {
//            costTotalAmt = conEpibolyCostConDVOS.stream().map(ConEpibolyCostConDVO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
//        }

        SaleConContractPayload saleConContractPayload = this.subAmtCount(SaleConContractConvert.INSTANCE.toPayload(vo));
        if (saleConContractPayload.getExtraAmt() != null) {
            vo.setExtraAmt(saleConContractPayload.getExtraAmt().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (saleConContractPayload.getEffectiveAmt() != null) {
            vo.setEffectiveAmt(saleConContractPayload.getEffectiveAmt().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        if (saleConContractPayload.getDemandTotalAmt() != null) {
            vo.setDemandTotalAmt(saleConContractPayload.getDemandTotalAmt().setScale(2, BigDecimal.ROUND_HALF_UP));
        }
        // 修改查询到的有效合同额
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setId(saleConContractPayload.getId());
        payload.setEffectiveAmt(saleConContractPayload.getEffectiveAmt());
        payload.setExtraAmt(saleConContractPayload.getExtraAmt());
        dao.updateByKeyDynamic(payload);
        //文件类型
        vo.setFileDatas(fileUtil.getFileDatas(vo.getFileCodes()));
        vo.setSowDatas(fileUtil.getFileDatas(vo.getSowFileCodes()));
        vo.setAssessDatas(fileUtil.getFileDatas(vo.getAssessFileCodes()));
        vo.setCloseDatas(fileUtil.getFileDatas(vo.getCloseFileCodes()));
        computeAmount(Collections.singletonList(vo));
        //翻译
        transfer(vo);
        //处理合同预算权限 交付BU负责人、平台资源总监、CFO（角色）、平台财务负责人（角色）、合同预算管理员（角色，本次新增角色）在详情中可以看到合同预算Tab页，并支持编辑
        Boolean saleBudgetAuthFlag = false;
        if (auth == null || auth.length == 0 || (!ObjectUtils.isEmpty(auth) && !auth[0])) {
            return vo;
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (loginUserId != null) {
            Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode(), RoleEnum.PLAT_CFO.getCode(), RoleEnum.PLAT_FIN_PIC.getCode(), RoleEnum.SALE_CONTRACT_BUDGET_MANAGER.getCode(), RoleEnum.SYS.getCode()));
            if (rolePermission) {
                saleBudgetAuthFlag = true;
            }
            if (vo.getDeliBuId() != null) {
                //交付BU负责人
                PrdOrgOrganizationVO org = cacheUtil.getOrg(vo.getDeliBuId());
                if (org != null && loginUserId.equals(org.getManageId())) {
                    saleBudgetAuthFlag = true;
                }
            }
            vo.setSaleBudgetAuthFlag(saleBudgetAuthFlag);
        }
        // 对客户状态查询
        if (null != vo.getCustId()) {
            BusinessPartnerVO businessPartnerVO = businessPartnerService.queryCustomerByBookId(vo.getCustId());
            vo.setCustStatus(businessPartnerVO.getCustomerStatus());
            vo.setPartnerId(businessPartnerVO.getId());
        }
        return vo;
    }

    @Override
    @Transactional
    public SaleConContractVO insert(SaleConContractPayload payload) {
        if (payload.getProductClass() == null) {
            throw TwException.error("", "销售大类不存在，请核验！");
        }
        // 合同名称不可以重复
        String name = payload.getName();
        if (StringUtils.hasText(name)) {
            SaleConContractQuery query = new SaleConContractQuery();
            query.setName(name);
            PagingVO<SaleConContractVO> queryPaging = dao.queryPaging(query);
            if (!CollectionUtils.isEmpty(queryPaging.getRecords())) {
                throw TwException.warn("", "合同名称不可重复！");
            }
        }

        // initData(payload);

        SaleConContractDO entityDo = SaleConContractConvert.INSTANCE.toDo(payload);
        String itemId = "";
        List<String> pathArry = new ArrayList<String>();
        entityDo.setFilingFlag(0);
        if ("MAIN".equalsIgnoreCase(payload.getMainType())) {
            String code = generateSeqNum("SALE_CON_NO");
            if (StringUtils.hasText(code)) {
                //根据销售大类重新生成编号
                PrdSystemSelectionVO systemSelection = cacheUtil.querySystemSelection("con:sales_class", entityDo.getProductClass());
                if (systemSelection != null) {
                    code = String.format(code, systemSelection.getExtString1());
                } else {
                    //如果没有配置销售大类，默认内部生成的虚拟合同
                    code = String.format(code, "IN");
                }
            }
            entityDo.setCode(code);
            payload.setCode(code);
            // 基于商机创建合同保存后，商机状态由激活 ---> 关闭，关闭原因 --->生成合同
            Long oppoId = payload.getOppoId();
            if (!ObjectUtils.isEmpty(oppoId)) {
                opportunityService.closeOpportunity(oppoId, "01", null, null, false);
            }
            pathArry.add("/" + code + " " + name);
        } else {
            //查询主合同
            SaleConContractVO mainCon = dao.queryByKey(payload.getParentId());
            if (!"ACTIVE".equalsIgnoreCase(mainCon.getStatus())) {
                throw TwException.warn("", "主合同是激活状态才可以创建子合同");
            }
            //查询该主合同下所有的子合同(包括已删除)
            List<SaleConContractDO> subCons = repo.findByParentId(payload.getParentId());
            String subCode = mainCon.getCode();
            if (subCons.size() < 9) {
                subCode = subCode + "0" + (subCons.size() + 1);
            } else {
                subCode = subCode + (subCons.size() + 1);
            }
            entityDo.setCode(subCode);
            payload.setCode(subCode);
            if (!SaleConEnum.FICTITIOUS.getCode().equalsIgnoreCase(entityDo.getPlatType())) {
                entityDo.setStatus("CREATE");
            }
            itemId = mainCon.getFolderId();
            pathArry.add("/" + subCode + " " + name);

            entityDo.setPercentage(BigDecimal.ZERO);
            // 根据子合同 工作类型 查询平台提成比例
            if (StringUtils.hasText(payload.getWorkType())) {
                PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.querySystemSelection("salecon:work_type", payload.getWorkType());
                String extString2 = prdSystemSelectionVO.getExtString2();
                if (!StringUtils.hasText(extString2)) {
                    log.error("工作类型：" + prdSystemSelectionVO.getSelectionName() + "未维护比例，请联系管理员");
//                    throw TwException.error("", "工作类型：" + prdSystemSelectionVO.getSelectionName() + "未维护比例，请联系管理员");
                }
                try {
                    BigDecimal percentage = new BigDecimal(prdSystemSelectionVO.getExtString2());
                    entityDo.setPercentage(percentage);
                } catch (Exception e) {
                    log.error("工作类型：" + prdSystemSelectionVO.getSelectionName() + "维护比例格式错误，请联系管理员");
//                    TwException.error("", "工作类型：" + prdSystemSelectionVO.getSelectionName() + "维护比例格式错误，请联系管理员");
                }
            }

        }
        this.saleConFileHandle(payload);

        String changeLog = "";

        SaleConContractVO saleConContractVO = SaleConContractConvert.INSTANCE.toVo(repo.save(entityDo));
        //新建日志--start
        if ("MAIN".equalsIgnoreCase(payload.getMainType())) {
            changeLog = "新建主合同";
        } else {
            changeLog = "新建子合同" + saleConContractVO.getName();
            logService.saveNewLog(saleConContractVO.getParentId(), PrdSystemObjectEnum.SaleConContract.getCode(), changeLog);
            payload.setId(saleConContractVO.getId());
            // 修改有效合同额
            this.subAmtCount(payload);
            entityDo.setEffectiveAmt(payload.getEffectiveAmt());
            repo.save(entityDo);
        }

        logService.saveNewLog(saleConContractVO.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), changeLog);
        //变更日志--end
        if (payload.getFileFlag()) {
//            Map<String, Object> context = BeanUtil.beanToMap(payload);
//            String fileCodeString = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getFileCodes());
//            entityDo.setFileCodes(fileCodeString);
            /*//----- 保存易道壳附件 -----
            // 1.创建文件夹
            String ydkFolderId = createYdkFolder(itemId, pathArry, payload.getAuthTokenByYdk());
            entityDo.setFolderId(ydkFolderId);
            // 2.把附件最终保存
            Set<String> allCacheKeys = new HashSet<>();
            List<String> cacheKeys = new ArrayList<>();
            List<String> assessCacheKeys = new ArrayList<>();
            List<String> sowCacheKeys = new ArrayList<>();
            if (StringUtils.hasText(payload.getCacheKey())) {
                cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
                allCacheKeys.addAll(cacheKeys);
            }
            if (StringUtils.hasText(payload.getAssessCacheKey())) {
                assessCacheKeys = Arrays.asList(payload.getAssessCacheKey().split(","));
                allCacheKeys.addAll(assessCacheKeys);
            }
            if (StringUtils.hasText(payload.getSowCacheKey())) {
                sowCacheKeys = Arrays.asList(payload.getSowCacheKey().split(","));
                allCacheKeys.addAll(sowCacheKeys);
            }
            if (!CollectionUtils.isEmpty(allCacheKeys)) {
                Map<String, String> cacheMap = saveYdkFile(ydkFolderId, allCacheKeys, payload.getAuthTokenByYdk());
                if (StringUtils.hasText(payload.getCacheKey())) {
                    String str = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    entityDo.setFileCodes(str);
                }
                if (StringUtils.hasText(payload.getAssessCacheKey())) {
                    String str = assessCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    entityDo.setAssessFileCodes(str);
                }
                if (StringUtils.hasText(payload.getSowCacheKey())) {
                    String str = sowCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                    entityDo.setSowFileCodes(str);
                }
            }*/

            // -- 易道壳保存附件结束 --
        }

        return saleConContractVO;
    }

    private void initData(SaleConContractPayload payload) {
        if (payload.getAgentFlag() == null) {
            payload.setAgentFlag(0);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleConContractVO update(SaleConContractPayload payload) {
        if (payload.getProductClass() == null) {
            throw TwException.error("", "销售大类不存在，请核验！");
        }
        this.saleConFileHandle(payload);
        // 合同名称不可以重复
        String name = payload.getName();
        if (StringUtils.hasText(name)) {
            SaleConContractQuery query = new SaleConContractQuery();
            query.setName(name);
            PagingVO<SaleConContractVO> queryPaging = dao.queryPaging(query);
            List<SaleConContractVO> records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty(queryPaging.getRecords())) {
                List<SaleConContractVO> collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    throw TwException.warn("", "合同名称不可重复！");
                }
            }
        }
        SaleConContractDO entity = repo.findById(payload.getId()).orElseGet(SaleConContractDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 审批中、关闭、作废不可以进行修改
        List<String> statusList = new ArrayList<>();
        statusList.add("APPROVING");
//        statusList.add("PENDING");
        statusList.add("CLOSE");
        statusList.add("INVALID");
        if (statusList.contains(entity.getStatus())) {
            {
                throw TwException.error("", "审批中、关闭、作废的合同不可以进行修改");
            }
        }
        //判断子合同含税总金额或者税率是否变化 如有变化，则修改其不含税总金额、有效合同金额
        if (entity.getAmt().compareTo(payload.getAmt()) != 0 || entity.getTaxRate().compareTo(payload.getTaxRate()) != 0) {
            this.subAmtCount(payload);
        }
        SaleConContractDO entityDo = SaleConContractConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        SaleConContractDO save = repo.save(entity);
        return SaleConContractConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional
    public Long updateByKeyDynamic(SaleConContractPayload payload) {
        SaleConContractDO entity = repo.findById(payload.getId()).orElseGet(SaleConContractDO::new);
        TwAssert.notNull(entity.getId(), "合同信息不存在");
        // 合同名称不可以重复
        String name = payload.getName();
        if (StringUtils.hasText(name)) {
            SaleConContractQuery query = new SaleConContractQuery();
            query.setEqName(name);
            PagingVO<SaleConContractVO> queryPaging = dao.queryPaging(query);
            List<SaleConContractVO> records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty(queryPaging.getRecords())) {
                List<SaleConContractVO> collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    throw TwException.warn("", "合同名称不可重复！");
                }
            }
        }
        // 审批中、暂挂、关闭、作废不可以进行修改
        List<String> statusList = new ArrayList<>();
        statusList.add("APPROVING");
//        statusList.add("PENDING");
        statusList.add("CLOSE");
        statusList.add("INVALID");
        if (statusList.contains(entity.getStatus())) {
            {
                throw TwException.error("", "审批中、关闭、作废的合同不可以进行修改");
            }
        }
        //变更日志--start
        SaleConContractDO oldEntity = new SaleConContractDO();
        //通过反射来获取 BigDecimal 类型的所有字段(用来把前端传过来的BigDecimal整数保留两位小数)
        Class<?> clazz = payload.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            if ("java.math.BigDecimal".equals(field.getType().getName())) {
                //属性名
                String fieldName = field.getName();
                //获取属性值的方法名
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                //属性值
                try {
                    Method getMethod = clazz.getMethod(getMethodName);
                    //获取属性值
                    BigDecimal value = (BigDecimal) getMethod.invoke(payload);
                    if (value != null) {
                        String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                        Method setMethod = clazz.getDeclaredMethod(setMethodName, field.getType());
                        //判断是否为整数，为整数则保留两位小数
//                        if (new BigDecimal(value.intValue()).compareTo(value) == 0){
//                            setMethod.invoke(payload,value.setScale(2));
//                        }
                        setMethod.invoke(payload, value.setScale(2));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        SaleConContractDO newEntity = SaleConContractConvert.INSTANCE.toDo(payload);
        BeanUtils.copyProperties(entity, oldEntity);
        //将不需要操作记录的字段进行排除
        newEntity.setRemark(null);
        oldEntity.setRemark(null);
        String changeLog = changeFieldLogUtil.getFieldsUpdateLog(newEntity, oldEntity);

        //新老客户修改
        if (!Objects.equals(oldEntity.getCustFlag(), newEntity.getCustFlag())) {
            if (newEntity.getCustFlag() == 1) {
                changeLog = changeLog + "新老客户 由 新客户 修改为 老客户";
            } else {
                changeLog = changeLog + "新老客户 由 老客户 修改为 新客户";
            }
        }
        logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), changeLog);
        //主合同修改了副交付负责人与副签单负责人，同步子合同修改
        // 主合同修改 签单BU 销售负责人 签约公司后 子合同同步修改
        if ("MAIN".equals(newEntity.getMainType()) && (
                !ObjectUtils.isEmpty(newEntity.getCodeliUserId())
                        || !ObjectUtils.isEmpty(newEntity.getCoSignUserId())
                        || !ObjectUtils.isEmpty(newEntity.getSignBuId())
                        || !ObjectUtils.isEmpty(newEntity.getSaleManUserId())
        )) {
            List<SaleConContractDO> subConDOSByMainConList = repo.findByDeleteFlagAndParentIdIn(0, List.of(newEntity.getId()));
            if (!CollectionUtils.isEmpty(subConDOSByMainConList)) {
                subConDOSByMainConList.forEach(
                        sub -> dao.updateSubContractInfoByMainContract(sub.getId(), newEntity)
                );
            }
        }
        //变更日志--end
        //判断子合同含税总金额或者税率是否变化 如有变化，则修改其不含税总金额、有效合同金额
        if ("SUB".equals(newEntity.getMainType())) {
            BigDecimal oldAmt = oldEntity.getAmt() == null ? BigDecimal.ZERO : oldEntity.getAmt();
            BigDecimal newAmt = newEntity.getAmt() == null ? BigDecimal.ZERO : newEntity.getAmt();
            BigDecimal oldTax = oldEntity.getTaxRate() == null ? new BigDecimal("0.00") : oldEntity.getTaxRate();
            BigDecimal newTax = newEntity.getTaxRate() == null ? new BigDecimal("0.00") : newEntity.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0 || oldTax.compareTo(newTax) != 0) {
                this.subAmtCount(payload);
            }
        }
        //判断产品大类有没有发生变化，如果有，则置空小类
        if (ObjectUtils.isEmpty(newEntity.getProductClass()) || (!newEntity.getProductClass().equals(oldEntity.getProductClass()))) {
            List<String> nullFields = payload.getNullFields();
            nullFields.add("productSubClassId");
            payload.setNullFields(nullFields);
        }
//        Map<String, Object> context = BeanUtil.beanToMap(payload);
//        String fileCodeString = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getFileCodes());
//        payload.setFileCodes(fileCodeString);
        this.saleConFileHandle(payload);
        long count = dao.updateByKeyDynamic(payload);
        //----- 如果没有创建易稻壳文件夹则先创建
//        String ydkFolderId = entity.getFolderId();
//        if (!StringUtils.hasText(ydkFolderId)) {
//            String itemId = "";
//            List<String> pathArry = new ArrayList<String>();
//            if ("SUB".equalsIgnoreCase(payload.getMainType())) {
//                //查询主合同
//                SaleConContractVO mainCon = dao.queryByKey(payload.getParentId());
//                itemId = mainCon.getFolderId();
//                if (!StringUtils.hasText(itemId)) {
//                    List<String> mainPathArry = new ArrayList<String>();
//                    mainPathArry.add("/" + mainCon.getCode() + " " + mainCon.getName());
//                    itemId = createYdkFolder("", mainPathArry, payload.getAuthTokenByYdk());
//                    // 保存主合同的易稻壳附件ID
//                    mainCon.setFolderId(itemId);
//                    SaleConContractPayload mainPaylod = SaleConContractConvert.INSTANCE.toPayload(mainCon);
//                    dao.updateByKeyDynamic(mainPaylod);
//                }
//            }
//            pathArry.add("/" + entity.getCode() + " " + name);
//            ydkFolderId = createYdkFolder(itemId, pathArry, payload.getAuthTokenByYdk());
//            payload.setFolderId(ydkFolderId);
//        }
        if (payload.getFileFlag()) {
            //----- 修改易道壳文件夹名称 -----
//            if (!entity.getName().equals(payload.getName())) {
//                ydkFolderId = reNameFolder(entity.getFolderId(), "/" + payload.getCode() + " " + name, payload.getAuthTokenByYdk());
//                payload.setFolderId(ydkFolderId);
//            }
//
//            // 2.把附件最终保存
//            Set<String> allCacheKeys = new HashSet<>();
//            List<String> cacheKeys = new ArrayList<>();
//            List<String> assessCacheKeys = new ArrayList<>();
//            List<String> sowCacheKeys = new ArrayList<>();
//            if (StringUtils.hasText(payload.getCacheKey())) {
//                cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
//                allCacheKeys.addAll(cacheKeys);
//            }
//            if (StringUtils.hasText(payload.getAssessCacheKey())) {
//                assessCacheKeys = Arrays.asList(payload.getAssessCacheKey().split(","));
//                allCacheKeys.addAll(assessCacheKeys);
//            }
//            if (StringUtils.hasText(payload.getSowCacheKey())) {
//                sowCacheKeys = Arrays.asList(payload.getSowCacheKey().split(","));
//                allCacheKeys.addAll(sowCacheKeys);
//            }
//            if (!CollectionUtils.isEmpty(allCacheKeys)) {
//                Map<String, String> cacheMap = saveYdkFile(ydkFolderId, allCacheKeys, payload.getAuthTokenByYdk());
//                if (StringUtils.hasText(payload.getCacheKey())) {
//                    String newFileCodes = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
//                    String fileCodes = StringUtils.hasText(payload.getFileCodes()) ? payload.getFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
//                    payload.setFileCodes(fileCodes);
//                }
//                if (StringUtils.hasText(payload.getAssessCacheKey())) {
//                    String newFileCodes = assessCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
//                    String fileCodes = StringUtils.hasText(payload.getAssessFileCodes()) ? payload.getAssessFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
//                    payload.setAssessFileCodes(fileCodes);
//                }
//                if (StringUtils.hasText(payload.getSowCacheKey())) {
//                    String newFileCodes = sowCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
//                    String fileCodes = StringUtils.hasText(payload.getSowFileCodes()) ? payload.getSowFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
//                    payload.setSowFileCodes(fileCodes);
//                }
//            }
            // -- 易道壳保存附件结束 --
        }
//        long count = dao.updateByKeyDynamic(payload);

        if ("SUB".equals(newEntity.getMainType())) {
            // 经沟通：#18167
            // 1、纸质合同状态改为已回，默认赋值收回日期=当天，是否归档=是
            // 2、纸质合同状态改为未回，默认赋值收回日期=空，是否归档=否
            String oldPaperStatus = oldEntity.getPaperStatus();
            String newPaperStatus = newEntity.getPaperStatus();
            if (
                    (!StringUtils.hasText(oldPaperStatus) && StringUtils.hasText(newPaperStatus)) ||
                            (StringUtils.hasText(oldPaperStatus) && StringUtils.hasText(newPaperStatus) && !oldPaperStatus.equals(newPaperStatus))
            ) {
                Long[] keys = {payload.getId()};
                if (newPaperStatus.equals(SaleConContractPaperStatusEnum.BACK.getCode())) {
                    conFiling(keys);
                } else if (newPaperStatus.equals(SaleConContractPaperStatusEnum.UNBACK.getCode())) {
                    unConFiling(keys);
                }
            }
        }

        return count;
    }

    /**
     * 销售合同附件处理
     *
     * @param payload payload
     */
    private void saleConFileHandle(SaleConContractPayload payload) {
        Map<String, Object> context = BeanUtil.beanToMap(payload);
        // 合同附件
        String fileCodeString = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getFileCodes());
        payload.setFileCodes(fileCodeString);
        // sow附件
        String sowFileCodeString = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getSowFileCodes());
        payload.setSowFileCodes(sowFileCodeString);
        // 估算申请单附件
        String assessFileCodeString = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getAssessFileCodes());
        payload.setAssessFileCodes(assessFileCodeString);
        // 合同关闭附件
        String closeFileCodeString = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getCloseFileCodes());
        payload.setCloseFileCodes(closeFileCodeString);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateInfoByKeyDynamic(SaleConContractPayload payload) {
        SaleConContractDO entity = repo.findById(payload.getId()).orElseGet(SaleConContractDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 合同名称不可以重复
        String name = payload.getName();
        if (StringUtils.hasText(name)) {
            SaleConContractQuery query = new SaleConContractQuery();
            query.setEqName(name);
            PagingVO<SaleConContractVO> queryPaging = dao.queryPaging(query);
            List<SaleConContractVO> records = queryPaging.getRecords();
            if (!CollectionUtils.isEmpty(queryPaging.getRecords())) {
                List<SaleConContractVO> collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    throw TwException.warn("", "合同名称不可重复！");
                }
            }
        }
        //变更日志--start
        SaleConContractDO oldEntity = new SaleConContractDO();
        //通过反射来获取 BigDecimal 类型的所有字段(用来把前端传过来的BigDecimal整数保留两位小数)
        Class<?> clazz = payload.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            if ("java.math.BigDecimal".equals(field.getType().getName())) {
                //属性名
                String fieldName = field.getName();
                //获取属性值的方法名
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                //属性值
                try {
                    Method getMethod = clazz.getMethod(getMethodName);
                    //获取属性值
                    BigDecimal value = (BigDecimal) getMethod.invoke(payload);
                    if (value != null) {
                        String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                        Method setMethod = clazz.getDeclaredMethod(setMethodName, field.getType());
                        setMethod.invoke(payload, value.setScale(2));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        SaleConContractDO newEntity = SaleConContractConvert.INSTANCE.toDo(payload);
        BeanUtils.copyProperties(entity, oldEntity);
        //将不需要操作记录的字段进行排除
        newEntity.setRemark(null);
        oldEntity.setRemark(null);
        String changeLog = changeFieldLogUtil.getFieldsUpdateLog(newEntity, oldEntity);
        // 关键信息变更保存变更记录
        SaleConContractVO newSaleConContractVO = SaleConContractConvert.INSTANCE.toVo(newEntity);
        udcUtil.translate(newSaleConContractVO);
        transfer(newSaleConContractVO);
        SaleConContractVO oldSaleConContractVO = SaleConContractConvert.INSTANCE.toVo(entity);
        udcUtil.translate(oldSaleConContractVO);
        transfer(oldSaleConContractVO);
        String saveChangeLog = saveChangeLog(newSaleConContractVO, oldSaleConContractVO);
        if (StringUtils.hasText(saveChangeLog)) {
            logService.saveNewLog(newSaleConContractVO.getId(), PrdSystemObjectEnum.SaleConContractChange.getCode(), saveChangeLog);
        }

        //新老客户修改
        if (!Objects.equals(oldEntity.getCustFlag(), newEntity.getCustFlag())) {
            if (newEntity.getCustFlag() == 1) {
                changeLog = changeLog + "新老客户 由 新客户 修改为 老客户";
            } else {
                changeLog = changeLog + "新老客户 由 老客户 修改为 新客户";
            }
        }
        logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), changeLog);
        //变更日志--end
        //判断子合同含税总金额或者税率是否变化 如有变化，则修改其不含税总金额、有效合同金额
        if ("SUB".equals(newEntity.getMainType())) {
            BigDecimal oldAmt = oldEntity.getAmt() == null ? BigDecimal.ZERO : oldEntity.getAmt();
            BigDecimal newAmt = newEntity.getAmt() == null ? BigDecimal.ZERO : newEntity.getAmt();
            BigDecimal oldTax = oldEntity.getTaxRate() == null ? new BigDecimal("0.00") : oldEntity.getTaxRate();
            BigDecimal newTax = newEntity.getTaxRate() == null ? new BigDecimal("0.00") : newEntity.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0 || oldTax.compareTo(newTax) != 0) {
                this.subAmtCount(payload);
            }
        }
        //判断产品大类有没有发生变化，如果有，则置空小类
        if (ObjectUtils.isEmpty(newEntity.getProductClass()) || (!newEntity.getProductClass().equals(oldEntity.getProductClass()))) {
            List<String> nullFields = payload.getNullFields();
            nullFields.add("productSubClassId");
            payload.setNullFields(nullFields);
        }
        //----- 如果没有创建易稻壳文件夹则先创建
        String ydkFolderId = entity.getFolderId();
        //----- 修改易道壳文件夹名称 -----
        if (!entity.getName().equals(payload.getName())) {
            ydkFolderId = reNameFolder(entity.getFolderId(), "/" + payload.getCode() + " " + name, payload.getAuthTokenByYdk());
            payload.setFolderId(ydkFolderId);
        }
        // 2.把附件最终保存
        Set<String> allCacheKeys = new HashSet<>();
        List<String> cacheKeys = new ArrayList<>();
        List<String> assessCacheKeys = new ArrayList<>();
        List<String> sowCacheKeys = new ArrayList<>();
        if (StringUtils.hasText(payload.getCacheKey())) {
            cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
            allCacheKeys.addAll(cacheKeys);
        }
        if (StringUtils.hasText(payload.getAssessCacheKey())) {
            assessCacheKeys = Arrays.asList(payload.getAssessCacheKey().split(","));
            allCacheKeys.addAll(assessCacheKeys);
        }
        if (StringUtils.hasText(payload.getSowCacheKey())) {
            sowCacheKeys = Arrays.asList(payload.getSowCacheKey().split(","));
            allCacheKeys.addAll(sowCacheKeys);
        }
        if (!CollectionUtils.isEmpty(allCacheKeys)) {
            Map<String, String> cacheMap = saveYdkFile(ydkFolderId, allCacheKeys, payload.getAuthTokenByYdk());
            if (StringUtils.hasText(payload.getCacheKey())) {
                String newFileCodes = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                String fileCodes = StringUtils.hasText(payload.getFileCodes()) ? payload.getFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                payload.setFileCodes(fileCodes);
            }
            if (StringUtils.hasText(payload.getAssessCacheKey())) {
                String newFileCodes = assessCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                String fileCodes = StringUtils.hasText(payload.getAssessFileCodes()) ? payload.getAssessFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                payload.setAssessFileCodes(fileCodes);
            }
            if (StringUtils.hasText(payload.getSowCacheKey())) {
                String newFileCodes = sowCacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
                String fileCodes = StringUtils.hasText(payload.getSowFileCodes()) ? payload.getSowFileCodes().concat(",").concat(newFileCodes) : newFileCodes;
                payload.setSowFileCodes(fileCodes);
            }
        }
        // -- 易道壳保存附件结束 --
        return dao.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<SaleConContractDO> optional = repo.findById(id);
                if (!optional.isEmpty()) {
                    SaleConContractDO entity = optional.get();
                    //删除合同 商机状态由关闭—>激活，关闭原因由生成合同—>空
                    Long oppoId = entity.getOppoId();
                    //0530 子合同关闭重新打开商机逻辑不太对，改成主合同删掉才打开商机
                    if (StringUtils.hasText(entity.getMainType()) && "MAIN".equalsIgnoreCase(entity.getMainType()) && !ObjectUtils.isEmpty(oppoId)) {
                        opportunityService.changeStatus(oppoId);
                    }
                    if (!"CREATE".equalsIgnoreCase(entity.getStatus())) {
                        throw TwException.error("", "只有新建状态的合同才能删除");
                    }
                    //新建日志--start
                    String changeLog = "";
                    if ("MAIN".equalsIgnoreCase(entity.getMainType())) {
                        changeLog = "删除主合同";
                    } else {
                        changeLog = "删除子合同" + entity.getName();
                        logService.saveNewLog(entity.getParentId(), PrdSystemObjectEnum.SaleConContract.getCode(), changeLog);
                    }
                    logService.saveNewLog(entity.getId(), PrdSystemObjectEnum.SaleConContract.getCode(), changeLog);
                    //变更日志--end
                }
            });
            dao.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public Long active(List<Long> keys) {
        // 目前先一个个激活
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "合同请一个个激活！");
        }
        List<SaleConContractDO> conContractDOS = repo.findAllById(keys);
//        return dao.updataStatusByIds(keys, "active");
        // 非虚拟合同的新建、暂挂可以激活，虚拟合同待激活、暂挂可以激活
        for (SaleConContractDO conContractDO : conContractDOS) {
            String mainType = conContractDO.getMainType();
            String status = conContractDO.getStatus();
            String platType = conContractDO.getPlatType();
            //判断是否为主合同
            if ("MAIN".equalsIgnoreCase(mainType)) {
                if (!("CREATE".equalsIgnoreCase(status))) {
                    throw TwException.error("", "只有处于新建状态的主合同才可以进行激活");
                }
            } else {
                //判断是否为虚拟合同
                List<String> platTypeList = new ArrayList<String>();
                platTypeList.add("FICTITIOUS");
                platTypeList.add("NO_CONTRACT_VIRTUAL_CONTRACT");
                if (!platTypeList.contains(platType)) {
                    if (!("CREATE".equalsIgnoreCase(status))) {
                        throw TwException.error("", "只有处于新建状态的非虚拟子合同才可以进行激活");
                    }
                } else {
                    if (!("ACTIVE_WAITING".equalsIgnoreCase(status))) {
                        throw TwException.error("", "只有处于待激活状态的虚拟子合同才可以进行激活");
                    }
                }
                //根据子合同范围性质做不同校验
                List<ConReceivablePlanVO> conReceivablePlanVOS = conReceivablePlanService.queryBySaleConId(conContractDO.getId());
                // 如果是T&M项目 激活不拦截没有收款计划
                if (!"T&M".equals(conContractDO.getWorkType())) {

                    //开口合同---激活时需要确认收款计划有值
                    if ("OPEN".equalsIgnoreCase(conContractDO.getRangeProp())) {
                        if (conReceivablePlanVOS.size() <= 0) {
                            throw TwException.error("", "该合同的收款计划为空");
                        }
                    } else {     //闭口合同----激活时需要确保收款计划总金额=子合同含税总金额
                        BigDecimal planAmt = BigDecimal.ZERO;
                        for (ConReceivablePlanVO conReceivablePlanVO : conReceivablePlanVOS) {
                            planAmt = planAmt.add(conReceivablePlanVO.getReceAmt());
                        }
                        if (planAmt.compareTo(conContractDO.getAmt()) != 0) {
                            throw TwException.error("", "收款计划总金额不等于子合同含税总金额");
                        }
                    }
                }
            }
        }
        SaleConContractDO conContractDO = conContractDOS.get(0);
        if ("MAIN".equalsIgnoreCase(conContractDO.getMainType())) {
            //创建客户经营
            SaleConContractVO conContractVO = SaleConContractConvert.INSTANCE.toVo(conContractDO);
            CrmCustomerOperationPayload customerOperationPayload = this.buildCustOperationPayload(conContractVO);
            try {
                //创建成功，发送消息提醒
                CrmCustomerOperationVO operationVO = crmCustomerOperationService.insert(customerOperationPayload, false);
                operationVO.setCustOperManagerName(cacheUtil.getUserName(operationVO.getCustOperManagerId()));
                operationVO.setSaleOperManagerName(cacheUtil.getUserName(operationVO.getSaleOperManagerId()));
                //补充启信宝信息
                crmCustomerOperationService.fillQxbInfo(operationVO.getCustName(), operationVO.getId());
                crmCustomerOperationService.noticeOperManagers(operationVO, CustomerOperationNoticeEnum.COMPLETE.getCode());
            } catch (TwException e) {
                log.warn("销售合同创建客户经营失败，异常信息 is {}", e.getErrors());
            }
            return dao.updataStatusByIds(keys, "ACTIVE");
        } else {
            // 如果子合同激活时，本次只需要判断收款计划是否维护
            List<ConReceivablePlanVO> conReceivablePlanVOS = conReceivablePlanService.queryBySaleConId(conContractDO.getId());
            if (!"T&M".equals(conContractDO.getWorkType()) && CollectionUtils.isEmpty(conReceivablePlanVOS)) {
                throw TwException.error("", "请先维护收款计划！");
            }
            activeProc(conContractDO);
            return 1L;
        }
    }

    private CrmCustomerOperationPayload buildCustOperationPayload(SaleConContractVO conContractVO) {
        CrmCustomerOperationPayload payload = new CrmCustomerOperationPayload();
        //查询客户信息 合同中的custId是地址簿id
        //CrmCustomerVO crmCustomerVO = crmCustomerService.queryDetailByBookId(conContractVO.getCustId());
        BusinessPartnerVO businessPartnerVO = businessPartnerService.queryCustomerByBookId(conContractVO.getCustId());
        if (businessPartnerVO == null) {
            return payload;
        }
        payload.setCustType(CustomerOperationTypeEnum.ENTERPRISE.getCode());
        payload.setCustomerId(businessPartnerVO.getId());
        payload.setCustName(businessPartnerVO.getPartnerName());
        payload.setNoticeTime(LocalDateTime.now());
        payload.setSaleOperBu(conContractVO.getSaleManUserBuId());
        payload.setSaleOperManagerId(conContractVO.getSaleManUserId());
        payload.setCustOperBu(conContractVO.getDeliBuId());
        payload.setCustOperManagerId(conContractVO.getDeliUserId());
        return payload;
    }

    /**
     * 发起子合同激活审批流程
     *
     * @param conContract
     */
    private void activeProc(SaleConContractDO conContract) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (true) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();

            HashMap<String, Object> variables = new HashMap<>();
            dealVariables(conContract.getParentId(), conContract.getSignBuId(), conContract.getDeliUserId(), conContract.getDeliBuId(), variables);
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.SALE_CON_ACTIVE.name(),
                    conContract.getName() + "-销售子合同激活审批流程",
                    conContract.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContract.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        String closeFileCodes = conContract.getCloseFileCodes();
        if (StringUtils.hasText(closeFileCodes)) {
            payload.setCloseFileCodes(closeFileCodes);
        }
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(payload);
        });
    }

    private void dealVariables(Long parentId, Long signBuId, Long deliUserId, Long deliBuId, HashMap<String, Object> variables) {

        // 查询主合同,主合同金额是否>50万
        SaleConContractVO parentCon = dao.queryByKey(parentId);
        BigDecimal amt = ObjectUtils.isEmpty(parentCon.getAmt()) ? BigDecimal.ZERO : parentCon.getAmt();
        Boolean amtValid = false;
        if (BigDecimal.valueOf(500000L).compareTo(amt) < 0) {
            amtValid = true;
        }
        variables.put("amtValid", amtValid);
        // 是否销售BU签单
        PrdOrgOrganizationVO orgVo = orgService.queryDetailSimpleByOrgId(signBuId);
        if ((!ObjectUtils.isEmpty(orgVo)) && "BS".equals(orgVo.getOrganizationType())) {
            variables.put("isSaleBuType", true);
        } else {
            variables.put("isSaleBuType", false);
        }
        // 签单bu负责人
        Long signBuManageUserId = daoOrg.queryManageIdById(signBuId);
        variables.put("Activity_17pzpxv", CollUtil.newArrayList(signBuManageUserId));
        // 交付负责人
        variables.put("Activity_1bffr1c", CollUtil.newArrayList(deliUserId));
        // 交付Bu负责人
        Long deliBuManageUserId = daoOrg.queryManageIdById(deliBuId);
        variables.put("Activity_0fgh8bp", CollUtil.newArrayList(deliBuManageUserId));
        //财务核定人员
        List<Long> finCheckUserIds = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CHECK.getCode());
        variables.put("Activity_1l293u9", CollUtil.newArrayList(finCheckUserIds));
        // CFO
        List<Long> cfo = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode());
        variables.put("Activity_15291u6", cfo);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long pending(List<Long> keys) {
        // 激活状态才可以暂挂
        List<SaleConContractDO> conContractDOS = repo.findAllById(keys);
        for (SaleConContractDO conContractDO : conContractDOS) {
            if ((!"ACTIVE".equalsIgnoreCase(conContractDO.getStatus()))) {
                throw TwException.error("", "激活的合同才可以进行暂挂");
            }
        }
        return dao.updataStatusByIds(keys, "PENDING");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long closeWithWorkFlow(List<Long> keys, String closeCacheKey, String anthToken) {
        // 目前先一个个删除
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "合同请一个个关闭！");
        }
        // 激活状态才可以关闭
//        List<SaleConContractDO> conContractDOS = repo.findAllById(keys);
//        for (SaleConContractDO conContractDO : conContractDOS) {
//            if (!"active".equalsIgnoreCase(conContractDO.getStatus())) {
//                throw TwException.error("", "激活的合同才可以进行关闭");
//            }
//        }
        Long key = keys.get(0);
        SaleConContractVO saleConContractVO = queryByKey(key);
        // 如果为开口合同，可以直接关闭
        if (SaleConEnum.OPEN.getCode().equalsIgnoreCase(saleConContractVO.getRangeProp())) {
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("正常关闭");
            dao.updateByKeyDynamic(payload);
            return 1L;
        }
        if (!"ACTIVE".equalsIgnoreCase(saleConContractVO.getStatus())) {
            throw TwException.error("", "激活的合同才可以进行关闭");
        }
        // 主合同关闭条件：1.该主合同处于激活状态  2.该主合同下的所有子合同已关闭
        if (ObjectUtils.isEmpty(saleConContractVO.getParentId())) {
            List<SaleConContractVO> subSaleConContractVOS = queryListByConId(key);
            // 查询子合同里面不是关闭状态的合同
            List<String> stringList = Arrays.asList("INVALID", "CLOSE");

            List<SaleConContractVO> collect = subSaleConContractVOS.stream().filter(e ->
                    !stringList.contains(e.getStatus())
            ).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                throw TwException.error("", "请先关闭所有子合同，再关闭主合同！");
            }
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("normal");
            dao.updateByKeyDynamic(payload);
        } else {
            // 异常关闭附件
            String closeFileCode = "";
            if (StringUtils.hasText(closeCacheKey)) {
                String folderId = saleConContractVO.getFolderId();
                if (!StringUtils.hasText(folderId)) {
                    throw TwException.error("", "易道壳附件没有文件夹，请先联系管理员创建文件夹！");
                }
                List<String> cacheKeys = Arrays.asList(closeCacheKey.split(","));
                Map<String, String> cacheMap = saveYdkFile(folderId, new HashSet<>(cacheKeys), anthToken);
                closeFileCode = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
            }
            // 正常关闭：正常关闭不需要走审批流程。正常关闭条件：1）合同收回并归档（即纸质合同状态为“已回“）2）合同已全额收款（已收款金额=合同金额） 3）合同处于激活状态
            String paperStatus = saleConContractVO.getPaperStatus();
            BigDecimal AmountCollected = amountOfMoney(saleConContractVO.getId()).get("AmountCollected");
            if ("BACK".equalsIgnoreCase(paperStatus) && AmountCollected.compareTo(saleConContractVO.getAmt()) == 0) {
                SaleConContractPayload payload = new SaleConContractPayload();
                payload.setId(saleConContractVO.getId());
                payload.setStatus("CLOSE");
                payload.setCloseDate(LocalDate.now());
                payload.setCloseReason("normal");
                dao.updateByKeyDynamic(payload);
            } else {
                if (StringUtils.hasText(closeFileCode)) {
                    saleConContractVO.setCloseFileCodes(closeFileCode);
                }
                closeProc(saleConContractVO);
            }
        }

//        dao.closeCon(keys);
        //走新增审批流程
//        closeProc(saleConContractVO);
        return 1L;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long close(List<Long> keys, String closeCacheKey, String anthToken) {
        // 目前先一个个删除
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "合同请一个个关闭！");
        }
        // 激活状态才可以关闭
//        List<SaleConContractDO> conContractDOS = repo.findAllById(keys);
//        for (SaleConContractDO conContractDO : conContractDOS) {
//            if (!"active".equalsIgnoreCase(conContractDO.getStatus())) {
//                throw TwException.error("", "激活的合同才可以进行关闭");
//            }
//        }
        Long key = keys.get(0);
        SaleConContractVO saleConContractVO = queryByKey(key);
        // 如果为开口合同，可以直接关闭
        if (SaleConEnum.OPEN.getCode().equalsIgnoreCase(saleConContractVO.getRangeProp())) {
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("正常关闭");
            dao.updateByKeyDynamic(payload);
            return 1L;
        }
        if (!"ACTIVE".equalsIgnoreCase(saleConContractVO.getStatus())) {
            throw TwException.error("", "激活的合同才可以进行关闭");
        }
        // 主合同关闭条件：1.该主合同处于激活状态  2.该主合同下的所有子合同已关闭
        if (ObjectUtils.isEmpty(saleConContractVO.getParentId())) {
            List<SaleConContractVO> subSaleConContractVOS = queryListByConId(key);
            // 查询子合同里面不是关闭状态的合同
            List<String> stringList = Arrays.asList("INVALID", "CLOSE");

            List<SaleConContractVO> collect = subSaleConContractVOS.stream().filter(e ->
                    !stringList.contains(e.getStatus())
            ).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                throw TwException.error("", "请先关闭所有子合同，再关闭主合同！");
            }
            SaleConContractPayload payload = new SaleConContractPayload();
            payload.setId(saleConContractVO.getId());
            payload.setStatus("CLOSE");
            payload.setCloseDate(LocalDate.now());
            payload.setCloseReason("normal");
            dao.updateByKeyDynamic(payload);
        } else {
            // 异常关闭附件
            String closeFileCode = "";
            if (StringUtils.hasText(closeCacheKey)) {
                String folderId = saleConContractVO.getFolderId();
                if (!StringUtils.hasText(folderId)) {
                    throw TwException.error("", "易道壳附件没有文件夹，请先联系管理员创建文件夹！");
                }
                List<String> cacheKeys = Arrays.asList(closeCacheKey.split(","));
                Map<String, String> cacheMap = saveYdkFile(folderId, new HashSet<>(cacheKeys), anthToken);
                closeFileCode = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
            }
            // 正常关闭：正常关闭不需要走审批流程。正常关闭条件：1）合同收回并归档（即纸质合同状态为“已回“）2）合同已全额收款（已收款金额=合同金额） 3）合同处于激活状态
            String paperStatus = saleConContractVO.getPaperStatus();
            BigDecimal AmountCollected = amountOfMoney(saleConContractVO.getId()).get("AmountCollected");
            if ("BACK".equalsIgnoreCase(paperStatus) && AmountCollected.compareTo(saleConContractVO.getAmt()) == 0) {
                SaleConContractPayload payload = new SaleConContractPayload();
                payload.setId(saleConContractVO.getId());
                payload.setStatus("CLOSE");
                payload.setCloseDate(LocalDate.now());
                payload.setCloseReason("normal");
                dao.updateByKeyDynamic(payload);
            } else {
                if (StringUtils.hasText(closeFileCode)) {
                    saleConContractVO.setCloseFileCodes(closeFileCode);
                }
                // 关闭合同
                SaleConContractPayload payload = new SaleConContractPayload();
                payload.setId(saleConContractVO.getId());
                payload.setStatus("CLOSE");
                payload.setCloseDate(LocalDate.now());
                payload.setCloseReason("abnormal");
                String closeFileCodes = saleConContractVO.getCloseFileCodes();
                if (StringUtils.hasText(closeFileCodes)) {
                    payload.setCloseFileCodes(closeFileCodes);
                }
                dao.updateByKeyDynamic(payload);
            }
        }

//        dao.closeCon(keys);
        //走新增审批流程
//        closeProc(saleConContractVO);
        return 1L;
    }

    /**
     * 发起子合同作废审批流程
     *
     * @param conContractVO
     */
    private void closeProc(SaleConContractVO conContractVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();

            //财务：何申夏 579785842973871494
            //商务：刘雯 579786153893431595
            //获取当前登录用户
            final Long loginUserId = GlobalUtil.getLoginUserId();
            //判断管理员
            final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (isSystemAdmin) {
                variables.put("isFinPic", true);
            } else {
                // 判断当前登录人是否拥有角色【财务负责人	FIN_PIC】
                List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(
                        Arrays.asList(RoleEnum.SYS.getCode(), "FIN_PIC"));
                if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
                    variables.put("isFinPic", true);
                }
                // 判断当前登录人是否拥有角色【商务负责人	BUSINESS_MANAGER】
                List<Long> userIdsByRole1 = systemRoleDAO.queryUserIdByRoleCodes(
                        Arrays.asList(RoleEnum.SYS.getCode(), "BUSINESS_MANAGER"));
                if (!CollectionUtils.isEmpty(userIdsByRole1) && userIdsByRole1.contains(loginUserId)) {
                    variables.put("isFinPic", false);
                }
            }
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.SALE_CON_CLOSE.name(),
                    conContractVO.getName() + "-销售子合同关闭审批流程",
                    conContractVO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContractVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        String closeFileCodes = conContractVO.getCloseFileCodes();
        if (StringUtils.hasText(closeFileCodes)) {
            payload.setCloseFileCodes(closeFileCodes);
        }
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(payload);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void invalidWithWorkFlow(List<Long> keys) {
        List<SaleConContractDO> conContractDOS = repo.findAllById(keys);
        for (SaleConContractDO conContractDO : conContractDOS) {
            String status = conContractDO.getStatus();
            String mainType = conContractDO.getMainType();
            if ("MAIN".equalsIgnoreCase(mainType)) {
                if (!("ACTIVE".equalsIgnoreCase(status))) {
                    throw TwException.error("", "激活的主合同才可作废！");
                }
                List<SaleConContractVO> subList = this.queryListByConId(conContractDO.getId());
                for (SaleConContractVO subConVO : subList) {
                    if (!"INVALID".equalsIgnoreCase(subConVO.getStatus())) {
                        throw TwException.error("", "所有主合同的子合同都作废，才可作废主合同！");
                    }
                }
                //走作废审批流程
                dao.updataStatusByIds(Collections.singletonList(conContractDO.getId()), "INVALID");
            } else {
                if (!("ACTIVE".equalsIgnoreCase(status))) {
                    throw TwException.error("", "该子合同不满足作废条件，不能作废！");
                }
                //走作废审批流程
                this.invalidProc(conContractDO);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void invalid(List<Long> keys) {
        List<SaleConContractDO> conContractDOS = repo.findAllById(keys);
        for (SaleConContractDO conContractDO : conContractDOS) {
            String status = conContractDO.getStatus();
            String mainType = conContractDO.getMainType();
            if ("MAIN".equalsIgnoreCase(mainType)) {
                if (!("ACTIVE".equalsIgnoreCase(status))) {
                    throw TwException.error("", "激活的主合同才可作废！");
                }
                List<SaleConContractVO> subList = this.queryListByConId(conContractDO.getId());
                for (SaleConContractVO subConVO : subList) {
                    if (!"INVALID".equalsIgnoreCase(subConVO.getStatus())) {
                        throw TwException.error("", "所有主合同的子合同都作废，才可作废主合同！");
                    }
                }
                //走作废审批流程
                dao.updataStatusByIds(Collections.singletonList(conContractDO.getId()), "INVALID");
            } else {
                if (!("ACTIVE".equalsIgnoreCase(status))) {
                    throw TwException.error("", "该子合同不满足作废条件，不能作废！");
                }
                //作废
                dao.updataStatusByIds(Collections.singletonList(conContractDO.getId()), WorkFlowStatusEnum.INVALID.getCode());

            }
        }
    }

    @Override
    public void change(SaleConContractPayload payload) {
        SaleConContractVO saleConContractVO = queryByKey(payload.getId());
        if (saleConContractVO.getChangeFlag() != null && saleConContractVO.getChangeFlag() == 1) {
            throw TwException.error("", "变更中的子合同不能再次发起变更");
        }
        if ("MAIN".equalsIgnoreCase(saleConContractVO.getMainType())) {
            throw TwException.error("", "只有子合同才能进行变更");
        }

        if (!"ACTIVE".equalsIgnoreCase(saleConContractVO.getStatus())) {
            throw TwException.error("", "激活的子合同才可变更！");
        }
        saleConContractVO = (SaleConContractVO) udcUtil.translate(saleConContractVO);
        SaleConContractVO newSaleConContractVO = new SaleConContractVO();
        BeanCopyUtil.beanCopy(saleConContractVO, newSaleConContractVO);
        // 合同变更的字段组装
        buildNewContract(newSaleConContractVO, payload);
        newSaleConContractVO = (SaleConContractVO) udcUtil.translate(newSaleConContractVO);
        Long saveId = changeService.save(ChangeTypeEnum.SALE_CON_CHANGE.getCode(), saleConContractVO, newSaleConContractVO, payload.getId() + "");

        //发起工作流
        ProcessInfo processInfo = startChangeWorkFlow(saleConContractVO, saveId);
        int changeFlag = 1;
        String changeStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        // 如果创建人和审批人是同一个人 并且设置了自动跳过 就直接完成了
        if (processInfo.getProcInstStatus().name().equals(ProcInstStatus.APPROVED.name())) {
            changeFlag = 0;
            changeStatus = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        }
        SaleConContractPayload payload0 = new SaleConContractPayload();
        payload0.setId(payload.getId());
        payload0.setChangeFlag(changeFlag);

        ComChangePayload changePayload = new ComChangePayload();
        changePayload.setId(saveId);
        changePayload.setProcInstId(processInfo.getProcInstId());
        changePayload.setApprStatus(processInfo.getProcInstStatus().name());
        changePayload.setChangeStatus(changeStatus);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(payload0);
            changeService.updateWorkFlow(changePayload);
        });
    }

    @Override
    @Transactional
    public void updateChange(SaleConContractPayload payload) {
        SaleConContractVO saleConContractVO = queryByKey(payload.getId());

        saleConContractVO = (SaleConContractVO) udcUtil.translate(saleConContractVO);
        SaleConContractVO newSaleConContractVO = new SaleConContractVO();
        BeanCopyUtil.beanCopy(saleConContractVO, newSaleConContractVO);
        // 合同变更的字段组装
        buildNewContract(newSaleConContractVO, payload);
        newSaleConContractVO = (SaleConContractVO) udcUtil.translate(newSaleConContractVO);

        ComChangeVO comChangeVO = changeService.queryByKey(payload.getChangeBusinesskey());
        if (!ObjectUtils.isEmpty(comChangeVO)) {
            //存在授权变更中的数据
            Long saveId = comChangeVO.getId();
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(saveId);
            changePayload.setChangeContent(JSONObject.toJSONString(newSaleConContractVO));
            changeService.updateByKeyDynamic(changePayload);
        }
    }

    @Override
    public SaleConContractVO queryChangeDetail(Long businessKey) {
        if (businessKey != null) {
            ComChangeVO comChangeVO = changeService.queryByKey(businessKey);
            String changeContent = comChangeVO.getChangeContent();
            if (org.apache.commons.lang3.StringUtils.isEmpty(changeContent)) {
                throw TwException.error("", "数据不存在,请联系管理员");
            }
            SaleConContractVO saleConContractVO = JSONObject.parseObject(changeContent, SaleConContractVO.class);
            return saleConContractVO;
        }
        return null;
    }


    // 合同变更的字段组装
    private void buildNewContract(SaleConContractVO newSaleConContractVO, SaleConContractPayload payload) {
        //签约公司
        if (payload.getOuBookId() != null) {
            newSaleConContractVO.setOuBookId(payload.getOuBookId());
            newSaleConContractVO.setOuName(cacheUtil.getCompanyNameByBookId(payload.getOuBookId()));
        }
        // 客户名称
        if (payload.getCustId() != null) {
            newSaleConContractVO.setCustId(payload.getCustId());
            newSaleConContractVO.setCustName(cacheUtil.getCompanyNameByBookId(payload.getCustId()));
        }
        // 工作类型
        if (StringUtils.hasText(payload.getWorkType())) {
            newSaleConContractVO.setWorkType(payload.getWorkType());
        }
        // 交付bu
        if (payload.getDeliBuId() != null) {
            newSaleConContractVO.setDeliBuId(payload.getDeliBuId());
        }
        // 销售大类
        if (StringUtils.hasText(payload.getProductClass())) {
            newSaleConContractVO.setProductClass(payload.getProductClass());
        }
        // 销售小类
        if (StringUtils.hasText(payload.getProductSubClass())) {
            newSaleConContractVO.setProductSubClass(payload.getProductSubClass());
        }
        // 签订日期
        if (payload.getSignDate() != null) {
            newSaleConContractVO.setSignDate(payload.getSignDate());
        }
        // 合同开始日期
        if (payload.getStartDate() != null) {
            newSaleConContractVO.setStartDate(payload.getStartDate());
        }
        // 合同结束日期
        if (payload.getEndDate() != null) {
            newSaleConContractVO.setEndDate(payload.getEndDate());
        }
        // 合同金额 税率
        if (payload.getAmt() != null || payload.getTaxRate() != null) {
            BigDecimal oldAmt = newSaleConContractVO.getAmt() == null ? BigDecimal.ZERO : newSaleConContractVO.getAmt();
            BigDecimal newAmt = payload.getAmt() == null ? BigDecimal.ZERO : payload.getAmt();
            BigDecimal oldTax = newSaleConContractVO.getTaxRate() == null ? new BigDecimal("0.00") : newSaleConContractVO.getTaxRate();
            BigDecimal newTax = payload.getTaxRate() == null ? new BigDecimal("0.00") : payload.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0 || oldTax.compareTo(newTax) != 0) {
                this.subAmtCount(payload);
                newSaleConContractVO.setAmt(payload.getAmt());
                newSaleConContractVO.setTaxRate(payload.getTaxRate());
                newSaleConContractVO.setExtraAmt(payload.getExtraAmt());
                newSaleConContractVO.setEffectiveAmt(payload.getEffectiveAmt());
                newSaleConContractVO.setDemandTotalAmt(payload.getDemandTotalAmt());
                BigDecimal amt = newSaleConContractVO.getAmt() == null ? BigDecimal.ZERO : newSaleConContractVO.getAmt();   //合同总金额
                BigDecimal taxRate = newSaleConContractVO.getTaxRate() == null ? BigDecimal.ZERO : newSaleConContractVO.getTaxRate();   //税率
                BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);    //不含税总金额
                // 不含税金额
                newSaleConContractVO.setNotTaxAmt(notTaxAmt);
            }
        }
        transfer(newSaleConContractVO);
    }

    private ProcessInfo startChangeWorkFlow(SaleConContractVO saleConContractVO, Long saveId) {


        HashMap<String, Object> batchMap = new HashMap<>();

        // 交付Bu负责人
        PrdOrgOrganizationVO org = cacheUtil.getOrg(saleConContractVO.getDeliBuId());
        batchMap.put("Activity_144ixvi", Lists.newArrayList(org.getManageId()));
        //平台财务核定
        List<Long> userIds = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CHECK.getCode());
        if (ObjectUtils.isEmpty(userIds)) {
            throw TwException.error("", "平台总账会计角色人员不存在");
        }
        batchMap.put("Activity_16kw0qx", Lists.newArrayList(userIds));

        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.SALE_CON_CHANGE.name(),
                "子合同变更审批-" + saleConContractVO.getName(),
                saveId + "",
                batchMap)
        );
        return processInfo;
    }


    /**
     * 更新数据
     *
     * @param saleConContractVO
     */
    @Override
    @Transactional
    public void updateWorkFlow(SaleConContractVO saleConContractVO) {
        SaleConContractPayload saleConContractPayload = SaleConContractConvert.INSTANCE.toPayload(saleConContractVO);
        SaleConContractVO oldContractVO = queryByKey(saleConContractVO.getId());
        // 审批完成才记录变更记录
        if (saleConContractVO.getApproveFlag() != null && saleConContractVO.getApproveFlag()) {
            // 审批完成写变更记录
            saveChangeLog(saleConContractVO, oldContractVO);
        }
        //合同更新
        dao.updateByKeyDynamic(saleConContractPayload);

    }

    private String saveChangeLog(SaleConContractVO newSaleConContractVO, SaleConContractVO oldContractVO) {
        StringBuilder stringBuilder = new StringBuilder();
        //签约公司
        if (newSaleConContractVO.getOuBookId() != null && !newSaleConContractVO.getOuBookId().equals(oldContractVO.getOuBookId())) {
            String oldCompanyName = cacheUtil.getCompanyNameByBookId(oldContractVO.getOuBookId());
            String newCompanyName = cacheUtil.getCompanyNameByBookId(newSaleConContractVO.getOuBookId());
            stringBuilder.append("签约公司由" + oldCompanyName + " 变更为 " + newCompanyName);
        }
        // 客户名称
        if (newSaleConContractVO.getCustId() != null && !newSaleConContractVO.getCustId().equals(oldContractVO.getCustId())) {
            String oldCompanyName = cacheUtil.getCompanyNameByBookId(oldContractVO.getCustId());
            String newCompanyName = cacheUtil.getCompanyNameByBookId(newSaleConContractVO.getCustId());
            stringBuilder.append("客户名称由" + oldCompanyName + " 变更为 " + newCompanyName);
        }
        // 工作类型
        if (StringUtils.hasText(newSaleConContractVO.getWorkType()) && !newSaleConContractVO.getWorkType().equals(oldContractVO.getWorkType())) {
            stringBuilder.append("工作类型由" + oldContractVO.getWorkTypeDesc() + " 变更为 " + newSaleConContractVO.getWorkTypeDesc());
        }
        // 交付bu
        if (newSaleConContractVO.getDeliBuId() != null && !newSaleConContractVO.getDeliBuId().equals(oldContractVO.getDeliBuId())) {
            stringBuilder.append("交付bu由" + oldContractVO.getDeliBuName() + " 变更为 " + newSaleConContractVO.getDeliBuName());

        }
        // 销售大类
        if (StringUtils.hasText(newSaleConContractVO.getProductClass()) && !newSaleConContractVO.getProductClass().equals(oldContractVO.getProductClass())) {
            stringBuilder.append("销售大类由" + oldContractVO.getProductClassDesc() + " 变更为 " + newSaleConContractVO.getProductClassDesc());

        }
        // 销售小类
        if (!oldContractVO.getProductSubClass().equals(newSaleConContractVO.getProductSubClass())) {
            stringBuilder.append("销售小类由" + oldContractVO.getProductSubClassDesc() + " 变更为 " + newSaleConContractVO.getProductSubClassDesc());
        }
        // 签订日期
        if (newSaleConContractVO.getSignDate() != null && !newSaleConContractVO.getSignDate().equals(oldContractVO.getSignDate())) {
            stringBuilder.append("签订日期由" + oldContractVO.getSignDate() + " 变更为 " + newSaleConContractVO.getSignDate());

        }
        // 合同开始日期
        if (newSaleConContractVO.getStartDate() != null && !newSaleConContractVO.getStartDate().equals(oldContractVO.getStartDate())) {
            stringBuilder.append("合同开始日期由" + oldContractVO.getStartDate() + " 变更为 " + newSaleConContractVO.getStartDate());

        }
        // 合同结束日期
        if (newSaleConContractVO.getEndDate() != null && !newSaleConContractVO.getEndDate().equals(oldContractVO.getEndDate())) {
            stringBuilder.append("合同结束日期由" + oldContractVO.getEndDate() + " 变更为 " + newSaleConContractVO.getEndDate());
        }
        // 合同金额 税率
        if (newSaleConContractVO.getAmt() != null || newSaleConContractVO.getTaxRate() != null) {
            BigDecimal oldAmt = oldContractVO.getAmt() == null ? BigDecimal.ZERO : oldContractVO.getAmt();
            BigDecimal newAmt = newSaleConContractVO.getAmt() == null ? BigDecimal.ZERO : newSaleConContractVO.getAmt();
            BigDecimal oldTax = oldContractVO.getTaxRate() == null ? new BigDecimal("0.00") : oldContractVO.getTaxRate();
            BigDecimal newTax = newSaleConContractVO.getTaxRate() == null ? new BigDecimal("0.00") : newSaleConContractVO.getTaxRate();
            if (oldAmt.compareTo(newAmt) != 0) {
                stringBuilder.append("合同金额由" + oldAmt + " 变更为 " + newAmt);
            }
            if (oldTax.compareTo(newTax) != 0) {
                stringBuilder.append("合同税率由" + oldContractVO.getTaxRateDesc() + " 变更为 " + newSaleConContractVO.getTaxRateDesc());
            }
        }
        return stringBuilder.toString();

    }

    /**
     * 发起子合同作废审批流程
     *
     * @param conContractDO
     */
    private void invalidProc(SaleConContractDO conContractDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();

            //财务:何申夏 579785842973871494
            //商务:刘雯 579786153893431595
            //tw: 31439529974956032
            //获取当前登录用户
            final Long loginUserId = GlobalUtil.getLoginUserId();
            //判断管理员
            final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            //商务提交 isFinPic 是false
            if (isSystemAdmin) {
                variables.put("isFinPic", false);   //目前不走这里，可能判断有问题  tw用户走不到这里
            } else {
                // 判断当前登录人是否拥有角色【财务负责人	FIN_PIC】
                List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(
                        List.of("FIN_PIC"));
                if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
                    variables.put("isFinPic", true);
                }
                // 判断当前登录人是否拥有角色【商务负责人	BUSINESS_MANAGER】
                List<Long> userIdsByRole1 = systemRoleDAO.queryUserIdByRoleCodes(
                        List.of("BUSINESS_MANAGER"));
                if (!CollectionUtils.isEmpty(userIdsByRole1) && userIdsByRole1.contains(loginUserId)) {
                    variables.put("isFinPic", false);
                }
            }
            String str = "-销售合同作废流程";
            if ("MAIN".equalsIgnoreCase(conContractDO.getMainType())) {
                str = "-销售主合同作废流程";
            } else {
                str = "-销售子合同作废流程";
            }

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.SALE_CON_INVALID.name(),
                    conContractDO.getName() + str,
                    conContractDO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContractDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(payload);
        });
    }


    @Override
    public List<SaleConContractVO> queryListByConId(Long parentId) {
        List<SaleConContractVO> voList = dao.queryListByConId(parentId);
        return voList;
    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long key) {
        return logService.queryLogList(key, PrdSystemObjectEnum.SaleConContract.getCode());
    }

    @Override
    public String subCode(Long parentId) {
        //查询主合同
        SaleConContractVO mainCon = dao.queryByKey(parentId);
        //查询该主合同下所有的子合同(包括已删除)
        List<SaleConContractDO> subCons = repo.findByParentId(parentId);
        String subCode = mainCon.getName() + "-" + (subCons.size() + 1);
        return subCode;
    }

    @Override
    public void downloadSaleCon(HttpServletResponse response, SaleConContractQuery query) {
        try {
//            MapBuilder mapBuilder = this.pageWhereBuilder(query);
//
//            List<SaleConContractVO> records = beanSearcher.searchList(SaleConContractVO.class, mapBuilder.build());
            query.setSize(9999);

            log.info("=============================开始查询=======================================");
            PagingVO<SaleConContractVO> paging = paging(query);
            log.info("=============================结束查询=======================================");
            List<SaleConContractVO> records = paging.getRecords();
            for (SaleConContractVO record : records) {
                record.setStartDateStr(record.getStartDate() == null ? "" : record.getStartDate().toString());
                record.setEndDateStr(record.getEndDate() == null ? "" : record.getEndDate().toString());
            }
            download(udcUtil.translateList(records), response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void transfer(SaleConContractVO vo) {
        String main = vo.getProductClass();
        String sub = vo.getProductSubClass();
        //翻译产品小类
        if (!ObjectUtils.isEmpty(main) || !ObjectUtils.isEmpty(sub)) {
            PrdSystemSelectionVO systemSelectionVO = cacheUtil.querySystemSelection("con:sales_class", main);
            if (systemSelectionVO != null) {
                vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(systemSelectionVO.getSelectionKey(), sub));
            }
            // switch (main) {
            //     case "04" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ImpServiceCore.getCode(), sub));
            //     case "40" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.PeopleDayService.getCode(), sub));
            //     case "05" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.OperServiceCore.getCode(), sub));
            //     case "22" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SoftwareHardwareTrade.getCode(), sub));
            //     case "23" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SoftwareTradeCore.getCode(), sub));
            //     case "50" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.DevelopSoftware.getCode(), sub));
            //     case "02" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SoftwareMACore.getCode(), sub));
            //     case "11" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ServiceTradeCore.getCode(), sub));
            //     case "06" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ConsultingCore.getCode(), sub));
            //     case "01" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.DSCore.getCode(), sub));
            //     case "21" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ServiceTrade.getCode(), sub));
            //     case "03" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.HardwareTradeCore.getCode(), sub));
            //     case "07" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CloudCore.getCode(), sub));
            //     case "24" ->
            //             vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CloudTrade.getCode(), sub));
            // }
        }
    }

    @Override
    public Map<String, BigDecimal> extraAndDemandTotalAmt(Long conId) {
        BigDecimal ExtraAmt = BigDecimal.ZERO;  //其他应减费用
        BigDecimal DemandTotalAmt = BigDecimal.ZERO;    //相关项目采购
        //调用外包费用的根据合同ID查询
        ConEpibolyCostConVO conEpibolyCostConVO = costConService.queryByContractId(conId);
        if (conEpibolyCostConVO != null) {
            //计算子合同的其他应减费用（外包确认单费用明细总金额）
            List<ConEpibolyCostConDVO> conEpibolyCostConDVOS = conEpibolyCostConVO.getConEpibolyCostConDVOS();
            if (!CollectionUtils.isEmpty(conEpibolyCostConDVOS)) {
                ExtraAmt = conEpibolyCostConDVOS.get(0).getAmt();
            }
        }
        if (ExtraAmt == null) {
            ExtraAmt = BigDecimal.ZERO;
        }
        //调用采购需求的根据合同ID查询
        ConPurchaseDemandVO conPurchaseDemandVO = demandService.queryBySaleConId(conId);
        if (conPurchaseDemandVO != null) {
            List<ConPurchaseDemandDVO> dVos = demandDService.queryByPurDemandId(conPurchaseDemandVO.getId());
            if (!ObjectUtils.isEmpty(dVos)) {
                for (ConPurchaseDemandDVO item : dVos) {
                    if (item.getNotTaxAmt() != null) {
                        DemandTotalAmt = DemandTotalAmt.add(item.getNotTaxAmt());
                    }
                }
            }
        }
        Map<String, BigDecimal> map = new HashMap<>();
        map.put("ExtraAmt", ExtraAmt);
        map.put("DemandTotalAmt", DemandTotalAmt);
        return map;
    }

    private Map<String, BigDecimal> extraAndDemandTotalAmtDib(Long conId) {
        BigDecimal totalAmt = BigDecimal.ZERO;    //相关项目采购
        //调用采购需求的根据合同ID查询
        ConPurchaseDemandVO conPurchaseDemandVO = demandService.queryBySaleConId(conId);
        if (conPurchaseDemandVO != null) {
            List<ConPurchaseDemandDVO> dVos = demandDService.queryByPurDemandId(conPurchaseDemandVO.getId());
            if (!ObjectUtils.isEmpty(dVos)) {
                for (ConPurchaseDemandDVO item : dVos) {
                    if (item.getNotTaxAmt() != null && item.getDemandType().equals(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode())) {
                        totalAmt = totalAmt.add(item.getNotTaxAmt());
                    }
                }
            }
        }
        Map<String, BigDecimal> map = new HashMap<>();
        map.put(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode(), totalAmt);
        return map;
    }

    /**
     * 计算子合同开票金额、收款金额
     *
     * @param conId
     * @return map
     */
    @Override
    public Map<String, BigDecimal> amountOfMoney(Long conId) {
        BigDecimal InvoicingAmount = BigDecimal.ZERO;  //开票
        BigDecimal AmountCollected = BigDecimal.ZERO;  //收款
        //调用收款计划的根据合同ID查询
        List<ConReceivablePlanVO> conReceivablePlanVOS = conReceivablePlanService.queryBySaleConId(conId);
        for (ConReceivablePlanVO conReceivablePlanVO : conReceivablePlanVOS) {
            //已收款金额
            AmountCollected = (conReceivablePlanVO.getActualRecvAmt() != null) ? AmountCollected.add(conReceivablePlanVO.getActualRecvAmt()) : AmountCollected;
            //已开票金额
            InvoicingAmount = (conReceivablePlanVO.getAlreadyInvAmt() != null) ? InvoicingAmount.add(conReceivablePlanVO.getAlreadyInvAmt()) : InvoicingAmount;
        }
        Map<String, BigDecimal> map = new HashMap<>();
        map.put("InvoicingAmount", InvoicingAmount);
        map.put("AmountCollected", AmountCollected);
        return map;
    }

    /**
     * 计算主合同开票金额与收款金额
     *
     * @param conId
     * @param mainType
     * @return map
     */
    private Map<String, BigDecimal> amountOfMoney(Long conId, String mainType) {
        BigDecimal InvoicingAmount = BigDecimal.ZERO;  //开票
        BigDecimal AmountCollected = BigDecimal.ZERO;  //收款
        List<SaleConContractVO> voList = this.queryListByConId(conId);
        for (SaleConContractVO saleConContractVO : voList) {
            Map<String, BigDecimal> map = amountOfMoney(saleConContractVO.getId());
            InvoicingAmount = map.get("InvoicingAmount").add(InvoicingAmount);
            AmountCollected = map.get("AmountCollected").add(AmountCollected);
        }
        Map<String, BigDecimal> map = new HashMap<>();
        map.put("InvoicingAmount", InvoicingAmount);
        map.put("AmountCollected", AmountCollected);
        return map;
    }

    /**
     * 用来修改子合同不含税总金额、有效合同金额
     *
     * @param payload
     * @return
     */
    @Override
    public SaleConContractPayload subAmtCount(SaleConContractPayload payload) {
        if ("SUB".equalsIgnoreCase(payload.getMainType())) {
            Map<String, BigDecimal> map = this.extraAndDemandTotalAmt(payload.getId());
            //其他应减费用
            BigDecimal extraAmt = map.get("ExtraAmt");
            payload.setExtraAmt(extraAmt);
            //相关项目采购
            BigDecimal demandTotalAmt = map.get("DemandTotalAmt");
            //计算子合同的不含税金额
            BigDecimal amt = payload.getAmt() == null ? BigDecimal.ZERO : payload.getAmt();
            BigDecimal taxRate = payload.getTaxRate() == null ? BigDecimal.ZERO : payload.getTaxRate();
            BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            //计算子合同的合同有效金额（不含税金额-相关项目采购-其他应减费用）
            // BigDecimal effectiveAmt = notTaxAmt.subtract(demandTotalAmt).subtract(extraAmt);
            // payload.setEffectiveAmt(effectiveAmt);
            payload.setDemandTotalAmt(demandTotalAmt);

            // dib 3、有效合同金额计算逻辑调整：
            //       a.有效合同金额=不含税金额-代理费金额-代采购
            //       b.代采购=该子合同采购需求中 需求类别 = 待采购 的所有记录的 不含税总额之和；
            Map<String, BigDecimal> stringBigDecimalMap = this.extraAndDemandTotalAmtDib(payload.getId());
            BigDecimal purchasingAgent = stringBigDecimalMap.get(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode());
            BigDecimal agentAmt = payload.getAgentAmt() == null ? BigDecimal.ZERO : payload.getAgentAmt();
            BigDecimal effectiveAmt = notTaxAmt.subtract(agentAmt).subtract(purchasingAgent);
            payload.setEffectiveAmt(effectiveAmt);

        }
        return payload;
    }

    /**
     * 合同归档
     * 合同归档逻辑调整：合同归档的同时，需要将“纸质合同状态”自动改为“已回”
     *
     * @param keys
     * @return Long
     */
    @Override
    @Transactional
    public Long conFiling(Long[] keys) {
        Arrays.stream(keys).forEach(key -> {
            SaleConContractVO vo = dao.queryByKey(key);
            if (vo.getFilingFlag() != null && vo.getFilingFlag() == 1) {
                throw TwException.error("", "合同【+" + vo.getName() + "+】已归档，无需重复归档！");
            }
        });
        return dao.conFiling(keys);
    }

    /**
     * 纸质合同状态改为未回，默认赋值收回日期=空，是否归档=否
     *
     * @param keys 钥匙
     * @return {@link Long}
     */// @Override
    // @Transactional
    public Long unConFiling(Long[] keys) {
        return dao.unConFiling(keys);
    }

    @Override
    public Long fictitiousConSubmit(List<Long> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        if (keys.size() != 1) {
            throw TwException.error("", "虚拟合同请一个个提交！");
        }
        Long key = keys.get(0);
        SaleConContractVO saleConVO = queryByKey(key);
        // 平台合同类型=无合同入场虚拟合同 且 合同类型=子合同  且合同状态=新建 的合同才可以提交虚拟合同。
        if ("NO_CONTRACT_VIRTUAL_CONTRACT".equalsIgnoreCase(saleConVO.getPlatType()) && "SUB".equalsIgnoreCase(saleConVO.getMainType()) && "CREATE".equalsIgnoreCase(saleConVO.getStatus())) {
            fictitiousConSubmitProc(saleConVO);
            return 1L;
        } else {
            throw TwException.error("", "虚拟合同请一个个提交！");
        }
    }

//    @Override
//    public void syncSaleContractDataTo4(String param) {
//        String syncType = "sale_contract_value";
//        LocalDateTime syncTime;
//        if (StringUtils.hasText(param)) {
//            syncTime = LocalDateTime.parse(param);
//        } else {
//            syncTime = daoLog.queryOrgSyncLog(syncType);
//            if (syncTime == null) {
//                syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
//            } else {
//                //将同步时间提前10秒，防止拉数据遗漏
//                syncTime = syncTime.minusSeconds(120);
//            }
//        }
//
//        XxlJobLogger.log("syncSaleContractData----销售合同数据同步到4.0开始...localDateTime：" + syncTime);
//
//        // 查询待同步数据
//        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
//        List<SaleConContractDO> saleDos = repo.findByModifyTimeStart(format);
//        // 同步内容
//        String syncData = "";
//        LocalDateTime syncNow = LocalDateTime.now();
//        if (!ObjectUtils.isEmpty(saleDos)) {
//            Map<Long, Long> V5ToV4ProductIdMap = prdProductRepo.findAll().stream().collect(Collectors.toMap(PrdProductDO::getId, e -> e.getProductIdV4() == null ? -999L : e.getProductIdV4(), (key1, key2) -> key2));
//            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
//            Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
//            Map<Long, Long> v4Byv5fin = prdSystemFinPeriodRepo.findAll().stream().collect(Collectors.toMap(PrdSystemFinPeriodDO::getId, e -> e.getFinPeriodIdV4() == null ? -999L : e.getFinPeriodIdV4(), (key1, key2) -> key2));
//            Map<Long, Long> abBookMap = prdAbRepo.findAll().stream().collect(Collectors.toMap(PrdAbDO::getId, e -> e.getBookIdV4() == null ? -999L : e.getBookIdV4(), (key1, key2) -> key2));
//            Map<Long, Long> ouBookMap = prdOrgCompanyRepo.findAll().stream().collect(Collectors.toMap(PrdOrgCompanyDO::getId, e -> e.getBookId() == null ? -999L : e.getBookId(), (key1, key2) -> key2));
//            Map<Long, Long> V4ToV5OppoIdMap = opportunityService.queryList().stream().collect(Collectors.toMap(CrmOpportunityListVO::getId, e -> e.getOppoIdV4() == null ? -999L : e.getOppoIdV4(), (key1, key2) -> key2));
//            // 组装同步的合同数据
//            List<TwContractEntity> SaleConContractDOListCopy = new ArrayList<>();
//            List<TwContractEntity> SaleConContractDOListCopySUB = new ArrayList<>();
//            for (SaleConContractDO tempDo : saleDos) {
//                TwContractEntity e = new TwContractEntity();
//                BeanUtils.copyProperties(tempDo, e);
//                e.setRatedEqva(tempDo.getFinRatedEqva());
//                e.setRatedExpense(tempDo.getRatedCost());
//                e.setContractNo(tempDo.getCode());
//                e.setContractName(tempDo.getName());
//                e.setContractStatus(tempDo.getStatus());
//                e.setApprStatus(tempDo.getProcInstStatus() != null ? tempDo.getProcInstStatus().getDesc() : null);
//                e.setUserdefinedNo(tempDo.getReferCode());
//                e.setMainContractId(tempDo.getParentId());
//                if (tempDo.getCustFlag() != null) {
//                    if (tempDo.getCustFlag() == 0L) {
//                        e.setNewContractFlag("NEW");
//                    }
//                    if (tempDo.getCustFlag() == 1L) {
//                        e.setNewContractFlag("OLD");
//                    }
//                }
//                e.setCustpaytravelFlag(tempDo.getCustBarExpense());
//                e.setSignBuId(v4AndV5OrgIds.get(tempDo.getSignBuId()));
//                e.setSalesmanResId(v4AndV5UserIds.get(tempDo.getSaleManUserId()));
//                e.setCoBuId(v4AndV5OrgIds.get(tempDo.getCoSignBuId()));
//                e.setCoResId(v4AndV5UserIds.get(tempDo.getCoSignUserId()));
//                e.setDeliBuId(v4AndV5OrgIds.get(tempDo.getDeliBuId()));
//                e.setDeliResId(v4AndV5UserIds.get(tempDo.getDeliUserId()));
//                e.setCodeliBuId(v4AndV5OrgIds.get(tempDo.getCodeliBuId()));
//                e.setCodeliResId(v4AndV5UserIds.get(tempDo.getCodeliUserId()));
//                e.setInternalBuId(v4AndV5OrgIds.get(tempDo.getInternalBuId()));
//                e.setInternalResId(v4AndV5UserIds.get(tempDo.getInternalUserId()));
//                e.setActivateDate(tempDo.getAcitveDate());
//                e.setProductId(V5ToV4ProductIdMap.get(tempDo.getProduct()));
//                e.setSaleType1(tempDo.getProductClass());
//                e.setSaleType2(tempDo.getProductSubClass());
//                e.setFinPeriodId(v4Byv5fin.get(tempDo.getFinPeriodId())); // 财务期间ID
//                if ("INVALID".equals(tempDo.getStatus())) {
//                    e.setContractStatus("DELETE");
//                }
//                // e.setProjProp() // 项目属性
//                // e.setObversionedEffectiveAmt() //折算后有效合同额
//                // e.setInformDate() // 提醒日期
//                // e.setInformResId() // 提醒对象
//                // e.setInformContent() // 提醒内容
//                e.setCooperationType(tempDo.getTransactionNature());
//                e.setChannelType(tempDo.getTransactionMethod());
//                e.setProjProp(tempDo.getCommissionType());
//                e.setProdProp(tempDo.getSupplierType());
//                // e.setProfitRuleNo() // 分配规则码
//                // e.setTagIds() // 合同标签
//                // e.setNetProfit();// 净利润
//                e.setRegionBuId(v4AndV5OrgIds.get(tempDo.getRegionBuId()));
//                e.setPmoResId(v4AndV5UserIds.get(tempDo.getPmoUserId()));
//                e.setPreSaleBuId(v4AndV5OrgIds.get(tempDo.getPreSaleBuId()));
//                e.setPreSaleResId(v4AndV5UserIds.get(tempDo.getPreSaleUserId()));
//                e.setSource(tempDo.getSourceType());
//                e.setContractIdV5(tempDo.getId());
//                if (tempDo.getTaxRate() != null) {
//                    e.setTaxRate(tempDo.getTaxRate().multiply(new BigDecimal(100)));
//                }
//                e.setCreateUserId(v4AndV5UserIds.get(tempDo.getCreateUserId()) + "");
//                e.setCreateTime(tempDo.getCreateTime());
//                e.setModifyUserId(v4AndV5UserIds.get(tempDo.getModifyUserId()) + "");
//                e.setModifyTime(tempDo.getModifyTime());
//                // v4--bookId
//                if (e.getCustId() != null) {
//                    e.setCustId(abBookMap.get(e.getCustId()));
//                }
//                Long ouBookId = ouBookMap.get(e.getOuId());
//                if (ouBookId != null) {
//                    e.setOuId(abBookMap.get(ouBookId));
//                }
//                e.setOppoId(V4ToV5OppoIdMap.get(tempDo.getOppoId()));
//                e.setRelatedContractId(null);
//                e.setId(null);
//                e.setDelFlag(tempDo.getDeleteFlag() == 0 ? false : true);
//                if ("MAIN".equals(e.getMainType())) {
//                    SaleConContractDOListCopy.add(e);
//                }
//                if ("SUB".equals(e.getMainType())) {
//                    SaleConContractDOListCopySUB.add(e);
//                }
//            }
//            SaleConContractDOListCopy.addAll(SaleConContractDOListCopySUB);
//            // 循环调用销售合同新增接口
//            int failNum = 0;
//            for (TwContractEntity temDo : SaleConContractDOListCopy) {
//                LocalDateTime syncStartTime = LocalDateTime.now();
//                try {
//                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
////                    String resultMain = httpUtil.sendPost(tw4_url + saleContract, map);
////                    Map<String, Object> data = (Map) JSON.parse(resultMain);
////                    if (!(data.get("ok") + "").equals("true")) {
////                        XxlJobLogger.log("销售合同" + temDo.getContractIdV5() + "同步异常......" + data);
////                    }
//                } catch (Exception e) {
//                    XxlJobLogger.log("销售合同" + temDo.getContractIdV5() + "同步异常......" + e);
//                    LocalDateTime syncEndTime = LocalDateTime.now();
//                    this.saveSyncLog(syncType + "_exception", "销售合同id" + temDo.getContractIdV5() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
//                    failNum++;
//                    //更新该条合同的更新时间，下一次处理;
//                    repo.updateRemark(temDo.getContractIdV5());
//                }
//            }
//            syncData = "更新了" + (SaleConContractDOListCopy.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
//        } else {
//            syncData = "销售合同数据未变化";
//        }
//        // 记录同步日志
//        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
//        XxlJobLogger.log("同步销售合同结束..." + logDO);
//    }

//    @Override
//    public void syncSaleContractHistoryDataTo5(String param) {
//        String syncType = "sale_contract_history_value";
//        // 查询同步数据
//        String syncData = "";
//        LocalDateTime syncNow = LocalDateTime.now();
//        //同步到5.0
////        String result = httpUtil.sendGet(tw4_url + saleContractHistory, new HashMap<>());
////        Map<String, Object> data = (Map) JSONObject.parse(result);
//        Map<String, Object> data = new HashMap<>();
//        if ((data.get("ok") + "").equals("true") && !ObjectUtils.isEmpty(data.get("datum"))) {
//            // 初始化的数据
//            List<SaleConContractDO> saleDos = JSON.parseArray(JSON.toJSONString(data.get("datum")), SaleConContractDO.class);
//            List<Long> collect = saleDos.stream().map(SaleConContractDO::getContractIdV4).collect(Collectors.toList());
//            // 查询是否已经同步过该数据
//            List<Long> byContractIdV4 = repo.findByContractIdV4(collect);
//            if (ObjectUtils.isEmpty(saleDos) || (!ObjectUtils.isEmpty(byContractIdV4) && byContractIdV4.size() == saleDos.size())) {
//                syncData = "4.0销售合同数据未变化";
//                this.saveSyncLog(syncType, syncData, syncNow);
//                return;
//            }
//
//            Map<Long, Long> V4ToV5ProductIdMap = prdProductRepo.findAll().stream().collect(Collectors.toMap(PrdProductDO::getProductIdV4, PrdProductDO::getId, (key1, key2) -> key2));
//            Map<Long, Long> V4ToV5OppoIdMap = opportunityService.queryList().stream().collect(Collectors.toMap(CrmOpportunityListVO::getOppoIdV4, CrmOpportunityListVO::getId, (key1, key2) -> key2));
//            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
//            Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
//            Map<Long, Long> v4Byv5fin = prdSystemFinPeriodRepo.findAll().stream().collect(Collectors.toMap(PrdSystemFinPeriodDO::getFinPeriodIdV4, PrdSystemFinPeriodDO::getId, (key1, key2) -> key2));
//            Map<Long, Long> abBookMap = prdAbRepo.findAll().stream().collect(Collectors.toMap(PrdAbDO::getBookIdV4, e -> e.getId() == null ? -999L : e.getId(), (key1, key2) -> key2));
//            Map<Long, Long> ouBookMap = prdOrgCompanyRepo.findAll().stream().collect(Collectors.toMap(PrdOrgCompanyDO::getBookId, e -> e.getId() == null ? -999L : e.getId(), (key1, key2) -> key2));
//            // 初始化的数据集合
//            List<SaleConContractDO> initDatas = new ArrayList<>();
//            saleDos.stream().forEach(e -> {
//                if (e.getTaxRate() != null) {
//                    e.setTaxRate(e.getTaxRate().divide(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP));
//                }
//                // 只做一次初始化数据
//                if (!byContractIdV4.contains(e.getContractIdV4())) {
//                    e.setRegionBuId(v4AndV5OrgIds.get(e.getRegionBuId()));
//                    e.setSignBuId(v4AndV5OrgIds.get(e.getSignBuId()));
//                    e.setCoSignBuId(v4AndV5OrgIds.get(e.getCoSignBuId()));
//                    e.setCoSignUserId(v4AndV5UserIds.get(e.getCoSignUserId()));
//                    e.setDeliBuId(v4AndV5OrgIds.get(e.getDeliBuId()));
//                    e.setDeliUserId(v4AndV5UserIds.get(e.getDeliUserId()));
//                    e.setCodeliBuId(v4AndV5OrgIds.get(e.getCodeliBuId()));
//                    e.setCodeliUserId(v4AndV5UserIds.get(e.getCodeliUserId()));
//                    e.setPmoUserId(v4AndV5UserIds.get(e.getPmoUserId()));
//                    e.setInternalBuId(v4AndV5OrgIds.get(e.getInternalBuId()));
//                    e.setSaleManUserId(v4AndV5UserIds.get(e.getSaleManUserId()));
//                    e.setInternalUserId(v4AndV5UserIds.get(e.getInternalUserId()));
//                    e.setPreSaleBuId(v4AndV5OrgIds.get(e.getPreSaleBuId()));
//                    e.setPreSaleUserId(v4AndV5UserIds.get(e.getPreSaleUserId()));
//                    e.setCreateUserId(v4AndV5UserIds.get(e.getCreateUserId()));
//                    e.setOppoId(V4ToV5OppoIdMap.get(e.getOppoId()));
//                    e.setProduct(V4ToV5ProductIdMap.get(e.getProduct()));
//                    e.setFinPeriodId(v4Byv5fin.get(e.getFinPeriodId()));
//                    // 两边合同删除状态名字翻译成一致
//                    if ("DELETE".equals(e.getStatus())) {
//                        e.setStatus("INVALID");
//                    }
//                    e.setCustId(abBookMap.get(e.getCustId()));
//                    Long ouBookId = abBookMap.get(e.getOuId());
//                    if (ouBookId != null) {
//                        e.setOuId(ouBookMap.get(ouBookId));
//                    }
//                    initDatas.add(e);
//                }
//            });
//            List<SaleConContractDO> saleConContractDOS = new ArrayList<>();
//            if (!CollectionUtils.isEmpty(initDatas)) {
//                for (SaleConContractDO initData : initDatas) {
//                    try {
//                        SaleConContractDO save = repo.save(initData);
//                        saleConContractDOS.add(save);
//                    } catch (Exception e) {
//                        String syncType1 = "sale_contract_history_value_exception";
//                        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType1, initData.getCode() + ":" + e, syncNow);
//                        XxlJobLogger.log("初始化销售合同报错..." + logDO);
//                    }
//                }
//            }
//            // 修改相关ID
////             repo.updateParentId();
////             repo.updateRelatId();
////
////            // 回调4.0接口
////            Map<String, Object> updateMap = new HashMap<>();
////            updateMap.put("syncDatas", saleConContractDOS);
////            String idsResult = httpUtil.sendPost(tw4_url + contractSyncFlag, updateMap);
////            Map<String, Object> idsData = (Map) JSONObject.parse(idsResult);
////            if((idsData.get("ok") + "").equals("true") && !ObjectUtils.isEmpty(idsData.get("datum"))) {
////                syncData = "4.0销售合同初始化完成";
////            }
//        }
//        // 记录同步日志
//        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
//        XxlJobLogger.log("初始化销售合同结束..." + logDO);
//    }

    /**
     * @Override public List<PurchaseContractManagerVO> queryPurchConList(Long saleconId) {
     * List<PurchaseContractManagerVO> managerVOS = dao.queryPurchConList(saleconId);
     * if (!ObjectUtils.isEmpty(managerVOS)) {
     * // 查询地址簿
     * //            List<PrdAbVO> prdAbVOS = prdAbDAO.queryBookInfoByRelat(null);
     * //            if (org.apache.commons.collections4.CollectionUtils.isEmpty(prdAbVOS)) {
     * //                prdAbVOS = new ArrayList<>();
     * //            }
     * //            Map<String, PrdAbVO> collect = prdAbVOS.stream().collect(Collectors.toMap(PrdAbVO::getBookNo, e -> e, (k1, k2) -> k1));
     * //
     * managerVOS.stream().forEach(item -> {
     * transSysSelectionAndName(item);
     * });
     * }
     * return managerVOS;
     * }
     */
    @Override
    public List<PurchaseContractManagerVO> queryPurchConList(Long saleconId) {
        List<PurchaseContractManagerVO> managerVOS = purchaseContractManagerService.queryBySaleConId(saleconId);
        if (!ObjectUtils.isEmpty(managerVOS)) {
            List<Long> bookIdList = new ArrayList<>();
            managerVOS.forEach(purchaseContractManagerVO -> {
                bookIdList.add(purchaseContractManagerVO.getSupplierBookId());
                transSysSelectionAndName(purchaseContractManagerVO);
            });
            // 翻译地址簿
            Map<Long, String> nameByBookIds = businessPartnerService.findNameByBookIds(bookIdList);
            managerVOS.forEach(purchaseContractManagerVO -> purchaseContractManagerVO.setSupplierName(nameByBookIds.get(purchaseContractManagerVO.getSupplierBookId())));

        }
        return managerVOS;
    }

    @Override
    public Long findIdByNo(String conNo) {
        return dao.findIdByNo(conNo);
    }


    private void transSysSelectionAndName(PurchaseContractManagerVO item) {
        // 名称翻译
        if (item.getPurchaseBuId() != null) {
            item.setPurchaseBuName(cacheUtil.getOrgName(item.getPurchaseBuId()));
        }
        String main = item.getProductClass(); //获取大类
        String sub = item.getProductSubClass(); //获取小类
        if (!ObjectUtils.isEmpty(main) || !ObjectUtils.isEmpty(sub)) {
            //翻译采购小类
            switch (main) {
                case "01" ->
                        item.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.DEVELOPMENT.getCode(), sub));
                case "02" ->
                        item.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SOFTWAREMA.getCode(), sub));
                case "03" ->
                        item.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.HARDWARE.getCode(), sub));
                case "04" ->
                        item.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.IMPLEMENT.getCode(), sub));
                case "05" ->
                        item.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.OPERATIONS.getCode(), sub));
                case "06" ->
                        item.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SOFTWARE.getCode(), sub));
                case "51" ->
                        item.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SYNTHESIS.getCode(), sub));
            }
        }
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

    /**
     * 无合同入场虚拟子合同提交流程
     *
     * @param conContract
     */
    private void fictitiousConSubmitProc(SaleConContractVO conContract) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.INVALID.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            Long signBuId = conContract.getSignBuId();
            PrdOrgOrganizationVO orgVo = orgService.queryDetailSimpleByOrgId(signBuId);
            if ((!ObjectUtils.isEmpty(orgVo)) && "BS".equals(orgVo.getOrganizationType())) {
                variables.put("isSaleBuType", true);
            } else {
                variables.put("isSaleBuType", false);
            }

            // 签单bu负责人
            Long signBuManageUserId = daoOrg.queryManageIdById(signBuId);
            variables.put("Activity_1azdmha", CollUtil.newArrayList(signBuManageUserId));
            // 销售负责人
            Long saleManUserId = conContract.getSaleManUserId();
            variables.put("Activity_06ed3o3", CollUtil.newArrayList(saleManUserId));
            // 交付Bu负责人
            Long deliBuId = conContract.getDeliBuId();
            Long deliBuManageUserId = daoOrg.queryManageIdById(deliBuId);
            variables.put("Activity_0sxhwto", CollUtil.newArrayList(deliBuManageUserId));

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.VIRTUAL_CON_SUBMIT.name(),
                    conContract.getName() + "-无合同入场虚拟子合同提交流程",
                    conContract.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        SaleConContractPayload payload = new SaleConContractPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContract.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setStatus(status);
        String closeFileCodes = conContract.getCloseFileCodes();
        if (StringUtils.hasText(closeFileCodes)) {
            payload.setCloseFileCodes(closeFileCodes);
        }
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(payload);
        });
    }


    private void download(List<SaleConContractVO> records, HttpServletResponse response) throws IOException {
//        int order = 1;
        //定义文件名称
        String sheetName = "销售合同数据";
//        List<CrmPotentialCustomerListExcelExport> resultList = CrmPotentialCustomerConvert.INSTANCE.voListVoExcelExport(records);
//        resultList = udcUtil.translateList(resultList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), SaleConContractVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, SaleConContractVO.class, null);
        //写入
        sheet.doWrite(records);
    }

    /**
     * 创建文件夹（一个或者多个）
     *
     * @param itemId
     * @param pathArry
     * @param authTokenByYdk
     * @return 易道壳的文件夹的itemId
     */
    private String createYdkFolder(String itemId, List<String> pathArry, String authTokenByYdk) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtils.hasText(itemId)) {
            map.put("ItemId", itemId);
        }
        map.put("PathArry", pathArry);
        map.put("LibraryId", yeedocProperties.getSaleConLibraryId());
        log.info("[销售合同创建文件夹-易道壳开始]-map:{}", JSONObject.toJSONString(map));
        String resultStr = yeedocService.createFolder(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
            log.info("[销售合同创建文件夹-易道壳]-map:{}", JSONObject.toJSONString(map));
            log.info("[销售合同创建文件夹-易道壳]-resultStr:{}", resultStr);
            throw TwException.error("", "销售合同创建文件夹失败!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject(resultStr);
        log.info("[销售合同创建文件夹-易道壳返回值]-resultJson:{}", resultJson);
        Object data = resultJson.get("Data");
        if (ObjectUtils.isEmpty(data)) {
            throw TwException.error("", "销售合同创建文件夹失败!result = {" + resultJson + "}");
        }
        JSONArray dataArray = JSONArray.parseArray(data.toString());
        String folderId = (String) JSONObject.parseObject(String.valueOf(dataArray.get(0))).get("FolderId");
        if (!StringUtils.hasText(folderId)) {
            throw TwException.error("", "销售合同创建文件夹返回值folderId为空!");
        }
        return folderId;
    }

    /**
     * 文件夹重命名
     *
     * @param authTokenByYdk
     * @return 易道壳的文件夹的itemId
     */
    private String reNameFolder(String itemId, String folderName, String authTokenByYdk) {
        Map<String, Object> map = new HashMap<>();
        map.put("ItemId", itemId);
        map.put("NewName", folderName);
        log.info("[销售合同文件夹重命名-易道壳开始]-map:{}", JSONObject.toJSONString(map));
        String resultStr = yeedocService.reNameFolder(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
            log.info("[销售合同文件夹重命名-易道壳]-map:{}", JSONObject.toJSONString(map));
            log.info("[销售合同文件夹重命名-易道壳]-resultStr:{}", resultStr);
            throw TwException.error("", "销售合同文件夹重命名失败!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject(resultStr);
        log.info("[销售合同文件夹重命名-易道壳返回值]-resultJson:{}", resultJson);
        if (ObjectUtils.isEmpty(resultJson)) {
            throw TwException.error("", "销售合同文件夹重命名失败!result = {" + resultJson + "}");
        }
        JSONObject date = resultJson.getJSONObject("Data");
        if (ObjectUtils.isEmpty(date)) {
            throw TwException.error("", "销售合同文件夹重命名失败!result = {" + resultJson + "}");
        }
        String folderId = date.getString("Id");
        if (!StringUtils.hasText(folderId)) {
            throw TwException.error("", "销售合同文件夹重命名返回值folderId为空!");
        }
        return folderId;
    }

    /**
     * 最终保存附件
     *
     * @param ydkFolderId
     * @param cacheKeys
     * @return map(cacheKey, itemId)
     */
    private Map<String, String> saveYdkFile(String ydkFolderId, Set<String> cacheKeys, String authTokenByYdk) {
        Map<String, Object> map = new HashMap<>();
        if (CollectionUtils.isEmpty(cacheKeys)) {
            return null;
        }
        map.put("FolderId", ydkFolderId);
        map.put("LibraryId", yeedocProperties.getSaleConLibraryId());
        map.put("CacheKey", cacheKeys);
        map.put("ItemList", Lists.newArrayList());
        map.put("AssociatedItemID", Lists.newArrayList());
        map.put("Description", "");
        log.info("[销售合同最终保存附件-易道壳开始]-map:{}", JSONObject.toJSONString(map));
        log.info("[销售合同最终保存附件-易道壳开始]-authTokenByYdk:{}", authTokenByYdk);
        String resultStr = yeedocService.newUploadFilesSave(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
            log.info("[销售合同最终保存附件-易道壳]-resultStr:{}", resultStr);
            throw TwException.error("", "销售合同最终保存附件失败!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject(resultStr);
        log.info("[销售合同最终保存附件-易道壳返回值]-resultJson:{}", resultJson);
        Boolean isSuccess = resultJson.getBoolean("IsSuccess");
        String message = resultJson.getString("Message");
        // todo 易道壳返回的是重复文件名称的，目前重复名称的这种不处理
        if ((!isSuccess) || (!"上传成功！".equals(message))) {
            throw TwException.error("", "销售合同最终保存附件失败!result = {" + resultJson + "}");
        }
        // 获取易道壳附件id
        Map<String, Object> getItemMap = new HashMap<>();
        getItemMap.put("CacheKeys", cacheKeys);
        log.info("[销售合同获取易道壳附件id-易道壳开始]-map:{}", JSONObject.toJSONString(getItemMap));
        log.info("[销售合同获取易道壳附件id-易道壳开始]-authTokenByYdk:{}", authTokenByYdk);
        String itemIdResult = yeedocService.getCaCheKeyItemId(getItemMap, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(itemIdResult)) {
            log.info("[销售合同获取易道壳附件id-易道壳]-resultStr:{}", itemIdResult);
        }
        JSONObject itemIdResultJson = JSONObject.parseObject(itemIdResult);
        Object itemIdData = itemIdResultJson.get("Data");
        if (ObjectUtils.isEmpty(itemIdData)) {
            throw TwException.error("", "销售合同获取易道壳附件id失败!result = {" + resultJson + "}");
        }
        List<JSONObject> itemIdJsonObjectList = JSONArray.parseArray(itemIdData.toString()).toJavaList(JSONObject.class);
        Map<String, String> resultMap = itemIdJsonObjectList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getString("CacheKey"), item -> item.getString("ItemId")));
        return resultMap;
    }


    /**
     * 无合同入场虚拟合同 激活完成后的动作
     * // 平台合同类型 为 无合同入场虚拟合同（NO_CONTRACT_VIRTUAL_CONTRACT）	 合同状态【待激活】 ，激活流程走完，
     * // 平台合同类型自动改为【平台内合同（INTERNAL）】，
     * // 同步更新对应主合同的平台合同类型为【平台内合同（INTERNAL）】
     *
     * @param id id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void activeVirtualContractCompleted(Long id) {
        // 查找主合同 平台类型
        Optional<SaleConContractDO> contractDOOptional = repo.findById(id);
        if (contractDOOptional.isPresent()) {
            SaleConContractDO saleConContractDO = contractDOOptional.get();
            // 无合同入场虚拟合同
            if (saleConContractDO.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode())) {
                SaleConContractPayload saleConContractPayload = new SaleConContractPayload();
                saleConContractPayload.setId(id);
                saleConContractPayload.setPlatType(SaleConEnum.INTERNAL.getCode());
                // 平台合同类型自动改为【平台内合同（INTERNAL）】，
                dao.updateByKeyDynamic(saleConContractPayload);

                Long parentId = saleConContractDO.getParentId();
                if (null != parentId) {
                    Optional<SaleConContractDO> parentContractOptional = repo.findById(parentId);
                    if (parentContractOptional.isPresent()) {
                        SaleConContractDO parentContract = parentContractOptional.get();
                        if (parentContract.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode())) {
                            SaleConContractPayload updateParentContract = new SaleConContractPayload();
                            updateParentContract.setId(parentId);
                            updateParentContract.setPlatType(SaleConEnum.INTERNAL.getCode());
                            // 同步更新对应主合同的平台合同类型为【平台内合同（INTERNAL）】
                            dao.updateByKeyDynamic(updateParentContract);
                        }
                    } else {
                        log.error("合同信息不存在，id:{}", parentId);
                    }
                }
            }
        } else {
            log.error("合同信息不存在，id:{}", id);
        }
    }
}
