package com.elitesland.tw.tw5.server.prd.workflow;


import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConExecConditionPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * 销售子合同-合同预算流程
 *
 * @author wly
 * @date 2023/5/5
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "SALE_CON_BUDGET" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class SaleConBudgetWorkflowCallBackController implements WorkflowCallBack {

    private final SaleConExecConditionService saleConExecConditionService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }


    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        SaleConExecConditionPayload saleConExecConditionPayload = new SaleConExecConditionPayload();
        saleConExecConditionPayload.setId(Long.parseLong(businessKey));
        // 交付buleader审批通过 发起工作代办
        if ("Activity_030x3nk".equals(taskKey)) {
            // 查询合同预算信息
            SaleConExecConditionVO saleConExecConditionVO = saleConExecConditionService.queryByKey(Long.parseLong(businessKey));
            saleConExecConditionPayload.setWorkAgentFlag(true);
            saleConExecConditionService.updateByKeyDynamic(saleConExecConditionPayload);
        }
        // 平台资源总监审批通过 关闭工作代办
        if ("Activity_1klbasn".equals(taskKey)) {
            saleConExecConditionPayload.setWorkAgentFlag(false);
            saleConExecConditionService.updateByKeyDynamic(saleConExecConditionPayload);
        }
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        SaleConExecConditionPayload saleConExecConditionPayload = new SaleConExecConditionPayload();
        saleConExecConditionPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        SaleConExecConditionVO saleConExecConditionVO = saleConExecConditionService.queryByKey(Long.valueOf(businessKey));
        if (saleConExecConditionVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //将单据状态改为“新建”，无合同入场虚拟合同改为待激活
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    //将单据状态改为“新建”，无合同入场虚拟合同改为待激活
                    saleConExecConditionPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    //将单据状态改为“新建”，无合同入场虚拟合同改为待激活
                    saleConExecConditionPayload.setDeleteFlag(1);
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    saleConExecConditionPayload.setApprovedTime(LocalDateTime.now());
                    break;
                case APPROVING:
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
            saleConExecConditionService.updateByKeyDynamic(saleConExecConditionPayload);
        }
        return WorkflowResult.success(null);
    }
}
