package com.elitesland.tw.tw5.server.prd.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * 销售子合同变更流程
 *
 * @author wly
 * @date 2024/5/7
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "SALE_CON_CHANGE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class SaleConChangeWorkflowCallBackController  implements WorkflowCallBack {

    private final SaleConContractService saleConContractService;
    private final SaleConContractDAO saleConContractDAO;
    private final ComChangeService changeService;
    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {

        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }


    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
//        PmsProjectPayload PmsProjectPayload = new PmsProjectPayload();
//        PmsProjectPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象

        //根据业务key查询当前业务对象
        ComChangeVO comChangeVO = changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            SaleConContractVO saleConContractVO = new SaleConContractVO();
            saleConContractVO.setId(Long.valueOf(comChangeVO.getChangeDocId()));

            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setProcInstId(comChangeVO.getProcInstId());
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    saleConContractVO.setChangeFlag(0);
                    saleConContractService.updateWorkFlow(saleConContractVO);
                    break;
                case INVALID://先删除流程再删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    changePayload.setDeleteFlag(1);
                    saleConContractVO.setChangeFlag(0);
                    //projectVO.setDeleteFlag(1);
                    saleConContractService.updateWorkFlow(saleConContractVO);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                case APPROVED:
                    saleConContractVO = JSON.parseObject(comChangeVO.getChangeContent(), SaleConContractVO.class);
                    saleConContractVO.setChangeFlag(0);
                    saleConContractVO.setApproveFlag(true);
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    saleConContractService.updateWorkFlow(saleConContractVO);
//                    //调用jde销售合同同步
//                    SaleConContractVO vo = saleConContractService.queryByKey(saleConContractVO.getId());
//                    jdeService.saleSyncJde(vo,null);
                    break;
                case APPROVING:
                    break;
            }
            changeService.updateWorkFlow(changePayload);
        }
        return WorkflowResult.success(null);
    }



}
