/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.QyWx.service;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxSchedulePayload;
import com.elitesland.tw.tw5.server.common.BeanMapTool;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.RedisCacheUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@RefreshScope
public class QyWxCommunicationService {
    private final HttpUtil httpUtil;
    private final RedisCacheUtil redisCacheUtil;
    private final BeanMapTool beanMapTool;
    @Value(value="${qywx.secret:aaa}")
    private String tw5Secret;
    @Value(value="${qywx.cropid:aaa}")
    private String elCropId;
    @Value(value="${qywx.agentid:aaa}")
    private String agentId;
    @Value(value="${qywx.url:aaa}")
    private String qyApi;
    private final PrdMessageConfigDAO prdMessageConfigDAO;

    public String getAccessToken(String corpsecret, String corpid) {
        String accessToken = null;
        if (accessToken == null) {
            HashMap<String, Object> uriMap = new HashMap<String, Object>();
            uriMap.put("corpid", corpid);
            uriMap.put("corpsecret", corpsecret);
            String result = this.httpUtil.sendGet(this.qyApi + "/gettoken", uriMap);
            accessToken = this.httpUtil.geStrItem(result, "access_token", "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1access_token\u5931\u8d25\uff01");
        }
        return accessToken;
    }

    private String getTw5AccessToken() {
        return this.getAccessToken(this.tw5Secret, this.elCropId);
    }

    public Map<String, Object> getCalendar(String calId) {
        HashMap<String, Object> idsMap = new HashMap<String, Object>();
        List<String> list = Collections.singletonList(calId);
        idsMap.put("cal_id_list", list);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/calendar/get?access_token=" + accessToken, idsMap);
        Map parse = (Map)JSON.parse((String)result);
        if (parse.get("errcode").equals(0)) {
            List calendarList = (List)parse.get("calendar_list");
            if (calendarList != null) {
                return (Map)calendarList.get(0);
            }
        } else {
            throw TwException.error("", "\u67e5\u8be2\u4f01\u4e1a\u5fae\u4fe1\u7aef\u65e5\u5386\u5931\u8d25");
        }
        return null;
    }

    public String saveCalendar(QyWxCalendarPayload payload) {
        Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        HashMap<String, Object> calanderMap = new HashMap<String, Object>();
        calanderMap.put("calendar", objectMap);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/calendar/add?access_token=" + accessToken, calanderMap);
        return this.httpUtil.geStrItem(result, "cal_id", "\u65e5\u5386\u540c\u6b65\u63d2\u5165\u5230\u4f01\u4e1a\u5fae\u4fe1\u5931\u8d25\uff01");
    }

    public void updateCalendar(QyWxCalendarPayload payload) {
        Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        HashMap<String, Object> calanderMap = new HashMap<String, Object>();
        calanderMap.put("calendar", objectMap);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/calendar/update?access_token=" + accessToken, calanderMap);
        this.httpUtil.geStrItem(result, "cal_id", "\u65e5\u5386\u540c\u6b65\u66f4\u65b0\u5230\u4f01\u4e1a\u5fae\u4fe1\u5931\u8d25\uff01");
    }

    public void deleteCalendar(String calId) {
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        idMap.put("cal_id", calId);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/calendar/del?access_token=" + accessToken, idMap);
        this.httpUtil.geStrItem(result, "cal_id", "\u4ece\u4f01\u4e1a\u5fae\u4fe1\u5220\u9664\u65e5\u5386\u5931\u8d25\uff01");
    }

    public Map<String, Object> getSchedule(String scheduleId) {
        HashMap<String, Object> idsMap = new HashMap<String, Object>();
        List<String> list = Collections.singletonList(scheduleId);
        idsMap.put("schedule_id_list", list);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/schedule/get?access_token=" + accessToken, idsMap);
        Map parse = (Map)JSON.parse((String)result);
        if (parse.get("errcode").equals(0)) {
            List scheduleList = (List)parse.get("schedule_list");
            if (scheduleList != null) {
                return (Map)scheduleList.get(0);
            }
        } else {
            throw TwException.error("", "\u67e5\u8be2\u4f01\u4e1a\u5fae\u4fe1\u7aef\u65e5\u7a0b\u5931\u8d25");
        }
        return null;
    }

    public String saveSchedule(QyWxSchedulePayload payload) {
        Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        HashMap<String, Object> scheduleMap = new HashMap<String, Object>();
        scheduleMap.put("schedule", objectMap);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/schedule/add?access_token=" + accessToken, scheduleMap);
        return this.httpUtil.geStrItem(result, "schedule_id", "\u65e5\u7a0b\u540c\u6b65\u63d2\u5165\u5230\u4f01\u4e1a\u5fae\u4fe1\u5931\u8d25\uff01");
    }

    public void updateSchedule(QyWxSchedulePayload payload) {
        Map<String, Object> objectMap = BeanMapTool.beanToMap(payload);
        HashMap<String, Object> scheduleMap = new HashMap<String, Object>();
        scheduleMap.put("schedule", objectMap);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/schedule/update?access_token=" + accessToken, scheduleMap);
        this.httpUtil.geStrItem(result, "schedule_id", "\u65e5\u7a0b\u540c\u6b65\u5230\u66f4\u65b0\u4f01\u4e1a\u5fae\u4fe1\u5931\u8d25\uff01");
    }

    public void deleteSchedule(String scheduleId) {
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        idMap.put("schedule_id", scheduleId);
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/schedule/del?access_token=" + accessToken, idMap);
        this.httpUtil.geStrItem(result, "schedule_id", "\u4ece\u4f01\u4e1a\u5fae\u4fe1\u5220\u9664\u65e5\u7a0b\u5931\u8d25\uff01");
    }

    public void addAttendees(QyWxSchedulePayload payload) {
        HashMap<String, Object> addMap = new HashMap<String, Object>();
        addMap.put("schedule_id", payload.getSchedule_id());
        addMap.put("attendees", payload.getAttendees());
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendPost(this.qyApi + "/oa/schedule/add_attendees?access_token=" + accessToken, addMap);
        this.httpUtil.geStrItem(result, "schedule_id", "\u6dfb\u52a0\u4f01\u5fae\u65e5\u7a0b\u53c2\u4e0e\u4eba\u5931\u8d25");
    }

    public String getQyWxuserid(String mobile) {
        String accessToken = this.getTw5AccessToken();
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        stringObjectMap.put("mobile", mobile);
        String result = this.httpUtil.sendPost(this.qyApi + "/user/getuserid?access_token=" + accessToken, stringObjectMap);
        Map parse = (Map)JSON.parse((String)result);
        if (parse.get("errcode").equals(0) && parse.get("userid") != null) {
            return "" + parse.get("userid");
        }
        return "";
    }

    public String getWxuserinfo(String code) {
        String accessToken = this.getTw5AccessToken();
        String result = this.httpUtil.sendGet(this.qyApi + "/auth/getuserinfo?access_token=" + accessToken + "&code=" + code, new HashMap<String, Object>());
        Map parse = (Map)JSON.parse((String)result);
        if (parse.get("errcode").equals(0) && parse.get("userid") != null) {
            return "" + parse.get("userid");
        }
        return "";
    }

    public void exportUsersRequest() {
        String accessToken = this.getTw5AccessToken();
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        stringObjectMap.put("block_size", 1000);
        stringObjectMap.put("encoding_aeskey", "IFxAxLOaqxfbYXW1U78KJy7x4pjfG4Fd5UKvjAdL1cx");
        String result = this.httpUtil.sendPost(this.qyApi + "/export/simple_user?access_token=" + accessToken, stringObjectMap);
        String jobid = this.httpUtil.geStrItem(result, "jobid", "\u53d1\u8d77\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u540c\u6b65\u5931\u8d25\uff01");
        this.redisCacheUtil.add("wx_user_job_id", jobid, 3600L, TimeUnit.SECONDS);
    }

    public void exportUsersExport() {
        String jobid = this.redisCacheUtil.get("wx_user_job_id");
        String accessToken = this.getTw5AccessToken();
        HashMap stringObjectMap = new HashMap();
        HashMap<String, Object> uriMap = new HashMap<String, Object>();
        uriMap.put("jobid", jobid);
        uriMap.put("access_token", accessToken);
        String result = this.httpUtil.sendGet(this.qyApi + "/export/get_result", uriMap);
        Map parse = (Map)JSON.parse((String)result);
        if (!parse.get("errcode").equals(0) || !parse.get("status").equals(2)) {
            throw TwException.error("", "\u4f01\u4e1a\u5fae\u4fe1\u5bfc\u51fa\u7ed3\u679c\u83b7\u53d6\u5931\u8d25\uff01");
        }
        Object[] objectArray = (Object[])parse.get("data_list");
    }

    public void sendMessageToUser(Map<String, Object> map) {
        String accessToken = this.getTw5AccessToken();
        map.put("agentid", this.agentId);
        String result = this.httpUtil.sendPost(this.qyApi + "/message/send?access_token=" + accessToken, map);
        Map parse = (Map)JSON.parse((String)result);
        if (!parse.get("errcode").equals(0)) {
            throw TwException.error("", "\u53d1\u9001\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    public void sendMessageToUser(List<Long> userIdList, String content) {
        if (!CollectionUtils.isEmpty(userIdList) && StringUtils.hasText((String)content)) {
            List<String> weComs = this.prdMessageConfigDAO.queryUserWeComByIds(userIdList);
            String touser = org.apache.commons.lang3.StringUtils.join((Iterable)weComs.stream().filter(weCom -> StringUtils.hasText((String)weCom)).collect(Collectors.toList()), (String)"|");
            HashMap<String, String> contentMap = new HashMap<String, String>();
            contentMap.put("content", content);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("touser", touser);
            map.put("msgtype", "text");
            map.put("text", contentMap);
            String accessToken = this.getTw5AccessToken();
            map.put("agentid", this.agentId);
            String result = this.httpUtil.sendPost(this.qyApi + "/message/send?access_token=" + accessToken, map);
            Map parse = (Map)JSON.parse((String)result);
            if (!parse.get("errcode").equals(0)) {
                throw TwException.error("", "\u53d1\u9001\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    public void sendMessageToUser(Long userId, String content) {
        if (null != userId) {
            ArrayList<Long> userIdList = new ArrayList<Long>();
            userIdList.add(userId);
            this.sendMessageToUser(userIdList, content);
        }
    }

    public boolean sendMessageToUserByWecomId(String wecomId, String content) {
        if (StringUtils.hasText((String)wecomId) && StringUtils.hasText((String)content)) {
            HashMap<String, String> contentMap = new HashMap<String, String>();
            contentMap.put("content", content);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("touser", wecomId);
            map.put("msgtype", "text");
            map.put("text", contentMap);
            String accessToken = this.getTw5AccessToken();
            map.put("agentid", this.agentId);
            String result = this.httpUtil.sendPost(this.qyApi + "/message/send?access_token=" + accessToken, map);
            Map parse = (Map)JSON.parse((String)result);
            return parse.get("errcode").equals(0);
        }
        return false;
    }

    public QyWxCommunicationService(HttpUtil httpUtil, RedisCacheUtil redisCacheUtil, BeanMapTool beanMapTool, PrdMessageConfigDAO prdMessageConfigDAO) {
        this.httpUtil = httpUtil;
        this.redisCacheUtil = redisCacheUtil;
        this.beanMapTool = beanMapTool;
        this.prdMessageConfigDAO = prdMessageConfigDAO;
    }
}

