/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.borrow.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowMoneyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.borrow.constant.BorrowStatusEnum;
import com.elitesland.tw.tw5.server.prd.borrow.entity.BorrowMoneyDO;
import com.elitesland.tw.tw5.server.prd.borrow.entity.QBorrowMoneyDO;
import com.elitesland.tw.tw5.server.prd.borrow.repo.BorrowMoneyRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class BorrowMoneyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BorrowMoneyRepo repo;
    private final QBorrowMoneyDO qdo = QBorrowMoneyDO.borrowMoneyDO;

    private JPAQuery<BorrowMoneyVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BorrowMoneyVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.borrowNo, this.qdo.borrowName, this.qdo.applicantUserId, this.qdo.transferDate, this.qdo.receiveUserId, this.qdo.receiveBuId, this.qdo.applicantTime, this.qdo.applicantBuId, this.qdo.costBuId, this.qdo.apprStatus, this.qdo.businessType, this.qdo.transferFlag, this.qdo.repaymentUserId, this.qdo.borrowAmt, this.qdo.alreadyWriteOffAmt, this.qdo.unwriteOffAmt, this.qdo.preWriteOffDate, this.qdo.fileCodes, this.qdo.accountNo, this.qdo.holderName, this.qdo.bankName, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.submitTime, this.qdo.approvedTime})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BorrowMoneyVO> getJpaQueryWhere(BorrowMoneyQuery query) {
        JPAQuery<BorrowMoneyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(BorrowMoneyQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BorrowMoneyQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBorrowNo())) {
            list.add(this.qdo.borrowNo.eq((Object)query.getBorrowNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBorrowName())) {
            list.add(this.qdo.borrowName.eq((Object)query.getBorrowName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBorrowNoOrName())) {
            list.add(this.qdo.borrowNo.like(SqlUtil.toSqlLikeString(query.getBorrowNoOrName())).or((Predicate)this.qdo.borrowName.like(SqlUtil.toSqlLikeString(query.getBorrowNoOrName()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplicantUserId())) {
            list.add(this.qdo.applicantUserId.eq((Object)query.getApplicantUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTransferDate())) {
            list.add(this.qdo.transferDate.eq((Object)query.getTransferDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiveUserId())) {
            list.add(this.qdo.receiveUserId.eq((Object)query.getReceiveUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiveBuId())) {
            list.add(this.qdo.receiveBuId.eq((Object)query.getReceiveBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplicantTime())) {
            list.add(this.qdo.applicantTime.eq((Object)query.getApplicantTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplicantBuId())) {
            list.add(this.qdo.applicantBuId.eq((Object)query.getApplicantBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostBuId())) {
            list.add(this.qdo.costBuId.eq((Object)query.getCostBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            if (BorrowStatusEnum.TRANSFER.getCode().equals(query.getApprStatus())) {
                list.add(this.qdo.transferFlag.eq(Boolean.valueOf(true)));
            } else {
                list.add(this.qdo.apprStatus.eq((Object)query.getApprStatus()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)query.getApprStatusList())) {
            list.add(this.qdo.apprStatus.in((Collection)query.getApprStatusList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBusinessType())) {
            list.add(this.qdo.businessType.eq((Object)query.getBusinessType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTransferFlag())) {
            list.add(this.qdo.transferFlag.eq(query.getTransferFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRepaymentUserId())) {
            list.add(this.qdo.repaymentUserId.eq((Object)query.getRepaymentUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBorrowAmt())) {
            list.add(this.qdo.borrowAmt.eq((Object)query.getBorrowAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAlreadyWriteOffAmt())) {
            list.add(this.qdo.alreadyWriteOffAmt.eq((Object)query.getAlreadyWriteOffAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUnwriteOffAmt())) {
            list.add(this.qdo.unwriteOffAmt.eq((Object)query.getUnwriteOffAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreWriteOffDate())) {
            list.add(this.qdo.preWriteOffDate.eq((Object)query.getPreWriteOffDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFileCodes())) {
            list.add(this.qdo.fileCodes.eq((Object)query.getFileCodes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountNo())) {
            list.add(this.qdo.accountNo.eq((Object)query.getAccountNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getHolderName())) {
            list.add(this.qdo.holderName.eq((Object)query.getHolderName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankName())) {
            list.add(this.qdo.bankName.eq((Object)query.getBankName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstId())) {
            list.add(this.qdo.procInstId.eq((Object)query.getProcInstId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProcInstStatus())) {
            list.add(this.qdo.procInstStatus.eq((Object)query.getProcInstStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubmitTime())) {
            list.add(this.qdo.submitTime.eq((Object)query.getSubmitTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprovedTime())) {
            list.add(this.qdo.approvedTime.eq((Object)query.getApprovedTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplicantTimeStart()) && !ObjectUtils.isEmpty((Object)query.getApplicantTimeEnd())) {
            list.add(this.qdo.applicantTime.goe((Comparable)query.getApplicantTimeStart()).and((Predicate)this.qdo.applicantTime.loe((Comparable)query.getApplicantTimeEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTransferDateStart()) && !ObjectUtils.isEmpty((Object)query.getTransferDateEnd())) {
            list.add(this.qdo.transferDate.goe((Comparable)query.getTransferDateStart()).and((Predicate)this.qdo.transferDate.loe((Comparable)query.getTransferDateEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSlippageFlag())) {
            if ("YES".equals(query.getSlippageFlag())) {
                list.add(this.qdo.preWriteOffDate.lt((Comparable)LocalDate.now()).and((Predicate)this.qdo.apprStatus.ne((Object)BorrowStatusEnum.WRITTEN_OFF.getCode())));
            } else if ("NO".equals(query.getSlippageFlag())) {
                list.add(this.qdo.preWriteOffDate.goe((Comparable)LocalDate.now()).or((Predicate)this.qdo.apprStatus.eq((Object)BorrowStatusEnum.WRITTEN_OFF.getCode())));
            }
        }
        return ExpressionUtils.allOf(list);
    }

    public BorrowMoneyVO queryByKey(Long id) {
        JPAQuery<BorrowMoneyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BorrowMoneyVO)jpaQuery.fetchFirst();
    }

    public List<BorrowMoneyVO> queryListDynamic(BorrowMoneyQuery query) {
        JPAQuery<BorrowMoneyVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BorrowMoneyVO> queryPaging(BorrowMoneyQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BorrowMoneyVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BorrowMoneyDO save(BorrowMoneyDO ado) {
        return (BorrowMoneyDO)this.repo.save(ado);
    }

    public List<BorrowMoneyDO> saveAll(List<BorrowMoneyDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BorrowMoneyPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBorrowNo() != null) {
            update.set((Path)this.qdo.borrowNo, (Object)payload.getBorrowNo());
        }
        if (payload.getBorrowName() != null) {
            update.set((Path)this.qdo.borrowName, (Object)payload.getBorrowName());
        }
        if (payload.getApplicantUserId() != null) {
            update.set(this.qdo.applicantUserId, (Object)payload.getApplicantUserId());
        }
        if (payload.getTransferDate() != null) {
            update.set(this.qdo.transferDate, (Object)payload.getTransferDate());
        }
        if (payload.getReceiveUserId() != null) {
            update.set(this.qdo.receiveUserId, (Object)payload.getReceiveUserId());
        }
        if (payload.getReceiveBuId() != null) {
            update.set(this.qdo.receiveBuId, (Object)payload.getReceiveBuId());
        }
        if (payload.getApplicantTime() != null) {
            update.set(this.qdo.applicantTime, (Object)payload.getApplicantTime());
        }
        if (payload.getApplicantBuId() != null) {
            update.set(this.qdo.applicantBuId, (Object)payload.getApplicantBuId());
        }
        if (payload.getCostBuId() != null) {
            update.set(this.qdo.costBuId, (Object)payload.getCostBuId());
        }
        if (payload.getApprStatus() != null) {
            update.set((Path)this.qdo.apprStatus, (Object)payload.getApprStatus());
        }
        if (payload.getBusinessType() != null) {
            update.set((Path)this.qdo.businessType, (Object)payload.getBusinessType());
        }
        if (payload.getTransferFlag() != null) {
            update.set((Path)this.qdo.transferFlag, (Object)payload.getTransferFlag());
        }
        if (payload.getRepaymentUserId() != null) {
            update.set(this.qdo.repaymentUserId, (Object)payload.getRepaymentUserId());
        }
        if (payload.getBorrowAmt() != null) {
            update.set(this.qdo.borrowAmt, (Object)payload.getBorrowAmt());
        }
        if (payload.getAlreadyWriteOffAmt() != null) {
            update.set(this.qdo.alreadyWriteOffAmt, (Object)payload.getAlreadyWriteOffAmt());
        }
        if (payload.getUnwriteOffAmt() != null) {
            update.set(this.qdo.unwriteOffAmt, (Object)payload.getUnwriteOffAmt());
        }
        if (payload.getPreWriteOffDate() != null) {
            update.set(this.qdo.preWriteOffDate, (Object)payload.getPreWriteOffDate());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdo.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getAccountNo() != null) {
            update.set((Path)this.qdo.accountNo, (Object)payload.getAccountNo());
        }
        if (payload.getHolderName() != null) {
            update.set((Path)this.qdo.holderName, (Object)payload.getHolderName());
        }
        if (payload.getBankName() != null) {
            update.set((Path)this.qdo.bankName, (Object)payload.getBankName());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("borrowNo")) {
                update.setNull((Path)this.qdo.borrowNo);
            }
            if (nullFields.contains("borrowName")) {
                update.setNull((Path)this.qdo.borrowName);
            }
            if (nullFields.contains("applicantUserId")) {
                update.setNull(this.qdo.applicantUserId);
            }
            if (nullFields.contains("transferDate")) {
                update.setNull(this.qdo.transferDate);
            }
            if (nullFields.contains("receiveUserId")) {
                update.setNull(this.qdo.receiveUserId);
            }
            if (nullFields.contains("receiveBuId")) {
                update.setNull(this.qdo.receiveBuId);
            }
            if (nullFields.contains("applicantTime")) {
                update.setNull(this.qdo.applicantTime);
            }
            if (nullFields.contains("applicantBuId")) {
                update.setNull(this.qdo.applicantBuId);
            }
            if (nullFields.contains("costBuId")) {
                update.setNull(this.qdo.costBuId);
            }
            if (nullFields.contains("apprStatus")) {
                update.setNull((Path)this.qdo.apprStatus);
            }
            if (nullFields.contains("businessType")) {
                update.setNull((Path)this.qdo.businessType);
            }
            if (nullFields.contains("transferFlag")) {
                update.setNull((Path)this.qdo.transferFlag);
            }
            if (nullFields.contains("repaymentUserId")) {
                update.setNull(this.qdo.repaymentUserId);
            }
            if (nullFields.contains("borrowAmt")) {
                update.setNull(this.qdo.borrowAmt);
            }
            if (nullFields.contains("alreadyWriteOffAmt")) {
                update.setNull(this.qdo.alreadyWriteOffAmt);
            }
            if (nullFields.contains("unwriteOffAmt")) {
                update.setNull(this.qdo.unwriteOffAmt);
            }
            if (nullFields.contains("preWriteOffDate")) {
                update.setNull(this.qdo.preWriteOffDate);
            }
            if (nullFields.contains("fileCodes")) {
                update.setNull((Path)this.qdo.fileCodes);
            }
            if (nullFields.contains("accountNo")) {
                update.setNull((Path)this.qdo.accountNo);
            }
            if (nullFields.contains("holderName")) {
                update.setNull((Path)this.qdo.holderName);
            }
            if (nullFields.contains("bankName")) {
                update.setNull((Path)this.qdo.bankName);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdo.procInstStatus);
            }
            if (nullFields.contains("submitTime")) {
                update.setNull(this.qdo.submitTime);
            }
            if (nullFields.contains("approvedTime")) {
                update.setNull(this.qdo.approvedTime);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateBorrowStatus(List<Long> keys, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.apprStatus, (Object)status).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public BorrowMoneyDAO(JPAQueryFactory jpaQueryFactory, BorrowMoneyRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

