/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.borrow.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.payload.TransferApplyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowWriteOffQuery;
import com.elitesland.tw.tw5.api.prd.borrow.query.TransferApplyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowWriteOffService;
import com.elitesland.tw.tw5.api.prd.borrow.service.TransferApplyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.borrow.constant.BorrowStatusEnum;
import com.elitesland.tw.tw5.server.prd.borrow.convert.TransferApplyConvert;
import com.elitesland.tw.tw5.server.prd.borrow.dao.TransferApplyDAO;
import com.elitesland.tw.tw5.server.prd.borrow.entity.TransferApplyDO;
import com.elitesland.tw.tw5.server.prd.borrow.repo.TransferApplyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TransferApplyServiceImpl
extends BaseServiceImpl
implements TransferApplyService {
    private static final Logger log = LoggerFactory.getLogger(TransferApplyServiceImpl.class);
    private final TransferApplyRepo transferApplyRepo;
    private final TransferApplyDAO transferApplyDAO;
    @Autowired
    @Lazy
    private BorrowMoneyService borrowMoneyService;
    private final BorrowWriteOffService borrowWriteOffService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;

    public PagingVO<TransferApplyVO> queryPaging(TransferApplyQuery query) {
        return this.transferApplyDAO.queryPaging(query);
    }

    public List<TransferApplyVO> queryListDynamic(TransferApplyQuery query) {
        return this.transferApplyDAO.queryListDynamic(query);
    }

    public TransferApplyVO queryByKey(Long key) {
        TransferApplyDO entity = this.transferApplyRepo.findById(key).orElseGet(TransferApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TransferApplyVO transferApplyVO = TransferApplyConvert.INSTANCE.toVo(entity);
        BorrowMoneyVO borrowMoneyVO = this.borrowMoneyService.queryByKey(entity.getBorrowId());
        transferApplyVO.setBorrowMoneyVO(borrowMoneyVO);
        BorrowWriteOffQuery borrowWriteOffQuery = new BorrowWriteOffQuery();
        borrowWriteOffQuery.setBorrowId(entity.getBorrowId());
        List borrowWriteOffVOS = this.borrowWriteOffService.queryListDynamic(borrowWriteOffQuery);
        transferApplyVO.setBorrowWriteOffList(borrowWriteOffVOS);
        return transferApplyVO;
    }

    public TransferApplyVO insert(TransferApplyPayload payload) {
        TransferApplyDO transferApplyDO = this.transactionUtilService.executeWithCallable(() -> (TransferApplyDO)this.transferApplyRepo.save(this.processData(payload)));
        TransferApplyVO transferApplyVO = TransferApplyConvert.INSTANCE.toVo(transferApplyDO);
        this.activeTransferApplyProc(transferApplyVO);
        return transferApplyVO;
    }

    private TransferApplyDO processData(TransferApplyPayload payload) {
        TransferApplyDO entityDo = TransferApplyConvert.INSTANCE.toDo(payload);
        BorrowMoneyVO borrowMoneyVO = this.borrowMoneyService.queryByKey(payload.getBorrowId());
        if (borrowMoneyVO == null || !BorrowStatusEnum.PAID.getCode().equals(borrowMoneyVO.getApprStatus()) && !BorrowStatusEnum.WRITE_OFF_PART.getCode().equals(borrowMoneyVO.getApprStatus())) {
            throw TwException.error("", "\u53ea\u6709\u5df2\u4ed8\u6b3e/\u90e8\u5206\u6838\u9500\u7684\u5355\u636e\u624d\u80fd\u53d1\u8d77\u51fa\u8ba9\u6d41\u7a0b\uff01");
        }
        BigDecimal amt = borrowMoneyVO.getBorrowAmt() == null ? BigDecimal.ZERO : borrowMoneyVO.getBorrowAmt();
        String transferName = this.cacheUtil.getUserName(borrowMoneyVO.getApplicantUserId()) + amt + "\u51fa\u8ba9" + this.cacheUtil.getUserName(payload.getReceiveUserId()) + "\u7533\u8bf7\u5355";
        entityDo.setTransferName(transferName);
        entityDo.setTransferUserId(borrowMoneyVO.getRepaymentUserId());
        entityDo.setTransferDate(LocalDate.now());
        entityDo.setTransferBuId(this.cacheUtil.getDefaultOrgIdByUserId(borrowMoneyVO.getRepaymentUserId()));
        return entityDo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TransferApplyVO update(TransferApplyPayload payload) {
        TransferApplyDO entity = this.transferApplyRepo.findById(payload.getId()).orElseGet(TransferApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TransferApplyDO entityDo = this.processData(payload);
        entity.copy(entityDo);
        return TransferApplyConvert.INSTANCE.toVo((TransferApplyDO)this.transferApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TransferApplyPayload payload) {
        TransferApplyDO entity = this.transferApplyRepo.findById(payload.getId()).orElseGet(TransferApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        return this.transferApplyDAO.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.transferApplyDAO.deleteSoft(keys);
        }
    }

    private void activeTransferApplyProc(TransferApplyVO transferApplyVO) {
        HashMap variables = new HashMap();
        String procInstName = transferApplyVO.getTransferName() + "-\u51fa\u8ba9\u6d41\u7a0b";
        PrdOrgOrganizationRefVO firstBuByBuId = this.cacheUtil.getBULevel1ByOrgId(transferApplyVO.getReceiveBuId());
        if (firstBuByBuId != null) {
            transferApplyVO.setReceiveFirstBuId(firstBuByBuId.getOrgId());
        }
        ProcessInfo processInfo = this.workflowUtil.simpleStartProcess(StartProcessPayload.of((String)ProcDefKey.DIB_BORROW_MONEY_TRANSFER.name(), (String)procInstName, (String)("" + transferApplyVO.getId()), variables), transferApplyVO, new Long[0]);
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            this.transactionUtilService.executeWithRunnable(() -> {
                TransferApplyPayload payload = new TransferApplyPayload();
                payload.setId(transferApplyVO.getId());
                BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
                borrowMoneyPayload.setId(transferApplyVO.getBorrowId());
                borrowMoneyPayload.setTransferFlag(Boolean.valueOf(true));
                this.transferApplyDAO.updateByKeyDynamic(payload);
                this.borrowMoneyService.updateByKeyDynamic(borrowMoneyPayload);
            });
        }
    }

    public TransferApplyServiceImpl(TransferApplyRepo transferApplyRepo, TransferApplyDAO transferApplyDAO, BorrowWriteOffService borrowWriteOffService, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, CacheUtil cacheUtil) {
        this.transferApplyRepo = transferApplyRepo;
        this.transferApplyDAO = transferApplyDAO;
        this.borrowWriteOffService = borrowWriteOffService;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
    }
}

