/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmActActivityController {
    private static final Logger log = LoggerFactory.getLogger(CrmActActivityController.class);
    private final CrmActActivityService service;

    @PostMapping(value={"/act/insert"})
    public TwOutputUtil insert(CrmActActivityPayload payload) {
        CrmActActivityVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/act/update"})
    public TwOutputUtil update(@RequestBody CrmActActivityPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/act/paging"})
    public TwOutputUtil paging(CrmActActivityQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @GetMapping(value={"/act/queryList"})
    public TwOutputUtil queryList(Long planId) {
        return TwOutputUtil.ok(this.service.queryList(planId));
    }

    @GetMapping(value={"/act/queryByKey/{id}"})
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        CrmActActivityVO vo = this.service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @GetMapping(value={"/act/queryDynamicByKey/{id}"})
    public TwOutputUtil queryDynamicByKey(@PathVariable Long id) {
        List vos = this.service.queryDynamicByKey(id);
        return TwOutputUtil.ok(vos);
    }

    @GetMapping(value={"/act/queryMembersByKey/{id}"})
    public TwOutputUtil queryMembersByKey(@PathVariable Long id) {
        List vos = this.service.queryMembersByKey(id);
        return TwOutputUtil.ok(vos);
    }

    @GetMapping(value={"/act/downloadActivitys"})
    public void downloadActivitys(HttpServletResponse response, CrmActActivityQuery query) {
        this.service.downloadActivitys(response, query);
    }

    @GetMapping(value={"/act/changeManger"})
    public TwOutputUtil changeManger(Long key, Long userId, Integer opeStatus) {
        this.service.changeManger(key, userId, opeStatus);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/act/changeLockStatus"})
    public TwOutputUtil changeLockStatus(Long key) {
        this.service.changeLockStatus(key);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/act/addMember"})
    public TwOutputUtil addMember(Long actId, Long[] userIds) {
        List memberVOS = this.service.addMember(actId, Arrays.asList(userIds));
        return TwOutputUtil.ok(memberVOS);
    }

    @GetMapping(value={"/act/deleteMember"})
    public TwOutputUtil deleteMember(Long actId, Long[] keys) {
        this.service.deleteMember(actId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/act/addDynamic"})
    public TwOutputUtil addDynamic(CrmActDynamicPayload payload) {
        return TwOutputUtil.ok(this.service.addDynamic(payload));
    }

    @PostMapping(value={"/act/updateDynamic"})
    public TwOutputUtil updateDynamic(CrmActDynamicPayload payload) {
        return TwOutputUtil.ok(this.service.updateDynamic(payload));
    }

    @GetMapping(value={"/act/queryActDynamicDetail/{id}"})
    public TwOutputUtil queryActDynamicDetail(@PathVariable Long id) {
        return TwOutputUtil.ok(this.service.queryActDynamicDetail(id));
    }

    @GetMapping(value={"/act/closeActivity"})
    public TwOutputUtil closeActivity(Long key, String closeReson, String clsoeRemark) {
        this.service.closeActivity(key, closeReson, clsoeRemark);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/act/queryActReportData/{id}"})
    public TwOutputUtil queryActReportData(@PathVariable Long id) {
        return TwOutputUtil.ok(this.service.queryActReportData(id));
    }

    @PostMapping(value={"/act/addReport"})
    public TwOutputUtil addReport(CrmActReportPayload payload) {
        return TwOutputUtil.ok(this.service.addReport(payload));
    }

    @GetMapping(value={"/act/queryActReportList"})
    public TwOutputUtil queryActReportList(Long actId, Integer reportType) {
        return TwOutputUtil.ok(this.service.queryActReportList(actId, reportType));
    }

    @GetMapping(value={"/act/queryActReportListByReportId"})
    public TwOutputUtil queryActReportListByReportId(Long reportId, Integer reportType) {
        return TwOutputUtil.ok(this.service.queryReportByKey(reportId, reportType));
    }

    @GetMapping(value={"/act/queryActReportDetail/{id}"})
    public TwOutputUtil queryActReportDetail(@PathVariable Long id) {
        return TwOutputUtil.ok(this.service.queryActReportDetail(id));
    }

    @GetMapping(value={"/act/{activityId}"})
    public TwOutputUtil changeLogList(@PathVariable Long activityId) {
        return TwOutputUtil.ok(this.service.changeLogList(activityId));
    }

    @GetMapping(value={"/act/changeModeData/{activityId}"})
    public TwOutputUtil getChangeModeData(@PathVariable Long activityId) {
        return TwOutputUtil.ok(this.service.changeLogDetailByActivityId(activityId));
    }

    @GetMapping(value={"/act/unReleasedPaging"})
    public TwOutputUtil queryPagingUnReleased(CrmActActivityQuery query) {
        return TwOutputUtil.ok(this.service.queryPagingUnReleased(query));
    }

    @GetMapping(value={"/act/refuseRelease/{id}"})
    public TwOutputUtil refuseRelease(@PathVariable Long id) {
        this.service.refuseRelease(id);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/act/test"})
    public TwOutputUtil test() {
        this.service.activityUnReleaseJobHandler();
        return TwOutputUtil.ok();
    }

    public CrmActActivityController(CrmActActivityService service) {
        this.service = service;
    }
}

