/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.recommended.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdInternalRecommQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdRecruitPositionService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdInternalRecommVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdRecruitPositionVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgPersonService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.convert.PrdInternalRecommConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.dao.PrdInternalRecommDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.PrdInternalRecommDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.repo.PrdInternalRecommRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PrdInternalRecommServiceImpl
extends BaseServiceImpl
implements PrdInternalRecommService {
    private static final Logger log = LoggerFactory.getLogger(PrdInternalRecommServiceImpl.class);
    private final PrdInternalRecommRepo prdInternalRecommRepo;
    private final PrdInternalRecommDAO prdInternalRecommDAO;
    private final PrdRecruitPositionService prdRecruitPositionService;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final FileUtil fileUtil;
    private final PrdSystemRoleService roleService;
    private final CacheUtil cacheUtil;
    private final PrdOrgPersonService personService;

    public PagingVO<PrdInternalRecommVO> queryPaging(PrdInternalRecommQuery query) {
        PagingVO<PrdInternalRecommVO> pagingVO = this.prdInternalRecommDAO.queryPaging(query);
        for (PrdInternalRecommVO prdInternalRecommVO : pagingVO.getRecords()) {
            prdInternalRecommVO.setRecommResumeFileList(this.fileUtil.getFileDatas(prdInternalRecommVO.getRecommResume()));
            prdInternalRecommVO.setJobType1Desc(this.cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", prdInternalRecommVO.getJobType1()));
            prdInternalRecommVO.setJobType2Desc(this.cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", prdInternalRecommVO.getJobType2()));
            prdInternalRecommVO.setManagerUserName(this.cacheUtil.getUserName(prdInternalRecommVO.getManagerUserId()));
        }
        return pagingVO;
    }

    public List<PrdInternalRecommVO> queryListDynamic(PrdInternalRecommQuery query) {
        return this.prdInternalRecommDAO.queryListDynamic(query);
    }

    public PrdInternalRecommVO queryByKey(Long key) {
        PrdInternalRecommDO entity = this.prdInternalRecommRepo.findById(key).orElseGet(PrdInternalRecommDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdInternalRecommVO vo = PrdInternalRecommConvert.INSTANCE.toVo(entity);
        vo.setPosIt(entity.getPositId());
        vo.setRecommResumeFileList(this.fileUtil.getFileDatas(vo.getRecommResume()));
        return vo;
    }

    public PrdInternalRecommVO insert(PrdInternalRecommPayload payload) {
        this.checkData(payload);
        payload.setDocNo(this.generateSeqNum("MY_RECOMMEND_NO", new String[0]));
        PrdInternalRecommDO entityDo = PrdInternalRecommConvert.INSTANCE.toDo(payload);
        entityDo.setPositId(payload.getPosIt());
        PrdOrgPersonVO orgPersonVO = this.personService.getByMobile(payload.getRecommPhone());
        if (null != orgPersonVO) {
            entityDo.setPersonId(orgPersonVO.getId());
            entityDo.setPersonName(orgPersonVO.getPersonName());
        }
        PrdInternalRecommDO save = null;
        try {
            this.transactionUtilService.begin();
            save = (PrdInternalRecommDO)this.prdInternalRecommRepo.save(entityDo);
            this.transactionUtilService.commit();
        }
        catch (Exception e) {
            this.transactionUtilService.rollback();
            throw e;
        }
        if (payload.getSubmit().booleanValue()) {
            this.startProcInst(save);
        }
        return PrdInternalRecommConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdInternalRecommVO update(PrdInternalRecommPayload payload) {
        this.checkData(payload);
        PrdInternalRecommDO entity = this.prdInternalRecommRepo.findById(payload.getId()).orElseGet(PrdInternalRecommDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdInternalRecommDO entityDo = PrdInternalRecommConvert.INSTANCE.toDo(payload);
        entityDo.setPositId(payload.getPosIt());
        entity.copy(entityDo);
        if (payload.getSubmit().booleanValue()) {
            this.startProcInst(entityDo);
        }
        return PrdInternalRecommConvert.INSTANCE.toVo((PrdInternalRecommDO)this.prdInternalRecommRepo.save(entity));
    }

    private void startProcInst(PrdInternalRecommDO prdInternalRecommDO) {
        ProcessInfo processInfo = new ProcessInfo();
        PrdRecruitPositionVO prdRecruitPositionVO = this.prdRecruitPositionService.queryByKey(prdInternalRecommDO.getPositId());
        if (prdRecruitPositionVO == null) {
            throw new BusinessException("\u5c97\u4f4d\u4e3anull");
        }
        Integer recommStatus = 1;
        if (this.workflow_enabled.booleanValue()) {
            recommStatus = 2;
            HashMap<String, List> variables = new HashMap<String, List>();
            variables.put("Activity_0i2vxh5", this.roleService.queryUserIdByRoleCode("PLAT_HIRING_MANAGER"));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.INTERIOR_RECO.name(), (String)(prdInternalRecommDO.getRecommUserName() + "-\u5185\u90e8\u63a8\u8350\u5ba1\u6279\u6d41\u7a0b"), (String)("" + prdInternalRecommDO.getId()), variables), new Long[0]);
        }
        PrdInternalRecommPayload payload = new PrdInternalRecommPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setAdoptReward(prdInternalRecommDO.getAdoptReward());
        payload.setFilterResult(prdInternalRecommDO.getFilterResult());
        payload.setRecommUserId(prdInternalRecommDO.getRecommUserId());
        payload.setId(prdInternalRecommDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setRecommStatus(recommStatus);
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprovedTime(LocalDateTime.now());
        this.transactionUtilService.executeWithRunnable(() -> this.prdInternalRecommDAO.updateByKeyDynamic(payload));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PrdInternalRecommPayload payload) {
        PrdInternalRecommDO entity = this.prdInternalRecommRepo.findById(payload.getId()).orElseGet(PrdInternalRecommDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.prdInternalRecommDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdInternalRecommDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean updateFormalReward(PrdInternalRecommPayload prdInternalRecommPayload) {
        Boolean res = this.prdInternalRecommDAO.updateFormalReward(prdInternalRecommPayload);
        return res;
    }

    public PrdInternalRecommVO getByPersonId(String name, Long personId) {
        List<PrdInternalRecommVO> res = this.prdInternalRecommDAO.getByPersonId(name, personId);
        if (CollUtil.isNotEmpty(res)) {
            return res.get(0);
        }
        return null;
    }

    @Transactional
    public Boolean updateByPersonId(PrdInternalRecommPayload prdInternalRecommPayload) {
        Boolean res = this.prdInternalRecommDAO.updateByPersonId(prdInternalRecommPayload);
        return res;
    }

    private void checkData(PrdInternalRecommPayload prdInternalRecommPayload) {
        if (StringUtils.isBlank((CharSequence)prdInternalRecommPayload.getRecommUserName())) {
            throw new BusinessException("\u88ab\u63a8\u8350\u4eba\u540d\u79f0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdInternalRecommPayload.getRecommPhone())) {
            throw new BusinessException("\u88ab\u63a8\u8350\u4eba\u624b\u673a\u53f7\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdInternalRecommPayload.getRecommResume())) {
            throw new BusinessException("\u63a8\u8350\u4eba\u7b80\u5386\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (prdInternalRecommPayload.getManagerUserId() == null) {
            throw new BusinessException("\u62db\u8058\u4eba\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (prdInternalRecommPayload.getRecommDate() == null) {
            throw new BusinessException("\u63a8\u8350\u65e5\u671f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (prdInternalRecommPayload.getPosIt() == null) {
            throw new BusinessException("\u5c97\u4f4did\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PrdInternalRecommServiceImpl(PrdInternalRecommRepo prdInternalRecommRepo, PrdInternalRecommDAO prdInternalRecommDAO, PrdRecruitPositionService prdRecruitPositionService, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, FileUtil fileUtil, PrdSystemRoleService roleService, CacheUtil cacheUtil, PrdOrgPersonService personService) {
        this.prdInternalRecommRepo = prdInternalRecommRepo;
        this.prdInternalRecommDAO = prdInternalRecommDAO;
        this.prdRecruitPositionService = prdRecruitPositionService;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.fileUtil = fileUtil;
        this.roleService = roleService;
        this.cacheUtil = cacheUtil;
        this.personService = personService;
    }
}

