/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResSearchQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResSearchService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEvaluateVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResPortrayalVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResSearchVO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResSearchDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ResSearchServiceImpl
implements ResSearchService {
    private static final Logger log = LoggerFactory.getLogger(ResSearchServiceImpl.class);
    private final ResSearchDAO resSearchDAO;
    private final PersonResService personResService;
    private final PrdEmployeCompositeAbilityService employeCompositeAbilityService;
    private final PrdPerformanceExamResultService performanceExamResultService;
    private final ResEvaluateService resEvaluateService;
    private final UdcUtil udcUtil;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;

    public PagingVO<ResSearchVO> queryPaging(ResSearchQuery query) {
        List<String> resStatusList = Arrays.asList("3", "4", "5");
        query.setResourceStatusList(resStatusList);
        PagingVO<ResSearchVO> resSearchPage = this.resSearchDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty(resSearchPage)) {
            List resSearchVOList = resSearchPage.getRecords();
            for (ResSearchVO resSearchVO : resSearchVOList) {
                PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery = new PrdEmployeCompositeAbilityQuery();
                prdEmployeCompositeAbilityQuery.setUserId(resSearchVO.getUserId());
                prdEmployeCompositeAbilityQuery.setMainFlag(Boolean.valueOf(true));
                List prdEmployeCompositeAbilityVOList = this.prdEmployeCompositeAbilityService.getList(prdEmployeCompositeAbilityQuery);
                if (ObjectUtils.isEmpty((Object)prdEmployeCompositeAbilityVOList)) continue;
                resSearchVO.setCapsetLevelName(((PrdEmployeCompositeAbilityVO)prdEmployeCompositeAbilityVOList.get(0)).getAbilityName());
            }
            resSearchPage.setRecords(resSearchVOList);
        }
        return resSearchPage;
    }

    public ResPortrayalVO getPortrayal(Long userId) {
        ResPortrayalVO resPortrayalVO = new ResPortrayalVO();
        PersonResVO personResVO = this.personResService.queryByUserId(userId);
        ResEvaluateVO resEvaluateVO = personResVO.getResEvaluateVO();
        if (resEvaluateVO != null) {
            List keyPointIds = this.resEvaluateService.getResPortrayalEvalConfig(userId);
            if (keyPointIds == null) {
                resEvaluateVO.setEvalDtl(null);
            } else {
                List resEvaluateDtlVOList = resEvaluateVO.getEvalDtl();
                resEvaluateDtlVOList = resEvaluateDtlVOList.stream().filter(e -> keyPointIds.contains(e.getEvalPointId())).collect(Collectors.toList());
                resEvaluateVO.setEvalDtl(resEvaluateDtlVOList);
            }
            personResVO.setResEvaluateVO(resEvaluateVO);
        }
        List personEduExperienceVOList = personResVO.getEduExperienceVOList();
        this.udcUtil.translateList(personEduExperienceVOList);
        resPortrayalVO.setPersonResVO(personResVO);
        BigDecimal resProjEvaluateScore = this.resEvaluateService.getResProjEvaluateScore(userId);
        resPortrayalVO.setProjEvalScore(resProjEvaluateScore);
        PrdEmployeCompositeAbilityQuery abilityQuery = new PrdEmployeCompositeAbilityQuery();
        abilityQuery.setUserId(userId);
        List employeCompositeAbilityVOList = this.employeCompositeAbilityService.getList(abilityQuery);
        resPortrayalVO.setCompositeAbilityVOList(employeCompositeAbilityVOList);
        PrdPerformanceExamResultQuery examResultQuery = new PrdPerformanceExamResultQuery();
        examResultQuery.setUserId(userId);
        List prdPerformanceExamResultVOList = this.performanceExamResultService.getList(examResultQuery);
        resPortrayalVO.setPrdPerformanceExamResultVOList(prdPerformanceExamResultVOList);
        return resPortrayalVO;
    }

    public ResSearchServiceImpl(ResSearchDAO resSearchDAO, PersonResService personResService, PrdEmployeCompositeAbilityService employeCompositeAbilityService, PrdPerformanceExamResultService performanceExamResultService, ResEvaluateService resEvaluateService, UdcUtil udcUtil, PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService) {
        this.resSearchDAO = resSearchDAO;
        this.personResService = personResService;
        this.employeCompositeAbilityService = employeCompositeAbilityService;
        this.performanceExamResultService = performanceExamResultService;
        this.resEvaluateService = resEvaluateService;
        this.udcUtil = udcUtil;
        this.prdEmployeCompositeAbilityService = prdEmployeCompositeAbilityService;
    }
}

