/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.extra.spring.SpringUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.MonthlyTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetApproveQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetSubsidySettingQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetSubsidySettingService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.JDEMonthlyTimesheetVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MonthlyTimesheetVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySelectTypeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySettingVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSyncDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeSuperiorQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsTimesheetProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSettingService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalResQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalResService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.SystemSettingEnum;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.OrgEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.SubsidyHolidaySubsidyTypeTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.SubsidyStdTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.SubsidyWorkDateTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.constant.VacationTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.VacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.tw.tw5.server.prd.work.repo.OvertimeApplicationRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsTimesheetServiceImpl
implements PmsTimesheetService {
    private static final Logger log = LoggerFactory.getLogger(PmsTimesheetServiceImpl.class);
    private final TimesheetRepo timesheetRepo;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final PmsProjectService pmsProjectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO daoUser;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final TimesheetDAO timesheetDAO;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;
    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final OvertimeApplicationRepo overtimeApplicationRepo;
    private final OvertimeApplicationDAO overtimeApplicationDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final TaskInfoService taskInfoService;
    private final VacationDAO vacationDAO;
    private final TaskCommonService taskCommonService;
    private final TaskPackageService taskPackageService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final PmsResourcePlanRoleService pmsResourcePlanRoleService;
    private final CacheUtil cacheUtil;
    private final ExcelUtil twExcelUtil;
    private final UdcUtil udcUtil;
    private final UserVacationService userVacationService;
    @Autowired
    @Lazy
    private VacationService vacationService;
    private final TsApprovalResService tsApprovalResService;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;
    private final CalTaskSettleService calTaskSettleService;
    private BeanSearcher beanSearcher;
    private final CrmOpportunityService crmOpportunityService;
    private final BuProjectService buProjectService;
    private final PrdSystemSettingService prdSystemSettingService;
    private final TimesheetSubsidySettingService timesheetSubsidySettingService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_TIME_SHEET);
    }

    public PagingVO<TimesheetVO> paging(TimesheetQuery query) {
        PagingVO<TimesheetVO> timesheetVOPagingVO = this.timesheetDAO.queryPaging(query);
        ArrayList timesheetIds = new ArrayList();
        if (timesheetVOPagingVO.getTotal() > 0L) {
            List userIds = timesheetVOPagingVO.getRecords().stream().map(TimesheetVO::getTsUserId).distinct().collect(Collectors.toList());
            List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = this.prdOrgEmployeeDAO.queryListByUserIdList(userIds);
            Map maps = prdOrgEmployeeDOS.stream().collect(Collectors.toMap(PrdOrgEmployeeDO::getUserId, Function.identity()));
            timesheetVOPagingVO.getRecords().forEach(vo -> {
                timesheetIds.add(vo.getId());
                PrdOrgEmployeeDO prdOrgEmployeeDO = (PrdOrgEmployeeDO)maps.get(vo.getTsUserId());
                if (prdOrgEmployeeDO != null) {
                    vo.setBaseCityId(prdOrgEmployeeDO.getExtString5());
                }
            });
            this.getApprovalResLogs(timesheetVOPagingVO.getRecords());
        }
        return timesheetVOPagingVO;
    }

    void getApprovalResLogs(List<TimesheetVO> timesheetVOS) {
        List timesheetIds = timesheetVOS.stream().map(TimesheetVO::getId).collect(Collectors.toList());
        TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
        tsApprovalResQuery.setTimesheetIds(timesheetIds);
        List tsApprovalResVOS = this.tsApprovalResService.queryListDynamic(tsApprovalResQuery);
        tsApprovalResVOS = this.udcUtil.translateList(tsApprovalResVOS);
        Map<Long, List> groupedByTimesheetId = tsApprovalResVOS.stream().collect(Collectors.groupingBy(TsApprovalResVO::getTimesheetId, Collectors.collectingAndThen(Collectors.toList(), list -> {
            list.sort(Comparator.comparingInt(TsApprovalResVO::getSortIndex));
            return list;
        })));
        timesheetVOS.forEach(vo -> {
            List tsApprovalResVOS1 = (List)groupedByTimesheetId.get(vo.getId());
            if (!CollectionUtils.isEmpty((Collection)tsApprovalResVOS1)) {
                vo.setTsApprovalResVOS(tsApprovalResVOS1);
            }
        });
    }

    public PagingVO<TimesheetVO> pagingPermission(TimesheetQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(TimesheetVO.class, mapBuilder.build());
        long total = (Long)totalNum;
        if (total == 0L) {
            return PagingVO.empty();
        }
        List timesheetVOS = this.beanSearcher.searchList(TimesheetVO.class, mapBuilder.build());
        this.getApprovalResLogs(timesheetVOS);
        return PagingVO.builder().records(timesheetVOS).total(total).build();
    }

    public List<TimesheetVO> listPermission(TimesheetQuery query) {
        query.setCurrent(Integer.valueOf(0));
        query.setSize(Integer.valueOf(2500000));
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        List timesheetVOS = this.beanSearcher.searchList(TimesheetVO.class, mapBuilder.build());
        return timesheetVOS;
    }

    private MapBuilder pageWhereBuilder(TimesheetQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getActName())) {
            ((MapBuilder)builder.field(TimesheetVO::getActName, new Object[]{query.getActName()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskName())) {
            String actIden = this.cacheUtil.getSystemSelectionValueByName("prd:timesheet:actType", query.getTaskName());
            String likeStr = "%" + query.getTaskName() + "%";
            if (StringUtils.hasText((String)actIden) && !query.getTaskName().equals(actIden)) {
                ((MapBuilder)builder.field(TimesheetVO::getTaskName, new FieldFns.FieldFn[]{TimesheetVO::getTsActIden})).sql("$1 like ? or $2 = ?", new Object[]{likeStr, actIden});
            } else {
                ((MapBuilder)builder.field(TimesheetVO::getTaskName, new Object[]{query.getTaskName()})).op((FieldOp)FieldOps.Contain);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageName())) {
            if (query.getTaskPackageName().equals("\u65e0\u4efb\u52a1")) {
                String likeStr = "%" + query.getTaskPackageName() + "%";
                ((MapBuilder)builder.field(TimesheetVO::getTaskPackageName, new FieldFns.FieldFn[]{TimesheetVO::getProjId, TimesheetVO::getTaskPackageId})).sql(" $1 like ? or ( ($2 is null or $2=0) and  ( $3 is null or $3=0))", new Object[]{likeStr});
            } else {
                ((MapBuilder)builder.field(TimesheetVO::getTaskPackageName, new Object[]{query.getTaskPackageName()})).op((FieldOp)FieldOps.Contain);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjId())) {
            ((MapBuilder)builder.field(TimesheetVO::getProjId, new Object[]{query.getProjId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsUserId())) {
            ((MapBuilder)builder.field(TimesheetVO::getTsUserId, new Object[]{query.getTsUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsUserBuId())) {
            ((MapBuilder)builder.field(TimesheetVO::getTsUserBuId, new Object[]{query.getTsUserBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsStatus())) {
            ((MapBuilder)builder.field(TimesheetVO::getTsStatus, new Object[]{query.getTsStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            ((MapBuilder)builder.field(TimesheetVO::getReasonId, new Object[]{query.getReasonId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprUserId())) {
            ((MapBuilder)builder.field(TimesheetVO::getApprUserId, new Object[]{query.getApprUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsUserIdList())) {
            ((MapBuilder)builder.field(TimesheetVO::getTsUserId, (Collection)query.getTsUserIdList())).op((FieldOp)FieldOps.InList);
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkDateBetween())) {
            ((MapBuilder)builder.field(TimesheetVO::getWorkDate, new Object[]{query.getWorkDateBetween().get(0), query.getWorkDateBetween().get(1)})).op((FieldOp)FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprovalTime())) {
            ((MapBuilder)builder.field(TimesheetVO::getApprovalTime, new Object[]{query.getApprovalTime().get(0), query.getApprovalTime().get(1)})).op((FieldOp)FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkDate())) {
            ((MapBuilder)builder.field(TimesheetVO::getWorkDate, new Object[]{query.getWorkDate().get(0), query.getWorkDate().get(1)})).op((FieldOp)FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty((Object)query.getNonHolidayFlag()) && query.getNonHolidayFlag() == 1) {
            ((MapBuilder)builder.field(TimesheetVO::getTsTaskIden, new FieldFns.FieldFn[]{TimesheetVO::getTsActIden})).sql("($1 is null or $1  <> 'VACATION') and ( $2 is null or $2 <> 'LEGALHOLIDAY' ) ");
        }
        if (!ObjectUtils.isEmpty((Object)query.getNoTaskFlag())) {
            if (query.getNoTaskFlag() == 0) {
                ((MapBuilder)builder.field(TimesheetVO::getTaskPackageId, new FieldFns.FieldFn[0])).sql("( $1 is null or $1=0)");
            }
            if (query.getNoTaskFlag() == 1) {
                ((MapBuilder)builder.field(TimesheetVO::getTaskPackageId, new Object[]{0})).op((FieldOp)FieldOps.GreaterThan);
            }
        }
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.desc((String)"workDate"));
        query.setOrders(orderse);
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public void getPermissionParams(TimesheetQuery query) {
        if (query.getIsPermission().booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (!isSystemAdmin) {
                List<Long> userIdsByPlatRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
                List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set<Long> orgIdList = null;
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                }
                List<PrdOrgEmployeeRefVO> empRef = this.daoUser.queryLowListByKey(null, loginUserId);
                Set empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    HashSet<Long> queryUserIds = new HashSet<Long>();
                    queryUserIds.add(loginUserId);
                    if (orgIdList != null && !orgIdList.isEmpty()) {
                        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if (empRefUserIdList != null && !empRefUserIdList.isEmpty()) {
                        queryUserIds.addAll(empRefUserIdList);
                    }
                    query.setTsUserIdList(queryUserIds);
                }
            }
        }
    }

    public PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query) {
        if (!ObjectUtils.isEmpty((Object)query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO paging = this.prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
                Set userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        }
        Page page = this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }

    public PagingVO pagingGroup(TimesheetQuery query) {
        query.setOrders(null);
        if (!ObjectUtils.isEmpty((Object)query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO paging = this.prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
                Set userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        } else {
            query.setTsUserIdList(new HashSet());
        }
        Page<Object[]> page = this.timesheetRepo.pagingGroup(query.getTsUserId(), query.getApprUserId(), query.getTsStatus(), query.getTsUserBuId(), query.getTimesheetIdV4IsNull(), (Pageable)query.getPageRequest(), query.getBlurryQuery(), query.getTsUserIdList());
        List content = page.getContent();
        List<TimesheetVO> all = this.getAll(content);
        this.setTheoryGetEqva(all);
        return PagingVO.builder().records(all).total(page.getTotalElements()).build();
    }

    public void setTheoryGetEqva(List<TimesheetVO> list) {
        if (list != null && list.size() > 0) {
            for (TimesheetVO timeView : list) {
                String[] groupIdsArr = timeView.getGroupIds().split(",");
                BigDecimal bd = new BigDecimal("0");
                for (int i = 0; i < groupIdsArr.length; ++i) {
                    TaskPackageVO task;
                    TimesheetVO data = this.queryByKey(Long.valueOf(groupIdsArr[i]));
                    if (data.getTaskPackageId() == null || data.getTaskPackageId() <= 0L || (task = this.taskPackageService.queryByKey(data.getTaskPackageId(), Boolean.valueOf(false))) == null || !"04".equals(task.getAcceptMethod())) continue;
                    bd = bd.add(data.getWorkHour().divide(new BigDecimal("8"), 1, RoundingMode.UP).multiply(task.getEqvaRatio()));
                }
                timeView.setTheoryGetEqva(bd);
            }
        }
    }

    public List<TimesheetVO> getAll(List<Object[]> objects) {
        ArrayList<TimesheetVO> list = new ArrayList<TimesheetVO>();
        for (Object[] obj : objects) {
            TimesheetVO timesheetVO = new TimesheetVO();
            timesheetVO.setGroupIds(String.valueOf(obj[0]));
            timesheetVO.setWorkHour(BigDecimal.valueOf(Double.parseDouble(String.valueOf(obj[1]))));
            timesheetVO.setProjId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            timesheetVO.setProjNo(String.valueOf(obj[3]));
            timesheetVO.setProjName(String.valueOf(obj[4]));
            timesheetVO.setTsStatus(String.valueOf(obj[5]));
            timesheetVO.setApprUserId(obj[6] != null ? Long.valueOf(String.valueOf(obj[6])) : null);
            timesheetVO.setWeekStartDate(obj[7] != null ? LocalDate.parse(String.valueOf(obj[7])) : null);
            timesheetVO.setTaskId(obj[8] != null ? Long.valueOf(String.valueOf(obj[8])) : null);
            timesheetVO.setTaskNo(String.valueOf(obj[9]));
            timesheetVO.setTaskName(String.valueOf(obj[10]));
            timesheetVO.setTsUserId(obj[11] != null ? Long.valueOf(String.valueOf(obj[11])) : null);
            timesheetVO.setTsUserBuId(obj[12] != null ? Long.valueOf(String.valueOf(obj[12])) : null);
            timesheetVO.setTsUserBuName(obj[13] != null ? String.valueOf(obj[13]) : "");
            list.add(timesheetVO);
        }
        return list;
    }

    public List<TimesheetVO> listGroup(TimesheetQuery query) {
        QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qTimesheetDO).from((EntityPath)qTimesheetDO)).where((Predicate)qTimesheetDO.deleteFlag.eq((Object)0));
        if (null != query.getTsUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.tsUserId.eq((Object)query.getTsUserId()));
        }
        if (null != query.getApprUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.apprUserId.eq((Object)query.getApprUserId()));
        }
        if (StringUtils.hasText((String)query.getTsStatus())) {
            jpaQuery.where((Predicate)qTimesheetDO.tsStatus.eq((Object)query.getTsStatus()));
        }
        QueryResults queryResults = ((JPAQuery)((JPAQuery)jpaQuery.groupBy(new Expression[]{qTimesheetDO.projId, qTimesheetDO.yearWeek, qTimesheetDO.tsUserId})).orderBy(new OrderSpecifier[]{qTimesheetDO.yearWeek.desc(), qTimesheetDO.tsUserId.desc()})).fetchResults();
        List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(queryResults.getResults());
        return timesheetVOList;
    }

    public List<TimesheetVO> queryList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.toVoList(this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public Map<LocalDate, Object> getTimesheetOverview(TimesheetQuery query) {
        HashMap<LocalDate, Object> result = new HashMap<LocalDate, Object>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (loginUserId == null) {
            throw TwException.error("", "\u7528\u6237\u67e5\u8be2\u5931\u8d25\uff01");
        }
        query.setTsUserId(loginUserId);
        List<TimesheetVO> timesheetVOS = this.queryList(query);
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        List workDate = query.getWorkDate();
        LocalDate startDate = (LocalDate)workDate.get(0);
        LocalDate endDate = (LocalDate)workDate.get(1);
        LocalDate localDate = startDate;
        while (localDate.isBefore(endDate.plusDays(1L))) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            if (timesheetVOS1 == null || timesheetVOS1.isEmpty()) {
                result.put(localDate, "");
            } else {
                String status = "";
                int rejectedNum = 0;
                int createNum = 0;
                int approvingNum = 0;
                int approvedNum = 0;
                int settledNum = 0;
                for (TimesheetVO timesheetVO : timesheetVOS1) {
                    String tsStatus = timesheetVO.getTsStatus();
                    switch (TimesheetStatus.valueOf(tsStatus)) {
                        case CREATE: {
                            ++createNum;
                            break;
                        }
                        case REJECTED: {
                            ++rejectedNum;
                            break;
                        }
                        case APPROVING: {
                            ++approvingNum;
                            break;
                        }
                        case APPROVED: {
                            ++approvedNum;
                            break;
                        }
                        case SETTLED: {
                            ++settledNum;
                        }
                    }
                }
                if (rejectedNum > 0) {
                    status = TimesheetStatus.REJECTED.getCode();
                } else if (createNum > 0) {
                    status = TimesheetStatus.CREATE.getCode();
                } else if (approvingNum > 0) {
                    status = TimesheetStatus.APPROVING.getCode();
                } else if (approvedNum > 0) {
                    status = TimesheetStatus.APPROVED.getCode();
                } else if (settledNum > 0) {
                    status = TimesheetStatus.SETTLED.getCode();
                }
                BigDecimal reduce = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                    reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                HashMap<String, Object> result1 = new HashMap<String, Object>();
                result1.put("status", status);
                result1.put("hour", reduce);
                result.put(localDate, result1);
            }
            localDate = localDate.plusDays(1L);
        }
        return result;
    }

    @Transactional
    public Boolean getTimesheetRemind(TimesheetQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode(), RoleEnum.PLATFORM_RES.getCode()));
        if (rolePermission.booleanValue()) {
            return false;
        }
        Map<LocalDate, Object> timesheetOverview = this.getTimesheetOverview(query);
        for (LocalDate localDate : timesheetOverview.keySet()) {
            if (timesheetOverview.get(localDate).equals("")) {
                return true;
            }
            Map result1 = (Map)timesheetOverview.get(localDate);
            String status = (String)result1.get("status");
            if (status.equals("APPROVING") || status.equals("APPROVED")) continue;
            return true;
        }
        return false;
    }

    public Map<LocalDate, Object> getAccReimTimesheetOverview(TimesheetQuery query) {
        HashMap<LocalDate, Object> result = new HashMap<LocalDate, Object>();
        if (query.getTsUserId() == null) {
            throw TwException.error("", "\u7528\u6237\u53c2\u6570\u5fc5\u4f20\uff01");
        }
        List<TimesheetVO> timesheetVOS = this.queryList(query);
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        List workDate = query.getWorkDateBetween();
        LocalDate startDate = (LocalDate)workDate.get(0);
        LocalDate endDate = (LocalDate)workDate.get(1);
        List vacationDay = this.vacationService.findVacationDay(startDate, endDate);
        LocalDate localDate = startDate;
        while (localDate.isBefore(endDate.plusDays(1L))) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            HashMap<String, Object> result1 = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                String status = "";
                int rejectedNum = 0;
                int createNum = 0;
                int approvingNum = 0;
                int approvedNum = 0;
                int settledNum = 0;
                for (TimesheetVO timesheetVO : timesheetVOS1) {
                    String tsStatus = timesheetVO.getTsStatus();
                    switch (TimesheetStatus.valueOf(tsStatus)) {
                        case CREATE: {
                            ++createNum;
                            break;
                        }
                        case REJECTED: {
                            ++rejectedNum;
                            break;
                        }
                        case APPROVING: {
                            ++approvingNum;
                            break;
                        }
                        case APPROVED: {
                            ++approvedNum;
                            break;
                        }
                        case SETTLED: {
                            ++settledNum;
                        }
                    }
                    if (rejectedNum > 0) {
                        status = TimesheetStatus.REJECTED.getCode();
                    } else if (createNum > 0) {
                        status = TimesheetStatus.CREATE.getCode();
                    } else if (approvingNum > 0) {
                        status = TimesheetStatus.APPROVING.getCode();
                    } else if (approvedNum > 0) {
                        status = TimesheetStatus.APPROVED.getCode();
                    } else if (settledNum > 0) {
                        status = TimesheetStatus.SETTLED.getCode();
                    }
                    BigDecimal reduce = BigDecimal.ZERO;
                    if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                        reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    result1.put("hour", reduce);
                    result1.put("status", status);
                    result1.put("vacDayFlag", false);
                    result.put(localDate, result1);
                }
            } else if (!CollectionUtils.isEmpty((Collection)vacationDay) && vacationDay.contains(localDate)) {
                result1.put("vacDayFlag", true);
                result.put(localDate, result1);
            } else {
                result.put(localDate, result1);
            }
            localDate = localDate.plusDays(1L);
        }
        return result;
    }

    public void updateApprovingUser(List<Long> keys, Long apprUserId) {
        if (null == apprUserId || CollectionUtils.isEmpty(keys)) {
            log.warn("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff0c\u5de5\u65f6\u5217\u8868\u53d8\u66f4\u5ba1\u6279\u4eba\u9519\u8bef");
            return;
        }
        TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
        tsApprovalResQuery.setTimesheetIds(keys);
        tsApprovalResQuery.setApprovalStatus(TimesheetStatus.APPROVING.getCode());
        List tsApprovalResVOS = this.tsApprovalResService.queryListDynamic(tsApprovalResQuery);
        for (TsApprovalResVO tsApprovalResVO : tsApprovalResVOS) {
            TsApprovalResPayload approvalResPayload = new TsApprovalResPayload();
            approvalResPayload.setId(tsApprovalResVO.getId());
            approvalResPayload.setApprovalResId(apprUserId);
            this.tsApprovalResService.updateByKeyDynamic(approvalResPayload);
        }
        this.timesheetRepo.updateApprovingUser(keys, apprUserId);
    }

    public void generateVacationPublicTimesheet(String param) {
    }

    public List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.doListToSyncVo(this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(TimesheetQuery query) {
        return this.timesheetRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public TimesheetVO queryByKey(Long key) {
        TimesheetDO entity = this.timesheetRepo.findById(key).orElseGet(TimesheetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
        TimesheetVO vo = TimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public TimesheetVO insert(TimesheetPayload payload) {
        if (payload.getProjId() != null && payload.getProjId() != 0L) {
            payload.setTsTaskIden(null);
            payload.setTsActIden(null);
        }
        this.check(payload);
        this.initData(payload);
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        this.biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        TimesheetDO save = (TimesheetDO)((Object)this.timesheetRepo.save((Object)entityDo));
        payload.setId(save.getId());
        return TimesheetConvert.INSTANCE.toVo(save);
    }

    public void saveAllForAutoCreate(List<TimesheetPayload> payloadList) {
        if (!CollectionUtils.isEmpty(payloadList)) {
            List<TimesheetDO> doList = TimesheetConvert.INSTANCE.toDoList(payloadList);
            this.timesheetRepo.saveAll(doList);
            for (TimesheetDO newTimesheetDO : doList) {
                newTimesheetDO.setTimesheetId(newTimesheetDO.getId());
            }
            List<TimesheetPlanDO> timesheetPlanDOS = TimesheetConvert.INSTANCE.toTimesheetPlanDo(doList);
            timesheetPlanDOS = timesheetPlanDOS.stream().map(e -> {
                e.setTsTaskIden("NOTASK");
                e.setTsActIden("VACATION");
                LocalDate workDate = e.getWorkDate();
                if (null != workDate) {
                    e.setWorkType(workDate.toString() + " 09:00:00," + workDate.toString() + " 18:00:00");
                }
                e.setId(null);
                return e;
            }).collect(Collectors.toList());
            this.timesheetPlanRepo.saveAll(timesheetPlanDOS);
            for (TimesheetPlanDO timesheetPlanDO : timesheetPlanDOS) {
                Long timesheetId = timesheetPlanDO.getTimesheetId();
                for (TimesheetDO newTimesheetDO : doList) {
                    if (!newTimesheetDO.getId().equals(timesheetId)) continue;
                    this.timesheetRepo.updatePlan(newTimesheetDO.getId(), timesheetPlanDO.getId());
                }
            }
        }
    }

    private void check(TimesheetPayload payload) {
        if (payload.isSubmitted()) {
            TaskPackageVO taskPackageVO;
            if (payload.getId() != null && payload.getId() > 0L) {
                TimesheetVO timesheetVO = this.queryByKey(payload.getId());
                if (!TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(timesheetVO.getTsStatus())) {
                    throw TwException.error("", "\u53ea\u80fd\u63d0\u4ea4\u65b0\u5efa\u6216\u5df2\u9000\u56de\u7684\u5355\u636e");
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            if (null == payload.getWorkDate()) {
                throw TwException.error("", "\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5\u671f");
            }
            if (!StringUtils.hasText((String)payload.getWorkDesc())) {
                throw TwException.error("", "\u8bf7\u8f93\u5165\u5de5\u4f5c\u65e5\u5fd7");
            }
            if (null == payload.getWorkHour()) {
                throw TwException.error("", "\u8bf7\u586b\u5199\u5de5\u65f6");
            }
            if (null != payload.getTaskPackageId() && null == (taskPackageVO = this.taskPackageService.queryByKey(payload.getTaskPackageId(), Boolean.valueOf(false)))) {
                throw TwException.error("", "\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
            }
            if (null != payload.getTaskId()) {
                TaskInfoVO taskVO = this.taskInfoService.queryByKey(payload.getTaskId(), Boolean.valueOf(true));
                if (null == taskVO) {
                    throw TwException.error("", "\u4efb\u52a1\u4e0d\u5b58\u5728");
                }
                List<String> statuss = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());
                if (!statuss.contains(taskVO.getTaskStatus()) && !taskVO.getId().equals(0L)) {
                    throw TwException.error("", taskVO.getTaskName() + "-\u4efb\u52a1\u4e0d\u53ef\u7528");
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetVO> batchInsert(TimesheetListPayload payload) {
        List deleteIdList;
        ArrayList<TimesheetVO> timesheetVOList = new ArrayList<TimesheetVO>();
        boolean submitted = payload.isSubmitted();
        List timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty((Collection)timesheetList)) {
            List<TimesheetPayload> pmsTimeSheetPayloadListForTask = null;
            timesheetList.forEach(timesheetPayload -> {
                Long taskPackageId;
                if (timesheetPayload.getWorkHour() == null) {
                    throw TwException.error("", "\u65e5\u671f" + timesheetPayload.getWorkDate() + "\u7684\u5de5\u65f6\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01");
                }
                Long taskId = timesheetPayload.getTaskId();
                if (taskId != null && (taskId.equals(0L) || taskId.equals(1L))) {
                    timesheetPayload.setTaskId(null);
                }
                if ((taskPackageId = timesheetPayload.getTaskPackageId()) != null && (taskPackageId.equals(0L) || taskPackageId.equals(1L))) {
                    timesheetPayload.setTaskPackageId(null);
                }
            });
            if (payload.isCheckFlag() && !this.workHourValidate(payload)) {
                throw TwException.error("", "\u5f53\u5929\u5de5\u65f6\u5df2\u8d85\u8fc78\u5c0f\u65f6");
            }
            if (!this.workHourHolidayValidate(payload)) {
                throw TwException.error("", "\u8282\u5047\u65e5\u53ea\u80fd\u586b\u4e00\u67610\u5de5\u65f6\u8bb0\u5f55");
            }
            if (submitted) {
                timesheetList.forEach(timesheetPayload -> {
                    timesheetPayload.setSubmitted(false);
                    TimesheetVO insert = this.insert((TimesheetPayload)timesheetPayload);
                    timesheetPayload.setId(insert.getId());
                });
                this.checkWorkDate(payload);
                pmsTimeSheetPayloadListForTask = timesheetList.stream().filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0L).collect(Collectors.toList());
            }
            timesheetList.forEach(timesheetPayload -> {
                if (payload.isSubmitted()) {
                    timesheetPayload.setSubmitted(true);
                }
                timesheetVOList.add(this.insert((TimesheetPayload)timesheetPayload));
            });
            if (!CollectionUtils.isEmpty(pmsTimeSheetPayloadListForTask)) {
                pmsTimeSheetPayloadListForTask.forEach(TimesheetPayload2 -> this.updatePmsTaskInfoByTimesheetPayload((TimesheetPayload)TimesheetPayload2));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(deleteIdList = payload.getDeleteIdList()))) {
            this.deleteSoft(deleteIdList);
        }
        return timesheetVOList;
    }

    public List<LocalDate> findVacationDayIn(List<LocalDate> localDateList) {
        List<LocalDate> res = this.vacationDAO.findVacationDayIn(localDateList);
        return res;
    }

    private String validateEqvaPms(TimesheetListPayload payload) {
        List<TimesheetPayload> timesheetPayloadList = payload.getTimesheetList().stream().filter(timesheetPayload -> this.tsStatusCheck((TimesheetPayload)timesheetPayload) && (ObjectUtils.isEmpty((Object)timesheetPayload.getType()) || !timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode()))).collect(Collectors.toList());
        String buAndOppoProjectTaskEqvaResult = this.validateBuAndOppoProjectTaskEqva(timesheetPayloadList);
        if (StringUtils.hasText((String)buAndOppoProjectTaskEqvaResult)) {
            return buAndOppoProjectTaskEqvaResult;
        }
        return null;
    }

    private String validateProjectTaskEqva(List<TimesheetPayload> timesheetPayloadList) {
        Map dayUsedMap;
        List tsListTmp = timesheetPayloadList.stream().filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0L && ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        List reasonIdList = tsListTmp.stream().map(t -> t.getReasonId()).collect(Collectors.toList());
        TimesheetQuery timesheetQuery2 = new TimesheetQuery();
        timesheetQuery2.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
        timesheetQuery2.setReasonIdList(reasonIdList);
        List<TimesheetVO> tsViewsAll = this.queryList(timesheetQuery2);
        ArrayList<TimesheetVO> twVoList = new ArrayList<TimesheetVO>();
        twVoList.addAll(tsViewsAll);
        for (TimesheetPayload timesheetPayload : tsListTmp) {
            long count = tsViewsAll.stream().filter(ts -> ts.getId().equals(timesheetPayload.getId())).count();
            if (count >= 1L) continue;
            TimesheetVO timesheetVO = TimesheetConvert.INSTANCE.payloadToVo(timesheetPayload);
            twVoList.add(timesheetVO);
        }
        Map dayUsedMapTemp = dayUsedMap = (Map)twVoList.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getProjContractTimeSheet()), HashMap::putAll);
        Map<Long, List<TimesheetVO>> reasonTsMap = twVoList.stream().collect(Collectors.groupingBy(TimesheetVO::getReasonId));
        Set<Long> reasonIdSet = reasonTsMap.keySet();
        for (Long resonId : reasonIdSet) {
            BigDecimal bigDecimal = reasonTsMap.get(resonId).stream().map(ts -> dayUsedMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : (BigDecimal)dayUsedMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
        }
        return null;
    }

    private String validateBuAndOppoProjectTaskEqva(List<TimesheetPayload> timesheetPayloadList) {
        List tsListTmp = timesheetPayloadList.stream().filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0L && (ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode()) || ts.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode()))).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        List taskIdList = tsListTmp.stream().map(t -> t.getTaskId()).collect(Collectors.toList());
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setIdList(taskIdList);
        List taskVOList = this.taskInfoService.queryListCommon(taskInfoQuery);
        Map<Long, BigDecimal> tsEffectiveEqva = taskVOList.stream().collect(Collectors.toMap(BaseViewModel::getId, TaskInfoVO::getEffectiveEqva));
        tsListTmp.stream().forEach(ts -> {
            if (ts.getId() == null) {
                ts.setId(Long.valueOf(Math.round(Math.random() * 1.0E8) * -1L));
            }
        });
        List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        Map<Long, BigDecimal> tsEqvaMap = this.calTsUsedEqvasByTsIds(tsIds);
        List tsTemp = tsListTmp.stream().filter(ts -> ts.getId() < 0L).collect(Collectors.toList());
        if (tsTemp != null || tsTemp.size() > 0) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<Long, BigDecimal>();
            }
            for (TimesheetPayload ts2 : tsTemp) {
                BigDecimal eqva = this.calTsUsedEqvasByTsDetail(ts2.getWorkDate(), ts2.getTsUserId(), ts2.getTaskId(), ts2.getWorkHour());
                tsEqvaMap.put(ts2.getId(), eqva);
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;
        Map<Long, List<TimesheetPayload>> taskTsMap = tsListTmp.stream().collect(Collectors.groupingBy(TimesheetPayload::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            BigDecimal tsSubmitEqva = taskTsMap.get(taskId).stream().map(ts -> tsEqvaMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : (BigDecimal)tsEqvaMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
            log.info("\u5f53\u524d\u4efb\u52a1\u5305\u4e0b\u6240\u6709\u5de5\u65f6\u4e0a\u62a5\u7684\u603b\u5f53\u91cf:" + tsSubmitEqva);
            log.info("\u8ba1\u7b97\u4efb\u52a1\u5305\u5269\u4f59\u53ef\u7528\u4e8e\u586b\u62a5\u5de5\u65f6\u7684\u5f53\u91cf:" + tsEffecttiveEqva);
            if (tsSubmitEqva == null || tsEffecttiveEqva == null || !(tsSubmitEqva.doubleValue() > tsEffecttiveEqva.doubleValue())) continue;
            String taskName = taskVOList.stream().filter(t -> t.getId().equals(taskId)).map(t -> t.getTaskName()).findAny().get();
            return "\u4efb\u52a1\u5305\u5f53\u91cf\u4e0d\u8db3\uff01\u672c\u6b21\u586b\u62a5\u7684\u4efb\u52a1\u5305\u3010" + taskName + "\u3011\u603b\u7684\u5de5\u65f6\u5f53\u91cf\u3010" + tsSubmitEqva + "\u3011\u5927\u4e8e\u4efb\u52a1\u5305\u5269\u4f59\u53ef\u7528\u4e8e\u5de5\u65f6\u586b\u62a5\u7684\u5f53\u91cf\u3010" + tsEffecttiveEqva + "\u3011\uff0c\u8bf7\u586b\u62a5\u5176\u4ed6\u4efb\u52a1\u5305\u6216\u5411\u53d1\u5305\u4eba\u7533\u8bf7\u7ed9\u4efb\u52a1\u5305\u8ffd\u52a0\u5f53\u91cf";
        }
        return null;
    }

    private void updatePmsTaskInfoByTimesheetPayload(TimesheetPayload timesheetPayload) {
        Long taskId = timesheetPayload.getTaskId();
        Long tsUserId = timesheetPayload.getTsUserId();
        BigDecimal workHour = timesheetPayload.getWorkHour();
        this.taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, workHour, "1");
    }

    private void updatePmsTaskInfoByTimesheetEntity(TimesheetDO entity, TimesheetStatus approved) {
        Long taskId = entity.getTaskId();
        Long tsUserId = entity.getTsUserId();
        BigDecimal workHour = entity.getWorkHour();
        if (null == entity.getTaskId()) {
            return;
        }
        TimesheetPayload timesheetPayload = new TimesheetPayload();
        timesheetPayload.setId(entity.getId());
        timesheetPayload.setWorkDate(entity.getWorkDate());
        timesheetPayload.setWorkDesc(entity.getWorkDesc());
        if (TimesheetStatus.APPROVED.getCode().equals(approved.getCode())) {
            this.taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, workHour, "2");
        } else if (TimesheetStatus.REJECTED.getCode().equals(approved.getCode()) || TimesheetStatus.CREATE.getCode().equals(approved.getCode())) {
            BigDecimal negativeNumberWorkHour = workHour.negate();
            this.taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, negativeNumberWorkHour, "1");
        } else if (TimesheetStatus.APPROVED_TO_CREATE.getCode().equals(approved.getCode())) {
            BigDecimal negativeNumberWorkHour = workHour.negate();
            this.taskCommonService.updateTimeSheet(timesheetPayload, taskId, tsUserId, negativeNumberWorkHour, "2");
        }
    }

    private List<TimesheetVO> validateDevOpsEqva(TimesheetListPayload payload, List<TimesheetPayload> timesheetList) {
        List timesheetPayloadList = payload.getTimesheetList().stream().filter(timesheetPayload -> this.tsStatusCheck((TimesheetPayload)timesheetPayload) && timesheetPayload.getProjId() > 0L && timesheetPayload.getTaskId() == null && StringUtils.hasText((String)timesheetPayload.getType()) && timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(timesheetPayloadList)) {
            return null;
        }
        List timesheetVOS = this.taskCommonService.bw8TimeSheetSubmit(timesheetPayloadList);
        if (!CollectionUtils.isEmpty((Collection)timesheetVOS)) {
            timesheetList.forEach(timesheetPayload -> {
                Long id = timesheetPayload.getId();
                if (StringUtils.hasText((String)timesheetPayload.getType()) && timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode())) {
                    timesheetVOS.stream().filter(timesheetVO -> timesheetVO.getId().equals(id)).forEach(timesheetVO -> {
                        if (timesheetVO.getTaskPackageId() == null || timesheetVO.getTaskId() == null) {
                            log.error("\u5e2e\u6211\u5427\u5de5\u65f6\u751f\u6210\u4efb\u52a1\u5f02\u5e38");
                            throw TwException.error("500", "\u5e2e\u6211\u5427\u5de5\u65f6\u751f\u6210\u4efb\u52a1\u5f02\u5e38");
                        }
                        timesheetPayload.setTaskPackageId(timesheetVO.getTaskPackageId());
                        timesheetPayload.setTaskId(timesheetVO.getTaskId());
                    });
                }
            });
        }
        return timesheetVOS;
    }

    private void doShiftingTimesheetList(List<TimesheetPayload> timesheetPayloadList, boolean submitted) {
        OvertimeApplicationDO overtimeApplicationDO;
        for (TimesheetPayload timesheetPayload : timesheetPayloadList) {
            overtimeApplicationDO = (OvertimeApplicationDO)((Object)this.overtimeApplicationRepo.findById(Long.valueOf(timesheetPayload.getExt2())).get());
            if (!RestStatusEnum.CREATE.getCode().equals(overtimeApplicationDO.getRestStatus())) {
                throw TwException.error("500", "\u5de5\u4f5c\u8ba1\u5212\u65f6\u95f4\u5df2\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9!");
            }
            if (timesheetPayload.getWorkHour().compareTo(overtimeApplicationDO.getOvertimeWorkHour()) <= 0) continue;
            throw TwException.error("500", "\u8c03\u4f11\u65f6\u95f4\u5927\u4e8e\u5de5\u4f5c\u8ba1\u5212\u65f6\u95f4,\u8bf7\u91cd\u65b0\u586b\u5199!");
        }
        if (submitted) {
            for (TimesheetPayload timesheetPayload : timesheetPayloadList) {
                overtimeApplicationDO = new OvertimeApplicationDO();
                overtimeApplicationDO.setRestStatus(RestStatusEnum.REST_APPROVING.getCode());
                overtimeApplicationDO.setRestDate(timesheetPayload.getWorkDate());
                overtimeApplicationDO.setId(Long.valueOf(timesheetPayload.getExt2()));
                this.overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
            }
        }
        for (TimesheetPayload timesheetPayload : timesheetPayloadList) {
            this.initData(timesheetPayload);
            TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(timesheetPayload);
            entityDo.setExt2(timesheetPayload.getExt2());
            entityDo.setTsUserId(GlobalUtil.getLoginUserId());
            this.timesheetRepo.save((Object)entityDo);
        }
    }

    private void checkWorkDate(TimesheetListPayload payload) {
        long count;
        LocalDate now = LocalDate.now();
        List timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty((Collection)timesheetList) && (count = timesheetList.stream().filter(timesheetPayload -> timesheetPayload.getWorkDate().isAfter(now)).count()) > 0L) {
            throw TwException.error("", "\u4e0d\u5141\u8bb8\u63d0\u524d\u63d0\u4ea4\u5de5\u65f6");
        }
    }

    private boolean tsStatusCheck(TimesheetPayload timesheetPayload) {
        timesheetPayload.setTsUserId(GlobalUtil.getLoginUserId());
        boolean flag = timesheetPayload.getTsStatus() != null && (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()));
        return flag;
    }

    private BigDecimal calTsUsedEqvasByTsDetail(LocalDate workDate, Long tsUserId, Long taskId, BigDecimal workHour) {
        TaskInfoVO taskInfoVO;
        if (workDate == null || taskId == null) {
            return null;
        }
        if (workDate == null) {
            return null;
        }
        if (tsUserId == null) {
            tsUserId = GlobalUtil.getLoginUserId();
        }
        if ((taskInfoVO = this.taskInfoService.queryByKey(taskId, Boolean.valueOf(true))) == null) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
        }
        BigDecimal eqvaRatio = taskInfoVO.getEqvaRatio();
        if (eqvaRatio == null) {
            eqvaRatio = this.employeeEqvaRatioService.getEqvaRatio(tsUserId, workDate);
        }
        if (eqvaRatio == null) {
            throw TwException.error("", "\u5f53\u91cf\u7cfb\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8L);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8L), 4, RoundingMode.DOWN);
    }

    private BigDecimal calProjTsUsedEqvasByTsDetail(LocalDate workDate, BigDecimal eqvaRatio, Long projId, BigDecimal workHour) {
        if (workDate == null || projId == null) {
            return null;
        }
        if (eqvaRatio == null) {
            return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8L);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8L), 2, RoundingMode.DOWN);
    }

    private Map<Long, BigDecimal> calTsUsedEqvasByIds(List<Long> taskIdList) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTaskIdList(taskIdList);
        ArrayList<String> tsStatusList = new ArrayList<String>();
        tsStatusList.add(TimesheetStatus.APPROVED.getCode());
        tsStatusList.add(TimesheetStatus.APPROVING.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        List<Object> tsViews = this.queryList(timesheetQuery);
        if (tsViews == null || tsViews.size() == 0) {
            return null;
        }
        Map<Long, BigDecimal> tsEqvaMap = this.calTsUsedEqvasByTsIds(tsViews.stream().map(ts -> ts.getId()).collect(Collectors.toList()));
        tsViews = tsViews.stream().map(ts -> {
            ts.setEqvaTimeSheet((BigDecimal)tsEqvaMap.get(ts.getId()));
            return ts;
        }).collect(Collectors.toList());
        HashMap<Long, BigDecimal> returnMap = new HashMap<Long, BigDecimal>();
        Map<Long, List<TimesheetVO>> taskTsMap = tsViews.stream().collect(Collectors.groupingBy(TimesheetVO::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            returnMap.put(taskId, taskTsMap.get(taskId).stream().map(ts -> ts.getEqvaTimeSheet() == null ? BigDecimal.ZERO : ts.getEqvaTimeSheet()).reduce(BigDecimal::add).get());
        }
        return returnMap;
    }

    private Map<Long, BigDecimal> calTsUsedEqvasByTsIds(List<Long> timeSheetIds) {
        log.warn("debug:::\u76ee\u6807\u64cd\u4f5c\u7684\u5de5\u65f6\u5217\u8868" + timeSheetIds);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        List<TimesheetVO> tsViews = this.queryList(timesheetQuery);
        for (TimesheetVO v : tsViews) {
            v.setEqvaRatio(null);
            TaskInfoVO taskInfoVO = this.taskInfoService.queryByKey(v.getTaskId(), Boolean.valueOf(true));
            Assert.notNull((Object)taskInfoVO, (String)"\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
            BigDecimal eqvaRatio = taskInfoVO.getEqvaRatio();
            if (null == eqvaRatio && null == (eqvaRatio = this.employeeEqvaRatioService.getEqvaRatio(v.getTsUserId(), v.getWorkDate()))) {
                throw TwException.error("", "\u5f53\u91cf\u7cfb\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            }
            v.setEqvaRatio(eqvaRatio);
        }
        return tsViews.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getEqvaTimeSheet()), HashMap::putAll);
    }

    private boolean workHourValidate(TimesheetListPayload payload) {
        Map<LocalDate, Double> resultMap = payload.getTimesheetList().stream().filter(timesheetPayload -> timesheetPayload.getTsStatus() != null && (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()))).collect(Collectors.groupingBy(TimesheetPayload::getWorkDate, Collectors.summingDouble(TimesheetPayload::getDoubleWorkHour)));
        ArrayList isValid = new ArrayList();
        resultMap.forEach((date, workHour) -> {
            TimesheetQuery query = new TimesheetQuery();
            query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
            query.setTsUserId(GlobalUtil.getLoginUserId());
            query.setWorkDateQuery(date);
            List<TimesheetVO> timesheetVOList = this.queryList(query);
            Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
            if (workHour + wh > 8.0) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    private boolean workHourHolidayValidate(TimesheetListPayload payload) {
        List timesheetList = payload.getTimesheetList();
        List<LocalDate> workDateList = timesheetList.stream().map(timesheetPayload -> timesheetPayload.getWorkDate()).collect(Collectors.toList());
        List<LocalDate> vacationDayList = this.findVacationDayIn(workDateList);
        Map<LocalDate, List<TimesheetPayload>> localDateListMap = timesheetList.stream().filter(timesheetPayload -> {
            LocalDate workDate = timesheetPayload.getWorkDate();
            BigDecimal workHour = timesheetPayload.getWorkHour();
            long count = vacationDayList.stream().filter(vacationDay -> vacationDay.isEqual(workDate)).count();
            return count > 0L && workHour.compareTo(BigDecimal.ZERO) == 0;
        }).collect(Collectors.groupingBy(TimesheetPayload::getWorkDate));
        ArrayList isValid = new ArrayList();
        localDateListMap.forEach((date, timesheetPayloadList) -> {
            if (timesheetPayloadList.stream().count() > 1L) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    private void initData(TimesheetPayload payload) {
        List list;
        List<PrdOrgDataRefVO> prdOrgDataRefVOS;
        payload.setWorkDayOffStatus("UNGEN");
        payload.setWorkFlag("NO");
        payload.setSettleStatus("NONE");
        payload.setAutoSaveFlag(Integer.valueOf(0));
        if (payload.getTsUserId() == null) {
            payload.setTsUserId(GlobalUtil.getLoginUserId());
        }
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS = this.daoUser.queryOrgListByKey(payload.getTsUserId())) && !CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            String orgName = ((PrdOrgDataRefVO)list.get(0)).getOrgName();
            payload.setTsUserBuId(orgId);
            payload.setTsUserBuName(orgName);
        }
        if (null != payload.getProjId()) {
            PmsProjectVO projectVO = this.pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskPackageId() != null) {
            TaskPackageVO taskPackageVO = this.taskPackageService.queryByKey(payload.getTaskPackageId(), Boolean.valueOf(false));
            if (!StringUtils.hasText((String)payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty((Object)payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText((String)payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText((String)payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }
        if (payload.getStageId() != null) {
            PmsProjectActivityVO resActivityVO = this.pmsProjectActivityService.queryByKey(payload.getStageId());
            if (!StringUtils.hasText((String)payload.getStageNo())) {
                payload.setStageNo(null != resActivityVO ? resActivityVO.getActNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getStageName())) {
                payload.setStageName(null != resActivityVO ? resActivityVO.getActName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            TaskInfoVO taskVO = this.taskInfoService.queryByKey(payload.getTaskId(), Boolean.valueOf(true));
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getValidEqva() : null);
            }
        }
        if (null != payload.getOperPlanId()) {
            CrmOperationPlanDetailVO planDetailVO = this.crmOperationPlanDetailService.queryByKey(payload.getOperPlanId());
            if (!StringUtils.hasText((String)payload.getOperPlanName())) {
                payload.setOperPlanName(null != planDetailVO ? planDetailVO.getPlanName() : "");
            }
        }
        payload.setApprResult(null);
        if (payload.isSubmitted()) {
            payload.setTsStatus(TimesheetStatus.APPROVING.getCode());
            this.handleApprovalUser(payload);
            if (payload.getId() != null && payload.getId() > 0L) {
                entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
                payload.setSubmitTime(entity.getSubmitTime());
                if (entity.getSubmitTime() == null) {
                    payload.setSubmitTime(LocalDateTime.now());
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            payload.setLastSubmitTime(LocalDateTime.now());
        } else if (payload.getId() != null && payload.getId() > 0L) {
            entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
            payload.setSubmitTime(entity.getSubmitTime());
            payload.setLastSubmitTime(entity.getLastSubmitTime());
            payload.setTsStatus(entity.getTsStatus());
        } else {
            payload.setTsStatus(TimesheetStatus.CREATE.getCode());
        }
        if (payload.getWorkDate() != null) {
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()))));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
        this.calSubSidyAmt(payload);
    }

    private void calSubSidyAmt(TimesheetPayload payload) {
        TimesheetQuery query = new TimesheetQuery();
        query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
        query.setTsUserId(payload.getTsUserId());
        query.setWorkDateQuery(payload.getWorkDate());
        query.setTsTaskIden("VACATION");
        query.setTsActIden("LEGALHOLIDAY");
        List<TimesheetVO> timesheetVOList = this.queryList(query);
        Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
        String workDateType = SubsidyWorkDateTypeEnum.WORK.getCode();
        if (wh == 8.0) {
            workDateType = SubsidyWorkDateTypeEnum.HOLIDAY.getCode();
        }
        String holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
        String projectSubsidyRole = null;
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && workDateType.equals(SubsidyWorkDateTypeEnum.HOLIDAY.getCode())) {
            holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
            projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
            PmsProjectVO projectVO = this.pmsProjectService.queryByKeySimple(payload.getReasonId());
            Assert.notNull((Object)projectVO, (String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            Integer depreciationMonths = projectVO.getDepreciationMonths();
            if (null != depreciationMonths && depreciationMonths == 1) {
                projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
            }
        }
        TimesheetSubsidySettingQuery subsidySettingQuery = new TimesheetSubsidySettingQuery();
        subsidySettingQuery.setReasonType(payload.getReasonType());
        subsidySettingQuery.setWorkDateType(workDateType);
        subsidySettingQuery.setHolidaySubsidyType(holidaySubsidyType);
        subsidySettingQuery.setProjectSubsidyRole(projectSubsidyRole);
        subsidySettingQuery.setSubsidySelectTypeCode(payload.getExt4());
        List list = this.timesheetSubsidySettingService.queryListDynamic(subsidySettingQuery);
        if (list.size() < 1 && payload.getReasonId() != 0L) {
            log.error("\u672a\u5339\u914d\u5230\u5de5\u65f6\u8865\u8d34\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5t_timesheet_subsidy_setting\u6570\u636e");
            throw TwException.error("", "\u5de5\u65f6\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (list.size() != 1 && payload.getReasonId() != 0L) {
            log.error("\u5339\u914d\u5230\u591a\u6761\u5de5\u65f6\u8865\u8d34\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5t_timesheet_subsidy_setting\u6570\u636e");
            throw TwException.error("", "\u5de5\u65f6\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        TimesheetSubsidySettingVO timesheetSubsidySettingVO = (TimesheetSubsidySettingVO)list.get(0);
        BigDecimal workHourCal = timesheetSubsidySettingVO.getWorkHourCal();
        String subsidyStdType = timesheetSubsidySettingVO.getSubsidyStdType();
        BigDecimal subSidyAmt = BigDecimal.ZERO;
        if (StringUtils.hasText((String)subsidyStdType) && !subsidyStdType.equals(SubsidyStdTypeEnum.NO.getCode())) {
            PrdOrgEmployeeDO prdOrgEmployeeDO = this.prdOrgEmployeeDAO.queryByUserId(payload.getTsUserId());
            Assert.notNull((Object)prdOrgEmployeeDO, (String)"\u8d44\u6e90\u4e0d\u5b58\u5728");
            if (subsidyStdType.equals(SubsidyStdTypeEnum.TRAVEL.getCode())) {
                subSidyAmt = this.getSubsidy(payload.getTsUserId(), prdOrgEmployeeDO.getExtString11());
            } else if (subsidyStdType.equals(SubsidyStdTypeEnum.ON_SITE.getCode())) {
                subSidyAmt = this.getSubsidy(payload.getTsUserId(), prdOrgEmployeeDO.getExtString12());
            }
        }
        BigDecimal sumWorkHour = payload.getWorkHour().add(workHourCal);
        BigDecimal resultSubSidyAmt = sumWorkHour.divide(new BigDecimal(8)).multiply(subSidyAmt).setScale(2, RoundingMode.HALF_UP);
        payload.setSubsidyAmt(resultSubSidyAmt);
    }

    private BigDecimal getSubsidy(Long userId, String subsidyStr) {
        BigDecimal result = BigDecimal.ZERO;
        if (StringUtils.hasText((String)subsidyStr)) {
            try {
                result = new BigDecimal(subsidyStr);
            }
            catch (Exception e) {
                log.error("\u8d44\u6e90{}\u7ef4\u62a4\u7684\u8865\u52a9\u6807\u51c6\u683c\u5f0f\u9519\u8bef\uff1b\u9519\u8bef\u6570\u636e {}", (Object)userId, (Object)subsidyStr);
            }
        }
        return result;
    }

    public List<TimesheetSubsidySelectTypeVO> listWorkTypeExt4(LocalDate workDate, String reasonType, Long reasonId, Long tsUserId) {
        List<TimesheetSubsidySettingVO> list = this.getTimesheetSubsidySettingCommon(workDate, reasonType, reasonId, tsUserId);
        List<TimesheetSubsidySelectTypeVO> selectList = list.stream().map(vo -> {
            TimesheetSubsidySelectTypeVO selectTypeVO = new TimesheetSubsidySelectTypeVO(vo.getSubsidySelectTypeName(), vo.getSubsidySelectTypeCode(), vo.getSubsidySelectDefaultFlag());
            return selectTypeVO;
        }).collect(Collectors.toList());
        return selectList;
    }

    public List<TimesheetSubsidySelectTypeVO> listWorkHourSelect(LocalDate workDate, String reasonType, Long reasonId, Long tsUserId) {
        List<TimesheetSubsidySettingVO> list = this.getTimesheetSubsidySettingCommon(workDate, reasonType, reasonId, tsUserId);
        List selectList = list.stream().map(TimesheetSubsidySettingVO::getWorkHourSelect).collect(Collectors.toList());
        HashSet<String> set = new HashSet<String>();
        for (String temp2 : selectList) {
            String[] split;
            for (String s : split = temp2.split(",")) {
                set.add(s);
            }
        }
        List<TimesheetSubsidySelectTypeVO> collect = set.stream().sorted().map(vo -> {
            TimesheetSubsidySelectTypeVO selectTypeVO = new TimesheetSubsidySelectTypeVO(vo, vo);
            return selectTypeVO;
        }).collect(Collectors.toList());
        return collect;
    }

    private List<TimesheetSubsidySettingVO> getTimesheetSubsidySettingCommon(LocalDate workDate, String reasonType, Long reasonId, Long tsUserId) {
        if (workDate == null) {
            throw TwException.error("", "workDate\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reasonType)) {
            throw TwException.error("", "reasonType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == tsUserId) {
            tsUserId = GlobalUtil.getLoginUserId();
        }
        TimesheetQuery query = new TimesheetQuery();
        query.setTsUserId(tsUserId);
        query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
        query.setWorkDateQuery(workDate);
        query.setTsTaskIden("VACATION");
        query.setTsActIden("LEGALHOLIDAY");
        List<TimesheetVO> timesheetVOList = this.queryList(query);
        Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
        String workDateType = SubsidyWorkDateTypeEnum.WORK.getCode();
        if (wh == 8.0) {
            workDateType = SubsidyWorkDateTypeEnum.HOLIDAY.getCode();
        }
        String holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
        String projectSubsidyRole = null;
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            if (reasonId == null) {
                throw TwException.error("", "reasonId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reasonId == 0L) {
                return Collections.EMPTY_LIST;
            }
            if (workDateType.equals(SubsidyWorkDateTypeEnum.HOLIDAY.getCode())) {
                holidaySubsidyType = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
                projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.N.getCode();
                PmsProjectVO projectVO = this.pmsProjectService.queryByKeySimple(reasonId);
                Assert.notNull((Object)projectVO, (String)"\u9879\u76ee\u4e0d\u5b58\u5728");
                Integer depreciationMonths = projectVO.getDepreciationMonths();
                if (null != depreciationMonths && depreciationMonths == 1) {
                    projectSubsidyRole = SubsidyHolidaySubsidyTypeTypeEnum.Y.getCode();
                }
            }
        }
        TimesheetSubsidySettingQuery subsidySettingQuery = new TimesheetSubsidySettingQuery();
        subsidySettingQuery.setReasonType(reasonType);
        subsidySettingQuery.setWorkDateType(workDateType);
        subsidySettingQuery.setHolidaySubsidyType(holidaySubsidyType);
        subsidySettingQuery.setProjectSubsidyRole(projectSubsidyRole);
        List list = this.timesheetSubsidySettingService.queryListDynamic(subsidySettingQuery);
        return list;
    }

    private void handleApprovalUser(TimesheetPayload payload) {
        TsApprovalConfigService tsApprovalConfigService = (TsApprovalConfigService)SpringUtil.getBean(TsApprovalConfigService.class);
        LocalDate workDate = payload.getWorkDate();
        int year = workDate.getYear();
        List tsApprovalResPayloads = tsApprovalConfigService.queryApprovalResDib(payload.getReasonId(), payload.getReasonType(), payload.getTsUserId(), Integer.valueOf(year));
        for (TsApprovalResPayload tsApprovalResPayload : tsApprovalResPayloads) {
            tsApprovalResPayload.setTimesheetId(payload.getId());
            this.tsApprovalResService.insert(tsApprovalResPayload);
            if (!tsApprovalResPayload.getApprovalStatus().equals("APPROVING")) continue;
            payload.setApprUserId(tsApprovalResPayload.getApprovalResId());
        }
    }

    private Long findApprUserId(TimesheetPayload payload) {
        Long apprUserId = null;
        if (payload.getTaskId() != null) {
            Long disterResId;
            TaskInfoVO taskInfoVO = this.taskInfoService.queryByKey(payload.getTaskId(), Boolean.valueOf(false));
            if (null != taskInfoVO && (disterResId = taskInfoVO.getDisterResId()) != null && disterResId >= 0L) {
                apprUserId = disterResId;
            }
        } else if (payload.getProjId() != null) {
            Long pmId;
            PmsProjectQuery twProjectQuery = new PmsProjectQuery();
            twProjectQuery.setId(payload.getProjId());
            List projects = this.pmsProjectService.queryListDynamic(twProjectQuery);
            if (projects != null && projects.size() > 0 && (pmId = ((PmsProjectVO)projects.get(0)).getPmResId()) != null && pmId > 0L) {
                apprUserId = pmId;
            }
        }
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(payload.getTsUserId());
        if (null == userDefaultOrg) {
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (apprUserId == null) {
            apprUserId = userDefaultOrg.getManageId();
        }
        if (apprUserId.longValue() == payload.getTsUserId().longValue()) {
            if (StringUtils.hasText((String)userDefaultOrg.getBuLevel()) && userDefaultOrg.getBuLevel().equals(OrgEnum.BuLevel.BU_LEVEL1.getCode())) {
                if (userDefaultOrg.getManageId().longValue() != apprUserId.longValue()) {
                    apprUserId = userDefaultOrg.getManageId();
                }
            } else {
                apprUserId = userDefaultOrg.getManageId();
            }
        }
        return apprUserId;
    }

    private Long findApprUserId0(TimesheetPayload payload) {
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
        Long disterResId;
        TaskInfoVO taskInfoVO;
        if (payload.getTaskId() != null && null != (taskInfoVO = this.taskInfoService.queryByKey(payload.getTaskId(), Boolean.valueOf(false))) && (disterResId = taskInfoVO.getDisterResId()) != null && disterResId >= 0L) {
            return disterResId;
        }
        if (payload.getProjId() != null) {
            Long pmId;
            PmsProjectQuery twProjectQuery = new PmsProjectQuery();
            twProjectQuery.setId(payload.getProjId());
            List projects = this.pmsProjectService.queryListDynamic(twProjectQuery);
            if (projects != null && projects.size() > 0 && (pmId = ((PmsProjectVO)projects.get(0)).getPmResId()) != null && pmId > 0L) {
                return pmId;
            }
        }
        if (null == (prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(payload.getTsUserId()))) {
            log.error("\u3010\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\u3011\uff1a\u5de5\u65f6\u586b\u62a5\u7528\u6237\u4e3b\u952e\uff1a{} ; \u5de5\u65f6\u6570\u636e\uff1a{}", (Object)payload.getTsUserId(), (Object)payload);
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Long tsUserBuId = payload.getTsUserBuId();
        PrdOrgOrganizationDO prdOrgOrganizationDO = this.prdOrgOrganizationDAO.queryById(tsUserBuId);
        String organizationType = prdOrgOrganizationDO.getOrganizationType();
        if (organizationType != null) {
            Long apprUserId = null;
            switch (organizationType) {
                case "BD": 
                case "BY": {
                    List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(payload.getTsUserId());
                    Set orgIdList = null;
                    if (!CollectionUtils.isEmpty(organizationDOList)) {
                        orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                        if (orgIdList.contains(tsUserBuId)) {
                            Long parentId = prdOrgEmployeeRefVO.getParentId();
                            return parentId;
                        }
                        Long manageId = prdOrgEmployeeRefVO.getManageId();
                        return manageId;
                    }
                    apprUserId = prdOrgEmployeeRefVO.getManageId();
                    break;
                }
                case "BM": 
                case "BS": {
                    apprUserId = prdOrgEmployeeRefVO.getParentId();
                }
            }
            return apprUserId;
        }
        Long parentId = prdOrgEmployeeRefVO.getParentId();
        return parentId;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetVO update(TimesheetPayload payload) {
        if (payload.getProjId() != null) {
            PmsProjectVO projectVO = this.pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskPackageId() != null) {
            TaskPackageVO taskPackageVO = this.taskPackageService.queryByKey(payload.getTaskPackageId(), Boolean.valueOf(false));
            if (!StringUtils.hasText((String)payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty((Object)payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText((String)payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText((String)payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }
        if (payload.getTaskId() != null) {
            TaskInfoVO taskVO = this.taskInfoService.queryByKey(payload.getTaskId(), Boolean.valueOf(true));
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getValidEqva() : null);
            }
        }
        TimesheetDO entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetConvert.INSTANCE.toVo((TimesheetDO)((Object)this.timesheetRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u521b\u5efa\u6216\u8005\u9000\u56de\u7684\u5de5\u65f6");
                    }
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText((String)overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {
                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.CREATE.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        this.overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }
                }
            });
            this.timesheetDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void toApproved(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
                    }
                    TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
                    tsApprovalResQuery.setTimesheetId(id);
                    tsApprovalResQuery.setApprovalStatus(TimesheetStatus.APPROVING.getCode());
                    List tsApprovalResVOS = this.tsApprovalResService.queryListDynamic(tsApprovalResQuery);
                    if (!CollectionUtils.isEmpty((Collection)tsApprovalResVOS)) {
                        TsApprovalResVO tsApprovalResVO = (TsApprovalResVO)tsApprovalResVOS.get(0);
                        if (!GlobalUtil.getLoginUserId().equals(tsApprovalResVO.getApprovalResId())) {
                            throw TwException.error("", "\u5ba1\u6279\u4eba\u9519\u8bef");
                        }
                        Integer lastFlag = tsApprovalResVO.getLastFlag();
                        TsApprovalResPayload approvalResPayload = new TsApprovalResPayload();
                        approvalResPayload.setId(tsApprovalResVO.getId());
                        if (tsApprovalResVO.getFristApprovalTime() == null) {
                            approvalResPayload.setFristApprovalTime(LocalDateTime.now());
                        }
                        approvalResPayload.setApprovalTime(LocalDateTime.now());
                        if (lastFlag == 1) {
                            approvalResPayload.setApprovalStatus(TimesheetStatus.APPROVED.getCode());
                            entity.setApprUserId(null);
                            entity.setTsStatus("APPROVED");
                            entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                            entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                            entity.setApprovalTime(LocalDateTime.now());
                            this.timesheetRepo.save((Object)entity);
                            this.updatePmsTaskInfoByTimesheetEntity(entity, TimesheetStatus.APPROVED);
                        } else {
                            approvalResPayload.setApprovalStatus(TimesheetStatus.APPROVED.getCode());
                            Integer sortIndex = tsApprovalResVO.getSortIndex() + 1;
                            tsApprovalResQuery = new TsApprovalResQuery();
                            tsApprovalResQuery.setTimesheetId(id);
                            tsApprovalResQuery.setSortIndex(sortIndex);
                            tsApprovalResVOS = this.tsApprovalResService.queryListDynamic(tsApprovalResQuery);
                            if (!CollectionUtils.isEmpty((Collection)tsApprovalResVOS)) {
                                TsApprovalResVO nextTsApprovalResVO = (TsApprovalResVO)tsApprovalResVOS.get(0);
                                TsApprovalResPayload nextApprovalResPayload = new TsApprovalResPayload();
                                nextApprovalResPayload.setId(nextTsApprovalResVO.getId());
                                nextApprovalResPayload.setApprovalStatus(TimesheetStatus.APPROVING.getCode());
                                this.tsApprovalResService.updateByKeyDynamic(nextApprovalResPayload);
                                entity.setApprUserId(nextTsApprovalResVO.getApprovalResId());
                                this.timesheetRepo.save((Object)entity);
                            } else {
                                throw TwException.error("", "\u83b7\u53d6\u4e0b\u4e00\u4e2a\u5ba1\u6279\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                            }
                        }
                        this.tsApprovalResService.updateByKeyDynamic(approvalResPayload);
                    } else {
                        entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                        entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                        entity.setApprovalTime(LocalDateTime.now());
                        this.timesheetRepo.save((Object)entity);
                        this.updatePmsTaskInfoByTimesheetEntity(entity, TimesheetStatus.APPROVED);
                    }
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText((String)overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {
                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.RESTED.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        this.overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void toAdvanced(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u6216\u65b0\u5efa\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                    this.timesheetRepo.save((Object)entity);
                    this.updatePmsTaskInfoByTimesheetEntity(entity, TimesheetStatus.APPROVED);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejected(List<Long> keys, String apprResult) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u62d2\u7edd");
                    }
                    this.tsApprovalResService.deleteSoftByTimesheetId(id);
                    entity.setApprUserId(null);
                    entity.setTsStatus(TimesheetStatus.REJECTED.getCode());
                    entity.setApprResult(apprResult);
                    this.timesheetRepo.save((Object)entity);
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText((String)overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {
                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.REJECTED.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        this.overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }
                    this.updatePmsTaskInfoByTimesheetEntity(entity, TimesheetStatus.REJECTED);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void revoked(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u64a4\u56de");
                    }
                    if (entity.getReturnFlag() != null && !entity.getReturnFlag().booleanValue()) {
                        throw TwException.error("", "\u8be5\u5de5\u65f6\u4e0d\u5141\u8bb8\u64a4\u56de");
                    }
                    this.tsApprovalResService.deleteSoftByTimesheetId(id);
                    entity.setTsStatus(TimesheetStatus.CREATE.getCode());
                    entity.setApprUserId(null);
                    entity.setApprResult("\u5ba1\u6279\u64a4\u56de");
                    this.timesheetRepo.save((Object)entity);
                    this.updatePmsTaskInfoByTimesheetEntity(entity, TimesheetStatus.CREATE);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskTimesheetEqva(List<Long> taskIdList) {
    }

    public void updateTaskTimesheetEqva(List<Long> taskIdList, TimesheetStatus timesheetStatus) {
        if (!CollectionUtils.isEmpty(taskIdList)) {
            HashSet<Long> taskIdsSet = new HashSet<Long>();
            taskIdsSet.addAll(taskIdList);
            for (Long l : taskIdsSet) {
            }
        }
    }

    public Map<Long, Long> getTimesheetAndPlanIds() {
        HashMap<Long, Long> orgMap = new HashMap<Long, Long>();
        List<Map<String, Object>> timeSheetAndPlanIds = this.timesheetRepo.getTimesheetAndPlanIds();
        for (Map<String, Object> timesheetAndPlanId : timeSheetAndPlanIds) {
            Long timesheetId = (Long)timesheetAndPlanId.get("timesheetId");
            Long workPlanId = (Long)timesheetAndPlanId.get("workPlanId");
            if (timesheetId == null || workPlanId == null) continue;
            orgMap.put(timesheetId, workPlanId);
        }
        return orgMap;
    }

    public Map<Long, Long> getV4AndV5TimesheetIds() {
        HashMap<Long, Long> timesheetMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5TimesheetIds = this.timesheetRepo.getV4AndV5TimesheetIds();
        for (Map<String, Object> v4AndV5TimesheetId : v4AndV5TimesheetIds) {
            Long timesheetId = (Long)v4AndV5TimesheetId.get("timesheetId");
            Long timesheetIdV4 = (Long)v4AndV5TimesheetId.get("timesheetIdV4");
            if (timesheetId == null || timesheetIdV4 == null) continue;
            timesheetMap.put(timesheetIdV4, timesheetId);
        }
        return timesheetMap;
    }

    public String timesheetAlertAll() {
        List<PrdOrgEmployeeDO> onJobUsers = this.prdOrgEmployeeDAO.getOnJobUser();
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate yesterday = LocalDate.now().minusDays(1L);
        LocalDate workDay = firstDayMonth;
        long difference = LocalDate.now().toEpochDay() - firstDayMonth.toEpochDay();
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        ArrayList<String> sendLogList = new ArrayList<String>();
        ArrayList<String> unSendLogList = new ArrayList<String>();
        if (difference >= 0L) {
            while (workDay.isBefore(LocalDate.now())) {
                dateList.add(workDay);
                workDay = workDay.plusDays(1L);
            }
            for (PrdOrgEmployeeDO user : onJobUsers) {
                HashSet unWritedSet;
                List<LocalDate> writeDateList;
                LocalDate enrollDate = user.getEnrollDate();
                if (!ObjectUtils.isEmpty((Object)enrollDate)) {
                    if (enrollDate.isBefore(firstDayMonth)) {
                        writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, yesterday);
                        unWritedSet = new HashSet(dateList);
                    } else if (enrollDate.isAfter(yesterday)) {
                        writeDateList = new ArrayList<LocalDate>(0);
                        unWritedSet = new HashSet(0);
                    } else {
                        ArrayList<LocalDate> enDateList = new ArrayList<LocalDate>();
                        while (enrollDate.isBefore(yesterday.plusDays(1L))) {
                            enDateList.add(enrollDate);
                            enrollDate = enrollDate.plusDays(1L);
                        }
                        writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, yesterday);
                        unWritedSet = new HashSet(enDateList);
                    }
                } else {
                    writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, yesterday);
                    unWritedSet = new HashSet(dateList);
                }
                HashSet<LocalDate> writedSet = new HashSet<LocalDate>(writeDateList);
                unWritedSet.removeAll(writedSet);
                if (unWritedSet.size() <= 0) continue;
                List unWriteDateList = unWritedSet.stream().toList();
                String content = "\u60a8" + unWriteDateList + "\u5de5\u65f6\u672a\u586b\u5199,\u8bf7\u53ca\u65f6\u586b\u5199";
                String employeeName = user.getEmployeeName();
                boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(user.getWecomId(), content);
                if (sendFlag) {
                    sendLogList.add(employeeName);
                    continue;
                }
                unSendLogList.add(employeeName);
            }
        }
        return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
    }

    public String timesheetAlertSuperior() {
        List<PrdOrgEmployeeDO> onJobUsers = this.prdOrgEmployeeDAO.getOnJobUser();
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastThreeDay = LocalDate.now().minusDays(3L);
        LocalDate workDay = firstDayMonth;
        List<PrdOrgEmployeeSuperiorQuery> userSuperiorList = this.prdOrgEmployeeDAO.getUserSuperior();
        Map<Long, Long> userSuperiorMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getEmployeeId, PrdOrgEmployeeSuperiorQuery::getSuperiorId));
        Map<Long, String> superiorNameMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorName, (val1, val2) -> val2));
        Map<Long, String> superiorWxMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorWxId, (val1, val2) -> val2));
        HashMap<Long, Object> superiorMap = new HashMap<Long, Object>();
        ArrayList<CallSite> sendLogList = new ArrayList<CallSite>();
        ArrayList<CallSite> unSendLogList = new ArrayList<CallSite>();
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        long difference = lastThreeDay.toEpochDay() - firstDayMonth.toEpochDay();
        if (difference >= 0L) {
            while (workDay.isBefore(lastThreeDay.plusDays(1L))) {
                dateList.add(workDay);
                workDay = workDay.plusDays(1L);
            }
            for (PrdOrgEmployeeDO user : onJobUsers) {
                HashSet unWritedSet;
                List<LocalDate> writeDateList;
                if (!userSuperiorMap.containsKey(user.getUserId())) continue;
                LocalDate enrollDate = user.getEnrollDate();
                if (!ObjectUtils.isEmpty((Object)enrollDate)) {
                    if (enrollDate.isBefore(firstDayMonth)) {
                        writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                        unWritedSet = new HashSet(dateList);
                    } else if (enrollDate.isAfter(lastThreeDay)) {
                        writeDateList = new ArrayList<LocalDate>(0);
                        unWritedSet = new HashSet(0);
                    } else {
                        ArrayList<LocalDate> enDateList = new ArrayList<LocalDate>();
                        while (enrollDate.isBefore(lastThreeDay.plusDays(1L))) {
                            enDateList.add(enrollDate);
                            enrollDate = enrollDate.plusDays(1L);
                        }
                        writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                        unWritedSet = new HashSet(enDateList);
                    }
                } else {
                    writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                    unWritedSet = new HashSet(dateList);
                }
                HashSet<LocalDate> writedSet = new HashSet<LocalDate>(writeDateList);
                unWritedSet.removeAll(writedSet);
                if (unWritedSet.size() <= 0) continue;
                String userContent = user.getEmployeeName();
                Long superiorId = userSuperiorMap.get(user.getUserId());
                if (superiorMap.containsKey(superiorId)) {
                    Object content = (String)superiorMap.get(superiorId);
                    content = (String)content + "," + userContent;
                    superiorMap.put(superiorId, content);
                    continue;
                }
                superiorMap.put(superiorId, userContent);
            }
            for (Long superiorId : superiorMap.keySet()) {
                String content = "\u60a8\u7684\u4e0b\u7ea7\u3010" + (String)superiorMap.get(superiorId) + "\u3011 \u5de5\u65f6\u5df2\u957f\u65f6\u95f4\u5ef6\u8bef\u672a\u586b\u5199\uff0c\u8bf7\u5e2e\u5fd9\u8ddf\u50ac\u4ee5\u514d\u5f71\u54cd\u5de5\u65f6\u7ed3\u7b97\u3002";
                boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(superiorWxMap.get(superiorId), content);
                String log = superiorNameMap.get(superiorId) + ":\u3010" + (String)superiorMap.get(superiorId) + "\u3011\n";
                if (sendFlag) {
                    sendLogList.add((CallSite)((Object)log));
                    continue;
                }
                unSendLogList.add((CallSite)((Object)log));
            }
        }
        return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
    }

    public String timesheetAlertBuLeader() {
        List<PrdOrgEmployeeDO> onJobUsers = this.prdOrgEmployeeDAO.getOnJobUser();
        LocalDate lastMonday = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).minusDays(7L);
        LocalDate lastFriday = lastMonday.plusDays(4L);
        LocalDate workDay = lastMonday;
        List<PrdOrgEmployeeLeaderQuery> userBuLeaderList = this.prdOrgEmployeeDAO.getUserBuLeader();
        Map<Long, Long> userBuLeaderMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getEmployeeId, PrdOrgEmployeeLeaderQuery::getOrgLeaderId));
        Map<Long, String> userBuLeaderNameMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderName, (val1, val2) -> val2));
        Map<Long, String> buLeaderWxMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderWxId, (val1, val2) -> val2));
        HashMap<Long, Object> buLeaderMap = new HashMap<Long, Object>();
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        ArrayList<CallSite> sendLogList = new ArrayList<CallSite>();
        ArrayList<CallSite> unSendLogList = new ArrayList<CallSite>();
        while (workDay.isBefore(lastFriday.plusDays(1L))) {
            dateList.add(workDay);
            workDay = workDay.plusDays(1L);
        }
        for (PrdOrgEmployeeDO user : onJobUsers) {
            HashSet unWritedSet;
            List<LocalDate> writeDateList;
            if (!userBuLeaderMap.containsKey(user.getUserId())) continue;
            LocalDate enrollDate = user.getEnrollDate();
            if (!ObjectUtils.isEmpty((Object)enrollDate)) {
                if (enrollDate.isBefore(lastMonday)) {
                    writeDateList = this.timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                    unWritedSet = new HashSet(dateList);
                } else if (enrollDate.isAfter(lastFriday)) {
                    writeDateList = new ArrayList<LocalDate>(0);
                    unWritedSet = new HashSet(0);
                } else {
                    ArrayList<LocalDate> enDateList = new ArrayList<LocalDate>();
                    while (enrollDate.isBefore(lastFriday.plusDays(1L))) {
                        enDateList.add(enrollDate);
                        enrollDate = enrollDate.plusDays(1L);
                    }
                    writeDateList = this.timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                    unWritedSet = new HashSet(enDateList);
                }
            } else {
                writeDateList = this.timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                unWritedSet = new HashSet(dateList);
            }
            HashSet<LocalDate> writedSet = new HashSet<LocalDate>(writeDateList);
            unWritedSet.removeAll(writedSet);
            if (unWritedSet.size() <= 0) continue;
            String userContent = user.getEmployeeName();
            Long buLeaderId = userBuLeaderMap.get(user.getUserId());
            if (buLeaderMap.containsKey(buLeaderId)) {
                Object content = (String)buLeaderMap.get(buLeaderId);
                content = (String)content + "," + userContent;
                buLeaderMap.put(buLeaderId, content);
                continue;
            }
            buLeaderMap.put(buLeaderId, userContent);
        }
        for (Long buLeaderId : buLeaderMap.keySet()) {
            String content = "\u60a8\u7684\u90e8\u95e8\u6210\u5458\u3010" + (String)buLeaderMap.get(buLeaderId) + "\u3011\u4e0a\u5468\u6709\u5de5\u65f6\u672a\u586b\u5199\uff0c\u8bf7\u5e2e\u5fd9\u8ddf\u50ac\u4ee5\u514d\u5f71\u54cd\u5de5\u65f6\u7ed3\u7b97\u3002";
            boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(buLeaderWxMap.get(buLeaderId), content);
            String log = userBuLeaderNameMap.get(buLeaderId) + ":\u3010" + (String)buLeaderMap.get(buLeaderId) + "\u3011\n";
            if (sendFlag) {
                sendLogList.add((CallSite)((Object)log));
                continue;
            }
            unSendLogList.add((CallSite)((Object)log));
        }
        return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
    }

    @Deprecated
    public void repairTimesheet() {
    }

    public String timesheetApprovingAlert() {
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        ArrayList<CallSite> sendLogList = new ArrayList<CallSite>();
        ArrayList<CallSite> unSendLogList = new ArrayList<CallSite>();
        HashMap<Long, Object> apprMap = new HashMap<Long, Object>();
        List<TimesheetApproveQuery> timesheetApproverList = this.timesheetDAO.approvingDate(firstDayMonth, today);
        Map<Long, String> apprWxMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprWxId, (val1, val2) -> val2));
        Map<Long, String> apprNameMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprName, (val1, val2) -> val2));
        for (TimesheetApproveQuery timesheetApproveQuery : timesheetApproverList) {
            String userContent = timesheetApproveQuery.getEmployeeName();
            Long apprUserId = timesheetApproveQuery.getApprUserId();
            if (apprMap.containsKey(apprUserId)) {
                Object content = (String)apprMap.get(apprUserId);
                content = (String)content + "," + userContent;
                apprMap.put(apprUserId, content);
                continue;
            }
            apprMap.put(apprUserId, userContent);
        }
        for (Long apprUserId : apprMap.keySet()) {
            String content = "\u60a8\u6709\u3010" + (String)apprMap.get(apprUserId) + "\u3011 \u63d0\u4ea4\u7684\u5de5\u65f6\u672a\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5ba1\u6279";
            boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(apprWxMap.get(apprUserId), content);
            String log = apprNameMap.get(apprUserId) + ":\u3010" + (String)apprMap.get(apprUserId) + "\u3011\n";
            if (sendFlag) {
                sendLogList.add((CallSite)((Object)log));
                continue;
            }
            unSendLogList.add((CallSite)((Object)log));
        }
        return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
    }

    public void approvedRevoked(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (TimesheetStatus.APPROVED.getCode().equals(entity.getTsStatus())) {
                        boolean flag = false;
                        if (!(flag = this.getRevokedFlag(flag))) {
                            throw TwException.error("", "\u65e0\u64cd\u4f5c\u5de5\u65f6\u9ad8\u7ea7\u64a4\u56de\u7684\u6743\u9650\uff01");
                        }
                        int interval = 60;
                        interval = this.getInterval(interval);
                        LocalDate now = LocalDate.now();
                        LocalDate workDate = entity.getWorkDate();
                        if (ChronoUnit.DAYS.between(workDate, now) > (long)interval) {
                            throw TwException.error("", "\u8be5\u5de5\u65f6\u5df2\u7ecf\u8d85\u8fc7" + interval + "\u5929\uff0c\u4e0d\u80fd\u64a4\u56de");
                        }
                    } else {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u624d\u5141\u8bb8\u64a4\u56de");
                    }
                    entity.setTsStatus(TimesheetStatus.CREATE.getCode());
                    entity.setApprUserId(null);
                    entity.setApprResult("\u5ba1\u6279\u64a4\u56de");
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    private boolean getRevokedFlag(boolean flag) {
        String settingValue;
        PrdSystemSettingVO systemSettingByKey = this.prdSystemSettingService.getSystemSettingByKey(SystemSettingEnum.TIMESHEET_APPROVED_REJECTED_FLAG.getCode());
        if (systemSettingByKey != null && StringUtils.hasText((String)(settingValue = systemSettingByKey.getSettingValue()))) {
            if (settingValue.equals("1")) {
                flag = true;
            } else if (settingValue.equals("2")) {
                flag = false;
            }
        }
        return flag;
    }

    private int getInterval(int interval) {
        String settingValue;
        PrdSystemSettingVO systemSettingByKeyInterval = this.prdSystemSettingService.getSystemSettingByKey(SystemSettingEnum.TIMESHEET_APPROVED_REJECTED_INTERVAL.getCode());
        if (systemSettingByKeyInterval != null && StringUtils.hasText((String)(settingValue = systemSettingByKeyInterval.getSettingValue()))) {
            try {
                interval = Integer.parseInt(settingValue);
            }
            catch (NumberFormatException ignored) {
                log.error("\u7cfb\u7edf\u8bbe\u7f6e\u9879-\u3010TIMESHEET_APPROVED_REJECTED_INTERVAL\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        return interval;
    }

    public void generateVacationPrivateTimesheet(UserVacationApplyPayload applyPayload) {
        List applyDetailPayloadList = applyPayload.getApplyDetailPayloadList();
        List extapplyDetailPayloadList = applyPayload.getExtapplyDetailPayloadList();
        if (!CollectionUtils.isEmpty((Collection)extapplyDetailPayloadList)) {
            applyDetailPayloadList.addAll(extapplyDetailPayloadList);
        }
        for (UserVacationApplyDetailPayload detail : applyDetailPayloadList) {
            BigDecimal workHour = new BigDecimal(8).multiply(detail.getVDays()).setScale(2, RoundingMode.HALF_UP);
            this.hadleTimesheetInsert(applyPayload, detail, workHour);
        }
    }

    @Transactional
    public void deleteVacationPrivateTimesheet(List<Long> applyDetailIds) {
        this.timesheetDAO.deleteByVacationApplyId(applyDetailIds);
    }

    @Transactional
    public void updateVacationPrivateTimesheet(UserVacationApplyPayload applyPayload, Integer opertType) {
        List<Long> applyDetailIds = applyPayload.getApplyDetailPayloadList().stream().map(e -> e.getId()).collect(Collectors.toList());
        if (opertType == 0) {
            this.timesheetDAO.deleteByVacationApplyId(applyDetailIds);
        }
        if (opertType == 1) {
            if (VacationTypeEnum.REWARD.getCode().equals(applyPayload.getVacationType())) {
                List<TimesheetVO> timesheetVOS = this.timesheetDAO.queryListByVactionIds(applyDetailIds);
                this.handleVacationTask(applyPayload);
                ArrayList<TimesheetPayload> timesheetPayloads = new ArrayList<TimesheetPayload>();
                ArrayList<TaskInfoVO> taskInfoVOS = new ArrayList<TaskInfoVO>();
                applyPayload.getApplyDetailPayloadList().forEach(detailPayload -> {
                    TaskInfoVO taskInfoVO = applyPayload.getTaskInfoVOS().stream().filter(vo -> vo.getId().equals(detailPayload.getTaskId())).findFirst().get();
                    if (!taskInfoVOS.contains(taskInfoVO)) {
                        taskInfoVOS.add(taskInfoVO);
                    }
                    if (detailPayload.getId() != null) {
                        TimesheetVO timesheetVO = timesheetVOS.stream().filter(vo -> vo.getVacationApplyDetailId().equals(detailPayload.getId())).findFirst().get();
                        BigDecimal multiply = detailPayload.getVDays().multiply(BigDecimal.valueOf(8L));
                        if (multiply.compareTo(timesheetVO.getWorkHour()) < 0) {
                            timesheetVO.setWorkHour(multiply);
                            TimesheetVO timesheetVO0 = new TimesheetVO();
                            timesheetVO0.copy(timesheetVO);
                            timesheetVO0.setId(null);
                            timesheetVOS.add(timesheetVO0);
                        }
                        TimesheetPayload payload = TimesheetConvert.INSTANCE.toPayload(timesheetVO);
                        timesheetPayloads.add(payload);
                        this.handleVacationTaskTimesheet(taskInfoVO, payload);
                    }
                });
                Optional<UserVacationApplyDetailPayload> first = applyPayload.getApplyDetailPayloadList().stream().filter(detail -> detail.getId() == null).findFirst();
                if (first.isPresent()) {
                    UserVacationApplyDetailPayload detailPayload2 = first.get();
                    TaskInfoVO taskInfoVO = applyPayload.getTaskInfoVOS().stream().filter(vo -> vo.getId().equals(detailPayload2.getTaskId())).findFirst().get();
                    if (!taskInfoVOS.contains(taskInfoVO)) {
                        taskInfoVOS.add(taskInfoVO);
                    }
                    TimesheetVO timesheetVO = timesheetVOS.stream().filter(vo -> vo.getId() == null).findFirst().get();
                    BigDecimal multiply = detailPayload2.getVDays().multiply(BigDecimal.valueOf(8L));
                    timesheetVO.setWorkHour(multiply);
                    TimesheetPayload payload = TimesheetConvert.INSTANCE.toPayload(timesheetVO);
                    timesheetPayloads.add(payload);
                    this.handleVacationTaskTimesheet(taskInfoVO, payload);
                }
                log.info("handleTaskSettle1:" + taskInfoVOS.size());
                this.handleTaskSettle(taskInfoVOS);
                this.timesheetRepo.saveAll(TimesheetConvert.INSTANCE.toDoList(timesheetPayloads));
            } else {
                this.timesheetDAO.updateStatusByVacationApplyId(applyDetailIds);
            }
        }
    }

    void handleTaskSettle(List<TaskInfoVO> taskInfoVOS) {
        Map<Long, List<TaskInfoVO>> maps = taskInfoVOS.stream().collect(Collectors.groupingBy(TaskInfoVO::getTaskPackageId));
        TaskPackageVO taskPackageVO = this.taskPackageService.queryByKey(taskInfoVOS.get(0).getTaskPackageId(), null);
        List<TaskPackageVO> taskPackageVOS = Arrays.asList(taskPackageVO);
        List detailPayloads = this.calTaskSettleService.taskAutoSettle(maps, taskPackageVOS, Boolean.valueOf(true));
        HashMap taskSettleIdMap = new HashMap();
        detailPayloads.forEach(detailPayload -> taskSettleIdMap.put(detailPayload.getTaskId(), detailPayload.getSettleId()));
        log.info("handleTaskSettle2:" + detailPayloads.size());
        taskInfoVOS.forEach(taskInfoVO -> {
            log.info("handleTaskSettle3:" + taskInfoVO.toString());
            TaskInfoPayload payload = new TaskInfoPayload();
            payload.setId(taskInfoVO.getId());
            payload.setUsedEqva(taskInfoVO.getUsedEqva());
            payload.setApprovedEqva(taskInfoVO.getApprovedEqva());
            payload.setSettledEqva(taskInfoVO.getApprovedEqva());
            if (taskInfoVO.getTotalEqva().compareTo(taskInfoVO.getApprovedEqva()) == 0) {
                payload.setTaskStatus(TaskStatusEnum.CLOSED.getCode());
            }
            this.taskInfoService.updateByKeyDynamic(payload);
        });
        this.calTaskSettleService.saveTaskTaskSettleTimesheet(taskSettleIdMap);
    }

    void handleVacationTaskTimesheet(TaskInfoVO taskInfoVO, TimesheetPayload timesheetEntity) {
        timesheetEntity.setType("PROJ");
        if (taskInfoVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            timesheetEntity.setProjId(taskInfoVO.getReasonId());
            timesheetEntity.setProjName(taskInfoVO.getReasonName());
        } else {
            timesheetEntity.setProjId(Long.valueOf(0L));
            timesheetEntity.setProjName("\u65e0\u9879\u76ee");
        }
        timesheetEntity.setTaskId(taskInfoVO.getId());
        timesheetEntity.setTaskNo(taskInfoVO.getTaskNo());
        timesheetEntity.setTaskName(taskInfoVO.getTaskName());
        timesheetEntity.setTaskPackageId(taskInfoVO.getTaskPackageId());
        timesheetEntity.setTaskPackageName(taskInfoVO.getTaskPackageName());
        timesheetEntity.setReasonId(taskInfoVO.getReasonId());
        timesheetEntity.setReasonName(taskInfoVO.getReasonName());
        timesheetEntity.setReasonType(taskInfoVO.getReasonType());
        timesheetEntity.setTsStatus("APPROVED");
        BigDecimal divide = timesheetEntity.getWorkHour().divide(BigDecimal.valueOf(8L), 4, RoundingMode.DOWN);
        BigDecimal upEqva = divide.multiply(taskInfoVO.getEqvaRatio());
        BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
        BigDecimal newUsedEqva = usedEqva.add(upEqva);
        taskInfoVO.setUsedEqva(newUsedEqva);
        BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
        BigDecimal newApprovedEqva = approvedEqva.add(upEqva);
        if (newUsedEqva.compareTo(newApprovedEqva) < 0) {
            taskInfoVO.setUsedEqva(newApprovedEqva);
        }
        taskInfoVO.setApprovedEqva(newApprovedEqva);
        log.info("handleTaskSettle0:" + newUsedEqva + "/:" + newApprovedEqva);
    }

    void handleVacationTask(UserVacationApplyPayload payload) {
        UserVacationVO userVacationVO = this.userVacationService.queryById(payload.getVacationId());
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setReasonType(userVacationVO.getReasonType());
        taskInfoQuery.setReasonId(userVacationVO.getReasonId());
        taskInfoQuery.setTaskResId(userVacationVO.getUserId());
        taskInfoQuery.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
        taskInfoQuery.setTaskStatus(TaskStatusEnum.PENDING.getCode());
        List<TaskInfoVO> taskInfoVOS0 = this.taskInfoService.queryListCommon(taskInfoQuery);
        if (ObjectUtils.isEmpty((Object)taskInfoVOS0)) {
            throw TwException.error("", "\u5956\u52b1\u5047\u5bf9\u5e94\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        BigDecimal eqvaRatio = ((TaskInfoVO)(taskInfoVOS0 = taskInfoVOS0.stream().filter(vo -> vo.getEffectiveEqva().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList())).get(0)).getEqvaRatio();
        if (eqvaRatio == null) {
            BigDecimal eqvaRatio0;
            eqvaRatio = eqvaRatio0 = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(userVacationVO.getUserId(), LocalDate.now());
            taskInfoVOS0.forEach(infoVO -> infoVO.setEqvaRatio(eqvaRatio0));
        }
        payload.setTaskInfoVOS(taskInfoVOS0);
        List taskInfoVOS = payload.getTaskInfoVOS();
        List applyDetailPayloadList = payload.getApplyDetailPayloadList();
        BigDecimal fianlEqvaRatio = eqvaRatio;
        applyDetailPayloadList.forEach(detail -> this.handleApplyDetail((UserVacationApplyDetailPayload)detail, taskInfoVOS, fianlEqvaRatio));
        Optional<UserVacationApplyDetailPayload> first = applyDetailPayloadList.stream().filter(detail -> detail.getTaskId() == null).findFirst();
        if (first.isPresent()) {
            UserVacationApplyDetailPayload etailPayload = first.get();
            etailPayload.setVDays(etailPayload.getVDays().divide(BigDecimal.valueOf(2L), 4, RoundingMode.DOWN));
            this.handleApplyDetail(etailPayload, taskInfoVOS, fianlEqvaRatio);
            if (etailPayload.getTaskId() == null) {
                throw TwException.error("", "\u5956\u52b1\u5047\u5bf9\u5e94\u4efb\u52a1\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            UserVacationApplyDetailPayload etailPayload0 = new UserVacationApplyDetailPayload();
            etailPayload0.setId(null);
            etailPayload0.setApplyId(etailPayload.getApplyId());
            etailPayload0.setVMonth(etailPayload.getVMonth());
            etailPayload0.setVDate(etailPayload.getVDate());
            etailPayload0.setVDays(etailPayload.getVDays());
            this.handleApplyDetail(etailPayload0, taskInfoVOS, fianlEqvaRatio);
            if (etailPayload.getTaskId() == null) {
                throw TwException.error("", "\u5956\u52b1\u5047\u5bf9\u5e94\u4efb\u52a1\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            applyDetailPayloadList.add(etailPayload0);
            payload.setApplyDetailPayloadList(applyDetailPayloadList);
        }
    }

    void handleApplyDetail(UserVacationApplyDetailPayload detail, List<TaskInfoVO> taskInfoVOS, BigDecimal fianlEqvaRatio) {
        TaskInfoVO taskInfoVO = null;
        BigDecimal applyEqva = detail.getVDays().multiply(fianlEqvaRatio);
        if (detail.getVDays().compareTo(BigDecimal.ONE) == 0) {
            Optional<TaskInfoVO> first = taskInfoVOS.stream().filter(infoVO -> infoVO.getEffectiveEqva().compareTo(applyEqva) >= 0).findFirst();
            if (first.isPresent()) {
                taskInfoVO = first.get();
            }
        } else {
            Optional<TaskInfoVO> first = taskInfoVOS.stream().filter(infoVO -> infoVO.getEffectiveEqva().add(applyEqva).compareTo(fianlEqvaRatio) >= 0 && infoVO.getEffectiveEqva().add(applyEqva).divide(fianlEqvaRatio).stripTrailingZeros().scale() <= 0).findFirst();
            if (first.isPresent()) {
                taskInfoVO = first.get();
            } else {
                Optional<TaskInfoVO> first1 = taskInfoVOS.stream().filter(infoVO -> infoVO.getEffectiveEqva().compareTo(applyEqva) >= 0).findFirst();
                if (first1.isPresent()) {
                    taskInfoVO = first1.get();
                } else {
                    throw TwException.error("", "\u5956\u52b1\u5047\u5bf9\u5e94\u4efb\u52a1\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
            }
        }
        detail.setTaskId(null);
        if (taskInfoVO != null) {
            taskInfoVO.setEffectiveEqva(taskInfoVO.getEffectiveEqva().subtract(applyEqva));
            detail.setTaskId(taskInfoVO.getId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void hadleTimesheetInsert(UserVacationApplyPayload applyPayload, UserVacationApplyDetailPayload detail, BigDecimal workHour) {
        List refList;
        TimesheetPayload timesheetEntity = new TimesheetPayload();
        timesheetEntity.setTsUserId(applyPayload.getUserId());
        timesheetEntity.setTsStatus(TimesheetStatus.APPROVING.getCode());
        timesheetEntity.setWorkDate(detail.getVDate());
        timesheetEntity.setApprUserId(Long.valueOf(1381L));
        timesheetEntity.setSubmitTime(applyPayload.getCreateTime());
        timesheetEntity.setLastSubmitTime(applyPayload.getCreateTime());
        timesheetEntity.setApprovalTime(LocalDateTime.now());
        List<PrdOrgDataRefVO> prdOrgDataRefVOS = this.daoUser.queryOrgListByKey(applyPayload.getUserId());
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS) && !CollectionUtils.isEmpty(refList = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)refList.get(0)).getOrgId();
            String orgName = ((PrdOrgDataRefVO)refList.get(0)).getOrgName();
            timesheetEntity.setTsUserBuId(orgId);
            timesheetEntity.setTsUserBuName(orgName);
        }
        timesheetEntity.setWorkHour(workHour);
        timesheetEntity.setWorkDesc("\u8bf7\u5047\u6d41\u7a0b\u81ea\u52a8\u586b\u5199");
        int weekBaseYear = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekBasedYear());
        int weeks = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekOfWeekBasedYear());
        String week = weeks < 10 ? "0" + weeks : "" + weeks;
        String yearWeek = weekBaseYear + week;
        timesheetEntity.setWeekStartDate(timesheetEntity.getWorkDate().with(DayOfWeek.MONDAY));
        timesheetEntity.setYearWeek(Integer.valueOf(Integer.parseInt(yearWeek)));
        timesheetEntity.setAutoSaveFlag(Integer.valueOf(1));
        timesheetEntity.setProjId(Long.valueOf(0L));
        timesheetEntity.setProjName("\u65e0\u9879\u76ee");
        timesheetEntity.setReasonId(Long.valueOf(0L));
        timesheetEntity.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
        timesheetEntity.setReasonName("\u65e0\u9879\u76ee");
        timesheetEntity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
        timesheetEntity.setTsActIden(applyPayload.getVacationType());
        if (VacationTypeEnum.SICK.getCode().equals(applyPayload.getVacationType())) {
            timesheetEntity.setTsActIden("SICKLEAVE");
        }
        if (VacationTypeEnum.IN_LIEU.getCode().equals(applyPayload.getVacationType())) {
            timesheetEntity.setTsActIden("SHIFTING");
        }
        if (VacationTypeEnum.REWARD.getCode().equals(applyPayload.getVacationType())) {
            timesheetEntity.setTsActIden("REWARDLEAVE");
        }
        timesheetEntity.setTsTaskIden("VACATION");
        timesheetEntity.setSettleStatus("NONE");
        timesheetEntity.setProcId(applyPayload.getProcInstId());
        timesheetEntity.setVacationApplyDetailId(detail.getId());
        timesheetEntity.setReturnFlag(Boolean.valueOf(false));
        this.timesheetRepo.save((Object)TimesheetConvert.INSTANCE.toDo(timesheetEntity));
    }

    public PagingVO monthlyPaging(MonthlyTimesheetQuery query) {
        List<Object[]> objects = this.timesheetRepo.queryMonthlyTimesheetVO(query);
        int offset = (query.getSize() - 1) * query.getCurrent();
        List<Object[]> pageObjects = objects.stream().skip(offset).limit(query.getSize().intValue()).toList();
        List<MonthlyTimesheetVO> monthlyTimesheetVOS = this.monthlyTimesheetMap(pageObjects);
        return PagingVO.builder().records(monthlyTimesheetVOS).total((long)objects.size()).build();
    }

    public void monthlySyncToJDE(MonthlyTimesheetQuery query) {
        List<Object[]> objects = this.timesheetRepo.queryMonthlyTimesheetVO(query);
        String jdeFileName = "";
        if (!ObjectUtils.isEmpty((Object)query.getWorkDateStart()) && !ObjectUtils.isEmpty((Object)query.getWorkDateEnd())) {
            jdeFileName = query.getWorkDateStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
        }
        List<MonthlyTimesheetVO> monthlyTimesheetVOS = this.monthlyTimesheetMap(objects);
        List<JDEMonthlyTimesheetVO> jdeMonthlyTimesheetVOS = this.monthlyTimesheetMapToJDE(monthlyTimesheetVOS);
        try {
            this.JDEMonthlyTimesheetExport(jdeMonthlyTimesheetVOS, jdeFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw TwException.error("", "\u751f\u6210\u6708\u5ea6\u5458\u5de5\u5de5\u65f6\u7edf\u8ba1\u8868\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public void monthlyExport(MonthlyTimesheetQuery query, HttpServletResponse response) {
        List<Object[]> objects = this.timesheetRepo.queryMonthlyTimesheetVO(query);
        StringBuilder fileName = new StringBuilder("\u6708\u5ea6\u5458\u5de5\u5de5\u65f6\u7edf\u8ba1\u8868\uff08\u8d22\u52a1\uff09");
        if (!ObjectUtils.isEmpty((Object)query.getWorkDateStart()) && !ObjectUtils.isEmpty((Object)query.getWorkDateEnd())) {
            fileName.append("-").append(query.getWorkDateStart()).append("-").append(query.getWorkDateEnd());
        }
        List<MonthlyTimesheetVO> monthlyTimesheetVOS = this.monthlyTimesheetMap(objects);
        try {
            this.monthlyTimesheetImport(monthlyTimesheetVOS, response, fileName.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw TwException.error("", "\u5bfc\u51fa\u6708\u5ea6\u5458\u5de5\u5de5\u65f6\u7edf\u8ba1\u8868\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public List<TimesheetVO> queryDaoList(TimesheetQuery query) {
        return this.timesheetDAO.queryList(query);
    }

    public List<PmsTimesheetProjectVO> listProject(Long userId, Boolean selectAll) {
        ArrayList<PmsTimesheetProjectVO> resultList = new ArrayList<PmsTimesheetProjectVO>();
        List pmsProjectVOS = this.pmsProjectService.queryListByProjectMember(userId, selectAll);
        List projectList = pmsProjectVOS.stream().map(pmsProjectVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(pmsProjectVO.getId());
            pmsTimesheetProjectVO.setReasonName(pmsProjectVO.getProjName());
            pmsTimesheetProjectVO.setReasonNo(pmsProjectVO.getProjNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(projectList);
        List oppoProject = this.crmOpportunityService.findByMemberIdIdEq(userId);
        List oppoProjectList = oppoProject.stream().map(opportunityVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(opportunityVO.getProjectId());
            pmsTimesheetProjectVO.setReasonName(opportunityVO.getProjectName());
            pmsTimesheetProjectVO.setReasonNo(opportunityVO.getProjectNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_OPPO.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(oppoProjectList);
        BuProjectQuery buProjectQuery = new BuProjectQuery();
        List buProjectVOS = this.buProjectService.listByMember(buProjectQuery);
        List buProjectList = buProjectVOS.stream().map(buProjectVO -> {
            PmsTimesheetProjectVO pmsTimesheetProjectVO = new PmsTimesheetProjectVO();
            pmsTimesheetProjectVO.setReasonId(buProjectVO.getId());
            pmsTimesheetProjectVO.setReasonName(buProjectVO.getProjName());
            pmsTimesheetProjectVO.setReasonNo(buProjectVO.getProjNo());
            pmsTimesheetProjectVO.setReasonType(PmsReasonTypeEnum.PROJ_BU.getCode());
            return pmsTimesheetProjectVO;
        }).collect(Collectors.toList());
        resultList.addAll(buProjectList);
        return resultList;
    }

    private List<MonthlyTimesheetVO> monthlyTimesheetMap(List<Object[]> objectResultList) {
        ArrayList<MonthlyTimesheetVO> monthlyTimesheetVOList = new ArrayList<MonthlyTimesheetVO>();
        objectResultList.forEach(object -> {
            MonthlyTimesheetVO monthlyTimesheetVO = new MonthlyTimesheetVO();
            Optional.ofNullable(object[0]).ifPresent(s -> monthlyTimesheetVO.setPrjAscriptionOuNO(s.toString()));
            Optional.ofNullable(object[1]).ifPresent(s -> monthlyTimesheetVO.setResAscriptionOuNO(s.toString()));
            Optional.ofNullable(object[2]).ifPresent(s -> monthlyTimesheetVO.setYear(s.toString()));
            Optional.ofNullable(object[3]).ifPresent(s -> monthlyTimesheetVO.setMonthly(s.toString()));
            Optional.ofNullable(object[4]).ifPresent(s -> monthlyTimesheetVO.setResNo(s.toString()));
            Optional.ofNullable(object[5]).ifPresent(s -> monthlyTimesheetVO.setResBu(s.toString()));
            Optional.ofNullable(object[6]).ifPresent(s -> monthlyTimesheetVO.setEmployeeName(s.toString()));
            Optional.ofNullable(object[7]).ifPresent(s -> monthlyTimesheetVO.setRefContractNo(s.toString()));
            Optional.ofNullable(object[8]).ifPresent(s -> monthlyTimesheetVO.setPrjName(s.toString()));
            Optional.ofNullable(object[9]).ifPresent(s -> monthlyTimesheetVO.setDeliverBu(s.toString()));
            Optional.ofNullable(object[10]).ifPresent(s -> monthlyTimesheetVO.setContractNo(s.toString()));
            Optional.ofNullable(object[11]).ifPresent(s -> monthlyTimesheetVO.setDays((BigDecimal)s));
            Optional.ofNullable(object[12]).ifPresent(s -> monthlyTimesheetVO.setEqvaRatio((BigDecimal)s));
            Optional.ofNullable(object[13]).ifPresent(s -> monthlyTimesheetVO.setSettleEqva((BigDecimal)s));
            Optional.ofNullable(object[14]).ifPresent(s -> monthlyTimesheetVO.setProductNo(s.toString()));
            Optional.ofNullable(object[15]).ifPresent(s -> monthlyTimesheetVO.setPjType(s.toString()));
            Optional.ofNullable(object[16]).ifPresent(s -> monthlyTimesheetVO.setPjType1(s.toString()));
            monthlyTimesheetVOList.add(monthlyTimesheetVO);
        });
        return monthlyTimesheetVOList;
    }

    private List<JDEMonthlyTimesheetVO> monthlyTimesheetMapToJDE(List<MonthlyTimesheetVO> monthlyTimesheetVOS) {
        return monthlyTimesheetVOS.stream().map(monthlyVO -> {
            JDEMonthlyTimesheetVO baseVO = new JDEMonthlyTimesheetVO();
            BeanUtils.copyProperties((Object)monthlyVO, (Object)baseVO);
            return baseVO;
        }).toList();
    }

    private void monthlyTimesheetImport(List<MonthlyTimesheetVO> monthlyTimesheetVOS, HttpServletResponse response, String fileName) throws Exception {
        if (!CollectionUtils.isEmpty(monthlyTimesheetVOS)) {
            ClassPathResource classPathResource = new ClassPathResource("template/monthlyTimesheet.xlsx");
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            this.monthlyTimesheetSheet(monthlyTimesheetVOS, workbook);
            this.monthlyTimesheetSummarySheet(monthlyTimesheetVOS, workbook);
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
    }

    private void JDEMonthlyTimesheetExport(List<JDEMonthlyTimesheetVO> jdeMonthlyTimesheetVOS, String fileName) {
        String filePath = "/upload/" + fileName + ".csv";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            writer.write("\u5e74\u5ea6,\u671f\u95f4,\u9879\u76ee\u6210\u672c\u4e2d\u5fc3,REP\u9879\u76ee\u7f16\u53f7,\u5458\u5de5\u7f16\u53f7,\u5b9e\u9645\u5de5\u4f5c\u671f\u95f4\u7684\u5929\u6570,\u5f53\u91cf\u7cfb\u6570,\u7ed3\u7b97\u5f53\u91cf,\u5de5\u65f6\u7c7b\u578b");
            writer.newLine();
            for (JDEMonthlyTimesheetVO jdeMonthlyTimesheetVO : jdeMonthlyTimesheetVOS) {
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getYear());
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getMonthly());
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getRefContractNo());
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getContractNo());
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getResNo());
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getDays());
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getEqvaRatio());
                PmsTimesheetServiceImpl.writePropertyValue(writer, jdeMonthlyTimesheetVO.getSettleEqva());
                writer.write(jdeMonthlyTimesheetVO.getPjType1() != null ? jdeMonthlyTimesheetVO.getPjType1() : "");
                writer.newLine();
            }
        }
        catch (IOException ignored) {
            throw TwException.error("", "\u751f\u6210\u6708\u5ea6\u5458\u5de5\u5de5\u65f6\u7edf\u8ba1\u8868\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private static void writePropertyValue(BufferedWriter writer, Object value) throws IOException {
        value = value == null ? "" : value;
        writer.write(value.toString());
        writer.write(",");
    }

    private void monthlyTimesheetSheet(List<MonthlyTimesheetVO> monthlyTimesheetVOS, Workbook workbook) {
        XSSFSheet monthlyTimesheetSheet = (XSSFSheet)workbook.getSheet("\u6708\u5ea6\u5458\u5de5\u5de5\u65f6\u7edf\u8ba1");
        CellStyle oddCellStyle = this.commonCreateCellStyle(workbook);
        oddCellStyle.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
        CellStyle evenCellStyle = this.commonCreateCellStyle(workbook);
        evenCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        if (monthlyTimesheetSheet != null) {
            int nextRow = 1;
            for (MonthlyTimesheetVO monthlyTimesheetVO : monthlyTimesheetVOS) {
                XSSFRow row = monthlyTimesheetSheet.createRow(nextRow);
                row.setHeightInPoints(22.65f);
                CellStyle cellStyle = nextRow % 2 == 0 ? evenCellStyle : oddCellStyle;
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 0, nextRow);
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 1, monthlyTimesheetVO.getPrjAscriptionOuNO());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 2, monthlyTimesheetVO.getResAscriptionOuNO());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 3, monthlyTimesheetVO.getYear());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 4, monthlyTimesheetVO.getMonthly());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 5, monthlyTimesheetVO.getResNo());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 6, monthlyTimesheetVO.getEmployeeName());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 7, monthlyTimesheetVO.getDays());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 8, monthlyTimesheetVO.getResBu());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 9, monthlyTimesheetVO.getRefContractNo());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 10, monthlyTimesheetVO.getPrjName());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 11, monthlyTimesheetVO.getDeliverBu());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 12, monthlyTimesheetVO.getPjType1());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 13, monthlyTimesheetVO.getContractNo());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 14, monthlyTimesheetVO.getEqvaRatio());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 15, monthlyTimesheetVO.getSettleEqva());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 16, monthlyTimesheetVO.getProductNo());
                this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 17, monthlyTimesheetVO.getPjType());
                ++nextRow;
            }
            XSSFRow sumRow = monthlyTimesheetSheet.createRow(nextRow);
            this.twExcelUtil.setCellValue((Row)sumRow, 0, "\u5408\u8ba1\uff1a");
            Cell sumCell7 = sumRow.createCell(7);
            sumCell7.setCellFormula("SUM(H2:H" + nextRow + ")");
            Cell sumCell15 = sumRow.createCell(15);
            sumCell15.setCellFormula("SUM(P2:P" + nextRow + ")");
        }
    }

    private void monthlyTimesheetSummarySheet(List<MonthlyTimesheetVO> monthlyTimesheetVOS, Workbook workbook) {
        XSSFSheet monthlyTimesheetSummarySheet = (XSSFSheet)workbook.getSheet("\u6c47\u603b");
        AtomicInteger nextRow = new AtomicInteger(1);
        CellStyle oddCellStyle = this.commonCreateCellStyle(workbook);
        oddCellStyle.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
        CellStyle evenCellStyle = this.commonCreateCellStyle(workbook);
        evenCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        Map<String, List<MonthlyTimesheetVO>> monthlyTimesheetMap = monthlyTimesheetVOS.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(monthlyTimesheet -> monthlyTimesheet.getResNo() + monthlyTimesheet.getEmployeeName()));
        monthlyTimesheetMap.forEach((resNoAndEmployeeName, timesheetVOS) -> {
            XSSFRow row = monthlyTimesheetSummarySheet.createRow(nextRow.get());
            row.setHeightInPoints(22.65f);
            CellStyle cellStyle = nextRow.get() % 2 == 0 ? evenCellStyle : oddCellStyle;
            BigDecimal days = BigDecimal.ZERO;
            BigDecimal settleEqva = BigDecimal.ZERO;
            for (MonthlyTimesheetVO monthlyTimesheetVO : timesheetVOS) {
                days = days.add(monthlyTimesheetVO.getDays() == null ? BigDecimal.ZERO : monthlyTimesheetVO.getDays());
                settleEqva = settleEqva.add(monthlyTimesheetVO.getSettleEqva() == null ? BigDecimal.ZERO : monthlyTimesheetVO.getSettleEqva());
            }
            MonthlyTimesheetVO monthlyTimesheetVO = (MonthlyTimesheetVO)timesheetVOS.get(0);
            this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 0, nextRow);
            this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 1, monthlyTimesheetVO.getResNo());
            this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 2, monthlyTimesheetVO.getEmployeeName());
            this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 3, days);
            this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 4, monthlyTimesheetVO.getResBu());
            this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 5, monthlyTimesheetVO.getEqvaRatio());
            this.twExcelUtil.setCellValueAndStyle((Row)row, cellStyle, 6, settleEqva);
            nextRow.getAndIncrement();
        });
        XSSFRow sumRow = monthlyTimesheetSummarySheet.createRow(nextRow.get());
        this.twExcelUtil.setCellValue((Row)sumRow, 0, "\u5408\u8ba1\uff1a");
        Cell sumCell3 = sumRow.createCell(3);
        sumCell3.setCellFormula("SUM(D2:D" + nextRow + ")");
        Cell sumCell6 = sumRow.createCell(6);
        sumCell6.setCellFormula("SUM(G2:g" + nextRow + ")");
    }

    private CellStyle commonCreateCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)9);
        font.setFontName("SimSun");
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setWrapText(true);
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        return style;
    }

    public PmsTimesheetServiceImpl(TimesheetRepo timesheetRepo, TimesheetPlanRepo timesheetPlanRepo, CrmOperationPlanDetailService crmOperationPlanDetailService, PmsProjectService pmsProjectService, PrdOrgEmployeeDAO employeeDAO, JPAQueryFactory jpaQueryFactory, PrdSystemRoleDAO systemRoleDAO, PrdUserDAO daoUser, PrdOrgOrganizationDAO prdOrgOrganizationDAO, TimesheetDAO timesheetDAO, TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo, PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService, QyWxCommunicationService qyWxCommunicationService, PrdOrgEmployeeDAO prdOrgEmployeeDAO, OvertimeApplicationRepo overtimeApplicationRepo, OvertimeApplicationDAO overtimeApplicationDAO, PrdOrgEmployeeService prdOrgEmployeeService, TaskInfoService taskInfoService, VacationDAO vacationDAO, TaskCommonService taskCommonService, TaskPackageService taskPackageService, PmsProjectActivityService pmsProjectActivityService, PmsResourcePlanRoleService pmsResourcePlanRoleService, CacheUtil cacheUtil, ExcelUtil twExcelUtil, UdcUtil udcUtil, UserVacationService userVacationService, TsApprovalResService tsApprovalResService, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService, CalTaskSettleService calTaskSettleService, CrmOpportunityService crmOpportunityService, BuProjectService buProjectService, PrdSystemSettingService prdSystemSettingService, TimesheetSubsidySettingService timesheetSubsidySettingService) {
        this.timesheetRepo = timesheetRepo;
        this.timesheetPlanRepo = timesheetPlanRepo;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.pmsProjectService = pmsProjectService;
        this.employeeDAO = employeeDAO;
        this.jpaQueryFactory = jpaQueryFactory;
        this.systemRoleDAO = systemRoleDAO;
        this.daoUser = daoUser;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.timesheetDAO = timesheetDAO;
        this.biweeklyReadFlagRepo = biweeklyReadFlagRepo;
        this.employeeEqvaRatioService = employeeEqvaRatioService;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
        this.overtimeApplicationRepo = overtimeApplicationRepo;
        this.overtimeApplicationDAO = overtimeApplicationDAO;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.taskInfoService = taskInfoService;
        this.vacationDAO = vacationDAO;
        this.taskCommonService = taskCommonService;
        this.taskPackageService = taskPackageService;
        this.pmsProjectActivityService = pmsProjectActivityService;
        this.pmsResourcePlanRoleService = pmsResourcePlanRoleService;
        this.cacheUtil = cacheUtil;
        this.twExcelUtil = twExcelUtil;
        this.udcUtil = udcUtil;
        this.userVacationService = userVacationService;
        this.tsApprovalResService = tsApprovalResService;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
        this.calTaskSettleService = calTaskSettleService;
        this.crmOpportunityService = crmOpportunityService;
        this.buProjectService = buProjectService;
        this.prdSystemSettingService = prdSystemSettingService;
        this.timesheetSubsidySettingService = timesheetSubsidySettingService;
    }
}

