/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TUserVacationCancelPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TUserVacationCancelQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.TUserVacationCancelService;
import com.elitesland.tw.tw5.api.prd.my.vo.TUserVacationCancelVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.VacationTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TUserVacationCancelConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TUserVacationCancelDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TUserVacationCancelDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TUserVacationCancelRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TUserVacationCancelServiceImpl
extends BaseServiceImpl
implements TUserVacationCancelService {
    private static final Logger log = LoggerFactory.getLogger(TUserVacationCancelServiceImpl.class);
    private final TUserVacationCancelRepo tUserVacationCancelRepo;
    private final TUserVacationCancelDAO tUserVacationCancelDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    private final UserVacationApplyRepo userVacationApplyRepo;
    private final UserVacationApplyDAO userVacationApplyDAO;
    private final UserVacationApplyDetailDAO userVacationApplyDetailDAO;
    private final UserVacationDAO userVacationDAO;
    private final PmsProjectService pmsProjectService;
    private final PrdSystemRoleService roleService;
    private final PmsTimesheetService timesheetService;

    @Transactional(rollbackFor={Exception.class})
    public TUserVacationCancelVO insertOrUpdate(TUserVacationCancelPayload payload) {
        this.checkData(payload);
        String procInstId = null;
        if (payload.getId() != null) {
            TUserVacationCancelVO tUserVacationCancelVO = this.tUserVacationCancelDAO.queryByKey(payload.getId());
            if (tUserVacationCancelVO == null) {
                throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
            }
            procInstId = tUserVacationCancelVO.getProcInstId();
        } else {
            payload.setCancelDate(LocalDate.now());
        }
        TUserVacationCancelDO aDo = TUserVacationCancelConvert.INSTANCE.toDo(payload);
        TUserVacationCancelDO save = this.tUserVacationCancelDAO.save(aDo);
        payload.setId(save.getId());
        payload.setProcInstId(procInstId);
        Boolean isUp = false;
        TUserVacationCancelPayload payload0 = new TUserVacationCancelPayload();
        if (!StringUtils.hasText((String)procInstId)) {
            this.startProcess(payload, payload0);
            isUp = true;
        } else if (!StringUtils.hasText((String)payload.getProcInstStatus()) || ProcInstStatus.NOTSUBMIT.name().equals(payload.getProcInstStatus()) || ProcInstStatus.REJECTED.name().equals(payload.getProcInstStatus())) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            this.dealVariables(payload, variables);
            this.workflowUtil.setVariables(SetVariablesPayload.of((String)payload.getProcInstId(), variables));
            payload0.setId(payload.getId());
            payload0.setProcInstStatus(ProcInstStatus.APPROVING.name());
            isUp = true;
        }
        if (isUp.booleanValue()) {
            this.transactionUtilService.executeWithRunnable(() -> this.tUserVacationCancelDAO.updateByKeyDynamic(payload0));
        }
        return TUserVacationCancelConvert.INSTANCE.toVo(save);
    }

    void checkData(TUserVacationCancelPayload payload) {
        if (payload.getApplyId() == null) {
            throw TwException.error("", "\u53d8\u66f4\u5047\u671f\u4f20\u503c\u9519\u8bef");
        }
        Optional userVacationApply = this.userVacationApplyRepo.findById(payload.getApplyId());
        if (!userVacationApply.isPresent()) {
            throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        UserVacationApplyDO userVacationApplyDO = (UserVacationApplyDO)((Object)userVacationApply.get());
        if (!StringUtils.hasText((String)userVacationApplyDO.getProcInstStatus().name()) || !ProcInstStatus.APPROVED.name().equals(userVacationApplyDO.getProcInstStatus().name())) {
            throw TwException.error("", "\u4ec5\u652f\u6301\u5ba1\u6279\u901a\u8fc7\u6570\u636e\u5904\u7406");
        }
        if (VacationTypeEnum.REWARD.getCode().equals(userVacationApplyDO.getVacationType())) {
            throw TwException.error("", "\u5956\u52b1\u5047\u6682\u4e0d\u652f\u6301\u53d8\u66f4");
        }
        TUserVacationCancelQuery query = new TUserVacationCancelQuery();
        query.setApplyId(payload.getApplyId());
        List<TUserVacationCancelVO> vos = this.tUserVacationCancelDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(vos)) {
            List<String> stringList = Arrays.asList(ProcInstStatus.DELETE.name(), ProcInstStatus.INVALID.name());
            List collect = vos.stream().filter(vo -> !stringList.contains(vo.getProcInstStatus())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                if (payload.getId() == null) {
                    throw TwException.error("", "\u8bf7\u5047\u5355\u53f7\uff1a\u3010" + userVacationApplyDO.getApplyNo() + "\u3011\u4e0d\u53ef\u91cd\u590d\u64cd\u4f5c");
                }
                if (collect.size() > 1 || ((TUserVacationCancelVO)collect.get(0)).getId().longValue() != payload.getId().longValue()) {
                    throw TwException.error("", "\u8bf7\u5047\u5355\u53f7\uff1a\u3010" + userVacationApplyDO.getApplyNo() + "\u3011\u4e0d\u53ef\u91cd\u590d\u64cd\u4f5c");
                }
            }
        }
        payload.setApplyNo(userVacationApplyDO.getApplyNo());
        payload.setUserVacationApplyPayload(UserVacationApplyConvert.INSTANCE.doToPayload(userVacationApplyDO));
    }

    void startProcess(TUserVacationCancelPayload payload, TUserVacationCancelPayload payload0) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.dealVariables(payload, variables);
        String operTypeDesc = "\u53d6\u6d88\u8bf7\u5047\u7533\u8bf7";
        if (StringUtils.hasText((String)payload.getOperType()) && "2".equals(payload.getOperType())) {
            operTypeDesc = "\u4fee\u6539\u8bf7\u5047\u7533\u8bf7";
        }
        String userName = this.cacheUtil.getUserName(payload.getUserId());
        String procInstName = "A36." + ProcDefKey.RES_VACATION_CANCEL.getDesc() + "-" + userName + "-" + payload.getApplyNo() + "-" + operTypeDesc;
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.RES_VACATION_CANCEL.name(), (String)procInstName, (String)("" + payload.getId()), variables), new Long[0]);
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus().name());
    }

    private void dealVariables(TUserVacationCancelPayload payload, HashMap<String, Object> variables) {
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
        UserVacationApplyPayload userVacationApplyPayload = payload.getUserVacationApplyPayload();
        Boolean inProjectFlag = false;
        if (userVacationApplyPayload.getInProjectFlag() != null) {
            int b = userVacationApplyPayload.getInProjectFlag().intValue();
            inProjectFlag = b != 0;
        }
        variables.put("inProjectFlag", inProjectFlag);
        variables.put("Activity_01j7rlu", CollUtil.newArrayList((Object[])new Long[]{payload.getUserId()}));
        variables.put("Activity_0y8vbtz", 0);
        if (inProjectFlag.booleanValue() && userVacationApplyPayload.getProjectId() != null) {
            PmsProjectVO pmsProjectVO;
            PmsProjectVO projectVO = pmsProjectVO = this.pmsProjectService.queryByKeySimple(userVacationApplyPayload.getProjectId());
            Long pmUserId = projectVO.getPmResId();
            variables.put("Activity_0y8vbtz", CollUtil.newArrayList((Object[])new Long[]{pmUserId}));
        }
        if ((prdOrgEmployeeRefVO = this.cacheUtil.getUserDefaultOrg(payload.getUserId())) == null) {
            throw TwException.error("", "\u5458\u5de5\u7ec4\u7ec7\u5173\u7cfb\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (prdOrgEmployeeRefVO.getParentId() == null) {
            throw TwException.error("", "\u5458\u5de5\u4e0a\u7ea7\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        variables.put("Activity_1dth2c5", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getParentId()}));
        List vacationAdmin = this.roleService.queryUserIdByRoleCodes((List)CollUtil.newArrayList((Object[])new String[]{RoleEnum.PLAT_SALARY_MANAGER.getCode(), RoleEnum.PLAT_SALARY_SPECIALIST.getCode()}));
        variables.put("Activity_0y87nt8", vacationAdmin);
    }

    public PagingVO<TUserVacationCancelVO> queryPaging(TUserVacationCancelQuery query) {
        return this.tUserVacationCancelDAO.queryPaging(query);
    }

    public List<TUserVacationCancelVO> queryListDynamic(TUserVacationCancelQuery query) {
        return this.tUserVacationCancelDAO.queryListDynamic(query);
    }

    public TUserVacationCancelVO queryByKey(Long key) {
        TUserVacationCancelVO tUserVacationCancelVO = this.tUserVacationCancelDAO.queryByKey(key);
        UserVacationApplyDO userVacationApplyDO = (UserVacationApplyDO)((Object)this.userVacationApplyRepo.findById(tUserVacationCancelVO.getApplyId()).get());
        UserVacationApplyVO userVacationApplyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDO);
        if (StringUtils.hasText((String)userVacationApplyVO.getProjectId())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKeySimple(Long.valueOf(userVacationApplyVO.getProjectId()));
            userVacationApplyVO.setProjectName(pmsProjectVO.getProjName());
        }
        tUserVacationCancelVO.setUserVacationApplyVO(userVacationApplyVO);
        return tUserVacationCancelVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TUserVacationCancelPayload payload) {
        long result = this.tUserVacationCancelDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<TUserVacationCancelVO> tUserVacationCancelVOS = this.tUserVacationCancelDAO.queryByKeys(keys);
            tUserVacationCancelVOS.forEach(vo -> {
                if (!ProcInstStatus.NOTSUBMIT.name().equals(vo.getProcInstStatus()) && !ProcInstStatus.REJECTED.name().equals(vo.getProcInstStatus())) {
                    throw TwException.error("", "\u4e0d\u652f\u6301\u5220\u9664\u64cd\u4f5c");
                }
                try {
                    if (StringUtils.hasText((String)vo.getProcInstId())) {
                        this.workflowUtil.deleteProcess(DeleteProcessPayload.of((String)vo.getProcInstId(), (String)""));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            this.tUserVacationCancelDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(TUserVacationCancelPayload payload) {
        if (ProcInstStatus.APPROVED.name().equals(payload.getProcInstStatus())) {
            TUserVacationCancelVO tUserVacationCancelVO = this.tUserVacationCancelDAO.queryByKey(payload.getId());
            payload.setApplyId(tUserVacationCancelVO.getApplyId());
            UserVacationApplyDO applyDO = (UserVacationApplyDO)((Object)this.userVacationApplyRepo.findById(payload.getApplyId()).get());
            if (!ObjectUtils.isEmpty((Object)applyDO.getVacationId()) && !ObjectUtils.isEmpty((Object)applyDO.getVacationDays())) {
                BigDecimal negate = applyDO.getVacationDays().negate();
                this.userVacationDAO.updateUsedDays(applyDO.getVacationId(), negate);
            }
            UserVacationApplyPayload userVacationApplyPayload = new UserVacationApplyPayload();
            userVacationApplyPayload.setId(payload.getApplyId());
            userVacationApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
            this.userVacationApplyDAO.updateProcData(userVacationApplyPayload);
            this.userVacationApplyDetailDAO.updateProcStatusByApplyId(payload.getApplyId(), ProcInstStatus.INVALID);
            List<UserVacationApplyDetailDO> vacationApplyDetailDOS = this.userVacationApplyDetailDAO.findByApplyId(payload.getApplyId());
            List applyDetailIds = vacationApplyDetailDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
            this.timesheetService.deleteVacationPrivateTimesheet(applyDetailIds);
        }
        this.tUserVacationCancelDAO.updateByKeyDynamic(payload);
    }

    public TUserVacationCancelServiceImpl(TUserVacationCancelRepo tUserVacationCancelRepo, TUserVacationCancelDAO tUserVacationCancelDAO, WorkflowUtil workflowUtil, CacheUtil cacheUtil, TransactionUtilService transactionUtilService, UserVacationApplyRepo userVacationApplyRepo, UserVacationApplyDAO userVacationApplyDAO, UserVacationApplyDetailDAO userVacationApplyDetailDAO, UserVacationDAO userVacationDAO, PmsProjectService pmsProjectService, PrdSystemRoleService roleService, PmsTimesheetService timesheetService) {
        this.tUserVacationCancelRepo = tUserVacationCancelRepo;
        this.tUserVacationCancelDAO = tUserVacationCancelDAO;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.transactionUtilService = transactionUtilService;
        this.userVacationApplyRepo = userVacationApplyRepo;
        this.userVacationApplyDAO = userVacationApplyDAO;
        this.userVacationApplyDetailDAO = userVacationApplyDetailDAO;
        this.userVacationDAO = userVacationDAO;
        this.pmsProjectService = pmsProjectService;
        this.roleService = roleService;
        this.timesheetService = timesheetService;
    }
}

