/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookContactsPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookContactsDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookContactsDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookContactsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class BookContactsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BookContactsRepo repo;
    private final QBookContactsDO qdo = QBookContactsDO.bookContactsDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;

    private JPAQuery<BookContactsVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BookContactsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.bookId, this.qdo.contactsType, this.qdo.contactsName, this.qdo.contactsPhone, this.qdo.contactsTelephone, this.qdo.contactsEmail, this.qdo.contactsAddress, this.qdo.socialAccountType, this.qdo.socialAccount, this.qdo.contactsDepartment, this.qdo.contactsPosition, this.qdo.contactsRelation, this.qdo.sex, this.qdo.birthday, this.qdo.isKeyPerson, this.qdo.contactsNo, this.qdo.contactsStatus, this.qdo.isDefault, this.qBusinessPartnerDO.partnerName.as("bookName")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qBusinessPartnerDO.bookId.eq(this.qdo.bookId));
    }

    private JPAQuery<BookContactsVO> getJpaQueryWhere(BookContactsQuery query) {
        JPAQuery<BookContactsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qBusinessPartnerDO.deleteFlag.eq((Object)0));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        return jpaQuery;
    }

    public long count(BookContactsQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qBusinessPartnerDO.bookId.eq(this.qdo.bookId));
        jpaQuery.where((Predicate)this.qBusinessPartnerDO.deleteFlag.eq((Object)0));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BookContactsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookId())) {
            list.add(this.qdo.bookId.eq((Object)query.getBookId()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getBookIdList())) {
            list.add(this.qdo.bookId.in((Collection)query.getBookIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsType())) {
            list.add(this.qdo.contactsType.eq((Object)query.getContactsType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsName())) {
            list.add(this.qdo.contactsName.eq((Object)query.getContactsName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsPhone())) {
            list.add(this.qdo.contactsPhone.eq((Object)query.getContactsPhone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsTelephone())) {
            list.add(this.qdo.contactsTelephone.eq((Object)query.getContactsTelephone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsEmail())) {
            list.add(this.qdo.contactsEmail.eq((Object)query.getContactsEmail()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsAddress())) {
            list.add(this.qdo.contactsAddress.eq((Object)query.getContactsAddress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSocialAccountType())) {
            list.add(this.qdo.socialAccountType.eq((Object)query.getSocialAccountType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSocialAccount())) {
            list.add(this.qdo.socialAccount.eq((Object)query.getSocialAccount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsDepartment())) {
            list.add(this.qdo.contactsDepartment.eq((Object)query.getContactsDepartment()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsPosition())) {
            list.add(this.qdo.contactsPosition.eq((Object)query.getContactsPosition()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsRelation())) {
            list.add(this.qdo.contactsRelation.eq((Object)query.getContactsRelation()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSex())) {
            list.add(this.qdo.sex.eq((Object)query.getSex()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBirthday())) {
            list.add(this.qdo.birthday.eq((Object)query.getBirthday()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsKeyPerson())) {
            list.add(this.qdo.isKeyPerson.eq(query.getIsKeyPerson()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsNo())) {
            list.add(this.qdo.contactsNo.eq((Object)query.getContactsNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsStatus())) {
            list.add(this.qdo.contactsStatus.eq((Object)query.getContactsStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsDefault())) {
            list.add(this.qdo.isDefault.eq(query.getIsDefault()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BookContactsVO queryByKey(Long id) {
        JPAQuery<BookContactsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookContactsVO)jpaQuery.fetchFirst();
    }

    public BookContactsVO queryDefaultByBookId(Long bookId) {
        JPAQuery<BookContactsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.isDefault.eq(Boolean.TRUE));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookContactsVO)jpaQuery.fetchFirst();
    }

    public List<BookContactsVO> queryListDynamic(BookContactsQuery query) {
        JPAQuery<BookContactsVO> jpaQuery = this.getJpaQueryWhere(query);
        OrderItem sortNoOrderItem = OrderItem.desc((String)"isDefault");
        OrderItem createTimeOrderItem = OrderItem.desc((String)"createTime");
        ArrayList<OrderItem> OrderItemList = new ArrayList<OrderItem>();
        OrderItemList.add(sortNoOrderItem);
        OrderItemList.add(createTimeOrderItem);
        query.setOrders(OrderItemList);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    public PagingVO<BookContactsVO> queryPaging(BookContactsQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BookContactsVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BookContactsDO save(BookContactsDO ado) {
        return (BookContactsDO)this.repo.save(ado);
    }

    public List<BookContactsDO> saveAll(List<BookContactsDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BookContactsPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getContactsType() != null) {
            update.set((Path)this.qdo.contactsType, (Object)payload.getContactsType());
        }
        if (payload.getContactsName() != null) {
            update.set((Path)this.qdo.contactsName, (Object)payload.getContactsName());
        }
        if (payload.getContactsPhone() != null) {
            update.set((Path)this.qdo.contactsPhone, (Object)payload.getContactsPhone());
        }
        if (payload.getContactsTelephone() != null) {
            update.set((Path)this.qdo.contactsTelephone, (Object)payload.getContactsTelephone());
        }
        if (payload.getContactsEmail() != null) {
            update.set((Path)this.qdo.contactsEmail, (Object)payload.getContactsEmail());
        }
        if (payload.getContactsAddress() != null) {
            update.set((Path)this.qdo.contactsAddress, (Object)payload.getContactsAddress());
        }
        if (payload.getSocialAccountType() != null) {
            update.set((Path)this.qdo.socialAccountType, (Object)payload.getSocialAccountType());
        }
        if (payload.getSocialAccount() != null) {
            update.set((Path)this.qdo.socialAccount, (Object)payload.getSocialAccount());
        }
        if (payload.getContactsDepartment() != null) {
            update.set((Path)this.qdo.contactsDepartment, (Object)payload.getContactsDepartment());
        }
        if (payload.getContactsPosition() != null) {
            update.set((Path)this.qdo.contactsPosition, (Object)payload.getContactsPosition());
        }
        if (payload.getContactsRelation() != null) {
            update.set((Path)this.qdo.contactsRelation, (Object)payload.getContactsRelation());
        }
        if (payload.getSex() != null) {
            update.set((Path)this.qdo.sex, (Object)payload.getSex());
        }
        if (payload.getBirthday() != null) {
            update.set(this.qdo.birthday, (Object)payload.getBirthday());
        }
        if (payload.getIsKeyPerson() != null) {
            update.set((Path)this.qdo.isKeyPerson, (Object)payload.getIsKeyPerson());
        }
        if (payload.getContactsNo() != null) {
            update.set((Path)this.qdo.contactsNo, (Object)payload.getContactsNo());
        }
        if (payload.getContactsStatus() != null) {
            update.set((Path)this.qdo.contactsStatus, (Object)payload.getContactsStatus());
        }
        if (payload.getIsDefault() != null) {
            update.set((Path)this.qdo.isDefault, (Object)payload.getIsDefault());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("contactsType")) {
                update.setNull((Path)this.qdo.contactsType);
            }
            if (nullFields.contains("contactsName")) {
                update.setNull((Path)this.qdo.contactsName);
            }
            if (nullFields.contains("contactsPhone")) {
                update.setNull((Path)this.qdo.contactsPhone);
            }
            if (nullFields.contains("contactsTelephone")) {
                update.setNull((Path)this.qdo.contactsTelephone);
            }
            if (nullFields.contains("contactsEmail")) {
                update.setNull((Path)this.qdo.contactsEmail);
            }
            if (nullFields.contains("contactsAddress")) {
                update.setNull((Path)this.qdo.contactsAddress);
            }
            if (nullFields.contains("socialAccountType")) {
                update.setNull((Path)this.qdo.socialAccountType);
            }
            if (nullFields.contains("socialAccount")) {
                update.setNull((Path)this.qdo.socialAccount);
            }
            if (nullFields.contains("contactsDepartment")) {
                update.setNull((Path)this.qdo.contactsDepartment);
            }
            if (nullFields.contains("contactsPosition")) {
                update.setNull((Path)this.qdo.contactsPosition);
            }
            if (nullFields.contains("contactsRelation")) {
                update.setNull((Path)this.qdo.contactsRelation);
            }
            if (nullFields.contains("sex")) {
                update.setNull((Path)this.qdo.sex);
            }
            if (nullFields.contains("birthday")) {
                update.setNull(this.qdo.birthday);
            }
            if (nullFields.contains("isKeyPerson")) {
                update.setNull((Path)this.qdo.isKeyPerson);
            }
            if (nullFields.contains("contactsNo")) {
                update.setNull((Path)this.qdo.contactsNo);
            }
            if (nullFields.contains("contactsStatus")) {
                update.setNull((Path)this.qdo.contactsStatus);
            }
            if (nullFields.contains("isDefault")) {
                update.setNull((Path)this.qdo.isDefault);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<BookContactsDO> queryByBookId(Long bookId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public BookContactsDAO(JPAQueryFactory jpaQueryFactory, BookContactsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

