/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentAccountantApprovePayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentDefaultQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.CostUndertakeDepartmentVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ed8\u6b3e\u7533\u8bf7\u5355"})
@RestController
@RequestMapping(value={"/api/crm/purchasePayment"})
@PermissionDomain(domain=PermissionDomainEnum.PAYMENT_APPLY)
public class PurchasePaymentController {
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentController.class);
    private final PurchasePaymentService purchasePaymentService;

    @PostMapping
    @ApiOperation(value="\u4ed8\u6b3e\u7533\u8bf7\u5355-\u65b0\u589e/\u4fee\u6539")
    @UdcNameClass
    public TwOutputUtil<PurchasePaymentVO> insertOrUpdate(@RequestBody PurchasePaymentPayload payload) {
        return TwOutputUtil.ok(this.purchasePaymentService.insertOrUpdate(payload));
    }

    @PostMapping(value={"/accountantApprove"})
    @ApiOperation(value="\u4ed8\u6b3e\u7533\u8bf7\u5355-\u5e94\u4ed8\u4f1a\u8ba1\u5ba1\u6279")
    @UdcNameClass
    public TwOutputUtil<PurchasePaymentVO> accountantApprove(@RequestBody PaymentAccountantApprovePayload payload) {
        return TwOutputUtil.ok(this.purchasePaymentService.accountantApprove(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u7533\u8bf7\u5355-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<PurchasePaymentVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.purchasePaymentService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u4ed8\u6b3e\u7533\u8bf7\u5355-\u5206\u9875")
    public TwOutputUtil<PagingVO<PurchasePaymentVO>> paging(PurchasePaymentQuery query) {
        return TwOutputUtil.ok(this.purchasePaymentService.queryPaging(query));
    }

    @PostMapping(value={"/permission/paging"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.PA_PAYMENT_LIST_DATA_POWER, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<PurchasePaymentVO>> permissionPaging(@RequestBody PurchasePaymentQuery query) {
        return TwOutputUtil.ok(this.purchasePaymentService.permissionPaging(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4ed8\u6b3e\u7533\u8bf7\u5355-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long id) {
        this.purchasePaymentService.deleteSoft(id, Boolean.valueOf(false));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/log/list/{key}"})
    public TwOutputUtil<List<PrdSystemLogVO>> queryLogList(@PathVariable Long key) {
        return TwOutputUtil.ok(this.purchasePaymentService.queryLogList(key));
    }

    @GetMapping(value={"/default"})
    @UdcNameClass
    public TwOutputUtil<PurchasePaymentVO> getDefaultByTypeAndDocNo(PurchasePaymentDefaultQuery defaultQuery) {
        return TwOutputUtil.ok(this.purchasePaymentService.getDefaultByTypeAndDocNo(defaultQuery));
    }

    @GetMapping(value={"/exportPaymentApply"})
    public void exportPaymentApply(HttpServletResponse response, PurchasePaymentQuery query) {
        this.purchasePaymentService.exportPaymentApply(response, query);
    }

    @PostMapping(value={"/permission/exportPaymentApply"})
    @UdcNameClass
    public void permissionExportPaymentApply(@RequestBody PurchasePaymentQuery query, HttpServletResponse response) {
        this.purchasePaymentService.permissionExportPaymentApply(response, query);
    }

    @GetMapping(value={"/findUrgentPaymentByProcInstId"})
    @UdcNameClass
    public TwOutputUtil<PurchasePaymentVO> findUrgentPaymentByProcInstId(String procInstId) {
        return TwOutputUtil.ok(this.purchasePaymentService.findUrgentPaymentByProcInstId(procInstId));
    }

    @GetMapping(value={"/queryByPurConOrAgreementId"})
    @ApiOperation(value="\u6839\u636e\u91c7\u8d2d\u5408\u540cIdOr\u91c7\u8d2d\u534f\u8baeId\u67e5\u8be2\u91c7\u8d2d\u660e\u7ec6")
    public TwOutputUtil<List<PurConOrAgreementDetailsSimpleVO>> queryByPurConOrAgreementId(Long purConOrAgreementId, String docType) {
        return TwOutputUtil.ok(this.purchasePaymentService.queryByPurConOrAgreementId(purConOrAgreementId, docType));
    }

    @GetMapping(value={"/queryByPurConOrInvoiceNo"})
    @ApiOperation(value="\u6839\u636e\u53d1\u7968\u53f7\u67e5\u8be2\u5df2\u7ecf\u4f20\u8f93JDE\u7684\u8d39\u7528\u90e8\u95e8\u627f\u62c5\u660e\u7ec6")
    @UdcNameClass
    public TwOutputUtil<List<CostUndertakeDepartmentVO>> queryByPurConOrInvoiceNo(String invoiceNo) {
        return TwOutputUtil.ok(this.purchasePaymentService.queryByPurConOrInvoiceNo(invoiceNo));
    }

    @PutMapping(value={"/queryByBatchPurConOrInvoiceNo"})
    @ApiOperation(value="\u6839\u636e\u53d1\u7968\u53f7\u67e5\u8be2\u5df2\u7ecf\u4f20\u8f93JDE\u7684\u8d39\u7528\u90e8\u95e8\u627f\u62c5\u660e\u7ec6")
    @UdcNameClass
    public TwOutputUtil<List<CostUndertakeDepartmentVO>> queryByBatchPurConOrInvoiceNo(@RequestBody PaymentSlipPayload payload) {
        if (Objects.isNull(payload) || CollectionUtils.isEmpty((Collection)payload.getInvoiceNos())) {
            return TwOutputUtil.error("\u53d1\u7968\u53f7\u6570\u636e\u4f20\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return TwOutputUtil.ok(this.purchasePaymentService.queryByPurConOrInvoiceNos(payload));
    }

    public PurchasePaymentController(PurchasePaymentService purchasePaymentService) {
        this.purchasePaymentService = purchasePaymentService;
    }
}

