/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.baiwang.bop.client.BopException;
import com.baiwang.open.entity.request.OutputEinvoiceQueryRequest;
import com.baiwang.open.entity.request.OutputInvoiceIssueRequest;
import com.baiwang.open.entity.request.OutputTransactionDeleteRequest;
import com.baiwang.open.entity.request.OutputTransactionQueryRequest;
import com.baiwang.open.entity.request.OutputTransactionUploadRequest;
import com.baiwang.open.entity.request.node.OutputEinvoiceQueryInvoiceQueryParam;
import com.baiwang.open.entity.request.node.OutputInvoiceIssueInvoiceDetail;
import com.baiwang.open.entity.request.node.OutputInvoiceIssuePreInvoice;
import com.baiwang.open.entity.request.node.OutputTransactionQueryParam;
import com.baiwang.open.entity.request.node.OutputTransactionUploadFlowSheet;
import com.baiwang.open.entity.request.node.OutputTransactionUploadFlowSheetDetail;
import com.baiwang.open.entity.response.OutputEinvoiceQueryResponse;
import com.baiwang.open.entity.response.OutputInvoiceIssueResponse;
import com.baiwang.open.entity.response.OutputTransactionDeleteResponse;
import com.baiwang.open.entity.response.OutputTransactionQueryResponse;
import com.baiwang.open.entity.response.OutputTransactionUploadResponse;
import com.baiwang.open.entity.response.node.OutputEinvoiceQuery;
import com.baiwang.open.entity.response.node.OutputInvoiceIssueInvoiceResult;
import com.baiwang.open.exception.BWOpenException;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchExcelExport;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchInvdtlPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchInvdtlService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SpelUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BatchStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.ReceStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TwInvoiceTypeEnum;
import com.elitesland.tw.tw5.server.prd.inv.config.TwInvoiceProperties;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvItemDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookInvoiceDAO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvBatchConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchInvdtlDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchInvdtlDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvBatchInvdtlRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvBatchRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivableRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.FileUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ConInvBatchServiceImpl
extends BaseServiceImpl
implements ConInvBatchService {
    private static final Logger log = LoggerFactory.getLogger(ConInvBatchServiceImpl.class);
    private final ConInvBatchRepo conInvBatchRepo;
    private final ConInvBatchDAO conInvBatchDAO;
    private final ConReceivablePlanDAO receivablePlanDAO;
    private final ConReceivablePlanRepo receivablePlanRepo;
    private final ConInvBatchInvdtlDAO conInvBatchInvdtlDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final ConReceivablePlanService receivablePlanService;
    private final InvItemDAO invItemDAO;
    private final BookInvoiceDAO bookInvoiceDAO;
    private final ConInvBatchInvdtlService conInvBatchInvdtlService;
    private final ConInvBatchInvdtlRepo conInvBatchInvdtlRepo;
    private final SaleConContractRepo saleConContractRepo;
    private final TransactionTemplate transactionTemplate;
    private final UdcUtil udcUtil;
    private final ExcelUtil excelUtil;
    private final FileService fileService;
    private final ConReceivableRepo conReceivableRepo;
    private final PrdOrgSyncLogDAO daoLog;
    private final TwInvoiceProperties invoiceProperties;
    @Autowired
    private TwInvoiceSendMsgService invoiceSendMsgService;
    private final PrdOrgEmployeeRepo employeeRepo;
    private final HttpUtil httpUtil;
    private final BusinessPartnerService businessPartnerService;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigService messageConfigService;
    private final ConInvSettingDAO conInvSettingDAO;
    private final FileUtilService fileUtilService;
    private final YeedocProperties yeedocProperties;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    @Value(value="${tw4.sale.contractInvBatch}")
    private String contractInvBatch;
    @Value(value="${tw4.sale.contractInvBatchInvDtl}")
    private String contractInvBatchInvDtl;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final PrdOrgEmployeeService employeeService;
    private final PrdSystemRoleDAO systemRoleDAO;

    public PagingVO<ConInvBatchVO> queryPaging(ConInvBatchQuery query) {
        this.getPermissionParams(query);
        PagingVO<ConInvBatchVO> conInvBatchVOPagingVO = this.conInvBatchDAO.queryPaging(query);
        List records = conInvBatchVOPagingVO.getRecords();
        for (ConInvBatchVO record : records) {
            ConReceivableDO conReceivableDO = this.conReceivableRepo.queryDistinctFirstByRecvClassAndSourceIdAndDeleteFlagOrderByCreateTimeDesc("1", record.getId(), 0);
            if (ObjectUtils.isEmpty((Object)conReceivableDO) || conReceivableDO.getLedgerDate() == null) continue;
            record.setLedgerDate(conReceivableDO.getLedgerDate());
        }
        return conInvBatchVOPagingVO;
    }

    private void getPermissionParams(ConInvBatchQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> financeRoles = Arrays.asList("FINANCE_MEMBER", "PLAT_FIN_CASHIER", "PLAT_FIN_MANAGER", "PLAT_CFO");
        List<String> oldRoles = Arrays.asList(RoleEnum.OPS.getCode(), RoleEnum.SYS.getCode(), RoleEnum.SALES_VP.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.SALES_CONTRACT_ADMIN.getCode(), RoleEnum.PLAT_RESOURCE_PIC.getCode(), RoleEnum.PLAT_FIN_CASHIER.getCode(), RoleEnum.PLAT_FIN_DATA_POWER.getCode());
        ArrayList<String> roles = new ArrayList<String>(oldRoles);
        roles.addAll(financeRoles);
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(roles);
        if (CollectionUtils.isEmpty(userIdsByRole) || !userIdsByRole.contains(loginUserId)) {
            List<PrdOrgOrganizationDO> organizationDOList = this.orgOrganizationDAO.queryByManagerId(loginUserId);
            Set<Long> orgIdList = null;
            if (!CollectionUtils.isEmpty(organizationDOList)) {
                orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                Set<Long> childOrgs = this.orgOrganizationDAO.queryAllChildOrgs(orgIdList);
                orgIdList.addAll(childOrgs);
                query.setAuthOuIds(orgIdList);
            } else {
                query.setCreateUserId(loginUserId);
            }
        }
    }

    public List<ConInvBatchVO> queryListDynamic(ConInvBatchQuery query) {
        return this.conInvBatchDAO.queryListDynamic(query);
    }

    public ConInvBatchVO queryByKey(Long key) {
        BookInvoiceVO bookInvoiceVO;
        ConInvBatchVO conInvBatchVO = this.conInvBatchDAO.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)conInvBatchVO)) {
            throw TwException.error("", "\u5355\u636e\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.hasText((String)conInvBatchVO.getRecipientInner())) {
            String recipientInnerDesc = Arrays.stream(conInvBatchVO.getRecipientInner().split(",")).filter(str -> !str.isEmpty()).map(Long::parseLong).map(userId -> this.cacheUtil.getUserName((Long)userId)).collect(Collectors.joining(","));
            conInvBatchVO.setRecipientInnerDesc(recipientInnerDesc);
        }
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setInvBatchId(key);
        List<ConReceivablePlanVO> conReceivablePlanVOS = this.receivablePlanDAO.queryListDynamic(query);
        conInvBatchVO.setReceivablePlanVOS(conReceivablePlanVOS);
        ConInvBatchInvdtlQuery invBatchInvdtlQuery = new ConInvBatchInvdtlQuery();
        invBatchInvdtlQuery.setInvbatchId(key);
        List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS = this.conInvBatchInvdtlDAO.queryListDynamic(invBatchInvdtlQuery);
        conInvBatchVO.setConInvBatchInvdtlVOS(conInvBatchInvdtlVOS);
        Long invItemId = conInvBatchVO.getInvItemId();
        if (invItemId != null) {
            conInvBatchVO.setInvItemVO(this.invItemDAO.queryByKey(invItemId));
        }
        if (conInvBatchVO.getInvoiceId() != null) {
            bookInvoiceVO = this.bookInvoiceDAO.queryByKey(conInvBatchVO.getInvoiceId());
            if (bookInvoiceVO != null) {
                this.udcUtil.translate(bookInvoiceVO);
            }
            conInvBatchVO.setPrdAbInvoiceVO(bookInvoiceVO);
        }
        if (conInvBatchVO.getInvOuId() != null && (bookInvoiceVO = this.bookInvoiceDAO.queryDefaultByBookId(conInvBatchVO.getInvOuId())) != null) {
            conInvBatchVO.setOuInvoiceVO(bookInvoiceVO);
        }
        return conInvBatchVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConInvBatchVO insert(ConInvBatchPayload payload) {
        if (payload.getTaxRate().compareTo(BigDecimal.valueOf(1L)) == 1) {
            throw TwException.error("", "\u5f00\u7968\u7a0e\u7387\u5f02\u5e38\uff0c\u5927\u4e8e\u4e86100%");
        }
        ConInvBatchDO entityDo = ConInvBatchConvert.INSTANCE.toDo(payload);
        entityDo.setBatchNo(this.generateSeqNum("CON_INV_BATCH", new String[0]));
        ConInvBatchDO save = (ConInvBatchDO)this.conInvBatchRepo.save(entityDo);
        this.receivablePlanDAO.setInvBatchId(save.getId(), payload.getConReceivablePlanIds());
        ConInvBatchVO conInvBatchVO = ConInvBatchConvert.INSTANCE.toVo(save);
        this.fileSaveOrUpdate(entityDo, payload);
        return conInvBatchVO;
    }

    private void fileSaveOrUpdate(ConInvBatchDO entityDo, ConInvBatchPayload payload) {
        if (!StringUtils.hasText((String)entityDo.getFolderId())) {
            ArrayList<String> pathArry = new ArrayList<String>();
            ConReceivablePlanVO conReceivablePlanVO = this.receivablePlanDAO.queryByInvBatchId(entityDo.getId());
            String saleConName = conReceivablePlanVO.getSaleConName();
            String projName = conReceivablePlanVO.getProjName();
            String projNo = conReceivablePlanVO.getProjNo();
            pathArry.add("/" + projNo + "-" + projName + "(" + saleConName + ")");
            String ydkFolderId = this.fileUtilService.createYdkFolder(this.yeedocProperties.getInvBatchLibraryId(), this.yeedocProperties.getInvBatchFolderId(), pathArry, payload.getAuthTokenByYdk());
            entityDo.setFolderId(ydkFolderId);
            payload.setFolderId(ydkFolderId);
        }
        List<Object> cacheKeys = new ArrayList();
        if (StringUtils.hasText((String)payload.getCacheKey())) {
            cacheKeys = Arrays.asList(payload.getCacheKey().split(","));
            Map<String, String> cacheMap = this.fileUtilService.saveYdkFile(this.yeedocProperties.getInvBatchLibraryId(), entityDo.getFolderId(), new HashSet<String>(cacheKeys), payload.getAuthTokenByYdk());
            String str = cacheKeys.stream().map(cacheMap::get).collect(Collectors.joining(","));
            if (StringUtils.hasText((String)payload.getFileCode())) {
                String newFileCodes = payload.getFileCode().concat(",").concat(str);
                payload.setFileCode(newFileCodes);
                entityDo.setFileCode(newFileCodes);
            } else {
                entityDo.setFileCode(str);
                payload.setFileCode(str);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateInvFlag(ConInvBatchPayload payload) {
        this.conInvBatchRepo.updateInvFlag(payload.getId(), payload.getInvFlag());
    }

    @Transactional(rollbackFor={Exception.class})
    public ConInvBatchVO update(ConInvBatchPayload payload) {
        ConInvBatchDO entity = this.conInvBatchRepo.findById(payload.getId()).orElseGet(ConInvBatchDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConInvBatchDO entityDo = ConInvBatchConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (StringUtils.hasText((String)payload.getCacheKey())) {
            this.fileSaveOrUpdate(entity, payload);
        }
        List conInvBatchInvdtlPayloads = payload.getConInvBatchInvdtlPayloads();
        if (payload.getBatchStatus() != null && payload.getBatchStatus().equals(BatchStatusEnum.APPROVINGINVBACK.getCode())) {
            long invAmtNullNum = conInvBatchInvdtlPayloads.stream().filter(e -> e.getInvAmt() == null).count();
            long netAmtNullNum = conInvBatchInvdtlPayloads.stream().filter(e -> e.getNetAmt() == null).count();
            if (invAmtNullNum > 0L || netAmtNullNum > 0L) {
                throw TwException.error("", "\u53d1\u7968\u91d1\u989d\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            List invAmtCollect = conInvBatchInvdtlPayloads.stream().map(e -> e.getInvAmt()).collect(Collectors.toList());
            List netAmtCollect = conInvBatchInvdtlPayloads.stream().map(e -> e.getNetAmt()).collect(Collectors.toList());
            BigDecimal invAmtSum = invAmtCollect.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal netAmtSum = netAmtCollect.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(invAmtSum) != 0) {
                throw TwException.error("", "\u9000\u7968\u65f6\u5f00\u7968\u91d1\u989d\u4e4b\u548c\u5fc5\u987b\u8981\u7b49\u4e8e0\uff01");
            }
            if (BigDecimal.ZERO.compareTo(netAmtSum) != 0) {
                throw TwException.error("", "\u9000\u7968\u65f6\u51c0\u989d\u4e4b\u548c\u5fc5\u987b\u8981\u7b49\u4e8e0\uff01");
            }
            entity.setInvAmt(BigDecimal.ZERO);
        } else if (payload.getBatchDate() != null) {
            if (!CollectionUtils.isEmpty((Collection)payload.getConReceivablePlanIds())) {
                this.receivablePlanDAO.updateInvAmt(payload.getConReceivablePlanIds(), payload.getBatchDate());
            } else {
                log.warn("\u66f4\u65b0\u6536\u6b3e\u8ba1\u5212\u8868\u5df2\u5f00\u7968\u91d1\u989d\u5931\u8d25\uff0cconReceivablePlanIds\u503c\u4e3a\u7a7a");
            }
            this.receivablePlanRepo.updateExpectRecvDate(payload.getId());
        }
        ConInvBatchVO conInvBatchVO = ConInvBatchConvert.INSTANCE.toVo((ConInvBatchDO)this.conInvBatchRepo.save(entity));
        if (!CollectionUtils.isEmpty((Collection)conInvBatchInvdtlPayloads)) {
            for (ConInvBatchInvdtlPayload conInvBatchInvdtlPayload : conInvBatchInvdtlPayloads) {
                conInvBatchInvdtlPayload.setInvbatchId(conInvBatchVO.getId());
                if (conInvBatchInvdtlPayload.getDeleteFlag() == 1) {
                    if (conInvBatchInvdtlPayload.getId() == null) continue;
                    this.conInvBatchInvdtlService.deleteSoft(Arrays.asList(conInvBatchInvdtlPayload.getId()));
                    continue;
                }
                if (conInvBatchInvdtlPayload.getId() == null || conInvBatchInvdtlPayload.getId() < 0L) {
                    this.conInvBatchInvdtlService.insert(conInvBatchInvdtlPayload);
                    continue;
                }
                this.conInvBatchInvdtlService.update(conInvBatchInvdtlPayload);
            }
        }
        return conInvBatchVO;
    }

    public void submitProc(Long key) {
        ConInvBatchVO conInvBatchVO = this.conInvBatchDAO.queryByKey(key);
        ProcessInfo processInfo = new ProcessInfo();
        String status = "";
        if (this.workflow_enabled.booleanValue()) {
            status = BatchStatusEnum.APPLYING.getCode();
            HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
            Long createUserId = conInvBatchVO.getCreateUserId();
            if (createUserId != null) {
                variables.put("Activity_16uktyp", CollUtil.newArrayList((Object[])new Long[]{createUserId}));
            }
            try {
                processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SALE_CON_INVOICING.name(), (String)(conInvBatchVO.getSubContractName() + "-\u5408\u540c\u5f00\u7968\u5ba1\u6279\u6d41\u7a0b"), (String)("" + conInvBatchVO.getId()), variables), new Long[0]);
            }
            catch (TwException e) {
                this.deleteSoft(Arrays.asList(key));
                ConReceivablePlanQuery planQuery = new ConReceivablePlanQuery();
                planQuery.setInvBatchIds(Arrays.asList(key));
                List<ConReceivablePlanVO> planList = this.receivablePlanDAO.queryListDynamic(planQuery);
                if (!CollectionUtils.isEmpty(planList)) {
                    List planIds = planList.stream().map(e1 -> e1.getId()).collect(Collectors.toList());
                    ConReceivablePlanPayload receivablePlan = new ConReceivablePlanPayload();
                    receivablePlan.setIds(planIds);
                    receivablePlan.setReceStatus(ReceStatusEnum.NO_INVOICE.getCode());
                    receivablePlan.setNullFields(Arrays.asList("invBatchId"));
                    this.receivablePlanDAO.updateByKeyDynamic(receivablePlan);
                }
                throw new BusinessException("\u6d41\u7a0b\u53d1\u8d77\u5931\u8d25\uff01" + e.getErrors().get(0).getMsg());
            }
        }
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setProcInstId(processInfo.getProcInstId());
        conInvBatchPayload.setId(conInvBatchVO.getId());
        conInvBatchPayload.setProcInstStatus(processInfo.getProcInstStatus());
        conInvBatchPayload.setSubmitTime(LocalDateTime.now());
        conInvBatchPayload.setBatchStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.conInvBatchDAO.updateByKeyDynamic(conInvBatchPayload));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ConInvBatchPayload payload) {
        ConInvBatchDO entity = this.conInvBatchRepo.findById(payload.getId()).orElseGet(ConInvBatchDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.fileSaveOrUpdate(entity, payload);
        long result = this.conInvBatchDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conInvBatchDAO.deleteSoft(keys);
        }
    }

    public List<ConReceivablePlanVO> queryRecvplanList(Long key) {
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setInvBatchId(key);
        return this.receivablePlanService.queryListDynamic(query);
    }

    public void returnTicket(Long invBatchId, String disDisc) {
        ConInvBatchVO conInvBatchVO = this.conInvBatchDAO.queryByKey(invBatchId);
        Assert.notNull((Object)conInvBatchVO.getId(), (String)"\u4e0d\u5b58\u5728");
        conInvBatchVO.setDisDisc(disDisc);
        this.conRefundProc(conInvBatchVO);
    }

    public List<ConInvBatchVO> getHistoryInv(Long custId, Long contractId) {
        List<Object> historyInvList = this.conInvBatchDAO.getHistoryInv(custId);
        for (ConInvBatchVO conInvBatchVO : historyInvList) {
            LocalDate actualInvDate = conInvBatchVO.getActualInvDate();
            if (actualInvDate == null) continue;
            conInvBatchVO.setBatchDate(actualInvDate);
        }
        historyInvList = historyInvList.stream().filter(e -> e.getBatchDate() != null).collect(Collectors.toList());
        ArrayList<ConInvBatchVO> sortedList = new ArrayList<ConInvBatchVO>();
        ArrayList<ConInvBatchVO> arrayList = new ArrayList<ConInvBatchVO>();
        ArrayList<ConInvBatchVO> otherContractList = new ArrayList<ConInvBatchVO>();
        for (ConInvBatchVO conInvBatchVO : historyInvList) {
            if (conInvBatchVO.getSubContractId().equals(contractId)) {
                arrayList.add(conInvBatchVO);
                continue;
            }
            otherContractList.add(conInvBatchVO);
        }
        this.sortList(arrayList);
        sortedList.addAll(arrayList);
        Map<Long, List<ConInvBatchVO>> groupedContracts = otherContractList.stream().collect(Collectors.groupingBy(ConInvBatchVO::getSubContractId));
        ArrayList<ConInvBatchVO> arrayList2 = new ArrayList<ConInvBatchVO>();
        for (Long key : groupedContracts.keySet()) {
            List<ConInvBatchVO> conInvBatchVOS = groupedContracts.get(key);
            this.sortList(conInvBatchVOS);
            ConInvBatchVO conInvBatchVO = conInvBatchVOS.get(0);
            arrayList2.add(conInvBatchVO);
        }
        this.sortList(arrayList2);
        for (ConInvBatchVO conInvBatchVO : arrayList2) {
            Long currentContractId = conInvBatchVO.getSubContractId();
            sortedList.addAll((Collection<ConInvBatchVO>)groupedContracts.get(currentContractId));
        }
        return sortedList;
    }

    private void sortList(List<ConInvBatchVO> conInvBatchVOS) {
        Collections.sort(conInvBatchVOS, new Comparator<ConInvBatchVO>(){

            @Override
            public int compare(ConInvBatchVO batch1, ConInvBatchVO batch2) {
                if (batch1.getBatchDate() == null && batch2.getBatchDate() == null) {
                    return 0;
                }
                if (batch1.getBatchDate() == null) {
                    return 1;
                }
                if (batch2.getBatchDate() == null) {
                    return -1;
                }
                return batch2.getBatchDate().compareTo(batch1.getBatchDate());
            }
        });
    }

    @Transactional
    public int completeInvBatch(ConInvBatchPayload payload) {
        this.update(payload);
        this.receivablePlanDAO.updateInvAmt(payload.getConReceivablePlanIds(), payload.getBatchDate());
        this.conInvBatchDAO.updateBatchStatusById(payload.getId(), "4");
        this.receivablePlanRepo.updateExpectRecvDate(payload.getId());
        return 1;
    }

    private void conRefundProc(ConInvBatchVO conInvBatchVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = "9";
        if (this.workflow_enabled.booleanValue()) {
            HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
            List<PrdOrgRoleVO> prdOrgRoleVOS = this.orgOrganizationDAO.queryRoleList(579786628726263285L);
            Optional<PrdOrgRoleVO> optional = prdOrgRoleVOS.stream().filter(e -> "PLAT_FIN_CHECK_PIC".equals(e.getRoleCode())).findFirst();
            if (!optional.isPresent()) {
                throw new BusinessException("\u8d22\u52a1\u7a3d\u6838\u4e13\u5458\uff08\u56e0\u516c\uff09\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
            }
            PrdOrgRoleVO prdOrgRoleVO = optional.get();
            String[] split = prdOrgRoleVO.getRoleEmployees().split(",");
            variables.put("Activity_1t2n7l4", Arrays.asList(split));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.CON_REFUND.name(), (String)(conInvBatchVO.getSubContractName() + "-\u5408\u540c\u5f00\u7968\u9000\u7968\u6d41\u7a0b"), (String)("" + conInvBatchVO.getId()), variables), new Long[0]);
        }
        ConInvBatchPayload payload = new ConInvBatchPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conInvBatchVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setBatchStatus(status);
        payload.setDisDisc(conInvBatchVO.getDisDisc());
        this.transactionUtilService.executeWithRunnable(() -> this.conInvBatchDAO.updateByKeyDynamic(payload));
    }

    public void outputInvoiceInBaiwang(Long invId, Integer invOrRefund) {
        ConInvBatchVO conInvBatchVO = this.queryByKey(invId);
        Long conOuId = conInvBatchVO.getInvOuId();
        if (conOuId == null) {
            throw new BusinessException("\u65e0\u6cd5\u67e5\u8be2\u5230\u5f00\u7968\u4e3b\u4f53");
        }
        List businessPartnerVOS = this.businessPartnerService.queryByBookId(conOuId);
        String taxRegNo = "";
        if (!CollectionUtils.isEmpty((Collection)businessPartnerVOS)) {
            taxRegNo = ((BusinessPartnerVO)businessPartnerVOS.get(0)).getIdenNo();
        }
        if (TwInvoiceTypeEnum.SHAPE.equals((Object)TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType()))) {
            return;
        }
        InvItemVO invoiceItem = conInvBatchVO.getInvItemVO();
        if (invoiceItem == null) {
            throw new BusinessException("\u53d1\u7968\u3010" + invId + "\u3011\u5546\u54c1\u4fe1\u606f\u83b7\u53d6\u5931\u8d25" + conInvBatchVO.getInvItemId());
        }
        BookInvoiceVO bookInvoiceVO = conInvBatchVO.getPrdAbInvoiceVO();
        if (bookInvoiceVO == null) {
            throw new BusinessException("\u53d1\u7968\u3010" + invId + "\u3011\u5f00\u7968\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        OutputInvoiceIssuePreInvoice data = new OutputInvoiceIssuePreInvoice();
        data.setSerialNo(conInvBatchVO.getBatchNo());
        data.setPriceTaxMark("1");
        data.setBuyerName(bookInvoiceVO.getInvoiceTitle());
        data.setBuyerTaxNo(bookInvoiceVO.getTaxNo());
        data.setBuyerBankAccount(bookInvoiceVO.getInvoiceAccount());
        data.setBuyerBankName(bookInvoiceVO.getDepositBank());
        data.setBuyerBankNumber(bookInvoiceVO.getInvoiceAccount());
        data.setBuyerAddress(bookInvoiceVO.getInvoiceAddress());
        data.setRemarks(conInvBatchVO.getInvRemark());
        switch (TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType())) {
            case EXCLUSIVE: {
                data.setInvoiceTypeCode("004");
                break;
            }
            case NORMAL: {
                data.setInvoiceTypeCode("007");
                break;
            }
            case ELEC_VAT_INV: {
                data.setInvoiceTypeCode("01");
                break;
            }
            case ELEC_NORMAL_INV: {
                data.setInvoiceTypeCode("02");
            }
        }
        ArrayList<OutputInvoiceIssueInvoiceDetail> invoiceDetailsList = new ArrayList<OutputInvoiceIssueInvoiceDetail>();
        OutputInvoiceIssueInvoiceDetail outputInvoiceIssueInvoiceDetail = new OutputInvoiceIssueInvoiceDetail();
        outputInvoiceIssueInvoiceDetail.setGoodsTaxRate(BigDecimal.valueOf(0.13));
        outputInvoiceIssueInvoiceDetail.setInvoiceLineNature("0");
        outputInvoiceIssueInvoiceDetail.setGoodsCode(invoiceItem.getGoodsCode());
        outputInvoiceIssueInvoiceDetail.setGoodsName(invoiceItem.getGoodsName());
        outputInvoiceIssueInvoiceDetail.setGoodsLineNo(Integer.valueOf(1));
        outputInvoiceIssueInvoiceDetail.setGoodsQuantity(BigDecimal.valueOf(1L));
        outputInvoiceIssueInvoiceDetail.setGoodsPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO);
        outputInvoiceIssueInvoiceDetail.setGoodsTaxRate(conInvBatchVO.getTaxRate() != null ? conInvBatchVO.getTaxRate() : BigDecimal.ZERO);
        outputInvoiceIssueInvoiceDetail.setGoodsTotalPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO);
        invoiceDetailsList.add(outputInvoiceIssueInvoiceDetail);
        data.setInvoiceDetailsList(invoiceDetailsList);
        OutputInvoiceIssueRequest request = new OutputInvoiceIssueRequest();
        request.setIsSplit(Boolean.valueOf(false));
        request.setData(data);
        request.setTaxNo(taxRegNo);
        request.setFormatGenerate(Boolean.valueOf(true));
        request.setFormatPushType(Boolean.valueOf(true));
        try {
            OutputInvoiceIssueResponse response = this.invoiceSendMsgService.outputInvoice(request);
            log.info("[\u5f00\u7968\u4fe1\u606f\u53d1\u9001\u767e\u671b\u7cfb\u7edf\u6210\u529f],response=" + response);
            if (!response.getSuccess().booleanValue()) {
                throw new BusinessException("\u5f00\u7968\u4fe1\u606f\u53d1\u9001\u767e\u671b\u7cfb\u7edf\u5931\u8d25\u3002");
            }
            List OutputInvoiceIssueInvoiceResult2 = response.getResponse().getSuccess();
            this.saveInvoiceMessage(OutputInvoiceIssueInvoiceResult2, conInvBatchVO);
        }
        catch (BWOpenException e) {
            log.error("[\u5f00\u7968\u4fe1\u606f\u53d1\u9001\u767e\u671b\u7cfb\u7edf\u5931\u8d25],\u8fd4\u56de\u4fe1\u606f\uff1a", (Throwable)e);
            throw new BusinessException("\u5f00\u7968\u4fe1\u606f\u53d1\u9001\u767e\u671b\u7cfb\u7edf\u5931\u8d25\u3002" + e.getSubMessage());
        }
    }

    private void saveInvoiceMessage(List<OutputInvoiceIssueInvoiceResult> reInvs, ConInvBatchVO conInvBatchVO) {
        if (!CollectionUtils.isEmpty(reInvs)) {
            for (OutputInvoiceIssueInvoiceResult mainInfo : reInvs) {
                String invNo = mainInfo.getInvoiceNo();
                int num = this.conInvBatchInvdtlRepo.countInvByNo(invNo);
                if (num > 0) {
                    log.info(String.format("\u53d1\u7968%s\u5df2\u5b58\u5728,\u8df3\u8fc7\u63d2\u5165", num));
                    continue;
                }
                ConInvBatchInvdtlDO invbatchInvdtl = new ConInvBatchInvdtlDO();
                invbatchInvdtl.setInvbatchId(conInvBatchVO.getId());
                invbatchInvdtl.setInvNo(mainInfo.getInvoiceNo());
                invbatchInvdtl.setNetAmt(mainInfo.getInvoiceTotalPrice());
                invbatchInvdtl.setTaxAmt(mainInfo.getInvoiceTotalTax());
                invbatchInvdtl.setInvAmt(mainInfo.getInvoiceTotalPriceTax());
                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());
                invbatchInvdtl.setInvStatus("NORMAL");
                invbatchInvdtl.setTaxRate(conInvBatchVO.getTaxRate());
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                LocalDate date = LocalDate.parse(mainInfo.getInvoiceDate(), formatter);
                invbatchInvdtl.setActualInvDate(date);
                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());
                invbatchInvdtl.setComeFrom("BAIWANG");
                this.conInvBatchInvdtlDAO.save(invbatchInvdtl);
            }
        } else {
            log.info("[\u767e\u671b\u7cfb\u7edf\u83b7\u53d6\u5f00\u7968\u4fe1\u606f\u6210\u529f\uff0c\u53d1\u7968\u5217\u8868\u4e3a\u7a7a],TW\u6279\u6b21\u53f7\uff1a" + conInvBatchVO.getBatchNo());
        }
    }

    public void sendInvInfoToBaiwang(Long invId, Integer invOrRefund) {
        ConInvBatchVO conInvBatchVO = this.queryByKey(invId);
        Long conOuId = conInvBatchVO.getInvOuId();
        if (conOuId == null) {
            throw new BusinessException("\u65e0\u6cd5\u67e5\u8be2\u5230\u5f00\u7968\u4e3b\u4f53");
        }
        List businessPartnerVOS = this.businessPartnerService.queryByBookId(conOuId);
        String taxRegNo = "";
        if (!CollectionUtils.isEmpty((Collection)businessPartnerVOS)) {
            taxRegNo = ((BusinessPartnerVO)businessPartnerVOS.get(0)).getIdenNo();
        }
        if (TwInvoiceTypeEnum.SHAPE.equals((Object)TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType()))) {
            return;
        }
        if (conInvBatchVO.getInvAmt() != null && conInvBatchVO.getInvAmt().compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)businessPartnerVOS) || !StringUtils.hasText((String)((BusinessPartnerVO)businessPartnerVOS.get(0)).getPartnerName()) || !((BusinessPartnerVO)businessPartnerVOS.get(0)).getPartnerName().contains("\u57c3\u6797\u54f2")) {
            return;
        }
        InvItemVO invoiceItem = conInvBatchVO.getInvItemVO();
        if (invoiceItem == null) {
            throw new BusinessException("\u53d1\u7968\u3010" + invId + "\u3011\u5546\u54c1\u4fe1\u606f\u83b7\u53d6\u5931\u8d25" + conInvBatchVO.getInvItemId());
        }
        BookInvoiceVO bookInvoiceVO = conInvBatchVO.getPrdAbInvoiceVO();
        if (bookInvoiceVO == null) {
            throw new BusinessException("\u53d1\u7968\u3010" + invId + "\u3011\u5f00\u7968\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        OutputTransactionUploadFlowSheetDetail flowSingleInfo = new OutputTransactionUploadFlowSheetDetail();
        flowSingleInfo.setGoodsCode(invoiceItem.getGoodsCode());
        flowSingleInfo.setGoodsName(invoiceItem.getGoodsName());
        flowSingleInfo.setInvoiceLineNature("0");
        flowSingleInfo.setGoodsLineNo("1");
        flowSingleInfo.setGoodsQuantity(BigDecimal.ONE);
        flowSingleInfo.setGoodsPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO);
        flowSingleInfo.setGoodsTaxRate(conInvBatchVO.getTaxRate() != null ? conInvBatchVO.getTaxRate() : BigDecimal.ZERO);
        flowSingleInfo.setGoodsTotalPrice(conInvBatchVO.getBatchInvAmt() != null ? conInvBatchVO.getBatchInvAmt() : BigDecimal.ZERO);
        ArrayList<OutputTransactionUploadFlowSheetDetail> listFlowSingleInfo = new ArrayList<OutputTransactionUploadFlowSheetDetail>();
        listFlowSingleInfo.add(flowSingleInfo);
        OutputTransactionUploadFlowSheet flowSingle = new OutputTransactionUploadFlowSheet();
        flowSingle.setFlowSheetDetailList(listFlowSingleInfo);
        flowSingle.setSerialNo(conInvBatchVO.getBatchNo());
        switch (TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType())) {
            case EXCLUSIVE: {
                flowSingle.setInvoiceTypeCode("004");
                break;
            }
            case NORMAL: {
                flowSingle.setInvoiceTypeCode("007");
                break;
            }
            case ELEC_VAT_INV: {
                flowSingle.setInvoiceTypeCode("01");
                break;
            }
            case ELEC_NORMAL_INV: {
                flowSingle.setInvoiceTypeCode("02");
            }
        }
        if (conInvBatchVO.getBatchDate() != null) {
            Date date = Date.from(conInvBatchVO.getBatchDate().atStartOfDay(ZoneId.systemDefault()).toInstant());
            flowSingle.setCreateDate(date);
        }
        flowSingle.setPriceTaxMark(invoiceItem.getPriceTaxMark());
        flowSingle.setContractNo(conInvBatchVO.getSubContractNo());
        flowSingle.setBuyerName(bookInvoiceVO.getInvoiceTitle());
        flowSingle.setBuyerTaxNo(bookInvoiceVO.getTaxNo());
        flowSingle.setBuyerAddressPhone(bookInvoiceVO.getInvoicePhone());
        flowSingle.setBuyerBankAccount(bookInvoiceVO.getInvoiceAccount());
        flowSingle.setBuyerBankName(bookInvoiceVO.getDepositBank());
        flowSingle.setBuyerBankNumber(bookInvoiceVO.getInvoiceAccount());
        flowSingle.setBuyerAddress(bookInvoiceVO.getInvoiceAddress());
        flowSingle.setBuyerTelphone(bookInvoiceVO.getInvoicePhone());
        flowSingle.setBuyerPhone(bookInvoiceVO.getInvoicePhone());
        flowSingle.setRemarks(conInvBatchVO.getInvRemark());
        ArrayList<OutputTransactionUploadFlowSheet> data = new ArrayList<OutputTransactionUploadFlowSheet>();
        data.add(flowSingle);
        OutputTransactionUploadRequest request = new OutputTransactionUploadRequest();
        request.setTaxNo(taxRegNo);
        request.setData(data);
        try {
            OutputTransactionUploadResponse response = this.invoiceSendMsgService.flowSingleImport(request);
            log.info("[\u5f00\u7968\u4fe1\u606f\u53d1\u9001\u767e\u671b\u7cfb\u7edf\u6210\u529f],response=", (Object)response);
        }
        catch (BWOpenException e) {
            log.error("[\u5f00\u7968\u4fe1\u606f\u53d1\u9001\u767e\u671b\u7cfb\u7edf\u5931\u8d25],\u8fd4\u56de\u4fe1\u606f\uff1a", (Throwable)e);
            throw new BusinessException("\u5f00\u7968\u4fe1\u606f\u53d1\u9001\u767e\u671b\u7cfb\u7edf\u5931\u8d25\u3002" + e.getSubMessage());
        }
    }

    public void deleteInvInfoToBaiwang(Long invId, Integer invOrRefund) {
        boolean flag;
        String taxRegNo;
        ConInvBatchVO conInvBatchVO;
        block11: {
            int invNum;
            if (invOrRefund == 1 && (invNum = this.conInvBatchInvdtlRepo.findInvBatchInvDtlsCount(invId)) > 0) {
                throw new BusinessException("\u5355\u636e\u5df2\u5b58\u5728\u53d1\u7968\u4fe1\u606f\uff0c\u7981\u6b62\u9000\u56de\u3002");
            }
            log.info("\u5f85\u5220\u9664\u5f00\u7968id::::" + invId);
            conInvBatchVO = this.queryByKey(invId);
            log.info("\u5408\u540c\u5f00\u7968vo::::" + conInvBatchVO);
            log.info("\u5408\u540c\u5f00\u7968vo::::" + conInvBatchVO.toString());
            Long conOuId = conInvBatchVO.getInvOuId();
            log.info("\u5408\u540c\u5f00\u7968void::::" + conInvBatchVO.getInvOuId());
            if (conOuId == null) {
                log.info("\u65e0\u6cd5\u67e5\u8be2\u5230\u5f00\u7968\u4e3b\u4f53::::\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a\uff1a");
                throw new BusinessException("\u65e0\u6cd5\u67e5\u8be2\u5230\u5f00\u7968\u4e3b\u4f53");
            }
            List businessPartnerVOS = this.businessPartnerService.queryByBookId(conOuId);
            taxRegNo = "";
            if (!CollectionUtils.isEmpty((Collection)businessPartnerVOS) && !StringUtils.hasText((String)(taxRegNo = ((BusinessPartnerVO)businessPartnerVOS.get(0)).getIdenNo()))) {
                throw new BusinessException("\u65e0\u6cd5\u67e5\u8be2\u5230\u5f00\u7968\u4e3b\u4f53\u7684\u7a0e\u53f7");
            }
            if (TwInvoiceTypeEnum.SHAPE.equals((Object)TwInvoiceTypeEnum.valueOf(conInvBatchVO.getInvType()))) {
                return;
            }
            flag = false;
            try {
                OutputTransactionQueryRequest queryRequest = new OutputTransactionQueryRequest();
                OutputTransactionQueryParam data = new OutputTransactionQueryParam();
                data.setSerialNo(conInvBatchVO.getBatchNo());
                queryRequest.setTaxNo(taxRegNo);
                queryRequest.setData(data);
                OutputTransactionQueryResponse queryResponse = this.invoiceSendMsgService.flowSingleQuery(queryRequest);
                if (queryResponse.getSuccess().booleanValue() && queryResponse.getResponse().size() > 0) {
                    flag = true;
                }
            }
            catch (BopException e) {
                log.error("[\u5f00\u7968\u4fe1\u606f\u4ece\u767e\u671b\u7cfb\u7edf\u5220\u9664\u5931\u8d25(\u67e5\u8be2\u6d41\u6c34\u5355\u4fe1\u606f\u5931\u8d25)],\u8fd4\u56de\u4fe1\u606f\uff1a", (Throwable)e);
                if (e.getMessage().contains("\u6839\u636e\u6d41\u6c34\u5355\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01")) break block11;
                throw new BusinessException("\u8be5\u5f00\u7968\u7533\u8bf7\u5728\u767e\u671b\u7cfb\u7edf\u7684\u6d41\u6c34\u5355\u5df2\u65e0\u6cd5\u5220\u9664\uff0c\u4e0d\u80fd\u62d2\u7edd\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u3002");
            }
        }
        if (flag) {
            try {
                OutputTransactionDeleteRequest request = new OutputTransactionDeleteRequest();
                request.setTaxNo(taxRegNo);
                request.setData(conInvBatchVO.getBatchNo());
                if (conInvBatchVO.getBatchNo() != null) {
                    OutputTransactionDeleteResponse response = this.invoiceSendMsgService.flowSingleDelete(request);
                    log.info("[\u5f00\u7968\u4fe1\u606f\u4ece\u767e\u671b\u7cfb\u7edf\u5220\u9664\u6210\u529f],response=", (Object)response);
                }
            }
            catch (BopException e) {
                log.error("[\u5f00\u7968\u4fe1\u606f\u4ece\u767e\u671b\u7cfb\u7edf\u5220\u9664\u5931\u8d25],\u8fd4\u56de\u4fe1\u606f\uff1a", (Throwable)e);
                throw new BusinessException("\u8be5\u5f00\u7968\u7533\u8bf7\u5728\u767e\u671b\u7cfb\u7edf\u7684\u6d41\u6c34\u5355\u5df2\u65e0\u6cd5\u5220\u9664\uff0c\u4e0d\u80fd\u62d2\u7edd\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u3002");
            }
        }
    }

    public int getInvoicesFromBaiwang() {
        ConInvSettingQuery query = new ConInvSettingQuery();
        query.setInvYear(Integer.valueOf(LocalDate.now().getYear()));
        List<ConInvSettingVO> conInvSettingVOS = this.conInvSettingDAO.queryListDynamic(query);
        List<Long> ouIds = conInvSettingVOS.stream().map(e -> e.getInvOuId()).collect(Collectors.toList());
        List<ConInvBatchDO> invBatchNos = this.conInvBatchRepo.findByBatchStatusInAndInvTypeNotAndInvOuIdIn(Arrays.asList(BatchStatusEnum.APPROVETOINV.getCode(), BatchStatusEnum.APPROVINGINVBACK.getCode()), TwInvoiceTypeEnum.SHAPE.getType(), ouIds);
        for (ConInvBatchDO batchDO : invBatchNos) {
            String batchNo = batchDO.getBatchNo();
            Long invBatchId = batchDO.getId();
            BigDecimal invAmt = batchDO.getInvAmt() == null ? BigDecimal.ZERO : batchDO.getInvAmt();
            Long invOuId = batchDO.getInvOuId();
            if (invOuId == null) {
                XxlJobLogger.log((String)("\u65e0\u6cd5\u67e5\u8be2\u5230\u5f00\u7968\u4e3b\u4f53,\u8df3\u8fc7,\u6279\u6b21\u53f7" + batchNo), (Object[])new Object[0]);
                continue;
            }
            List businessPartnerVOS = this.businessPartnerService.queryByBookId(invOuId);
            String taxRegNo = "";
            if (!CollectionUtils.isEmpty((Collection)businessPartnerVOS)) {
                taxRegNo = ((BusinessPartnerVO)businessPartnerVOS.get(0)).getIdenNo();
            }
            int length = invAmt.divide(this.invoiceProperties.getMaxInvAmt(), 0, 2).intValue();
            ArrayList<Object> batchNos = new ArrayList<Object>();
            if (length == 1 || length == 0) {
                batchNos.add(batchNo);
            } else {
                ++length;
                for (int i = 1; i < length; ++i) {
                    batchNos.add(batchNo + "-" + i);
                }
            }
            for (String string : batchNos) {
                OutputEinvoiceQueryRequest request = new OutputEinvoiceQueryRequest();
                OutputEinvoiceQueryInvoiceQueryParam data = new OutputEinvoiceQueryInvoiceQueryParam();
                data.setPageNo(Integer.valueOf(1));
                data.setPageSize(Integer.valueOf(500));
                data.setSerialNo(string);
                request.setData(data);
                request.setTaxNo(taxRegNo);
                try {
                    OutputEinvoiceQueryResponse response = this.invoiceSendMsgService.invoiceQuery(request);
                    if (response.getSuccess().booleanValue() && response.getResponse().size() > 0) {
                        List reInvs = response.getResponse();
                        if (!CollectionUtils.isEmpty((Collection)reInvs)) {
                            for (OutputEinvoiceQuery mainInfo : reInvs) {
                                String invNo = mainInfo.getInvoiceNo();
                                int num = this.conInvBatchInvdtlRepo.countInvByNo(invNo);
                                if (num > 0) {
                                    log.info(String.format("\u53d1\u7968%s\u5df2\u5b58\u5728,\u8df3\u8fc7\u63d2\u5165", num));
                                    continue;
                                }
                                ConInvBatchInvdtlDO invbatchInvdtl = new ConInvBatchInvdtlDO();
                                invbatchInvdtl.setInvbatchId(invBatchId);
                                invbatchInvdtl.setInvNo(mainInfo.getInvoiceNo());
                                invbatchInvdtl.setNetAmt(mainInfo.getInvoiceTotalPrice());
                                invbatchInvdtl.setTaxAmt(mainInfo.getInvoiceTotalTax());
                                invbatchInvdtl.setInvAmt(mainInfo.getInvoiceTotalPriceTax());
                                if ("00".equals(mainInfo.getInvoiceStatus())) {
                                    invbatchInvdtl.setInvStatus("NORMAL");
                                } else {
                                    invbatchInvdtl.setInvStatus("INVALID");
                                }
                                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());
                                invbatchInvdtl.setTaxRate(batchDO.getTaxRate());
                                invbatchInvdtl.setActualInvDate(LocalDate.parse(mainInfo.getInvoiceDate().substring(0, 10)));
                                invbatchInvdtl.setDownloadUrl(mainInfo.getEInvoiceUrl());
                                invbatchInvdtl.setComeFrom("BAIWANG");
                                this.conInvBatchInvdtlDAO.save(invbatchInvdtl);
                            }
                            continue;
                        }
                        log.info("[\u767e\u671b\u7cfb\u7edf\u83b7\u53d6\u5f00\u7968\u4fe1\u606f\u6210\u529f\uff0c\u53d1\u7968\u5217\u8868\u4e3a\u7a7a],TW\u6279\u6b21\u53f7\uff1a", new Object[]{batchNo, ",\u767e\u671b\u6d41\u6c34\u53f7\uff1a", string, ",response=", response});
                        continue;
                    }
                    log.info("[\u767e\u671b\u7cfb\u7edf\u83b7\u53d6\u5f00\u7968\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a],TW\u6279\u6b21\u53f7\uff1a", new Object[]{batchNo, ",\u767e\u671b\u6d41\u6c34\u53f7\uff1a", string, ",response=", response});
                }
                catch (BopException e2) {
                    log.error("[\u767e\u671b\u7cfb\u7edf\u83b7\u53d6\u5f00\u7968\u4fe1\u606f\u5931\u8d25],TW\u6279\u6b21\u53f7\uff1a", new Object[]{batchNo, ",\u767e\u671b\u6d41\u6c34\u53f7\uff1a", string, ",response=", e2});
                }
            }
        }
        return 0;
    }

    public void downloadBatch(HttpServletResponse response, ConInvBatchQuery query) {
        try {
            Object workbook = null;
            String fileName = "\u5408\u540c\u5f00\u7968\u6570\u636e-" + LocalDate.now();
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            List<ConInvBatchVO> conInvBatchVOS = this.conInvBatchDAO.queryListDynamic(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            this.download(conInvBatchVOS, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<ConInvBatchVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        records = this.udcUtil.translateList(records);
        String sheetName = "\u6536\u6b3e\u8ba1\u5212\u6570\u636e";
        List<ConInvBatchExcelExport> resultList = ConInvBatchConvert.INSTANCE.voListVoExcelExport(records);
        for (ConInvBatchExcelExport record : resultList) {
            record.setOrder(String.valueOf(order));
            ++order;
        }
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ConInvBatchExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, ConInvBatchExcelExport.class, null);
        sheet.doWrite(resultList);
    }

    public String reject(Long[] ids) {
        List<Long> idsList = Arrays.asList(ids);
        ConInvBatchQuery query = new ConInvBatchQuery();
        query.setIds(idsList);
        List<ConInvBatchVO> invList = this.conInvBatchDAO.queryListDynamic(query);
        if (invList == null || invList.size() == 0) {
            return "\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u5408\u540c\u5f00\u7968\u4fe1\u606f\uff1b\u5408\u540c\u5f00\u7968\u8868\u4e3b\u952e" + Arrays.toString((Object[])ids);
        }
        ConReceivablePlanQuery planQuery = new ConReceivablePlanQuery();
        planQuery.setInvBatchIds(idsList);
        List<ConReceivablePlanVO> planList = this.receivablePlanDAO.queryListDynamic(planQuery);
        if (planList == null || planList.size() <= 0) {
            return "\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u8ba1\u5212\u4fe1\u606f\uff1b\u5408\u540c\u5f00\u7968\u8868\u4e3b\u952e" + Arrays.toString((Object[])ids);
        }
        boolean allMatch = invList.stream().allMatch(inv -> "4".equals(inv.getBatchStatus()));
        if (!allMatch) {
            invList.stream().filter(inv -> !"4".equals(inv.getBatchStatus())).forEach(inv -> log.info("\u5f00\u7968\u6279\u6b21\u4e0d\u662f\u3010\u5df2\u5f00\u7968\u672a\u6536\u6b3e\u3011\u5408\u540c\u5f00\u7968\u8868id=" + inv.getId() + ";\u6279\u6b21\u72b6\u6001=" + inv.getBatchStatus()));
            return "\u5f00\u7968\u6279\u6b21\u72b6\u6001\u4e0d\u662f[\u5df2\u5f00\u7968\u672a\u6536\u6b3e],\u4e0d\u80fd\u9000\u56de\uff01";
        }
        allMatch = planList.stream().allMatch(plan -> "4".equals(plan.getReceStatus()));
        if (!allMatch) {
            planList.stream().filter(plan -> !"4".equals(plan.getReceStatus())).forEach(plan -> log.info("\u6536\u6b3e\u8ba1\u5212\u7684\u8ba1\u5212\u72b6\u6001\u4e0d\u662f\u3010\u5df2\u5f00\u7968\u3011\u6536\u6b3e\u8ba1\u5212\u8868id" + plan.getId() + ";\u6536\u6b3e\u72b6\u6001" + plan.getReceStatus()));
            return "\u6536\u6b3e\u8ba1\u5212\u7684\u8ba1\u5212\u72b6\u6001\u4e0d\u662f\u3010\u5df2\u5f00\u7968\u3011,\u4e0d\u80fd\u9000\u56de";
        }
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setIds(idsList);
        conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPROVETOINV.getCode());
        this.conInvBatchDAO.updateByKeyDynamic(conInvBatchPayload);
        List planIds = planList.stream().map(e -> e.getId()).collect(Collectors.toList());
        ConReceivablePlanPayload receivablePlan = new ConReceivablePlanPayload();
        receivablePlan.setIds(planIds);
        receivablePlan.setReceStatus(ReceStatusEnum.NO_INVOICE.getCode());
        this.receivablePlanDAO.updateByKeyDynamic(receivablePlan);
        return "";
    }

    public void syncContractInvBatchTo4(String param) {
        LocalDateTime syncTime;
        String syncType = "contract_invbatch_to4";
        syncTime = StringUtils.hasText((String)param) ? LocalDateTime.parse(param) : ((syncTime = this.daoLog.queryOrgSyncLog(syncType)) == null ? LocalDateTime.of(2023, 11, 1, 0, 0) : syncTime.minusSeconds(30L));
        XxlJobLogger.log((String)"\u5408\u540c\u5f00\u7968\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncContractInvBatchTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        String format = DateUtil.format((LocalDateTime)syncTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<ConInvBatchDO> invBatchDOS = this.conInvBatchRepo.findByModifyTimeStart(format);
        Object syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(invBatchDOS)) {
            Map<Long, Long> v4AndV5UserIds = this.employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConInvBatchDO temDo : invBatchDOS) {
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag", temDo.getDeleteFlag());
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
                    map.put("taxRate", temDo.getTaxRate().multiply(BigDecimal.valueOf(100L)));
                    HashMap data = new HashMap();
                    if (("" + data.get("ok")).equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        this.conInvBatchRepo.updateInvBatchIdV4(idV4, temDo.getId());
                        continue;
                    }
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u5f00\u7968id" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + data.get("datum"), null);
                    this.conInvBatchRepo.updateRemark(temDo.getId());
                    ++failNum;
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)("\u5408\u540c\u5f00\u7968" + temDo.getBatchNo() + "\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u5f00\u7968id" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e, null);
                    ++failNum;
                    this.conInvBatchRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "\u66f4\u65b0\u4e86" + (invBatchDOS.size() - failNum) + "\u6570\u636e,\u6709" + failNum + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
        } else {
            syncData = "\u5408\u540c\u5f00\u7968\u6570\u636e\u672a\u53d8\u5316";
        }
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, (String)syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u5408\u540c\u5f00\u7968\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    public void syncContractInvBatchInvDtlTo4(String param) {
        LocalDateTime syncTime;
        String syncType = "contract_invbatch_invdtl_to4";
        syncTime = StringUtils.hasText((String)param) ? LocalDateTime.parse(param) : ((syncTime = this.daoLog.queryOrgSyncLog(syncType)) == null ? LocalDateTime.of(2023, 11, 1, 0, 0) : syncTime.minusSeconds(30L));
        XxlJobLogger.log((String)"\u5408\u540c\u5f00\u7968\u53d1\u7968\u540c\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncContractInvBatchTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        String format = DateUtil.format((LocalDateTime)syncTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<ConInvBatchInvdtlDO> invBatchInvdtlDOS = this.conInvBatchInvdtlRepo.findByModifyTimeStart(format);
        Object syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(invBatchInvdtlDOS)) {
            Map<Long, Long> v4AndV5UserIds = this.employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConInvBatchInvdtlDO temDo : invBatchInvdtlDOS) {
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag", temDo.getDeleteFlag());
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
                    HashMap data = new HashMap();
                    if (("" + data.get("ok")).equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        this.conInvBatchInvdtlRepo.updateInvBatchInvdtlIdV4(idV4, temDo.getId());
                        continue;
                    }
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u5f00\u7968id" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + data.get("datum"), null);
                    this.conInvBatchInvdtlRepo.updateRemark(temDo.getId());
                    ++failNum;
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)("\u5408\u540c\u5f00\u7968\u53d1\u7968" + temDo.getInvNo() + "\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u5f00\u7968\u53d1\u7968id" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e, null);
                    ++failNum;
                    this.conInvBatchInvdtlRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "\u66f4\u65b0\u4e86" + (invBatchInvdtlDOS.size() - failNum) + "\u6570\u636e,\u6709" + failNum + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
        } else {
            syncData = "\u5408\u540c\u5f00\u7968\u6570\u636e\u672a\u53d8\u5316";
        }
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, (String)syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u5408\u540c\u5f00\u7968\u53d1\u7968\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void sendEmail(ConInvBatchVO conInvBatchVO) {
        conInvBatchVO = (ConInvBatchVO)this.udcUtil.translate(conInvBatchVO);
        PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20240322001501");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("custName", conInvBatchVO.getInvTitle());
        result.put("contractName", conInvBatchVO.getContractName());
        result.put("invoiceType", conInvBatchVO.getInvTypeDesc() + "/" + conInvBatchVO.getTaxRate().multiply(BigDecimal.valueOf(100L)) + "%");
        result.put("phaseDesc", conInvBatchVO.getPhaseDesc());
        result.put("invContent", conInvBatchVO.getGoodsNameStr());
        String formattedNumber = conInvBatchVO.getBatchInvAmt() == null ? "" : String.format("%,.2f", conInvBatchVO.getBatchInvAmt());
        result.put("invAmt", formattedNumber);
        result.put("invNo", conInvBatchVO.getInvNo());
        result.put("invOuName", conInvBatchVO.getInvOuName());
        String downloadCollect = conInvBatchVO.getConInvBatchInvdtlVOS().stream().filter(e -> StringUtils.hasText((String)e.getDownloadUrl())).map(e -> e.getDownloadUrl()).collect(Collectors.joining(","));
        result.put("downloadUrl", downloadCollect.replaceAll("http", "https"));
        String recipientInner = conInvBatchVO.getRecipientInner();
        ArrayList<Long> userIdList = new ArrayList<Long>();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
        userIdList.addAll(userIdsByRole);
        if (!ObjectUtils.isEmpty((Object)recipientInner)) {
            List recipientInnerList = Arrays.stream(recipientInner.split(",")).filter(str -> !str.isEmpty()).map(Long::parseLong).collect(Collectors.toList());
            userIdList.addAll(recipientInnerList);
        }
        List prdOrgEmployeeVOS = this.employeeService.queryByUserIdIn(userIdList);
        List emailCollect = prdOrgEmployeeVOS.stream().map(e -> e.getEmail()).collect(Collectors.toList());
        String releaseTitle = SpelUtil.parseStringExpression(configVO.getMessageTitle(), result);
        String releaseBody = SpelUtil.parseStringExpression(configVO.getMessageContent(), result);
        String recipientOuter = conInvBatchVO.getRecipientOuter();
        if (!ObjectUtils.isEmpty((Object)recipientOuter)) {
            List recipientOuterCollect = Arrays.stream(recipientOuter.split("[,;\uff0c\uff1b]")).collect(Collectors.toList());
            emailCollect.addAll(recipientOuterCollect);
        }
        List distinctList = emailCollect.stream().distinct().collect(Collectors.toList());
        String invEmail = conInvBatchVO.getInvEmail();
        distinctList.remove(invEmail);
        this.messageConfigService.sendEmailWithCc(Collections.singletonList(invEmail), distinctList, releaseTitle, releaseBody, configVO.getSource());
    }

    @Transactional
    public Long updateBatchStatusById(Long id, String batchStatus) {
        return this.conInvBatchDAO.updateBatchStatusById(id, batchStatus);
    }

    public ConInvBatchServiceImpl(ConInvBatchRepo conInvBatchRepo, ConInvBatchDAO conInvBatchDAO, ConReceivablePlanDAO receivablePlanDAO, ConReceivablePlanRepo receivablePlanRepo, ConInvBatchInvdtlDAO conInvBatchInvdtlDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, ConReceivablePlanService receivablePlanService, InvItemDAO invItemDAO, BookInvoiceDAO bookInvoiceDAO, ConInvBatchInvdtlService conInvBatchInvdtlService, ConInvBatchInvdtlRepo conInvBatchInvdtlRepo, SaleConContractRepo saleConContractRepo, TransactionTemplate transactionTemplate, UdcUtil udcUtil, ExcelUtil excelUtil, FileService fileService, ConReceivableRepo conReceivableRepo, PrdOrgSyncLogDAO daoLog, TwInvoiceProperties invoiceProperties, PrdOrgEmployeeRepo employeeRepo, HttpUtil httpUtil, BusinessPartnerService businessPartnerService, CacheUtil cacheUtil, PrdMessageConfigService messageConfigService, ConInvSettingDAO conInvSettingDAO, FileUtilService fileUtilService, YeedocProperties yeedocProperties, PrdOrgOrganizationDAO orgOrganizationDAO, PrdOrgEmployeeService employeeService, PrdSystemRoleDAO systemRoleDAO) {
        this.conInvBatchRepo = conInvBatchRepo;
        this.conInvBatchDAO = conInvBatchDAO;
        this.receivablePlanDAO = receivablePlanDAO;
        this.receivablePlanRepo = receivablePlanRepo;
        this.conInvBatchInvdtlDAO = conInvBatchInvdtlDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.receivablePlanService = receivablePlanService;
        this.invItemDAO = invItemDAO;
        this.bookInvoiceDAO = bookInvoiceDAO;
        this.conInvBatchInvdtlService = conInvBatchInvdtlService;
        this.conInvBatchInvdtlRepo = conInvBatchInvdtlRepo;
        this.saleConContractRepo = saleConContractRepo;
        this.transactionTemplate = transactionTemplate;
        this.udcUtil = udcUtil;
        this.excelUtil = excelUtil;
        this.fileService = fileService;
        this.conReceivableRepo = conReceivableRepo;
        this.daoLog = daoLog;
        this.invoiceProperties = invoiceProperties;
        this.employeeRepo = employeeRepo;
        this.httpUtil = httpUtil;
        this.businessPartnerService = businessPartnerService;
        this.cacheUtil = cacheUtil;
        this.messageConfigService = messageConfigService;
        this.conInvSettingDAO = conInvSettingDAO;
        this.fileUtilService = fileUtilService;
        this.yeedocProperties = yeedocProperties;
        this.orgOrganizationDAO = orgOrganizationDAO;
        this.employeeService = employeeService;
        this.systemRoleDAO = systemRoleDAO;
    }
}

