/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingMonthService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingTypeService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingMonthConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingTypeConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingMonthDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingTypeDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingTypeDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingMonthRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingTypeRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ConInvSettingServiceImpl
extends BaseServiceImpl
implements ConInvSettingService {
    private static final Logger log = LoggerFactory.getLogger(ConInvSettingServiceImpl.class);
    private final ConInvSettingRepo conInvSettingRepo;
    private final ConInvSettingMonthRepo conInvSettingMonthRepo;
    private final ConInvSettingTypeRepo conInvSettingTypeRepo;
    private final ConInvSettingDAO conInvSettingDAO;
    private final ConInvSettingMonthDAO conInvSettingMonthDAO;
    private final ConInvSettingTypeDAO conInvSettingTypeDAO;
    private final ConInvSettingMonthService invSettingMonthService;
    private final ConInvSettingTypeService invSettingTypeService;
    private final CacheUtil cacheUtil;

    public PagingVO<ConInvSettingVO> queryPaging(ConInvSettingQuery query) {
        return this.conInvSettingDAO.queryPaging(query);
    }

    public List<ConInvSettingVO> queryListDynamic(ConInvSettingQuery query) {
        return this.conInvSettingDAO.queryListDynamic(query);
    }

    public ConInvSettingVO queryByKey(Long key) {
        ConInvSettingDO entity = this.conInvSettingRepo.findById(key).orElseGet(ConInvSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConInvSettingVO vo = ConInvSettingConvert.INSTANCE.toVo(entity);
        List conInvSettingMonthVOS = this.invSettingMonthService.queryByInvSetting(vo);
        List conInvSettingTypeVOS = this.invSettingTypeService.queryByInvSettingId(entity.getId());
        vo.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        vo.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        return vo;
    }

    public ConInvSettingVO queryByInvOuIdAndYear(Long invOuId, Integer invYear) {
        ConInvSettingDO entity = this.conInvSettingRepo.findByInvOuIdAndInvYear(invOuId, invYear);
        if (ObjectUtils.isEmpty((Object)entity)) {
            throw TwException.error("", "\u4e0d\u5b58\u5728");
        }
        ConInvSettingVO vo = ConInvSettingConvert.INSTANCE.toVo(entity);
        List conInvSettingMonthVOS = this.invSettingMonthService.queryByInvSetting(vo);
        List conInvSettingTypeVOS = this.invSettingTypeService.queryByInvSettingId(entity.getId());
        vo.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        vo.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer insertCheck(ConInvSettingPayload payload) {
        int count = 0;
        count = payload.getId() != null ? this.conInvSettingRepo.countByInvOuIdAndInvYearAndIdNot(payload.getInvOuId(), payload.getInvYear(), payload.getId()) : this.conInvSettingRepo.countByInvOuIdAndInvYear(payload.getInvOuId(), payload.getInvYear());
        return count;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConInvSettingVO insert(ConInvSettingPayload payload) {
        int count = this.conInvSettingRepo.countByInvOuIdAndInvYear(payload.getInvOuId(), payload.getInvYear());
        if (count > 0) {
            throw TwException.error("", payload.getInvYear() + "\u5e74" + this.cacheUtil.getCompanyNameByBookId(payload.getInvOuId()) + "\u5df2\u914d\u7f6e!");
        }
        ConInvSettingDO entityDo = ConInvSettingConvert.INSTANCE.toDo(payload);
        ConInvSettingVO conInvSettingVO = ConInvSettingConvert.INSTANCE.toVo((ConInvSettingDO)this.conInvSettingRepo.save(entityDo));
        Long settingId = conInvSettingVO.getId();
        List conInvSettingMonthPayloadList = payload.getConInvSettingMonthPayloadList();
        conInvSettingMonthPayloadList.stream().forEach(e -> e.setInvSettingId(settingId));
        if (!conInvSettingMonthPayloadList.isEmpty()) {
            List<ConInvSettingMonthDO> conInvSettingMonthDOS = ConInvSettingMonthConvert.INSTANCE.toDoList(conInvSettingMonthPayloadList);
            List conInvSettingMonthVOS = ConInvSettingMonthConvert.INSTANCE.toVoList(this.conInvSettingMonthRepo.saveAll(conInvSettingMonthDOS));
            conInvSettingVO.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        }
        List conInvSettingTypePayloadList = payload.getConInvSettingTypePayloadList();
        conInvSettingTypePayloadList.stream().forEach(e -> e.setInvSettingId(settingId));
        if (!conInvSettingTypePayloadList.isEmpty()) {
            List<ConInvSettingTypeDO> conInvSettingTypeDOS = ConInvSettingTypeConvert.INSTANCE.toDoList(conInvSettingTypePayloadList);
            List conInvSettingTypeVOS = ConInvSettingTypeConvert.INSTANCE.toVoList(this.conInvSettingTypeRepo.saveAll(conInvSettingTypeDOS));
            conInvSettingVO.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        }
        return conInvSettingVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConInvSettingVO update(ConInvSettingPayload payload) {
        List conInvSettingTypePayloadList;
        List deleteSettingMonthKeys = payload.getDeleteSettingMonthKeys();
        List deleteSettingTypeKeys = payload.getDeleteSettingTypeKeys();
        if (!CollectionUtils.isEmpty((Collection)deleteSettingMonthKeys)) {
            this.conInvSettingMonthDAO.deleteSoft(deleteSettingMonthKeys);
        }
        if (!CollectionUtils.isEmpty((Collection)deleteSettingTypeKeys)) {
            this.conInvSettingTypeDAO.deleteSoft(deleteSettingTypeKeys);
        }
        ConInvSettingDO entity = this.conInvSettingRepo.findById(payload.getId()).orElseGet(ConInvSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConInvSettingDO entityDo = ConInvSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        ConInvSettingVO conInvSettingVO = ConInvSettingConvert.INSTANCE.toVo((ConInvSettingDO)this.conInvSettingRepo.save(entity));
        List conInvSettingMonthPayloadList = payload.getConInvSettingMonthPayloadList();
        if (!conInvSettingMonthPayloadList.isEmpty()) {
            List<ConInvSettingMonthDO> conInvSettingMonthDOS = ConInvSettingMonthConvert.INSTANCE.toDoList(conInvSettingMonthPayloadList);
            ArrayList<ConInvSettingMonthVO> conInvSettingMonthVOS = new ArrayList<ConInvSettingMonthVO>();
            for (ConInvSettingMonthDO conInvSettingMonthDO : conInvSettingMonthDOS) {
                if (conInvSettingMonthDO.getId() != null) {
                    ConInvSettingMonthDO monthEntity = this.conInvSettingMonthRepo.findById(conInvSettingMonthDO.getId()).orElseGet(ConInvSettingMonthDO::new);
                    Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
                    monthEntity.copy(conInvSettingMonthDO);
                    conInvSettingMonthVOS.add(ConInvSettingMonthConvert.INSTANCE.toVo((ConInvSettingMonthDO)this.conInvSettingMonthRepo.save(monthEntity)));
                    continue;
                }
                conInvSettingMonthDO.setInvSettingId(payload.getId());
                conInvSettingMonthVOS.add(ConInvSettingMonthConvert.INSTANCE.toVo((ConInvSettingMonthDO)this.conInvSettingMonthRepo.save(conInvSettingMonthDO)));
            }
            conInvSettingVO.setConInvSettingMonthVOList(conInvSettingMonthVOS);
        }
        if (!(conInvSettingTypePayloadList = payload.getConInvSettingTypePayloadList()).isEmpty()) {
            List<ConInvSettingTypeDO> conInvSettingTypeDOS = ConInvSettingTypeConvert.INSTANCE.toDoList(conInvSettingTypePayloadList);
            ArrayList<ConInvSettingTypeVO> conInvSettingTypeVOS = new ArrayList<ConInvSettingTypeVO>();
            for (ConInvSettingTypeDO conInvSettingTypeDO : conInvSettingTypeDOS) {
                if (conInvSettingTypeDO.getId() != null) {
                    ConInvSettingTypeDO typeEntity = this.conInvSettingTypeRepo.findById(conInvSettingTypeDO.getId()).orElseGet(ConInvSettingTypeDO::new);
                    Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
                    typeEntity.copy(conInvSettingTypeDO);
                    conInvSettingTypeVOS.add(ConInvSettingTypeConvert.INSTANCE.toVo((ConInvSettingTypeDO)this.conInvSettingTypeRepo.save(typeEntity)));
                    continue;
                }
                conInvSettingTypeDO.setInvSettingId(payload.getId());
                conInvSettingTypeVOS.add(ConInvSettingTypeConvert.INSTANCE.toVo((ConInvSettingTypeDO)this.conInvSettingTypeRepo.save(conInvSettingTypeDO)));
            }
            conInvSettingVO.setConInvSettingTypeVOList(conInvSettingTypeVOS);
        }
        return conInvSettingVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ConInvSettingPayload payload) {
        ConInvSettingDO entity = this.conInvSettingRepo.findById(payload.getId()).orElseGet(ConInvSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.conInvSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conInvSettingDAO.deleteSoft(keys);
        }
    }

    public ConInvSettingServiceImpl(ConInvSettingRepo conInvSettingRepo, ConInvSettingMonthRepo conInvSettingMonthRepo, ConInvSettingTypeRepo conInvSettingTypeRepo, ConInvSettingDAO conInvSettingDAO, ConInvSettingMonthDAO conInvSettingMonthDAO, ConInvSettingTypeDAO conInvSettingTypeDAO, ConInvSettingMonthService invSettingMonthService, ConInvSettingTypeService invSettingTypeService, CacheUtil cacheUtil) {
        this.conInvSettingRepo = conInvSettingRepo;
        this.conInvSettingMonthRepo = conInvSettingMonthRepo;
        this.conInvSettingTypeRepo = conInvSettingTypeRepo;
        this.conInvSettingDAO = conInvSettingDAO;
        this.conInvSettingMonthDAO = conInvSettingMonthDAO;
        this.conInvSettingTypeDAO = conInvSettingTypeDAO;
        this.invSettingMonthService = invSettingMonthService;
        this.invSettingTypeService = invSettingTypeService;
        this.cacheUtil = cacheUtil;
    }
}

