/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRemindPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRemindQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRemindVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRemindDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemRemindDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRemindRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemRemindDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemRemindRepo repo;
    private final QPrdSystemRemindDO qdo = QPrdSystemRemindDO.prdSystemRemindDO;

    public PrdSystemRemindDO save(PrdSystemRemindDO ado) {
        return (PrdSystemRemindDO)this.repo.save(ado);
    }

    private JPAQuery<PrdSystemRemindVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemRemindVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remindCode, this.qdo.remindContent, this.qdo.remindContentLocale, this.qdo.remindType, this.qdo.portalFlag, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PrdSystemRemindVO> getJpaQueryWhere(PrdSystemRemindQuery query) {
        JPAQuery<PrdSystemRemindVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getRemindCode())) {
            jpaQuery.where((Predicate)this.qdo.remindCode.eq((Object)query.getRemindCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemindContent())) {
            jpaQuery.where((Predicate)this.qdo.remindContent.like(SqlUtil.toSqlLikeString(query.getRemindContent())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemindContentLocale())) {
            jpaQuery.where((Predicate)this.qdo.remindContentLocale.eq((Object)query.getRemindContentLocale()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemindType())) {
            jpaQuery.where((Predicate)this.qdo.remindType.eq((Object)query.getRemindType()));
        }
        if (query.getPortalFlag() != null) {
            jpaQuery.where((Predicate)this.qdo.portalFlag.eq(query.getPortalFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)this.qdo.id.ne((Object)query.getId()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<PrdSystemRemindVO> queryListDynamic(PrdSystemRemindQuery query) {
        JPAQuery<PrdSystemRemindVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public long updateByKeyDynamic(PrdSystemRemindPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getRemindCode() != null) {
            update.set((Path)this.qdo.remindCode, (Object)payload.getRemindCode());
        }
        if (payload.getRemindContent() != null) {
            update.set((Path)this.qdo.remindContent, (Object)payload.getRemindContent());
        }
        if (payload.getRemindContentLocale() != null) {
            update.set((Path)this.qdo.remindContentLocale, (Object)payload.getRemindContentLocale());
        }
        if (payload.getRemindType() != null) {
            update.set((Path)this.qdo.remindType, (Object)payload.getRemindType());
        }
        if (payload.getPortalFlag() != null) {
            update.set((Path)this.qdo.portalFlag, (Object)payload.getPortalFlag());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("remindContent")) {
                update.setNull((Path)this.qdo.remindContent);
            }
            if (nullFields.contains("remindContentLocale")) {
                update.setNull((Path)this.qdo.remindContentLocale);
            }
            if (nullFields.contains("remark")) {
                update.setNull((Path)this.qdo.remark);
            }
        }
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public PrdSystemRemindVO queryByKey(Long id) {
        JPAQuery<PrdSystemRemindVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemRemindVO)jpaQuery.fetchFirst();
    }

    public PagingVO<PrdSystemRemindVO> queryPaging(PrdSystemRemindQuery query) {
        JPAQuery<PrdSystemRemindVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public PrdSystemRemindDAO(JPAQueryFactory jpaQueryFactory, PrdSystemRemindRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

