package com.elitesland.tw.tw5.server.common.funConfig.util;

import lombok.Getter;

@Getter
public enum CodeGenDomainEnum {

    TW("tw", "tw-svr5-common", "tw-api-common", "tw-server-common", "COMMON项目"),
    CRM("crm", "tw-svr5-crm", "tw-api-crm", "tw-server-crm", "CRM"),
    PMS("pms", "tw-svr5-crm", "tw-api-crm", "tw-server-crm", "PMS"),
    EL("el", "tw-svr5", "tw-api", "tw-server", "内部EL-埃林哲5.0"),
    ;


    /**
     * code  对应模版文件夹名称
     */
    private String code;
    /**
     * 项目
     */
    private String parentModuleName;
    /**
     * api模块名称
     */
    private String apiModuleName;
    /**
     * 实现服务模块名称
     */
    private String serverModuleName;
    /**
     * 描述
     */
    private String desc;


    CodeGenDomainEnum(String code, String parentModuleName, String apiModuleName, String serverModuleName, String desc) {
        this.code = code;
        this.parentModuleName = parentModuleName;
        this.apiModuleName = apiModuleName;
        this.serverModuleName = serverModuleName;
        this.desc = desc;
    }

    public static CodeGenDomainEnum match(String code) {
        for (CodeGenDomainEnum typeEnum : CodeGenDomainEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }



}
