package com.elitesland.tw.tw5.server.common.util;

import lombok.Data;

import java.util.List;

/**
 * 邮件发送入参
 *
 * @author wangding
 */
@Data
public class JavaMailPayload {
    /**
     * 收件人邮箱
     */
    private String receiveEmail;

    /**
     * 收件人邮箱（多个）
     */
    private List<String> receiveEmails;

    /**
     * 邮件主题
     */
    private String subject;

    /**
     * 邮件正文
     */
    private String text;

    /**
     * 抄送人邮箱
     */
    private String ccEmail;

    /**
     * 抄送人邮箱（多个）
     */
    private List<String> ccEmails;
    /**
     * 附件地址
     */
    private List<String> fileUrls;

    /**
     * 是否html
     */
    private boolean htmlContentFlag = true;
    /**
     * 是否有附件
     */
    private boolean fileContentFlag = false;

    /**
     * 发件人
     */
    String source;
}
