package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimDetailMealPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimDetailMealQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimDetailMealService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailMealVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销明细餐费记录
 *
 * @author zoey
 * @date 2024-06-12
 */
@Api(tags = "报销明细餐费记录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/accReimDetailMeal")
@Slf4j
public class AccReimDetailMealController {

    private final AccReimDetailMealService accReimDetailMealService;

    /**
     * 报销明细餐费记录-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销明细餐费记录-新增")
    public TwOutputUtil<AccReimDetailMealVO> insert(@RequestBody AccReimDetailMealPayload payload) {
        return TwOutputUtil.ok(accReimDetailMealService.insert(payload));
    }

    /**
     * 报销明细餐费记录-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销明细餐费记录-更新")
    public TwOutputUtil<AccReimDetailMealVO> update(@RequestBody AccReimDetailMealPayload payload) {
        return TwOutputUtil.ok(accReimDetailMealService.update(payload));
    }

    /**
     * 报销明细餐费记录-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销明细餐费记录-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimDetailMealPayload payload) {
        return TwOutputUtil.ok(accReimDetailMealService.updateByKeyDynamic(payload));
    }

    /**
     * 报销明细餐费记录-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销明细餐费记录-主键查询")
    public TwOutputUtil<AccReimDetailMealVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimDetailMealService.queryByKey(key));
    }

    /**
     * 报销明细餐费记录-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("报销明细餐费记录-分页")
    public TwOutputUtil<PagingVO<AccReimDetailMealVO>> paging(AccReimDetailMealQuery query) {
        return TwOutputUtil.ok(accReimDetailMealService.queryPaging(query));
    }

    /**
     * 报销明细餐费记录-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("报销明细餐费记录-查询列表")
    public TwOutputUtil<List<AccReimDetailMealVO>> queryList(AccReimDetailMealQuery query) {
        return TwOutputUtil.ok(accReimDetailMealService.queryListDynamic(query));
    }

    /**
     * 报销明细餐费记录-初始化列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/initList")
    @UdcNameClass
    @ApiOperation("销明细餐费记录-初始化列表")
    public TwOutputUtil<List<AccReimDetailMealVO>> queryInitList(AccReimDetailMealQuery query) {
        return TwOutputUtil.ok(accReimDetailMealService.queryListInit(query));
    }

    /**
     * 报销明细餐费记录-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销明细餐费记录-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimDetailMealService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

