package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTaxPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTaxQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTaxService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTaxVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

/**
 * 费用报销税额管理
 *
 * @author sunxw
 * @date 2023-12-05
 */
@Api(tags = "费用报销税额管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accReimTax")
@Slf4j
public class AccReimTaxController {

    private final AccReimTaxService accReimTaxService;

    private final UdcUtil udcUtil;
    /**
     * 费用报销税额管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("费用报销税额管理-新增")
    public TwOutputUtil<AccReimTaxVO> insert(@RequestBody AccReimTaxPayload payload) {
        return TwOutputUtil.ok(accReimTaxService.insert(payload));
    }

    /**
     * 费用报销税额管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("费用报销税额管理-更新")
    public TwOutputUtil<AccReimTaxVO> update(@RequestBody AccReimTaxPayload payload) {
        return TwOutputUtil.ok(accReimTaxService.update(payload));
    }

    /**
     * 费用报销税额管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("费用报销税额管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimTaxPayload payload) {
        return TwOutputUtil.ok(accReimTaxService.updateByKeyDynamic(payload));
    }

    /**
     * 费用报销税额管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("费用报销税额管理-主键查询")
    public TwOutputUtil<AccReimTaxVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimTaxService.queryByKey(key));
    }

    /**
     * 费用报销税额管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("费用报销税额管理-分页")
    public TwOutputUtil<PagingVO<AccReimTaxVO>> paging(AccReimTaxQuery query) {
        return TwOutputUtil.ok(accReimTaxService.queryPaging(query));
    }

    /**
     * 费用报销税额管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("费用报销税额管理-查询列表")
    public TwOutputUtil<List<AccReimTaxVO>> queryList(AccReimTaxQuery query) {
        return TwOutputUtil.ok(accReimTaxService.queryListDynamic(query));
    }

    /**
     * 费用报销税额管理-导出
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/exportExcel")
    @ApiOperation("费用报销税额管理-导出")
    public void exportExcel(AccReimTaxQuery query, HttpServletResponse response) throws IOException {
        List<AccReimTaxVO> list = accReimTaxService.queryListDynamic(query);
        if(!CollectionUtils.isEmpty(list)){
            list = udcUtil.translateList(list);
            //定义文件名称
            String sheetName = "进项税抵扣导出";
            //对文件名进行固定格式编码
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            //设置请求响应内容类型
            //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            //设置请求响应内容编码方式
            response.setCharacterEncoding("utf-8");
            //文件下载，指定默认名
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

            final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), AccReimTaxVO.class)
                    .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                    .sheet(sheetName);
            // 列
            ExcelUtil.excelHelper(sheet, AccReimTaxVO.class, null);
            //写入
            sheet.doWrite(list);
        }

    }

    /**
     * 费用报销税额管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("费用报销税额管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimTaxService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

