package com.elitesland.tw.tw5.server.prd.acc.dao;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverduePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingOverdueDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimSettingOverdueDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingOverdueRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 报销逾期配置
 *
 * @author zoey
 * @date 2024-04-08
 */
@Repository
@RequiredArgsConstructor
public class AccReimSettingOverdueDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimSettingOverdueRepo repo;
    private final QAccReimSettingOverdueDO qdo = QAccReimSettingOverdueDO.accReimSettingOverdueDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingOverdueVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccReimSettingOverdueVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 报销配置主表id
                // 逾期开始日期
                qdo.overdueStartDate
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingOverdueVO> getJpaQueryWhere(AccReimSettingOverdueQuery query) {
        JPAQuery<AccReimSettingOverdueVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccReimSettingOverdueQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccReimSettingOverdueQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 逾期开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getOverdueStartDate())) {
            list.add(qdo.overdueStartDate.eq(query.getOverdueStartDate()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccReimSettingOverdueVO queryByKey(Long id) {
        JPAQuery<AccReimSettingOverdueVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccReimSettingOverdueVO> queryListDynamic(AccReimSettingOverdueQuery query) {
        JPAQuery<AccReimSettingOverdueVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccReimSettingOverdueVO> queryPaging(AccReimSettingOverdueQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<AccReimSettingOverdueVO> jpaQuery = getJpaQueryWhere(query);
        List<AccReimSettingOverdueVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccReimSettingOverdueVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccReimSettingOverdueDO save(AccReimSettingOverdueDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccReimSettingOverdueDO> saveAll(List<AccReimSettingOverdueDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccReimSettingOverduePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }

        // 逾期开始日期
        if (payload.getOverdueStartDate() != null) {
            update.set(qdo.overdueStartDate, payload.getOverdueStartDate());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 逾期开始日期
            if (nullFields.contains("overdueStartDate")) {
                update.setNull(qdo.overdueStartDate);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

