package com.elitesland.tw.tw5.server.prd.adm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyDetailService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyDetailVO;
import com.elitesland.tw.tw5.server.prd.adm.convert.AdmFeeApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.adm.dao.AdmFeeApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmFeeApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmFeeApplyDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 特殊费用申请明细管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AdmFeeApplyDetailServiceImpl extends BaseServiceImpl implements AdmFeeApplyDetailService {

    private final AdmFeeApplyDetailRepo admFeeApplyDetailRepo;
    private final AdmFeeApplyDetailDAO admFeeApplyDetailDAO;

    @Override
    public PagingVO<AdmFeeApplyDetailVO> queryPaging(AdmFeeApplyDetailQuery query) {
        return admFeeApplyDetailDAO.queryPaging(query);
    }

    @Override
    public List<AdmFeeApplyDetailVO> queryListDynamic(AdmFeeApplyDetailQuery query) {
        return admFeeApplyDetailDAO.queryListDynamic(query);
    }

    @Override
    public AdmFeeApplyDetailVO queryByKey(Long key) {
        return admFeeApplyDetailDAO.queryByKey(key);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AdmFeeApplyDetailVO insert(AdmFeeApplyDetailPayload payload) {
        AdmFeeApplyDetailDO entityDo = AdmFeeApplyDetailConvert.INSTANCE.toDo(payload);
        return AdmFeeApplyDetailConvert.INSTANCE.toVo(admFeeApplyDetailRepo.save(entityDo));
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AdmFeeApplyDetailPayload payload) {

        long result = admFeeApplyDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {

            });
        }
    }

    @Override
    public List<AdmFeeApplyDetailVO> bacthInsert(List<AdmFeeApplyDetailPayload> payloads) {
        List<AdmFeeApplyDetailDO> dos = AdmFeeApplyDetailConvert.INSTANCE.toDos(payloads);
        admFeeApplyDetailDAO.saveAll(dos);
        return null;
    }

    @Override
    public void deleteSoftByApplyId(List<Long> applyIds) {
        admFeeApplyDetailDAO.deleteSoftByApplyId(applyIds);
    }

}
