package com.elitesland.tw.tw5.server.prd.borrow.controller;

import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowWriteOffPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowWriteOffQuery;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowWriteOffVO;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowWriteOffService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 借款核销
 *
 * @folder 借款核销
 * @author wangly
 * @date 2024-07-15
 */
@Api(tags = "借款核销")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/borrowWriteOff")
@Slf4j
public class BorrowWriteOffController {

private final BorrowWriteOffService borrowWriteOffService;

    /**
     * 借款核销-新增
     *
     * @folder 借款核销
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("借款核销-新增")
    public TwOutputUtil<BorrowWriteOffVO> insert(@RequestBody BorrowWriteOffPayload payload){
         return TwOutputUtil.ok(borrowWriteOffService.insert(payload));
    }

    /**
     * 借款核销-更新
     *
         * @folder 借款核销
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("借款核销-更新")
    public TwOutputUtil<BorrowWriteOffVO> update(@RequestBody BorrowWriteOffPayload payload){
        return TwOutputUtil.ok(borrowWriteOffService.update(payload));
    }

    /**
     * 借款核销-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 借款核销
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("借款核销-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BorrowWriteOffPayload payload){
        return TwOutputUtil.ok(borrowWriteOffService.updateByKeyDynamic(payload));
    }

    /**
     * 借款核销-主键查询
     *
     * @folder 借款核销
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("借款核销-主键查询")
    public TwOutputUtil<BorrowWriteOffVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(borrowWriteOffService.queryByKey(key));
    }

    /**
     * 借款核销-分页
     *
         * @folder 借款核销
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("借款核销-分页")
    public TwOutputUtil<PagingVO<BorrowWriteOffVO>> paging(BorrowWriteOffQuery query) {
        return TwOutputUtil.ok(borrowWriteOffService.queryPaging(query));
    }

    /**
     * 借款核销-查询列表
     *
     * @folder 借款核销
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("借款核销-查询列表")
    public TwOutputUtil<List<BorrowWriteOffVO>> queryList(BorrowWriteOffQuery query) {
        return TwOutputUtil.ok(borrowWriteOffService.queryListDynamic(query));
    }

    /**
     * 借款核销-删除
     *
         * @folder 借款核销
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("借款核销-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         borrowWriteOffService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

