package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 当量成本配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Entity
@Table(name = "cal_eqva_cost", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "cal_eqva_cost", comment = "当量成本配置管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalEqvaCostDO extends BaseModel implements Serializable {
    /**
     * 平台编号
     */
    @Comment("平台编号")
    @Column()
    private String busifieldType;
    /**
     * buid
     */
    @Comment("buid")
    @Column()
    private Long buId;
    /**
     * 当量名称
     */
    @Comment("当量名称")
    @Column()
    private String eqvaName;
    /**
     * 工种
     */
    @Comment("工种")
    @Column()
    private String jobType1;
    /**
     * 工种子类
     */
    @Comment("工种子类")
    @Column()
    private String jobType2;
    /**
     * 核算年度
     */
    @Comment("核算年度")
    @Column()
    private Integer finYear;
    /**
     * 核算期间
     */
    @Comment("核算期间")
    @Column()
    private Integer finPeriod;
    /**
     * 当量成本
     */
    @Comment("当量成本")
    @Column()
    private BigDecimal eqvaCost;

    public void copy(CalEqvaCostDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
