package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountTurnoverPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountTurnoverQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountTurnoverService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountTurnoverVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalAccountTurnoverConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalAccountTurnoverDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalAccountTurnoverDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalAccountTurnoverRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 核算-账户流水记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalAccountTurnoverServiceImpl extends BaseServiceImpl implements CalAccountTurnoverService {

    private final CalAccountTurnoverRepo calAccountTurnoverRepo;
    private final CalAccountTurnoverDAO calAccountTurnoverDAO;

    @Override
    public void batchInsert(List<CalAccountTurnoverPayload> payloads) {
        List<CalAccountTurnoverDO> dos = CalAccountTurnoverConvert.INSTANCE.toDos(payloads);
        calAccountTurnoverDAO.saveAll(dos);
    }

    /**
     * 数据核验
     *
     * @param payload
     */
    void checkData(CalAccountTurnoverPayload payload) {
        if (payload.getAccId() == null) {
            throw TwException.error("", "归属账户不可为空");
        }
    }

    @Override
    public PagingVO<CalAccountTurnoverVO> queryPaging(CalAccountTurnoverQuery query) {
        if (query.getAccId() == null) {
            return null;
        }
        return calAccountTurnoverDAO.queryPaging(query);
    }

    //    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public CalAccountTurnoverVO insert(CalAccountTurnoverPayload payload) {
//        CalAccountTurnoverDO entityDo = CalAccountTurnoverConvert.INSTANCE.toDo(payload);
//        return CalAccountTurnoverConvert.INSTANCE.toVo(calAccountTurnoverRepo.save(entityDo));
//    }

//
//    @Override
//    public List<CalAccountTurnoverVO> queryListDynamic(CalAccountTurnoverQuery query) {
//        return calAccountTurnoverDAO.queryListDynamic(query);
//    }
//
//    @Override
//    public CalAccountTurnoverVO queryByKey(Long key) {
//        CalAccountTurnoverDO entity = calAccountTurnoverRepo.findById(key).orElseGet(CalAccountTurnoverDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        CalAccountTurnoverVO vo = CalAccountTurnoverConvert.INSTANCE.toVo(entity);
//        return vo;
//    }
//
//
////    @Override
////    @Transactional(rollbackFor = Exception.class)
////    public CalAccountTurnoverVO update(CalAccountTurnoverPayload payload) {
////        CalAccountTurnoverDO entity = calAccountTurnoverRepo.findById(payload.getId()).orElseGet(CalAccountTurnoverDO::new);
////        Assert.notNull(entity.getId(), "不存在");
////        CalAccountTurnoverDO entityDo = CalAccountTurnoverConvert.INSTANCE.toDo(payload);
////        entity.copy(entityDo);
////        return CalAccountTurnoverConvert.INSTANCE.toVo(calAccountTurnoverRepo.save(entity));
////    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public long updateByKeyDynamic(CalAccountTurnoverPayload payload) {
//        CalAccountTurnoverDO entity = calAccountTurnoverRepo.findById(payload.getId()).orElseGet(CalAccountTurnoverDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        long result = calAccountTurnoverDAO.updateByKeyDynamic(payload);
//        return result;
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void deleteSoft(List<Long> keys) {
//        if (!keys.isEmpty()) {
//            keys.stream().forEach(id -> {
//                Optional<CalAccountTurnoverDO> optional = calAccountTurnoverRepo.findById(id);
//                if (!optional.isEmpty()) {
//                    CalAccountTurnoverDO entity = optional.get();
//                    calAccountTurnoverRepo.save(entity);
//                }
//            });
//        }
//    }


}
