package com.elitesland.tw.tw5.server.prd.copartner.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigUserPayload;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeUserDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigUserQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigUserService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigDetailVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigUserVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeUserDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractListVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CopartnerEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeConfigUserConvert;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeUserDetailConvert;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigDAO;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigDetailDAO;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigUserDAO;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeUserDetailDAO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeConfigUserDO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeUserDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeConfigUserRepo;
import com.elitesland.tw.tw5.server.prd.crm.constant.SystemBasicStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.salecon.service.ConAchieveServiceImpl;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus.*;

/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PerformanceReadmeConfigUserServiceImpl extends BaseServiceImpl implements PerformanceReadmeConfigUserService {

    private final PerformanceReadmeConfigUserRepo performanceReadmeConfigUserRepo;
    private final PerformanceReadmeConfigUserDAO performanceReadmeConfigUserDAO;
    private final PerformanceReadmeConfigDAO performanceReadmeConfigDAO;
    private final PerformanceReadmeConfigDetailDAO performanceReadmeConfigDetailDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    private final PerformanceReadmeUserDetailDAO performanceReadmeUserDetailDAO;
    private final ConAchieveDService conAchieveDService;
    private final PmsProjectService pmsProjectService;
    private final PmsTimesheetService pmsTimesheetService;
    private final SaleConContractService saleConContractService;
    private final CrmOpportunityService crmOpportunityService;
    private final UdcUtil udcUtil;
    private BeanSearcher beanSearcher;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT);
    }

    @Override
    public PagingVO<PerformanceReadmeConfigUserVO> queryPaging(PerformanceReadmeConfigUserQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PerformanceReadmeConfigUserVO.class, mapBuilder.build());
        long total = (long) totalNum;
        if (total == 0) {
            return PagingVO.empty();
        }
        List<PerformanceReadmeConfigUserVO> vos = beanSearcher.searchList(PerformanceReadmeConfigUserVO.class, mapBuilder.build());
        return PagingVO.<PerformanceReadmeConfigUserVO>builder().records(vos).total(total).build();
    }

    private MapBuilder pageWhereBuilder(PerformanceReadmeConfigUserQuery query) {
        MapBuilder builder = MapUtils.builder();

        /** 配置主键 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            builder.field(PerformanceReadmeConfigUserVO::getConfigId, query.getConfigId()).op(FieldOps.Equal);
        }
        /** 员工主键 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            builder.field(PerformanceReadmeConfigUserVO::getUserId, query.getUserId()).op(FieldOps.Equal);
        }
        /** 状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            builder.field(PerformanceReadmeConfigUserVO::getApplyStatus, query.getApplyStatus()).op(FieldOps.Equal);
        }
        /** 名称 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigUserName())) {
            String likeStr = "%" + query.getConfigUserName() + "%";
            builder.field(PerformanceReadmeConfigUserVO::getConfigUserName).sql("$1 like ? ", likeStr);
        }
        /** 审批名称 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstName())) {
            String likeStr = "%" + query.getProcInstName() + "%";
            builder.field(PerformanceReadmeConfigUserVO::getProcInstName).sql("$1 like ? ", likeStr);
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            builder.field(PerformanceReadmeConfigUserVO::getProcInstStatus, query.getProcInstStatus()).op(FieldOps.Equal);
        }
        /** 流程id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            builder.field(PerformanceReadmeConfigUserVO::getProcInstId, query.getProcInstId()).op(FieldOps.Equal);
        }
        /** buId 精确 */
        if (!ObjectUtils.isEmpty(query.getBuId())) {
            builder.field(PerformanceReadmeConfigUserVO::getBuId, query.getBuId()).op(FieldOps.Equal);
        }
        /** 考核周期 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigCycle())) {
            builder.field(PerformanceReadmeConfigUserVO::getConfigCycle, query.getConfigCycle()).op(FieldOps.Equal);
        }
        /** 发起人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            builder.field(PerformanceReadmeConfigUserVO::getApplyUserId, query.getApplyUserId()).op(FieldOps.Equal);
        }
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);

        return builder;
    }

    @Override
    public List<PerformanceReadmeConfigUserVO> queryListDynamic(PerformanceReadmeConfigUserQuery query) {
        return performanceReadmeConfigUserDAO.queryListDynamic(query);
    }

    @Override
    public PerformanceReadmeConfigUserVO queryByKey(Long key) {
        PerformanceReadmeConfigUserVO userVO = performanceReadmeConfigUserDAO.queryByKey(key);

        List<PerformanceReadmeUserDetailVO> userDetailVOS = performanceReadmeUserDetailDAO.queryByConfigUserId(key);
        if (ObjectUtils.isEmpty(userDetailVOS)) {
            //需要初始化数据
            //查询配置
            PerformanceReadmeConfigVO configVO = performanceReadmeConfigDAO.queryByKey(userVO.getConfigId());
            PerformanceReadmeConfigDetailQuery query = new PerformanceReadmeConfigDetailQuery();
            query.setConfigId(configVO.getId());
            //查询配置详情
            List<PerformanceReadmeConfigDetailVO> configDetailVOS = performanceReadmeConfigDetailDAO.queryListDynamic(query);
            //初始化数据
            initUserDetail(userVO, configVO, configDetailVOS);
        } else {
            userVO.setPerformanceReadmeUserDetailVOs(userDetailVOS);
        }
        List<PerformanceReadmeUserDetailVO> performanceReadmeUserDetailVOs = udcUtil.translateList(userVO.getPerformanceReadmeUserDetailVOs());
        userVO.setPerformanceReadmeUserDetailVOs(performanceReadmeUserDetailVOs);

        return userVO;
    }

    @Override
    public PerformanceReadmeConfigUserVO querySimpleByKey(Long key) {
        return performanceReadmeConfigUserDAO.queryByKey(key);
    }

    @Override
    public long updateByKeyDynamic(PerformanceReadmeConfigUserPayload payload) {
        return performanceReadmeConfigUserDAO.updateByKeyDynamic(payload);
    }

    /**
     * 初始化自述详情
     */
    void initUserDetail(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS) {
        /**
         * 签单日期在查询范围内的
         * 自签单：业绩类别为签单或售前，有且只有一个，且比例为100%
         * 售前支持（已成单）：除自签单业绩外，按实际比例算
         *项目交付贡献：业绩类别为交付
         */
        ConAchieveDQuery query = new ConAchieveDQuery();
        List<LocalDate> dateBetween = new ArrayList<>();
        dateBetween.add(configVO.getStartDate());
        dateBetween.add(configVO.getEndDate());
        query.setSignDate(dateBetween);
        //  query.setChargeResId(userVO.getUserId());
        List<String> achieveTypes = Arrays.asList(ConAchieveServiceImpl.SIGN, ConAchieveServiceImpl.DELI, ConAchieveServiceImpl.PRE_SALE);
        query.setAchieveTypes(achieveTypes);
        //1.处理项目交付，自签单，已成单
        List<ConAchieveDVO> conAchieveDVOS = conAchieveDService.queryListDynamic(query);
        List<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<>();
        if (!ObjectUtils.isEmpty(conAchieveDVOS)) {
            //获取：项目交付贡献
            List<PerformanceReadmeUserDetailVO> deliDetailVOS = handleDeli(userVO, configVO, configDetailVOS, conAchieveDVOS);
            userDetailVOS.addAll(deliDetailVOS);
            //获取：自签单和售前支持贡献(已成单)，已经分配绩效的
            List<PerformanceReadmeUserDetailVO> signAndPreSaleDetailVOS = handleSignAndPreSale(userVO, configVO, configDetailVOS, conAchieveDVOS);
            userDetailVOS.addAll(signAndPreSaleDetailVOS);
            //设置自动生成标志
            userDetailVOS.forEach(vo -> vo.setCreateFlag(0));
        }
        //2.处理售前未成单及已成单但是未分配绩效填了工时数据
        List<PerformanceReadmeUserDetailVO> performanceReadmeUserDetailVOS = noAllocationDetailVOs(userVO, configVO, configDetailVOS);
        //设置手动生成标志
        performanceReadmeUserDetailVOS.forEach(userDetailVO -> {
            if (StringUtils.hasText(userDetailVO.getReasonType()) && userDetailVO.getReasonId() != null) {
                userDetailVO.setCreateFlag(1);
                Optional<PerformanceReadmeUserDetailVO> first = userDetailVOS.stream().filter(vo ->
                        vo.getReasonType() != null && vo.getReasonType().equals(userDetailVO.getReasonType())
                                && vo.getReasonId() != null && vo.getReasonId().equals(userDetailVO.getReasonId())
                ).findFirst();
                if (!first.isPresent()) {
                    userDetailVOS.add(userDetailVO);
                }
            }
        });
        userVO.setPerformanceReadmeUserDetailVOs(userDetailVOS);
    }


    /**
     * 处理自签单和售前支持贡献(已成单)
     *
     * @param userVO
     * @param configVO
     * @param configDetailVOS
     * @param conAchieveDVOS
     * @return
     */
    List<PerformanceReadmeUserDetailVO> handleSignAndPreSale(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS, List<ConAchieveDVO> conAchieveDVOS) {
        List<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<>();
        List<String> achieveTypes = Arrays.asList(ConAchieveServiceImpl.SIGN, ConAchieveServiceImpl.PRE_SALE);
        //提取跟本人相关业绩统计数据
        List<ConAchieveDVO> dVOs = conAchieveDVOS.stream().filter(dvo -> dvo.getChargeResId().equals(userVO.getUserId()) && achieveTypes.contains(dvo.getAchieveType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(dVOs)) {
            //提取跟本人相关子合同ids
            List<Long> conIds = dVOs.stream().map(ConAchieveDVO::getSubConId).distinct().collect(Collectors.toList());
            //提取跟本人相关子合同分组对应的业绩数据
            Map<Long, List<ConAchieveDVO>> conMap = conAchieveDVOS.stream().filter(dvo -> conIds.contains(dvo.getSubConId()) && achieveTypes.contains(dvo.getAchieveType())).collect(Collectors.groupingBy(ConAchieveDVO::getSubConId));
            //提取：自签单对应的业绩统计数据Ids
            List<Long> dVOIds = new ArrayList<>();
            conMap.forEach((key, value) -> {
                //自签单：业绩类别为签单或售前，有且只有一个，且比例为100%
                if (value.size() == 1) {
                    ConAchieveDVO conAchieveDVO = value.get(0);
                    if (StringUtils.hasText(conAchieveDVO.getRatio()) && Integer.valueOf(conAchieveDVO.getRatio()) == 100) {
                        //归属自签单
                        dVOIds.add(conAchieveDVO.getId());
                    }
                }
            });
            //提取:售前支持贡献(已成单) 对应的业绩统计数据ids
            List<Long> preSaleDVOIds;
            if (dVOIds.size() > 0) {
                preSaleDVOIds = dVOs.stream().filter(dvo -> !dVOIds.contains(dvo.getId())).map(ConAchieveDVO::getId).collect(Collectors.toList());
            } else {
                preSaleDVOIds = dVOs.stream().map(ConAchieveDVO::getId).collect(Collectors.toList());

            }
            SaleConContractQuery query = new SaleConContractQuery();
            query.setIds(conIds);
            List<SaleConContractListVO> saleConContractListVOS = saleConContractService.queryListDynamic(query);
            List<Long> oppoIds = saleConContractListVOS.stream().filter(vo -> vo.getOppoId() != null).map(SaleConContractListVO::getOppoId).collect(Collectors.toList());
            CrmOpportunityQuery queryOppo = new CrmOpportunityQuery();
            queryOppo.setIds(oppoIds);
            List<CrmOpportunityListVO> oppoVOS = crmOpportunityService.querySimpleList(queryOppo);
            //获取合同和商机项目id的对饮关系
            Map<Long, Long> conIdMap = new HashMap<>();
            saleConContractListVOS.forEach(vo -> {
                Optional<CrmOpportunityListVO> first = oppoVOS.stream().filter(oppoVO -> oppoVO.getId().equals(vo.getOppoId())).findFirst();
                if (first.isPresent()) {
                    conIdMap.put(vo.getId(), first.get().getProjectId());
                }
            });
            String reasonType = PmsReasonTypeEnum.PROJ_OPPO.getCode();
            //获取数据
            userDetailVOS = getUserDetails(userVO, configVO, dVOs, conIdMap, reasonType);
            //定义考核点 自签单
            PerformanceReadmeConfigDetailVO point1 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point1.getCode())).findFirst().get();
            userDetailVOS.stream().filter(vo -> dVOIds.contains(vo.getAchieveDId())).forEach(vo -> vo.setConfigDetailId(point1.getId()));
            //定义考核点 售前支持贡献(已成单)
            PerformanceReadmeConfigDetailVO point2 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point2.getCode())).findFirst().get();
            userDetailVOS.stream().filter(vo -> preSaleDVOIds.contains(vo.getAchieveDId())).forEach(vo -> vo.setConfigDetailId(point2.getId()));
            //赋值合同类型
            userDetailVOS.forEach(userDetailVO -> {
                Optional<SaleConContractListVO> first = saleConContractListVOS.stream().filter(vo -> vo.getId().equals(userDetailVO.getContractId())).findFirst();
                if (first.isPresent()) {
                    String workType = first.get().getWorkType();
                    PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.querySystemSelection("salecon:work_type", workType);
                    userDetailVO.setContractType(prdSystemSelectionVO.getExtString1());
                }
            });

        }
        return userDetailVOS;
    }


    /**
     * 处理项目交付贡献
     *
     * @param userVO
     * @param configVO
     * @param conAchieveDVOS
     */
    List<PerformanceReadmeUserDetailVO> handleDeli(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS, List<ConAchieveDVO> conAchieveDVOS) {
        List<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<>();
        //提取相关业绩统计数据
        List<ConAchieveDVO> dVOs = conAchieveDVOS.stream().filter(dvo -> dvo.getChargeResId().equals(userVO.getUserId()) && ConAchieveServiceImpl.DELI.equals(dvo.getAchieveType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(dVOs)) {
            // PerformanceReadmeConfigDetailVO point3 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point3.getCode())).findFirst().get();
            //子合同ids
            List<Long> conIds = dVOs.stream().map(ConAchieveDVO::getSubConId).distinct().collect(Collectors.toList());
            //子合同对应的项目
            List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryByContractIds(conIds);
            if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
                Map<Long, Long> conIdMap = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, PmsProjectVO::getId));
                String reasonType = PmsReasonTypeEnum.PROJ_CONTRACT.getCode();
                //获取数据
                userDetailVOS = getUserDetails(userVO, configVO, dVOs, conIdMap, reasonType);
                //定义考核点 项目交付贡献
                PerformanceReadmeConfigDetailVO point3 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point3.getCode())).findFirst().get();
                userDetailVOS.forEach(vo -> {
                    vo.setConfigDetailId(point3.getId());
                    Long projectId = conIdMap.get(vo.getContractId());
                    if (projectId != null && projectId.longValue() > 0) {
                        //赋值对应的项目信息
                        Optional<PmsProjectVO> first = pmsProjectVOS.stream().filter(pmsProjectVO -> pmsProjectVO.getId().equals(projectId)).findFirst();
                        if (first.isPresent()) {
                            PmsProjectVO pmsProjectVO = first.get();
                            vo.setProjectId(pmsProjectVO.getId());
                            vo.setProjectName(pmsProjectVO.getProjName());
                            //翻译合同类型
                            PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.querySystemSelection("salecon:work_type", pmsProjectVO.getWorkType());
                            vo.setContractType(prdSystemSelectionVO.getExtString1());
                        }
                    }

                });
            }

        }
        return userDetailVOS;
    }

    /**
     * 获取 合伙人绩效自述数据
     *
     * @param userVO
     * @param configVO
     * @param dVOs
     * @param conIdMap
     * @param reasonType
     * @return
     */
    List<PerformanceReadmeUserDetailVO> getUserDetails(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<ConAchieveDVO> dVOs, Map<Long, Long> conIdMap, String reasonType) {
        List<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<>();
        if (conIdMap.isEmpty()) {
            return userDetailVOS;
        }
        /**
         * 查询范围
         * 1.配置区间内
         * 2.相关项目下
         * 3.已审批，审批中，已结算
         * 4.相关人的，
         */
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTsUserId(userVO.getUserId());
        List<LocalDate> dateBetween = new ArrayList<>();
        dateBetween.add(configVO.getStartDate());
        dateBetween.add(configVO.getEndDate());
        timesheetQuery.setWorkDateBetween(dateBetween);
        timesheetQuery.setReasonType(reasonType);

        timesheetQuery.setReasonIdList(new ArrayList<>(conIdMap.values()));
        timesheetQuery.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));

        List<TimesheetVO> timesheetVOS = pmsTimesheetService.queryDaoList(timesheetQuery);
        Map<Long, List<TimesheetVO>> reasonMaps = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getReasonId));

        dVOs.forEach(dVO -> {
            PerformanceReadmeUserDetailVO userDetailVO = new PerformanceReadmeUserDetailVO();
            userDetailVO.setAchieveDId(dVO.getId());
            userDetailVO.setConfigUserId(userVO.getId());
            userDetailVO.setUserId(userVO.getUserId());
            userDetailVO.setConfigId(userVO.getConfigId());
            // userDetailVO.setConfigDetailId(point3.getId());
            userDetailVO.setContractId(dVO.getSubConId());
            userDetailVO.setContractName(dVO.getSubConName());
            userDetailVO.setSaleUserId(dVO.getSaleManUserId());
            userDetailVO.setAmount(dVO.getSignAmt());
            userDetailVO.setAmountNoTax(dVO.getEffectiveAmt());
            userDetailVO.setRatio(dVO.getRatio());
            userDetailVO.setAmt(dVO.getAmt());

            BigDecimal workHour = BigDecimal.ZERO;
            Long reasonId = conIdMap.get(dVO.getSubConId());
            if (reasonId != null && reasonId.longValue() > 0) {
                List<TimesheetVO> timesheetVOS1 = reasonMaps.get(reasonId);
                if (!ObjectUtils.isEmpty(timesheetVOS1)) {
                    workHour = timesheetVOS1.stream()
                            .map(TimesheetVO::getWorkHour)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);
                }
            }
            BigDecimal workDays = workHour.divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);
            userDetailVO.setDeliDays(workDays);
            userDetailVO.setTotalDays(workDays);
            userDetailVO.setReasonId(reasonId);
            userDetailVO.setReasonType(reasonType);

            userDetailVOS.add(userDetailVO);
        });

        return userDetailVOS;
    }

    /**
     * 初始化未成单数据以及已成单但是未分配绩效填了工时数据
     *
     * @return
     */
    List<PerformanceReadmeUserDetailVO> noAllocationDetailVOs(PerformanceReadmeConfigUserVO userVO, PerformanceReadmeConfigVO configVO, List<PerformanceReadmeConfigDetailVO> configDetailVOS) {
        List<PerformanceReadmeUserDetailVO> userDetailVOS = new ArrayList<>();

        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTsUserId(userVO.getUserId());
        List<LocalDate> dateBetween = new ArrayList<>();
        dateBetween.add(configVO.getStartDate());
        dateBetween.add(configVO.getEndDate());
        timesheetQuery.setWorkDateBetween(dateBetween);
//        timesheetQuery.setReasonType(PmsReasonTypeEnum.PROJ_OPPO.getCode());
        timesheetQuery.setReasonTypes(Arrays.asList(PmsReasonTypeEnum.PROJ_OPPO.getCode(), PmsReasonTypeEnum.PROJ_CONTRACT.getCode()));
        timesheetQuery.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));

        List<TimesheetVO> timesheetVOS = pmsTimesheetService.queryDaoList(timesheetQuery);
        if (!ObjectUtils.isEmpty(timesheetVOS)) {
            //售前工时
            Map<Long, List<TimesheetVO>> reasonOppoMaps = timesheetVOS.stream().filter(vo ->
                    vo.getReasonId() != null && StringUtils.hasText(vo.getReasonType()) && PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(vo.getReasonType())
            ).collect(Collectors.groupingBy(TimesheetVO::getReasonId));

            if (!reasonOppoMaps.isEmpty()) {
                //定义考核点 售前支持未成单
                PerformanceReadmeConfigDetailVO point4 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point4.getCode())).findFirst().get();
                PerformanceReadmeConfigDetailVO point2 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point2.getCode())).findFirst().get();

                //查工时对应的商机
                CrmOpportunityQuery queryOppo = new CrmOpportunityQuery();
                // queryOppo.setProjectStatus(SystemBasicStatusEnum.ACTIVE.getCode());
                queryOppo.setProjectIds(new ArrayList<>(reasonOppoMaps.keySet()));

                List<CrmOpportunityListVO> oppoVOS = crmOpportunityService.querySimpleList(queryOppo);
                List<Long> oppoIds = oppoVOS.stream().map(CrmOpportunityListVO::getId).collect(Collectors.toList());
                //查商机对应的合同
                SaleConContractQuery query = new SaleConContractQuery();
                query.setOppoIds(oppoIds);
                query.setMainType(SaleConEnum.MAIN.getCode());
                List<SaleConContractListVO> saleConContractListVOS = saleConContractService.queryListDynamic(query);
                Map<Long, SaleConContractListVO> collect = new HashMap<>();
                if (!ObjectUtils.isEmpty(saleConContractListVOS)) {
                    collect = saleConContractListVOS.stream().filter(vo -> !vo.getStatus().equals(SystemBasicStatusEnum.CREATE.getCode())).collect(Collectors.toMap(SaleConContractListVO::getOppoId, Function.identity()));
                    //去除创建过合同的商机
                    //oppoIds.removeAll(collect);
                }
                //已经创建过合同的商机
                Map<Long, SaleConContractListVO> finalCollect = collect;
                oppoVOS.forEach(oppoVO -> {
                    PerformanceReadmeUserDetailVO userDetailVO = new PerformanceReadmeUserDetailVO();
//                    if (oppoIds.contains(oppoVO.getId())) {
                    if (finalCollect.containsKey(oppoVO.getId())) {
                        //售前支持已成单
                        SaleConContractListVO saleConContractListVO = finalCollect.get(oppoVO.getId());
                        userDetailVO.setConfigDetailId(point2.getId());
                        userDetailVO.setContractId(saleConContractListVO.getId());
                        userDetailVO.setContractName(saleConContractListVO.getName());
                        userDetailVO.setAmount(saleConContractListVO.getAmt());
                        userDetailVO.setAmountNoTax(saleConContractListVO.getEffectiveAmt());
                    } else {
                        //售前支持未成单
                        userDetailVO.setConfigDetailId(point4.getId());
                        userDetailVO.setAmount(oppoVO.getForecastAmount());
                    }

                    userDetailVO.setConfigUserId(userVO.getId());
                    userDetailVO.setUserId(userVO.getUserId());
                    userDetailVO.setConfigId(userVO.getConfigId());
                    userDetailVO.setSaleUserId(oppoVO.getManageUserId());

                    userDetailVO.setOppoId(oppoVO.getProjectId());
                    userDetailVO.setOppoName(oppoVO.getProjectName());
                    String status = "pre_sale_status1";
                    if (StringUtils.hasText(oppoVO.getProjectStatus()) && SystemBasicStatusEnum.ACTIVE.getCode().equals(oppoVO.getProjectStatus())) {
                        status = "pre_sale_status2";
                    }
                    userDetailVO.setOppoStatus(status);
                    BigDecimal workHour = BigDecimal.ZERO;

                    List<TimesheetVO> timesheetVOS1 = reasonOppoMaps.get(oppoVO.getProjectId());
                    if (!ObjectUtils.isEmpty(timesheetVOS1)) {
                        workHour = timesheetVOS1.stream()
                                .map(TimesheetVO::getWorkHour)
                                .filter(Objects::nonNull)
                                .reduce(BigDecimal::add)
                                .orElse(BigDecimal.ZERO);
                    }

                    BigDecimal workDays = workHour.divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);
                    userDetailVO.setDeliDays(workDays);
                    userDetailVO.setTotalDays(workDays);
                    userDetailVO.setReasonId(oppoVO.getProjectId());
                    userDetailVO.setReasonType(PmsReasonTypeEnum.PROJ_OPPO.getCode());
                    Optional<PerformanceReadmeUserDetailVO> first = userDetailVOS.stream().filter(vo -> vo.getReasonType().equals(userDetailVO.getReasonType()) && vo.getReasonId().equals(userDetailVO.getReasonId())).findFirst();
                    if (!first.isPresent()) {
                        userDetailVOS.add(userDetailVO);
                    }
                });
            }
            //项目工时
            Map<Long, List<TimesheetVO>> reasonProjectMaps = timesheetVOS.stream().filter(vo ->
                    vo.getReasonId() != null && StringUtils.hasText(vo.getReasonType()) && PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(vo.getReasonType())
            ).collect(Collectors.groupingBy(TimesheetVO::getReasonId));
            if (!reasonProjectMaps.isEmpty()) {
                PerformanceReadmeConfigDetailVO point3 = configDetailVOS.stream().filter(detailVO -> detailVO.getDetailPod().equals(CopartnerEnum.Point.point3.getCode())).findFirst().get();
                List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryByKeysSimple(new ArrayList<>(reasonProjectMaps.keySet()));
                pmsProjectVOS.forEach(pmsProjectVO -> {

                    PerformanceReadmeUserDetailVO userDetailVO = new PerformanceReadmeUserDetailVO();
                    //售前支持已成单
                    userDetailVO.setConfigDetailId(point3.getId());
                    userDetailVO.setContractId(pmsProjectVO.getContractId());
                    userDetailVO.setContractName(pmsProjectVO.getContractName());

                    userDetailVO.setConfigUserId(userVO.getId());
                    userDetailVO.setUserId(userVO.getUserId());
                    userDetailVO.setConfigId(userVO.getConfigId());
                    userDetailVO.setSaleUserId(pmsProjectVO.getSaleManUserId());
                    userDetailVO.setAmount(pmsProjectVO.getSumAmt());
                    userDetailVO.setAmountNoTax(pmsProjectVO.getEffectiveAmt());
                    userDetailVO.setProjectId(pmsProjectVO.getId());
                    userDetailVO.setProjectName(pmsProjectVO.getProjName());
                    BigDecimal workHour = BigDecimal.ZERO;
                    List<TimesheetVO> timesheetVOS1 = reasonProjectMaps.get(pmsProjectVO.getId());
                    if (!ObjectUtils.isEmpty(timesheetVOS1)) {
                        workHour = timesheetVOS1.stream()
                                .map(TimesheetVO::getWorkHour)
                                .filter(Objects::nonNull)
                                .reduce(BigDecimal::add)
                                .orElse(BigDecimal.ZERO);
                    }

                    BigDecimal workDays = workHour.divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);
                    userDetailVO.setDeliDays(workDays);
                    userDetailVO.setTotalDays(workDays);
                    userDetailVO.setReasonId(pmsProjectVO.getId());
                    userDetailVO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                    Optional<PerformanceReadmeUserDetailVO> first = userDetailVOS.stream().filter(vo -> vo.getReasonType().equals(userDetailVO.getReasonType()) && vo.getReasonId().equals(userDetailVO.getReasonId())).findFirst();
                    if (!first.isPresent()) {
                        //翻译合同类型
                        PrdSystemSelectionVO prdSystemSelectionVO = cacheUtil.querySystemSelection("salecon:work_type", pmsProjectVO.getWorkType());
                        userDetailVO.setContractType(prdSystemSelectionVO.getExtString1());
                        userDetailVOS.add(userDetailVO);
                    }
                });

            }


        }
        return userDetailVOS;
    }

    @Override

    public List<PerformanceReadmeConfigUserVO> batchInsert(List<PerformanceReadmeConfigUserPayload> payloads) {
        List<PerformanceReadmeConfigUserDO> entityDos = payloads.stream().map(payload -> {
            PerformanceReadmeConfigUserDO entityDo = PerformanceReadmeConfigUserConvert.INSTANCE.toDo(payload);
            return entityDo;
        }).collect(Collectors.toList());
        List<PerformanceReadmeConfigUserDO> PerformanceReadmeConfigUserDOS = performanceReadmeConfigUserDAO.saveAll(entityDos);

        List<PerformanceReadmeConfigUserVO> vos = PerformanceReadmeConfigUserDOS.stream().map(entity -> {
            PerformanceReadmeConfigUserVO vo = PerformanceReadmeConfigUserConvert.INSTANCE.toVo(entity);
            return vo;
        }).collect(Collectors.toList());
        return vos;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void procInstUpdate(PerformanceReadmeConfigUserPayload payload) {
        if (payload.getInitFlag() == null || payload.getInitFlag()) {
            //处理数据
            handleData(payload);
        }
        String procInstId = payload.getProcInstId();
        if (!StringUtils.hasText(procInstId)) {
            //发起流程
            startProcess(payload);
        } else {
            if (!StringUtils.hasText(payload.getProcInstStatus()) || ProcInstStatus.NOTSUBMIT.name().equals(payload.getProcInstStatus()) || ProcInstStatus.REJECTED.name().equals(payload.getProcInstStatus())) {
                // 重新给流程参数赋值
                HashMap<String, Object> variables = new HashMap<>();
                dealVariables(payload, variables);
                workflowUtil.setVariables(SetVariablesPayload.of(payload.getProcInstId(), variables));
                payload.setProcInstStatus(ProcInstStatus.APPROVING.name());
            }
        }
        Long buId = cacheUtil.getDefaultOrgIdByUserId(payload.getUserId());
        payload.setBuId(buId);

        transactionUtilService.executeWithRunnable(() -> {
            performanceReadmeConfigUserDAO.updateByKeyDynamic(payload);
        });
    }

    /**
     * 处理数据
     *
     * @param payload
     */
    private void handleData(PerformanceReadmeConfigUserPayload payload) {
        List<PerformanceReadmeUserDetailPayload> userDetailPayloads = payload.getPerformanceReadmeUserDetailPayloads();
        if (ObjectUtils.isEmpty(userDetailPayloads)) {
            throw TwException.error("", "合伙人绩效自述明细不存在");
        }
        PerformanceReadmeConfigUserVO vo = performanceReadmeConfigUserDAO.queryByKey(payload.getId());
        payload.setProcInstId(vo.getProcInstId());
        //删除合伙人绩效自述明细
        performanceReadmeUserDetailDAO.deleteSoftByConfigUserId(payload.getId());
        List<PerformanceReadmeUserDetailDO> userDetailDOS = userDetailPayloads.stream().map(userDetailPayload -> {
            if (userDetailPayload.getConfigDetailId() == null) {
                throw TwException.error("", "合伙人绩效自述明细配置详情为空");
            }
            userDetailPayload.setConfigId(vo.getConfigId());
            userDetailPayload.setUserId(vo.getUserId());
            userDetailPayload.setConfigUserId(vo.getId());
            PerformanceReadmeUserDetailDO aDo = PerformanceReadmeUserDetailConvert.INSTANCE.toDo(userDetailPayload);
            return aDo;
        }).collect(Collectors.toList());

        performanceReadmeUserDetailDAO.saveAll(userDetailDOS);
    }

    /**
     * 提交流程
     *
     * @param payload
     */
    void startProcess(PerformanceReadmeConfigUserPayload payload) {
        HashMap<String, Object> variables = new HashMap<>();
        // 处理对应的审批参数
        dealVariables(payload, variables);
        String userName = cacheUtil.getUserName(payload.getUserId());
        String procInstName = "A40." + payload.getConfigName() + "-" + userName;
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.COPARTNER_REPORT.name(),
                procInstName,
                payload.getId() + "",
                variables)
        );
        payload.setId(payload.getId());
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus().name());
        payload.setProcInstName(procInstName);
    }

    // 处理审批参数
    private void dealVariables(PerformanceReadmeConfigUserPayload payload, HashMap<String, Object> variables) {

        //合伙人自述
        variables.put("Activity_0gyegzd", CollUtil.newArrayList(payload.getUserId()));
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(payload.getUserId());
        //所属bu负责人审批
        variables.put("Activity_1k76zem", CollUtil.newArrayList(userDefaultOrg.getManageId()));

        PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(userDefaultOrg.getOrgId());
        if (buLevel1 == null) {
            //一级BU事业部负责人审批
            variables.put("Activity_0zj92zg", CollUtil.newArrayList(userDefaultOrg.getManageId()));
        } else {
            //一级BU事业部负责人审批
            variables.put("Activity_0zj92zg", CollUtil.newArrayList(buLevel1.getManageId()));
        }

        //CHO审批(平台人力资源总监)
        List<Long> vacationAdmin = cacheUtil.getUserIdByRoleCodes(CollUtil.newArrayList(RoleEnum.PLAT_HRD.getCode()));
        variables.put("Activity_17tgayw", vacationAdmin);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            performanceReadmeConfigUserDAO.deleteSoft(keys);
        }
    }

    @Override
    public void deleteSoftByConfigId(Long configId) {
        performanceReadmeConfigUserDAO.deleteSoftByConfigId(configId);
    }

}
