package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftInfoQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftListQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmGiftInfoVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmGiftInfoService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 礼品单明细
 *
 * @author xxb
 * @date 2023-08-31
 */
@Api(tags = "礼品单明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/crmGiftInfo")
@Slf4j
public class CrmGiftInfoController {

    private final CrmGiftInfoService crmGiftInfoService;

    /**
     * 礼品单明细-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("礼品单明细-新增")
    public TwOutputUtil<CrmGiftInfoVO> insert(@RequestBody CrmGiftInfoPayload payload){
        return TwOutputUtil.ok(crmGiftInfoService.insert(payload));
    }

    /**
     * 礼品单明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("礼品单明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CrmGiftInfoPayload payload){
        return TwOutputUtil.ok(crmGiftInfoService.updateByKeyDynamic(payload));
    }

    /**
     * 礼品单列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/pagingByGiftList")
    @UdcNameClass
    @ApiOperation("礼品单列表")
    public TwOutputUtil<PagingVO<CrmGiftInfoVO>> pagingByGiftList(CrmGiftListQuery query) {
        return TwOutputUtil.ok(crmGiftInfoService.pagingByGiftList(query));
    }

    /**
     * 礼品单明细-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("礼品单明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        crmGiftInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 礼品单明细-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("礼品单明细-查询列表")
    public TwOutputUtil<List<CrmGiftInfoVO>> queryList(CrmGiftInfoQuery query) {
        return TwOutputUtil.ok(crmGiftInfoService.queryListDynamic(query));
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/batchExport")
    public void batchExport(HttpServletResponse response, CrmGiftListQuery query) {
        crmGiftInfoService.downloadBatch(response, query);
    }


//
//    /**
//     * 礼品单明细-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("礼品单明细-更新")
//    public TwOutputUtil<CrmGiftInfoVO> update(@RequestBody CrmGiftInfoPayload payload){
//        return TwOutputUtil.ok(crmGiftInfoService.update(payload));
//    }



//    /**
//     * 礼品单明细-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("礼品单明细-主键查询")
//    public TwOutputUtil<CrmGiftInfoVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(crmGiftInfoService.queryByKey(key));
//    }



//    /**
//     * 礼品单明细-分页
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("礼品单明细-分页")
//    public TwOutputUtil<PagingVO<CrmGiftInfoVO>> paging(CrmGiftInfoQuery query) {
//        return TwOutputUtil.ok(crmGiftInfoService.queryPaging(query));
//    }




}
