package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityOutCostService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;


/**
 * 商机渠道（外包）费用
 *
 * @author duwh
 * @date 2022/09/07
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@PermissionDomain(domain = PermissionDomainEnum.OUTCOST)
@Slf4j
public class CrmOpportunityOutCostController {
    private final CrmOpportunityOutCostService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/outCost/insert")
    public TwOutputUtil insert(CrmOpportunityOutCostPayload payload) {
        CrmOpportunityOutCostVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }


    @PostMapping("/oppo/outCost/submit/{id}")
    //@GlobalTransactional
    public TwOutputUtil submit(@PathVariable Long id) {
        service.submit(id);
        return TwOutputUtil.ok();
    }

    /**
     * 根据主键查询
     *
     * @param id
     * @return result
     */
    @GetMapping("/oppo/outCost/queryById/{id}")
    public TwOutputUtil queryById(@PathVariable Long id) {
        return TwOutputUtil.ok(service.queryById(id));
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/outCost/update")
    public TwOutputUtil update(CrmOpportunityOutCostPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @param oppoId 商机id
     * @return result
     */
    @GetMapping("/oppo/outCost/queryList")
    @UdcNameClass
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.OUTCOST_PAGE, type = FunctionTypeEnum.TAB, referDomain = {PermissionDomainEnum.BUSINESS_OPPORTUNITY})
    })
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(service.queryList(oppoId));
    }


    /**
     * 删除
     *
     * @param oppoId 商机id
     * @param keys   主键id
     * @return result
     */
    @DeleteMapping("/oppo/outCost/deleteSoft")
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
