package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.crm.repo.*;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectMemberDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityRepo repo;
    private final CrmOpportunitySalesRepo repoSales;
    private final CrmOpportunityStakeholderRepo repoStakeholder;
    private final CrmOpportunityPartnerRepo repoPartner;
    private final CrmOpportunityCompetitorRepo repoCompetitor;
    private final CrmOpportunityAnalyzeRepo repoAnalyze;

    private final QCrmOpportunityDO qdo = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QPrjProjectDO qdoProject1 = new QPrjProjectDO("qdoProject1");
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QPrjProjectMemberDO qdoMember = QPrjProjectMemberDO.prjProjectMemberDO;
    private final QCrmActActivityDO qdoActivity = QCrmActActivityDO.crmActActivityDO;

    private final QCrmOpportunitySalesDO qdoSales = QCrmOpportunitySalesDO.crmOpportunitySalesDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunityDO save(CrmOpportunityDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActProjectVO> getJpaQuerySelectProject() {
        JPAQuery<CrmActProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActProjectVO.class,
                qdoProject.id,
                qdoProject.projectName,
                qdoProject.projectNo,
                qdoProject.manageUserId,
                qdoProject.orgId,
                qdoProject.projectStatus,
                qdoProject.closeReason,
                qdoEmployee.employeeName.as("manageUserName"),
                qdo.codeliUserId,
                qdo.oppoIdV4,
                qdo.deliUserId,
                qdo.preSaleUserId,
                qdo.preSaleOrgId,
                qdo.coUserId,
                qdoProject.createUserId,
                qdoProject.creator,
                qdoProject.createTime
        )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue())).leftJoin(qdoEmployee).on(qdoEmployee.userId.longValue().eq(qdoProject.manageUserId.longValue()));
        return jpaQuery;
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmActProjectVO queryProjectBykey(Long key) {
        JPAQuery<CrmActProjectVO> jpaQuery = getJpaQuerySelectProject();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象项目
     * @return 修改的行数
     */
    public long updateProjectByKeyDynamic(CrmOpportunityPayload payload, Long projectId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoProject)
                .where(qdoProject.id.eq(projectId));
        if (payload.getProjectName() != null) {
            update.set(qdoProject.projectName, payload.getProjectName());
        }
        if (payload.getManageUserId() != null) {
            update.set(qdoProject.manageUserId, payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(qdoProject.orgId, payload.getOrgId());
        }
        if (payload.getCompanyId() != null) {
            update.set(qdoProject.companyId, payload.getCompanyId());
        }
        if (payload.getFileCodes() != null) {
            update.set(qdoProject.fileCodes, payload.getFileCodes());
        }
        if (payload.getLoseReason() != null) {
            update.set(qdoProject.loseReason, payload.getLoseReason());
        }
        if (payload.getCloseReason() != null) {
            update.set(qdoProject.closeReason, payload.getCloseReason());
        }
        if (payload.getClsoeRemark() != null) {
            update.set(qdoProject.clsoeRemark, payload.getClsoeRemark());
        }
        if (payload.getProjectStatus() != null) {
            update.set(qdoProject.projectStatus, payload.getProjectStatus());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("closeReason")) {
                update.setNull(qdoProject.closeReason);
            }
        }
        // 执行修改
        return update.execute();
    }


    @Transactional
    public long updateByKeyDynamic(CrmOpportunityPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getActId() != null) {
            update.set(qdo.actId, payload.getActId());
        }
        if (payload.getLeadsId() != null) {
            update.set(qdo.leadsId, payload.getLeadsId());
        }
        if (payload.getOppoIdV4() != null) {
            update.set(qdo.oppoIdV4, payload.getOppoIdV4());
        }
        if (payload.getSaleProduct() != null) {
            update.set(qdo.saleProduct, payload.getSaleProduct());
        }
        if (payload.getCustRegion() != null) {
            update.set(qdo.custRegion, payload.getCustRegion());
        }
        if (payload.getCustBookId() != null) {
            update.set(qdo.custBookId, payload.getCustBookId());
        }
        if (payload.getCustBookName() != null) {
            update.set(qdo.custBookName, payload.getCustBookName());
        }
        if (payload.getCustProject() != null) {
            update.set(qdo.custProject, payload.getCustProject());
        }
        if (payload.getContactName() != null) {
            update.set(qdo.contactName, payload.getContactName());
        }
        if (payload.getContactPhone() != null) {
            update.set(qdo.contactPhone, payload.getContactPhone());
        }
        if (payload.getContactDept() != null) {
            update.set(qdo.contactDept, payload.getContactDept());
        }
        if (payload.getContactPosition() != null) {
            update.set(qdo.contactPosition, payload.getContactPosition());
        }
        if (payload.getContactWebsite() != null) {
            update.set(qdo.contactWebsite, payload.getContactWebsite());
        }
        if (payload.getCustProp() != null) {
            update.set(qdo.custProp, payload.getCustProp());
        }
        if (payload.getCustIdst() != null) {
            update.set(qdo.custIdst, payload.getCustIdst());
        }
        if (payload.getForecastWinDate() != null) {
            update.set(qdo.forecastWinDate, payload.getForecastWinDate());
        }
        if (payload.getForecastAmount() != null) {
            update.set(qdo.forecastAmount, payload.getForecastAmount());
        }
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        if (payload.getSalePhase() != null) {
            update.set(qdo.salePhase, payload.getSalePhase());
        }
        if (payload.getDeliveryAddress() != null) {
            update.set(qdo.deliveryAddress, payload.getDeliveryAddress());
        }
        if (payload.getOppoLevel() != null) {
            update.set(qdo.oppoLevel, payload.getOppoLevel());
        }
        if (payload.getIsNeedPartner() != null) {
            update.set(qdo.isNeedPartner, payload.getIsNeedPartner());
        }
        if (payload.getCoopBookId() != null) {
            update.set(qdo.coopBookId, payload.getCoopBookId());
        }
        if (payload.getCoopBookName() != null) {
            update.set(qdo.coopBookName, payload.getCoopBookName());
        }
        if (payload.getPartnerDesc() != null) {
            update.set(qdo.partnerDesc, payload.getPartnerDesc());
        }
        if (payload.getPreSaleOrgId() != null) {
            update.set(qdo.preSaleOrgId, payload.getPreSaleOrgId());
        }
        if (payload.getPreSaleUserId() != null) {
            update.set(qdo.preSaleUserId, payload.getPreSaleUserId());
        }
        if (payload.getProjectDifficult() != null) {
            update.set(qdo.projectDifficult, payload.getProjectDifficult());
        }
        if (payload.getProjectImportance() != null) {
            update.set(qdo.projectImportance, payload.getProjectImportance());
        }
        if (payload.getProbability() != null) {
            update.set(qdo.probability, payload.getProbability());
        }
        if (payload.getDeliOrgId() != null) {
            update.set(qdo.deliOrgId, payload.getDeliOrgId());
        }
        if (payload.getProbabilityHint() != null) {
            update.set(qdo.probabilityHint, payload.getProbabilityHint());
        }
        if (payload.getDeliUserId() != null) {
            update.set(qdo.deliUserId, payload.getDeliUserId());
        }
        if (payload.getSolutionDifficulty() != null) {
            update.set(qdo.solutionDifficulty, payload.getSolutionDifficulty());
        }
        if (payload.getSolutionImportance() != null) {
            update.set(qdo.solutionImportance, payload.getSolutionImportance());
        }
        if (payload.getCoUserId() != null) {
            update.set(qdo.coUserId, payload.getCoUserId());
        }
        if (payload.getSourceType() != null) {
            update.set(qdo.sourceType, payload.getSourceType());
        }
        if (payload.getInternalOrgId() != null) {
            update.set(qdo.internalOrgId, payload.getInternalOrgId());
        }
        if (payload.getInternalUserId() != null) {
            update.set(qdo.internalUserId, payload.getInternalUserId());
        }
        if (payload.getExternalIden() != null) {
            update.set(qdo.externalIden, payload.getExternalIden());
        }
        if (payload.getExternalName() != null) {
            update.set(qdo.externalName, payload.getExternalName());
        }

        if (payload.getProbability() != null) {
            update.set(qdo.probability, payload.getProbability());
        }
        if (payload.getProbabilityHint() != null) {
            update.set(qdo.probabilityHint, payload.getProbabilityHint());
        }
        if (payload.getItemId() != null) {
            update.set(qdo.itemId, payload.getItemId());
        }
        // 外部来源电话
        if (payload.getExternalPhone() != null) {
            update.set(qdo.externalPhone, payload.getExternalPhone());
        }
        // 利益承诺
        if (payload.getProfitDesc() != null) {
            update.set(qdo.profitDesc, payload.getProfitDesc());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getOppoIdV4() != null) {
            update.set(qdo.oppoIdV4, payload.getOppoIdV4());
        }
        // 客户id
        if (payload.getCustBookId() != null) {
            update.set(qdo.custBookId, payload.getCustBookId());
        }
        // 客户名称
        if (payload.getCustBookName() != null) {
            update.set(qdo.custBookName, payload.getCustBookName());
        }
        // 关联合作伙伴Id
        if (payload.getCoopBookId() != null) {
            update.set(qdo.coopBookId, payload.getCoopBookId());
        }
        // 关联合作伙伴名称
        if (payload.getCoopBookName() != null) {
            update.set(qdo.coopBookName, payload.getCoopBookName());
        }
        if (payload.getActId() != null) {
            update.set(qdo.actId, payload.getActId());
        }
        if (payload.getFormalCustomerId() != null) {
            update.set(qdo.formalCustomerId, payload.getFormalCustomerId());
        }
        // 验证状态[crm:oppo:check_status]
        if (payload.getCheckStatus() != null) {
            update.set(qdo.checkStatus, payload.getCheckStatus());
        }
        // 客户跟进级别
//        if (payload.getCustomerGrade() != null) {
//            update.set(qdo.customerGrade, payload.getCustomerGrade());
//        }
        // 是否实施过本公司产品
        if (payload.getIsImplementation() != null) {
            update.set(qdo.isImplementation, payload.getIsImplementation());
        }
        // 实施情况
        if (payload.getImplementCondition() != null) {
            update.set(qdo.implementCondition, payload.getImplementCondition());
        }
        // 上线要求
        if (payload.getOnboarding() != null) {
            update.set(qdo.onboarding, payload.getOnboarding());
        }
        // 项目预算情况
        if (payload.getProResource() != null) {
            update.set(qdo.proResource, payload.getProResource());
        }
        // 项目发起原因
        if (payload.getProInitiateReason() != null) {
            update.set(qdo.proInitiateReason, payload.getProInitiateReason());
        }
        // 项目关键决策人描述
        if (payload.getProPolicymakerDesc() != null) {
            update.set(qdo.proPolicymakerDesc, payload.getProPolicymakerDesc());
        }
        // 接触部门描述
//        if (payload.getContactbudesc() != null) {
//            update.set(qdo.contactbudesc, payload.getContactbudesc());
//        }
        // 涉及本公司产品与服务
        if (payload.getProductServe() != null) {
            update.set(qdo.productServe, payload.getProductServe());
        }
        // 对标客户
        if (payload.getBenchmarkingCust() != null) {
            update.set(qdo.benchmarkingCust, payload.getBenchmarkingCust());
        }
        // 客户年营业额（万元）
        if (payload.getCustTurnoverYear() != null) {
            update.set(qdo.custTurnoverYear, payload.getCustTurnoverYear());
        }
        // 是否是上市公司
        if (payload.getIsListedCompany() != null) {
            update.set(qdo.isListedCompany, payload.getIsListedCompany());
        }
        // 方案情况(UDC)
        if (payload.getProgramSituation() != null) {
            update.set(qdo.programSituation, payload.getProgramSituation());
        }
        // 团队资源(UDC)
        if (payload.getTeamResources() != null) {
            update.set(qdo.teamResources, payload.getTeamResources());
        }
        // 商务资源(UDC)
        if (payload.getBusinessResources() != null) {
            update.set(qdo.businessResources, payload.getBusinessResources());
        }
        // 副售前负责人
        if (payload.getCodePreSaleUserId() != null) {
            update.set(qdo.codePreSaleUserId, payload.getCodePreSaleUserId());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        //上级主管部门
        if (!ObjectUtils.isEmpty(payload.getParentManageBu())) {
            update.set(qdo.parentManageBu, payload.getParentManageBu());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            if (nullFields.contains("projectId")) {
                update.setNull(qdo.projectId);
            }
            if (nullFields.contains("leadsId")) {
                update.setNull(qdo.leadsId);
            }
            // 销售产品
            if (nullFields.contains("saleProduct")) {
                update.setNull(qdo.saleProduct);
            }
            // 客户区域
            if (nullFields.contains("custRegion")) {
                update.setNull(qdo.custRegion);
            }
            // 是否老客户
            if (nullFields.contains("isOldCust")) {
                update.setNull(qdo.isOldCust);
            }
            // 客户项目
            if (nullFields.contains("custProject")) {
                update.setNull(qdo.custProject);
            }
            // 客户联系人
            if (nullFields.contains("contactName")) {
                update.setNull(qdo.contactName);
            }
            // 客户联系电话
            if (nullFields.contains("contactPhone")) {
                update.setNull(qdo.contactPhone);
            }
            // 客户联系人部门
            if (nullFields.contains("contactDept")) {
                update.setNull(qdo.contactDept);
            }
            // 客户联系人岗位
            if (nullFields.contains("contactPosition")) {
                update.setNull(qdo.contactPosition);
            }
            // 企业主页
            if (nullFields.contains("contactWebsite")) {
                update.setNull(qdo.contactWebsite);
            }
            // 客户性质
            if (nullFields.contains("custProp")) {
                update.setNull(qdo.custProp);
            }
            // 客户行业
            if (nullFields.contains("custIdst")) {
                update.setNull(qdo.custIdst);
            }
            // 预计成单日期
            if (nullFields.contains("forecastWinDate")) {
                update.setNull(qdo.forecastWinDate);
            }
            // 预计签单金额
            if (nullFields.contains("forecastAmount")) {
                update.setNull(qdo.forecastAmount);
            }
            // 成单概率
            if (nullFields.contains("probability")) {
                update.setNull(qdo.probability);
            }
            // 币种
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 销售阶段
            if (nullFields.contains("salePhase")) {
                update.setNull(qdo.salePhase);
            }
            // 交付地点
            if (nullFields.contains("deliveryAddress")) {
                update.setNull(qdo.deliveryAddress);
            }
            // 商机级别
            if (nullFields.contains("oppoLevel")) {
                update.setNull(qdo.oppoLevel);
            }
            // 是否需要合作伙伴
            if (nullFields.contains("isNeedPartner")) {
                update.setNull(qdo.isNeedPartner);
            }
            // 合作伙伴描述
            if (nullFields.contains("partnerDesc")) {
                update.setNull(qdo.partnerDesc);
            }
            // 售前bu
            if (nullFields.contains("preSaleOrgId")) {
                update.setNull(qdo.preSaleOrgId);
            }
            // 售前负责人
            if (nullFields.contains("preSaleUserId")) {
                update.setNull(qdo.preSaleUserId);
            }
            // 项目难度
            if (nullFields.contains("projectDifficult")) {
                update.setNull(qdo.projectDifficult);
            }
            // 项目重要度
            if (nullFields.contains("projectImportance")) {
                update.setNull(qdo.projectImportance);
            }
            // 交付BU_ID
            if (nullFields.contains("deliOrgId")) {
                update.setNull(qdo.deliOrgId);
            }
            // 交付负责人ID
            if (nullFields.contains("deliUserId")) {
                update.setNull(qdo.deliUserId);
            }
            // 方案难度
            if (nullFields.contains("solutionDifficulty")) {
                update.setNull(qdo.solutionDifficulty);
            }
            // 方案重要度
            if (nullFields.contains("solutionImportance")) {
                update.setNull(qdo.solutionImportance);
            }
            // 合作(副)签单BU_ID
            if (nullFields.contains("coOrgId")) {
                update.setNull(qdo.coOrgId);
            }
            // 合作(副)签单负责人ID
            if (nullFields.contains("coUserId")) {
                update.setNull(qdo.coUserId);
            }
            // 合作(副)交付BU_ID
            if (nullFields.contains("codeliOrgId")) {
                update.setNull(qdo.codeliOrgId);
            }
            // 合作(副)交付负责人ID
            if (nullFields.contains("codeliUserId")) {
                update.setNull(qdo.codeliUserId);
            }
            // 来源类型
            if (nullFields.contains("sourceType")) {
                update.setNull(qdo.sourceType);
            }
            // 内部来源BU_ID
            if (nullFields.contains("internalOrgId")) {
                update.setNull(qdo.internalOrgId);
            }
            // 内部来源人ID
            if (nullFields.contains("internalUserId")) {
                update.setNull(qdo.internalUserId);
            }
            // 外部线索来源
            if (nullFields.contains("externalIden")) {
                update.setNull(qdo.externalIden);
            }
            // 外部来源人
            if (nullFields.contains("externalName")) {
                update.setNull(qdo.externalName);
            }
            // 外部来源电话
            if (nullFields.contains("externalPhone")) {
                update.setNull(qdo.externalPhone);
            }
            // 利益承诺
            if (nullFields.contains("profitDesc")) {
                update.setNull(qdo.profitDesc);
            }
            if (nullFields.contains("extString1")) {
                update.setNull(qdo.extString1);
            }
            if (nullFields.contains("extString2")) {
                update.setNull(qdo.extString2);
            }
            if (nullFields.contains("extString3")) {
                update.setNull(qdo.extString3);
            }
            if (nullFields.contains("extString4")) {
                update.setNull(qdo.extString4);
            }
            if (nullFields.contains("extString5")) {
                update.setNull(qdo.extString5);
            }
            if (nullFields.contains("oppoIdV4")) {
                update.setNull(qdo.oppoIdV4);
            }
            // 客户id
            if (nullFields.contains("custBookId")) {
                update.setNull(qdo.custBookId);
            }
            // 客户名称
            if (nullFields.contains("custBookName")) {
                update.setNull(qdo.custBookName);
            }
            // 关联合作伙伴Id
            if (nullFields.contains("coopBookId")) {
                update.setNull(qdo.coopBookId);
            }
            // 关联合作伙伴名称
            if (nullFields.contains("coopBookName")) {
                update.setNull(qdo.coopBookName);
            }
            if (nullFields.contains("actId")) {
                update.setNull(qdo.actId);
            }
            if (nullFields.contains("formalCustomerId")) {
                update.setNull(qdo.formalCustomerId);
            }
            // 易稻壳对应itemId
            if (nullFields.contains("itemId")) {
                update.setNull(qdo.itemId);
            }
            // 验证状态[crm:oppo:check_status]
            if (nullFields.contains("checkStatus")) {
                update.setNull(qdo.checkStatus);
            }
            // 客户跟进级别
//            if (nullFields.contains("customerGrade")) {
//                update.setNull(qdo.customerGrade);
//            }
            // 是否实施过本公司产品
            if (nullFields.contains("isImplementation")) {
                update.setNull(qdo.isImplementation);
            }
            // 实施情况
            if (nullFields.contains("implementCondition")) {
                update.setNull(qdo.implementCondition);
            }
            // 上线要求
            if (nullFields.contains("onboarding")) {
                update.setNull(qdo.onboarding);
            }
            // 项目预算情况
            if (nullFields.contains("proResource")) {
                update.setNull(qdo.proResource);
            }
            // 项目发起原因
            if (nullFields.contains("proInitiateReason")) {
                update.setNull(qdo.proInitiateReason);
            }
            // 项目关键决策人描述
            if (nullFields.contains("proPolicymakerDesc")) {
                update.setNull(qdo.proPolicymakerDesc);
            }
            // 接触部门描述
//            if (nullFields.contains("contactbudesc")) {
//                update.setNull(qdo.contactbudesc);
//            }
            // 涉及本公司产品与服务
            if (nullFields.contains("productServe")) {
                update.setNull(qdo.productServe);
            }
            // 对标客户
            if (nullFields.contains("benchmarkingCust")) {
                update.setNull(qdo.benchmarkingCust);
            }
            // 客户年营业额（万元）
            if (nullFields.contains("custTurnoverYear")) {
                update.setNull(qdo.custTurnoverYear);
            }
            // 是否是上市公司
            if (nullFields.contains("isListedCompany")) {
                update.setNull(qdo.isListedCompany);
            }
            // 方案情况(UDC)
            if (nullFields.contains("programSituation")) {
                update.setNull(qdo.programSituation);
            }
            // 团队资源(UDC)
            if (nullFields.contains("teamResources")) {
                update.setNull(qdo.teamResources);
            }
            // 商务资源(UDC)
            if (nullFields.contains("businessResources")) {
                update.setNull(qdo.businessResources);
            }
            // 副售前负责人
            if (nullFields.contains("codePreSaleUserId")) {
                update.setNull(qdo.codePreSaleUserId);
            }
            // 成单概率不清楚原因
            if (nullFields.contains("probabilityHint")) {
                update.setNull(qdo.probabilityHint);
            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
            // 上级主管部门
            if (nullFields.contains("parentManageBu")) {
                update.setNull(qdo.parentManageBu);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityVO> getJpaQuerySelect() {
        JPAQuery<CrmOpportunityVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunityVO.class,
                        qdo.id,
                        qdo.projectId,
                        qdo.actId,
                        qdoProject1.projectName.as("actName"),
                        qdo.itemId,
                        qdoProject.projectName,
                        qdoProject.projectNo,
                        qdoProject.orgId,
                        qdoProject.manageUserId,
                        qdoProject.companyId,
                        qdoProject.fileCodes,
                        qdoProject.projectStatus,
                        qdoProject.closeReason,
                        qdoProject.loseReason,
                        qdoProject.clsoeRemark,
                        qdo.leadsId,
                        qdoLeads.leadsName,
                        qdo.saleProduct,
                        qdo.custRegion,
                        qdo.isOldCust,
                        qdo.custBookId,
                        qdo.custBookName,
                        qdo.custProject,
                        qdo.contactName,
                        qdo.contactPhone,
                        qdo.contactDept,
                        qdo.contactPosition,
                        qdo.contactWebsite,
                        qdo.custProp,
                        qdo.custIdst,
                        qdo.forecastWinDate,
                        qdo.forecastAmount,
                        qdo.probability,
                        qdo.probabilityHint,
                        qdo.currCode,
                        qdo.salePhase,
                        qdo.deliveryAddress,
                        qdo.oppoLevel,
                        qdo.isNeedPartner,
                        qdo.coopBookId,
                        qdo.coopBookName,
                        qdo.partnerDesc,
                        qdo.formalCustomerId,
                        qdo.preSaleOrgId,
                        qdo.preSaleUserId,
                        qdo.projectDifficult,
                        qdo.projectImportance,
                        qdo.deliOrgId,
                        qdo.deliUserId,
                        qdo.solutionDifficulty,
                        qdo.solutionImportance,
                        qdo.coOrgId,
                        qdo.coUserId,
                        qdo.codeliOrgId,
                        qdo.codeliUserId,
                        qdo.sourceType,
                        qdo.internalOrgId,
                        qdo.internalUserId,
                        qdo.externalIden,
                        qdo.externalName,
                        qdo.externalPhone,
                        qdo.profitDesc,
                        qdo.extString1,
                        qdo.extString2,
                        qdo.extString3,
                        qdo.extString4,
                        qdo.extString5,
                        qdo.remark,
                        qdo.oppoIdV4,
                        qdo.checkStatus,
                        qdoProject.createUserId,
                        qdoProject.creator,
                        qdoProject.createTime,
                        qdoLeads.demandProductOrg,
                        qdoLeads.marketChannel,
                        qdo.isImplementation,
                        qdo.implementCondition,
                        qdo.onboarding,
                        qdo.proResource,
                        qdo.proInitiateReason,
                        qdo.proPolicymakerDesc,
                        qdo.contactBUDesc,
                        qdo.productServe,
                        qdo.benchmarkingCust,
                        qdo.custTurnoverYear,
                        qdo.isListedCompany,
                        qdo.programSituation,
                        qdo.teamResources,
                        qdo.businessResources,
                        qdo.codePreSaleUserId,
                        qdo.parentManageBu
                )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue()))
                .leftJoin(qdoLeads).on(qdoLeads.id.longValue().eq(qdo.leadsId.longValue()))
                .leftJoin(qdoProject1).on(qdoProject1.id.longValue().eq(qdo.actId.longValue()))
                .leftJoin(qdoMember).on(qdoMember.projectId.longValue().eq(qdoProject.id.longValue()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityListVO> getJpaQuerySelectList() {
        JPAQuery<CrmOpportunityListVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunityListVO.class,
                qdo.id,
                qdo.projectId,
                qdo.preSaleUserId,
                qdo.preSaleOrgId,
                qdo.deliOrgId,
                qdo.deliUserId,
                qdo.forecastAmount,
                qdoProject.orgId,
                qdoProject.manageUserId,
                qdoProject.projectName,
                qdoProject.projectNo,
                qdoProject.projectStatus,
                qdoProject.eqvaPrice,
                qdo.custBookId,
                qdo.forecastWinDate,
                qdo.custBookName,
                qdo.oppoIdV4
        )).from(qdo).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdo.projectId.longValue()));
        return jpaQuery;
    }


    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmOpportunityVO queryByKey(Long key) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param oppoProjId 主键
     * @return
     * @Description 主键查询
     **/
    public CrmOpportunityVO queryByOppoProjId(Long oppoProjId) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.projectId.eq(oppoProjId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public CrmOpportunityDO queryByKeySimple(Long key) {
        CrmOpportunityDO entity = repo.findById(key).orElseGet(CrmOpportunityDO::new);
        return entity;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityVO> getJpaQueryWhere(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoProject.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getManageUserId())) {
            jpaQuery.where(qdoProject.manageUserId.eq(query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdoProject.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectNameOrNo())) {
            jpaQuery.where(qdoProject.projectName.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo())).or(qdoProject.projectNo.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo()))));
        }
        if (!ObjectUtils.isEmpty(query.getForecastWinDateRange())) {
            LocalDate startDate = null;
            LocalDate endDate = null;
            if ("0".equals(query.getForecastWinDateRange())) {
                endDate = LocalDate.now().plusMonths(3);
            }
            if ("1".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(3);
            }
            if ("2".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(6);
            }
            if (startDate != null) {
                jpaQuery.where(qdo.forecastWinDate.goe(startDate));
            }
            if (endDate != null) {
                jpaQuery.where(qdo.forecastWinDate.loe(endDate));
            }
        }
        if (!ObjectUtils.isEmpty(query.getPreSaleOrgId())) {
            jpaQuery.where(qdo.preSaleOrgId.eq(query.getPreSaleOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getPreSaleUserId())) {
            jpaQuery.where(qdo.preSaleUserId.eq(query.getPreSaleUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getDeliOrgId())) {
            jpaQuery.where(qdo.deliOrgId.eq(query.getDeliOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getDeliUserId())) {
            jpaQuery.where(qdo.deliUserId.eq(query.getDeliUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCustRegion())) {
            jpaQuery.where(qdo.custRegion.eq(query.getCustRegion()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectStatus())) {
            if ("0".equals(query.getProjectStatusType())) {
                jpaQuery.where(qdoProject.projectStatus.eq(query.getProjectStatus()));
            } else {
                jpaQuery.where(qdoProject.projectStatus.ne(query.getProjectStatus()));
            }
        }
        if (!ObjectUtils.isEmpty(query.getCustBookName())) {
            jpaQuery.where(qdo.custBookName.like(SqlUtil.toSqlLikeString(query.getCustBookName())));
        }
        if (!ObjectUtils.isEmpty(query.getOppoLevel())) {
            jpaQuery.where(qdo.oppoLevel.eq(query.getOppoLevel()));
        }
        if (!ObjectUtils.isEmpty(query.getLeadsId())) {
            jpaQuery.where(qdo.leadsId.eq(query.getLeadsId()));
        }
        if (!ObjectUtils.isEmpty(query.getCoopBookId())) {
            jpaQuery.where(qdo.coopBookId.eq(query.getCoopBookId()));
        }

        if (!ObjectUtils.isEmpty(query.getCoopBookName())) {
            jpaQuery.where(qdo.coopBookName.like(SqlUtil.toSqlLikeString(query.getCoopBookName())));
        }
        if (!ObjectUtils.isEmpty(query.getCoOrgId())) {
            jpaQuery.where(qdo.coOrgId.eq(query.getCoOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getCodeliOrgId())) {
            jpaQuery.where(qdo.codeliOrgId.eq(query.getCodeliOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getInternalOrgId())) {
            jpaQuery.where(qdo.internalOrgId.eq(query.getInternalOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getInternalUserId())) {
            jpaQuery.where(qdo.internalUserId.eq(query.getInternalUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCustIdst())) {
            jpaQuery.where(qdo.custIdst.eq(query.getCustIdst()));
        }
        if (!ObjectUtils.isEmpty(query.getFormalCustomerId())) {
            jpaQuery.where(qdo.formalCustomerId.eq(query.getFormalCustomerId()));
        }
        if (oppoUserIds != null && !oppoUserIds.isEmpty()) {
            Predicate temp = qdoMember.userId.in(oppoUserIds).or(qdoProject.manageUserId.in(oppoUserIds)).or(qdoProject.orgId.in(orgManageIds)).or(qdo.preSaleOrgId.in(orgManageIds))
                    .or(qdo.deliOrgId.in(orgManageIds)).or(qdo.coOrgId.in(orgManageIds)).or(qdo.codeliOrgId.in(orgManageIds)).or(qdo.internalOrgId.in(orgManageIds));
            if (CollectionUtils.isNotEmpty(sapPermissionOrgIdList)) {
                temp = ExpressionUtils.or(temp, qdo.preSaleOrgId.in(sapPermissionOrgIdList).or(qdo.deliOrgId.in(sapPermissionOrgIdList)));
            }
            jpaQuery.where(temp);
            jpaQuery.where(qdoMember.deleteFlag.eq(0));
        }

        if (!ObjectUtils.isEmpty(query.getOppoIds())) {
            jpaQuery.where(qdo.id.in(query.getOppoIds()));
//            jpaQuery.where(qdo.id.eq(1020l));
        }
        if (!ObjectUtils.isEmpty(query.getOppoIdsV4())) {
            jpaQuery.where(qdo.oppoIdV4.in(query.getOppoIdsV4()));
//            jpaQuery.where(qdo.id.eq(1020l));
        }
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            jpaQuery.where(qdo.sourceType.eq(query.getSourceType()));
        }
        if (StringUtils.isNotBlank(query.getCheckStatus())) {
            jpaQuery.where(qdo.checkStatus.eq(query.getCheckStatus()));
        }
        if (StringUtils.isNotBlank(query.getProjectImportance())) {
            jpaQuery.where(qdo.projectImportance.eq(query.getProjectImportance()));
        }
        jpaQuery.groupBy(qdoProject.id);
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
//        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(query.getOrders(), qdo, qdoProject));
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmOpportunityVO> queryPaging(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQueryWhere(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        QueryResults<CrmOpportunityVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<CrmOpportunityVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

//    /**
//     * sap部门 单独查询逻辑
//     * @param query 前端查询参数
//     * @param sapPermissionOrgIdList sap部门权限 orgId
//     * @param userId 登录用户id
//     * @return
//     */
//    @Deprecated
//    public PagingVO<CrmOpportunityVO> queryPagingForSap(CrmOpportunityQuery query, List<Long> sapPermissionOrgIdList, long userId) {
//        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQueryWhere(query, null, null);
//        if (CollectionUtils.isNotEmpty(sapPermissionOrgIdList)){
//            jpaQuery.where(qdo.preSaleOrgId.in(sapPermissionOrgIdList).or(qdo.deliOrgId.in(sapPermissionOrgIdList)));
//        } else {
//            jpaQuery.where(qdo.preSaleUserId.eq(userId));
//        }
//        QueryResults<CrmOpportunityVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
//        System.out.println(result.getTotal());
//        return PagingVO.<CrmOpportunityVO>builder().records(result.getResults()).total(result.getTotal()).build();
//    }

    public List<CrmOpportunityVO> queryList(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQueryWhere(query, oppoUserIds, orgManageIds, null);
        return jpaQuery.fetch();
    }

    public List<CrmOpportunityListVO> queryList() {
        JPAQuery<CrmOpportunityListVO> jpaQuery = getJpaQuerySelectList();
        jpaQuery.distinct().where(qdo.deleteFlag.eq(0));
        //   jpaQuery.where(qdoProject.projectStatus.eq("ACTIVE"));
        return jpaQuery.fetch();
    }

    public List<CrmOpportunityListVO> queryListDynamic(CrmOpportunityQuery query) {
        JPAQuery<CrmOpportunityListVO> jpaQuery = getJpaQuerySelectList();
        jpaQuery.distinct().where(qdo.deleteFlag.eq(0));
        if (query.getProjectStatus() != null) {
            jpaQuery.where(qdoProject.projectStatus.eq(query.getProjectStatus()));
        }
        if (query.getPreSaleUserId() != null) {
            jpaQuery.where(qdo.preSaleUserId.eq(query.getPreSaleUserId()));
        }
        if (query.getProjectId() != null) {
            jpaQuery.where(qdoProject.id.eq(query.getProjectId()));
        }
        if (query.getProjectIds() != null) {
            jpaQuery.where(qdoProject.id.in(query.getProjectIds()));
        }
        if (query.getIds() != null) {
            jpaQuery.where(qdo.id.in(query.getIds()));
        }
        if (query.getIsPermission()) {
            BooleanExpression orExpression = qdo.preSaleUserId.eq(query.getLoginUserId());
            if (!ObjectUtils.isEmpty(query.getPreSaleOrgIds())) {
                orExpression = orExpression.or(qdo.preSaleOrgId.in(query.getPreSaleOrgIds()));
            }
            jpaQuery.where(orExpression);
        }
        return jpaQuery.fetch();
    }

    /**
     * 修改流程状态
     *
     * @param key 主键
     * @return
     */
    public long updateStatus(Long key, String projectStatus) {

        JPAUpdateClause update = jpaQueryFactory.update(qdoProject)
                .set(qdoProject.projectStatus, projectStatus);
        update.where(qdoProject.id.eq(key));
        return update.execute();
    }

    /**
     * 获取员工数据
     *
     * @param userIds
     * @return
     */
    public List<Map<String, Object>> queryEmployees(Set<Long> userIds) {
        return repo.queryEmployees(userIds);
    }

    /**
     * 获取组织数据
     *
     * @param orgIds
     * @return
     */
    public List<Map<String, Object>> queryOrgs(Set<Long> orgIds) {
        return repo.queryOrgs(orgIds);
    }

    /**
     * 获取地址簿数据
     *
     * @param bookIds
     * @return
     */
    public List<Map<String, Object>> queryBooks(Set<Long> bookIds) {
        return repo.queryBookList(bookIds);
    }


    public List<Long> findNotBindOppos() {
        return repo.findNotBindOppos();
    }

    public Long getIdByV4(Long oppoIdV4) {
        return repo.getIdByV4(oppoIdV4) == null ? null : repo.getIdByV4(oppoIdV4).get(0);
    }


    public void deleteSoft(Long id) {
        repo.deleteSoft(id);
    }

    public List<Map<String, Object>> getV4AndV5OppoIds() {
        return repo.getV4AndV5OppoIds();
    }


    public long updateCheckStatus(Long oppoId, Boolean flag) {

        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.checkStatus, flag ? "1" : "0");
        update.where(qdo.id.eq(oppoId));
        return update.execute();
    }

    public List<Long> queryByFormalCustomerId(Long customerId) {
        return repo.queryByFormalCustomerId(customerId);
    }

    public List<CrmActProjectVO> queryListByCustomId(Long customId) {
        JPAQuery<CrmActProjectVO> jpaQuery = getJpaQuerySelectProject();
        jpaQuery.where(qdo.formalCustomerId.eq(customId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据商机编号查询商机
     *
     * @param projectNo 商机编号
     * @return 商机
     */
    public CrmOpportunityVO queryByProjectNo(String projectNo) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect().where(qdoProject.projectNo.eq(projectNo));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据签单BU查询商机
     *
     * @param orgIds 组织id
     * @return 商机
     */
    public List<CrmOpportunityVO> findByOrgIdIn(List<Long> orgIds) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect().where(qdoProject.orgId.in(orgIds));
        return jpaQuery.fetch();
    }

    public List<CrmOpportunityVO> findByMemberIdIdEq(Long userID) {
        JPAQuery<CrmOpportunityVO> jpaQuery = getJpaQuerySelect().where(qdoMember.userId.eq(userID));
        return jpaQuery.fetch();
    }

    /**
     * 根据商机编号查询签单BU
     *
     * @param docNo 商机编号
     * @return 签单BU
     */
    public Long findOrgIdByDocNo(String docNo) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(
                        qdoProject.orgId
                ).from(qdoProject)
                .where(qdoProject.projectNo.eq(docNo));
        return jpaQuery.fetchFirst();
    }
}
