package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityScoreConfigPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityScoreConfigVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityScoreConfigDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityScoreConfigRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 成单率分值配置
 *
 * @author likunpeng
 * @date 2023-11-02
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityScoreConfigDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityScoreConfigRepo repo;
    private final QCrmOpportunityScoreConfigDO qdo = QCrmOpportunityScoreConfigDO.crmOpportunityScoreConfigDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityScoreConfigVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CrmOpportunityScoreConfigVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 承担率
                qdo.probabilityName,
                // 分值区间1
                qdo.scoreMin,
                // 分值区间2
                qdo.scoreMax,
                // 说明
                qdo.imply
        )).from(qdo);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CrmOpportunityScoreConfigVO queryByKey(Long id) {
        JPAQuery<CrmOpportunityScoreConfigVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 查询所有
     * @return  List<CrmOpportunityScoreConfigVO>
     */
    public List<CrmOpportunityScoreConfigVO> queryAll() {
        JPAQuery<CrmOpportunityScoreConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

}

