package com.elitesland.tw.tw5.server.prd.crm.repo;

import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description
 * @date
 **/
public interface CrmCustomerRepo extends JpaRepository<CrmCustomerDO, Long>, QuerydslPredicateExecutor<CrmCustomerDO>, JpaSpecificationExecutor<CrmCustomerDO> {
    /**
     * 查询员工数据
     *
     * @param userIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT user_id as userId,employee_name as employeeName FROM prd_org_employee  where user_id in (?1) and delete_flag=0")
    List<Map<String, Object>> queryEmployees(List<Long> userIds);


    int countByCustomerNameAndDeleteFlag(String name,Integer deleteFlag);


    List<CrmCustomerDO> findByCustomerNameAndDeleteFlag(String name,Integer deleteFlag);

    @Query("select c.id from CrmCustomerDO c where c.deleteFlag=0 and c.bookId=?1")
    Long findIdByBookId(Long bookId);

    @Query(value = "SELECT count(id) FROM sale_con_contract WHERE CUST_ID=(select book_id from com_business_partner where id=?1 AND delete_flag=0) AND delete_flag=0 AND main_type='SUB'",nativeQuery = true)
    int queryContractNum(Long customerId);

    @Query(value = "select book_id from crm_customer where id=?1 AND delete_flag=0",nativeQuery = true)
    Long getCustBookId (Long customerId);
}
