package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.crm.constant.CrmOpportunityEnum;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityScoreConfigRepo;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityScoreConfigDAO;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityScoreConfigConvert;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityScoreConfigService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityScoreConfigPayload;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityScoreConfigDO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityScoreConfigVO;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.*;

/**
 * 成单率分值配置
 *
 * @author likunpeng
 * @date 2023-11-02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityScoreConfigServiceImpl extends BaseServiceImpl implements CrmOpportunityScoreConfigService {

    private final CrmOpportunityScoreConfigRepo crmOpportunityScoreConfigRepo;
    private final CrmOpportunityScoreConfigDAO crmOpportunityScoreConfigDAO;



    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<CrmOpportunityScoreConfigVO> insertOrUpdate(List<CrmOpportunityScoreConfigPayload> payloads) {
        if (payloads == null) {
            return null;
        }
        List<CrmOpportunityScoreConfigDO> list = new ArrayList<>(payloads.size());
        Map<String,CrmOpportunityScoreConfigPayload> map = new HashMap<>(payloads.size());
        payloads.forEach(payload -> map.put(payload.getProbabilityName(), payload));
        payloads.forEach(payload ->{
            BigDecimal scoreMin = payload.getScoreMin();
            BigDecimal scoreMax = payload.getScoreMax();
            if (scoreMin == null || scoreMax == null || scoreMin.compareTo(scoreMax) > 0) {
                throw TwException.error("","成单率分值区间不合法，请检查");
            }
            if (map.get(CrmOpportunityEnum.D.getCode()).getScoreMin().compareTo(BigDecimal.ZERO) != 0) {
                log.error("D-困难等级分数配置需从0开始");
                throw TwException.error("","D-困难等级分数配置需从0开始");
            }
            if (map.get(CrmOpportunityEnum.S.getCode()).getScoreMax().compareTo(new BigDecimal("100")) != 0) {
                log.error("S-已选择等级分数配置需从100结束");
                throw TwException.error("","S-已选择等级分数配置需从100结束");
            }
            if (map.get(CrmOpportunityEnum.C.getCode()).getScoreMin().compareTo(map.get(CrmOpportunityEnum.D.getCode()).getScoreMax()) != 0) {
                log.error("C-有竞争性的最小值应等于D-困难的最大值");
                throw TwException.error("","C-有竞争性的最小值应等于D-困难的最大值");
            }
            if (map.get(CrmOpportunityEnum.P.getCode()).getScoreMin().compareTo(map.get(CrmOpportunityEnum.C.getCode()).getScoreMax()) != 0) {
                log.error("P-有倾向的最小值应等于C-有竞争性的最大值");
                throw TwException.error("","P-有倾向的最小值应等于C-有竞争性的最大值");
            }
            if (map.get(CrmOpportunityEnum.S.getCode()).getScoreMin().compareTo(map.get(CrmOpportunityEnum.P.getCode()).getScoreMax()) != 0) {
                log.error("S-已选择的最小值应等于P-有倾向的最大值");
                throw TwException.error("","S-已选择的最小值应等于P-有倾向的最大值");
            }
            CrmOpportunityScoreConfigDO entityDo = CrmOpportunityScoreConfigConvert.INSTANCE.toDo(payload);
            list.add(entityDo);
        });
        List<CrmOpportunityScoreConfigDO> list1 = crmOpportunityScoreConfigRepo.saveAll(list);
        List<CrmOpportunityScoreConfigVO> crmOpportunityScoreConfigVOList = new ArrayList<>(payloads.size());
        list1.forEach(entityDo ->{
            CrmOpportunityScoreConfigVO crmOpportunityScoreConfigVO = CrmOpportunityScoreConfigConvert.INSTANCE.toVo(crmOpportunityScoreConfigRepo.save(entityDo));
            crmOpportunityScoreConfigVOList.add(crmOpportunityScoreConfigVO);
        });
        return crmOpportunityScoreConfigVOList;
    }

    @Override
    public List<CrmOpportunityScoreConfigVO> queryAll() {
        return crmOpportunityScoreConfigDAO.queryAll();
    }


}
