package com.elitesland.tw.tw5.server.prd.funConfig.controller;

import com.elitesland.tw.tw5.api.common.funConfig.dto.BusinessPageJsonDTO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessPageService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.PrdUserDataForFunConfigVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessPartnerCustomerVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.funConfig.util.BusinessPageJsonUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 页面配置
 *
 * @author duwh
 * @folder 页面配置
 * @date 2023-06-20
 */
@Api(tags = "页面配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/funConfig/businessPage")
@Slf4j
public class CrmBusinessPageController {

    private final BusinessPageService businessPageService;
    private final PrdUserService prdUserService;
    private final CacheUtil cacheUtil;
    private final BusinessPartnerService businessPartnerService;
    private final BusinessCustomerInfoService businessCustomerInfoService;


    /**
     * crm页面配置-查询列表
     *
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("crm页面配置-查询列表")
    public TwOutputUtil queryList(Long partnerId, String taskType, BusinessPageQuery query) {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<BusinessPageVO> list = businessPageService.queryListDynamic(query);
        if (CollectionUtils.isEmpty(list)) {
            return TwOutputUtil.ok(resultList);
        }
//        if (null == partnerId) {
//            return TwOutputUtil.error("partnerId不能为空");
//        }
        if (ObjectUtils.isEmpty(taskType)) {
            return TwOutputUtil.error("taskType不能为空");
        }
        Map<String, Object> param = new HashMap<>();

        if (null != partnerId) {
            BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(partnerId);
            BusinessPartnerCustomerVO partnerCustomerVO = new BusinessPartnerCustomerVO();
            BeanUtils.copyProperties(businessPartnerVO, partnerCustomerVO);
            partnerCustomerVO.setId(businessPartnerVO.getId().toString());
            partnerCustomerVO.setBookId(businessPartnerVO.getBookId() != null ? businessPartnerVO.getBookId().toString() : "");


            BusinessCustomerInfoQuery customerInfoQuery = new BusinessCustomerInfoQuery();
            customerInfoQuery.setPartnerId(partnerId);
            List<BusinessCustomerInfoVO> businessCustomerInfoVOS = businessCustomerInfoService.queryListDynamic(customerInfoQuery);
            BusinessCustomerInfoVO customerInfo;
            if (CollectionUtils.isEmpty(businessCustomerInfoVOS)) {
                return TwOutputUtil.error("客户不存在");
            } else {
                customerInfo = businessCustomerInfoVOS.get(0);
                partnerCustomerVO.setCustomerInfo(customerInfo);
//                param.put("customerInfo", customerInfo);
            }

            param.put("partner", partnerCustomerVO);
        }

        PrdUserDataVO userInfoBase = prdUserService.getUserInfoBase();
        // Long类型转String 方便表达式解析
        PrdUserDataForFunConfigVO userDataForFunConfigVO = new PrdUserDataForFunConfigVO();
        BeanUtils.copyProperties(userInfoBase, userDataForFunConfigVO);
        userDataForFunConfigVO.setUserId(null != userInfoBase.getUserId() ? userInfoBase.getUserId().toString() : "");
        userDataForFunConfigVO.setBookId(null != userInfoBase.getBookId() ? userInfoBase.getBookId().toString() : "");
        userDataForFunConfigVO.setOrgId(null != userInfoBase.getOrgId() ? userInfoBase.getOrgId().toString() : "");
        param.put("twUser", userDataForFunConfigVO);
//        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
//        param.put("cloudUser", loginGeneralUser);

        Map<String, Object> visitTask = new HashMap<>();
        visitTask.put("taskType", taskType);
        param.put("visitTask", visitTask);

        list.forEach(businessPageVO -> {
            BusinessPageJsonDTO jsonDto = businessPageVO.getJsonDto();

            List<BusinessPageJsonDTO> pageJsonDTOList = BusinessPageJsonUtil.jsonToList(jsonDto);
            // 解析
            BusinessPageJsonUtil.parseExpression(pageJsonDTOList, param);

            if (!CollectionUtils.isEmpty(pageJsonDTOList)) {
                pageJsonDTOList.forEach(pageJsonDTO -> {
                    Object show = pageJsonDTO.getShow();
                    boolean flag = false;
                    if (show instanceof Boolean) {
                        flag = (Boolean) show;

                    } else if (show instanceof String) {
                        String showStr = show.toString();
                        if (showStr.equals("true")) {
                            flag = true;
                        }
                    }
                    if (flag) {
                        Map<String, Object> result1 = new HashMap<>();
                        result1.put("id", pageJsonDTO.getId());
                        result1.put("title", pageJsonDTO.getTitle());
                        resultList.add(result1);
                    }
                });
//                pageJsonDTOList.forEach(businessPageJsonDTO -> {
//                    Object show = businessPageJsonDTO.getShow();
//                    if (!ObjectUtils.isEmpty(show)) {
//                        if (show instanceof Boolean) {
//
//                        } else if (show instanceof String) {
//                            String showStr = show.toString();
//
//                            // 找到表达式
//                            List<String> resultFindAll = ReUtil.findAll(REGULAR, show.toString(), 0, new ArrayList<>());
//                            for (String result : resultFindAll) {
//                                log.info("result");
//                                log.info(result);
//
//                                // 替换 ${}
//                                String resultPro = result.replaceAll(REGULAR, "$1");
//                                // !!重要 解析表达式
//                                Object eval = null;
//                                try {
//                                    eval = ExpressionUtil.eval(resultPro, map);
//                                } catch (Exception e) {
//                                    log.error("页面配置解析表达式失败: 表达式：{}  上下文：{}", resultPro, map.toString(), e);
//                                }
//                                if (null != eval) {
//                                    showStr = showStr.replace(result, String.valueOf(eval));
//                                } else {
//                                    showStr = showStr.replace(result, "");
//                                }
//
//                                if (eval instanceof Boolean) {
//                                    Boolean flag = (Boolean) eval;
//                                    if (flag) {
//                                        Map<String, Object> result1 = new HashMap<>();
//                                        result1.put("id", businessPageJsonDTO.getId());
//                                        result1.put("name", businessPageJsonDTO.getName());
//                                        resultList.add(result1);
//                                    }
//                                }
//                                log.info("页面配置化=====resultPro");
//                                log.info(resultPro);
//                            }
//                            log.info("页面配置化=====resultFindAll");
//                            System.out.println(resultFindAll);
//                            show = showStr;
//                        } else {
//                            show = false;
//                        }
//                        businessPageJsonDTO.setShow(show);
//                    }
//                });
            }
        });
        return TwOutputUtil.ok(resultList);
    }

}

