package com.elitesland.tw.tw5.server.prd.humanresources.ability.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdAbilityLevelPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-26
 * @desc : 能力级别定义
 */

@RestController
@RequestMapping("/api/prdAbilityLevel")
@RequiredArgsConstructor
@Api(value = "能力级别定义", tags = {"能力级别定义"})
public class PrdAbilityLevelController{

    private final PrdAbilityLevelService prdAbilityLevelService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-能力级别定义")
    public TwOutputUtil<PrdAbilityLevelVO> get(@PathVariable Long id) {

        PrdAbilityLevelVO res = prdAbilityLevelService.get(id);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("getByAbilityId/{id}")
    @ApiOperation("根据能力id查找-能力级别定义")
    public TwOutputUtil<List<PrdAbilityLevelVO>> getByAbilityId(@PathVariable Long abilityId) {

        List<PrdAbilityLevelVO> res = prdAbilityLevelService.getByAbilityId(abilityId);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("save")
    @ApiOperation("新增-能力级别定义")
    public TwOutputUtil<Long> save(@RequestBody PrdAbilityLevelPayload prdAbilityLevelPayload) {

        PrdAbilityLevelVO res = prdAbilityLevelService.save(prdAbilityLevelPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-能力级别定义")
    public TwOutputUtil<Long> update(@RequestBody PrdAbilityLevelPayload prdAbilityLevelPayload) {

        PrdAbilityLevelVO res = prdAbilityLevelService.update(prdAbilityLevelPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-能力级别定义")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdAbilityLevelService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-能力级别定义")
    public TwOutputUtil<PagingVO<PrdAbilityLevelVO>> page(PrdAbilityLevelQuery prdAbilityLevelQuery) {

        PagingVO<PrdAbilityLevelVO> res = prdAbilityLevelService.page(prdAbilityLevelQuery);
        return TwOutputUtil.ok(res);

    }



}

