package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdAbilityLevelPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdAbilityLevelDO;

import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdAbilityLevelRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdAbilityLevelDao;

import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdAbilityLevelConvert;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 能力级别定义Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdAbilityLevelServiceImpl implements PrdAbilityLevelService {


    private final PrdAbilityLevelDao prdAbilityLevelDao;

    private final PrdAbilityLevelRepo prdAbilityLevelRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdAbilityLevelVO save(PrdAbilityLevelPayload prdAbilityLevelPayload) {

        checkData(prdAbilityLevelPayload);
        PrdAbilityLevelDO prdAbilityLevelDO = new PrdAbilityLevelDO();
        prdAbilityLevelDO = PrdAbilityLevelConvert.INSTANCE.p2d(prdAbilityLevelPayload);
        PrdAbilityLevelDO res = prdAbilityLevelRepo.save(prdAbilityLevelDO);
        return PrdAbilityLevelConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdAbilityLevelVO update(PrdAbilityLevelPayload prdAbilityLevelPayload) {

        Assert.notNull(prdAbilityLevelPayload.getId(), "id is null");
        PrdAbilityLevelVO res = save(prdAbilityLevelPayload);
        return res;

    }


    @Override
    public PrdAbilityLevelVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdAbilityLevelVO res = prdAbilityLevelDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdAbilityLevelVO> page(PrdAbilityLevelQuery prdAbilityLevelQuery) {

        PagingVO<PrdAbilityLevelVO> res = prdAbilityLevelDao.page(prdAbilityLevelQuery);
        return res;

    }

    @Override
    public List<PrdAbilityLevelVO> getList(PrdAbilityLevelQuery prdAbilityLevelQuery) {

        List<PrdAbilityLevelVO> res = prdAbilityLevelDao.getList(prdAbilityLevelQuery);
        return res;

    }

    @Override
    @Transactional
    public Long delByAbilitId(Long id) {

        Long res = prdAbilityLevelDao.delByAbilitId(id);

        return res;
    }

    @Override
    public List<PrdAbilityLevelVO> getByAbilityId(Long abilityId) {

        PrdAbilityLevelQuery prdAbilityLevelQuery = new PrdAbilityLevelQuery();
        prdAbilityLevelQuery.setAbilityId(abilityId);
        List<PrdAbilityLevelVO> res = prdAbilityLevelDao.getList(prdAbilityLevelQuery);
        return res;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdAbilityLevelDao.del(ids);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdAbilityLevelPayload
     */
    private void checkData(PrdAbilityLevelPayload prdAbilityLevelPayload) {

//        if (StringUtils.isBlank(prdAbilityLevelPayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }

    }


}

