package com.elitesland.tw.tw5.server.prd.humanresources.basebu.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBuChangeTodoPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBuChangeTodoQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBuChangeTodoService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBuChangeTodoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-7
 * @desc : baseBU变更待办事项
 */

@RestController
@RequestMapping("/api/prdBuChangeTodo")
@RequiredArgsConstructor
@Api(value = "baseBU变更待办事项", tags = {"baseBU变更待办事项"})
public class PrdBuChangeTodoController {

    private final PrdBuChangeTodoService prdBuChangeTodoService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-baseBU变更待办事项")
    public TwOutputUtil<PrdBuChangeTodoVO> get(@PathVariable Long id) {

        PrdBuChangeTodoVO res = prdBuChangeTodoService.get(id);
        return TwOutputUtil.ok(res);

    }


//    @PostMapping("save")
//    @ApiOperation("新增-baseBU变更待办事项")
//    public TwOutputUtil<Long> save(@RequestBody PrdBuChangeTodoPayload prdBuChangeTodoPayload) {
//
//        PrdBuChangeTodoVO res = prdBuChangeTodoService.save(prdBuChangeTodoPayload);
//        return TwOutputUtil.ok(res.getId());
//
//    }


//    @PostMapping("update")
//    @ApiOperation("修改-baseBU变更待办事项")
//    public TwOutputUtil<Long> update(@RequestBody PrdBuChangeTodoPayload prdBuChangeTodoPayload) {
//
//        PrdBuChangeTodoVO res = prdBuChangeTodoService.update(prdBuChangeTodoPayload);
//        return TwOutputUtil.ok(res.getId());
//
//    }


    @DeleteMapping("del")
    @ApiOperation("删除-baseBU变更待办事项")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdBuChangeTodoService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-baseBU变更待办事项")
    public TwOutputUtil<PagingVO<PrdBuChangeTodoVO>> page(PrdBuChangeTodoQuery prdBuChangeTodoQuery) {

        PagingVO<PrdBuChangeTodoVO> res = prdBuChangeTodoService.page(prdBuChangeTodoQuery);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("updateByCondition")
    @ApiOperation("条件修改-baseBU变更待办事项")
    public TwOutputUtil<Long> updateByCondition(@RequestBody PrdBuChangeTodoPayload prdBuChangeTodoPayload) {

        Long res = prdBuChangeTodoService.updateByCondition(prdBuChangeTodoPayload);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("/getList")
    @UdcNameClass
    @ApiOperation("列表查询-baseBU变更待办事项")
    public TwOutputUtil<List<PrdBuChangeTodoVO>> getList(PrdBuChangeTodoQuery prdBuChangeTodoQuery, Long userId) {

        List<PrdBuChangeTodoVO> res = prdBuChangeTodoService.getList(prdBuChangeTodoQuery, userId);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("updateByBatch")
    @ApiOperation("批量修改-baseBU变更待办事项")
    public TwOutputUtil<Boolean> updateByBatch(@RequestBody List<PrdBuChangeTodoPayload> prdBuChangeTodoPayloadList) {

        Boolean res = prdBuChangeTodoService.updateByBatch(prdBuChangeTodoPayloadList);
        return TwOutputUtil.ok(res);

    }

}

