package com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseBuChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBaseBuChangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.QPrdBaseBuChangeDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-3
 * @desc : baseBu变更RepoProc
 */

@Component
public class PrdBaseBuChangeDao extends BaseRepoProc<PrdBaseBuChangeDO> {

    private static final QPrdBaseBuChangeDO qPrdBaseBuChangeDO = QPrdBaseBuChangeDO.prdBaseBuChangeDO;


    protected PrdBaseBuChangeDao() {

        super(qPrdBaseBuChangeDO);

    }


    public PagingVO<PrdBaseBuChangeVO> page(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        JPAQuery<PrdBaseBuChangeVO> query =
                select(PrdBaseBuChangeVO.class)
                        .where(bulidPredicate(prdBaseBuChangeQuery));
        prdBaseBuChangeQuery.setPaging(query);
        prdBaseBuChangeQuery.fillOrders(query, qPrdBaseBuChangeDO);
        return PagingVO.<PrdBaseBuChangeVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdBaseBuChangeDO)
                .set(qPrdBaseBuChangeDO.deleteFlag, 1)
                .where(qPrdBaseBuChangeDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdBaseBuChangeVO get(Long id) {

        PrdBaseBuChangeVO prdBaseBuChangeVO = select(PrdBaseBuChangeVO.class)
                .where(qPrdBaseBuChangeDO.id.eq(id))
                .fetchOne();
        return prdBaseBuChangeVO;

    }


    public List<PrdBaseBuChangeVO> getList(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        List<PrdBaseBuChangeVO> res =
                select(PrdBaseBuChangeVO.class)
                        .where(bulidPredicate(prdBaseBuChangeQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdBaseBuChangeDO.userId,
                        qPrdBaseBuChangeDO.empId,
                        qPrdBaseBuChangeDO.empName,
                        qPrdBaseBuChangeDO.oldPEmpId,
                        qPrdBaseBuChangeDO.oldPUserId,
                        qPrdBaseBuChangeDO.oldPEmpName,
                        qPrdBaseBuChangeDO.newPEmpId,
                        qPrdBaseBuChangeDO.newPUserId,
                        qPrdBaseBuChangeDO.newPEmpName,
                        qPrdBaseBuChangeDO.mainAbility,
                        qPrdBaseBuChangeDO.auxAbility,
                        qPrdBaseBuChangeDO.dlRatio,
                        qPrdBaseBuChangeDO.entryDate,
                        qPrdBaseBuChangeDO.oldJoinDate,
                        qPrdBaseBuChangeDO.newJoinDate,
                        qPrdBaseBuChangeDO.cooperateType,
                        qPrdBaseBuChangeDO.jobGrade,
                        qPrdBaseBuChangeDO.jobGradeActiveDate,
                        qPrdBaseBuChangeDO.salaryType,
                        qPrdBaseBuChangeDO.salaryCycle,
                        qPrdBaseBuChangeDO.oldBuId,
                        qPrdBaseBuChangeDO.oldBuName,
                        qPrdBaseBuChangeDO.newBuId,
                        qPrdBaseBuChangeDO.newBuName,
                        qPrdBaseBuChangeDO.oldRoleId,
                        qPrdBaseBuChangeDO.oldRoleCode,
                        qPrdBaseBuChangeDO.oldRoleName,
                        qPrdBaseBuChangeDO.newRoleId,
                        qPrdBaseBuChangeDO.newRoleCode,
                        qPrdBaseBuChangeDO.newRoleName,
                        qPrdBaseBuChangeDO.changeDesc,
                        qPrdBaseBuChangeDO.applyUserId,
                        qPrdBaseBuChangeDO.applyUserName,
                        qPrdBaseBuChangeDO.applyDate,
                        qPrdBaseBuChangeDO.id,
                        qPrdBaseBuChangeDO.createTime,
                        qPrdBaseBuChangeDO.oldDlRatio,
                        qPrdBaseBuChangeDO.remark

                )).from(qPrdBaseBuChangeDO);

    }


    private Predicate bulidPredicate(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(null != prdBaseBuChangeQuery.getUserId(), qPrdBaseBuChangeDO.userId, prdBaseBuChangeQuery.getUserId())
                .andEq(null != prdBaseBuChangeQuery.getEmpId(), qPrdBaseBuChangeDO.empId, prdBaseBuChangeQuery.getEmpId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getEmpName()), qPrdBaseBuChangeDO.empName, prdBaseBuChangeQuery.getEmpName())
                .andEq(null != prdBaseBuChangeQuery.getOldPEmpId(), qPrdBaseBuChangeDO.oldPEmpId, prdBaseBuChangeQuery.getOldPEmpId())
                .andEq(null != prdBaseBuChangeQuery.getOldPUserId(), qPrdBaseBuChangeDO.oldPUserId, prdBaseBuChangeQuery.getOldPUserId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getOldPEmpName()), qPrdBaseBuChangeDO.oldPEmpName, prdBaseBuChangeQuery.getOldPEmpName())
                .andEq(null != prdBaseBuChangeQuery.getNewPEmpId(), qPrdBaseBuChangeDO.newPEmpId, prdBaseBuChangeQuery.getNewPEmpId())
                .andEq(null != prdBaseBuChangeQuery.getNewPUserId(), qPrdBaseBuChangeDO.newPUserId, prdBaseBuChangeQuery.getNewPUserId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getNewPEmpName()), qPrdBaseBuChangeDO.newPEmpName, prdBaseBuChangeQuery.getNewPEmpName())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getMainAbility()), qPrdBaseBuChangeDO.mainAbility, prdBaseBuChangeQuery.getMainAbility())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getAuxAbility()), qPrdBaseBuChangeDO.auxAbility, prdBaseBuChangeQuery.getAuxAbility())
                .andEq(null != prdBaseBuChangeQuery.getDlRatio(), qPrdBaseBuChangeDO.dlRatio, prdBaseBuChangeQuery.getDlRatio())
                .andEq(null != prdBaseBuChangeQuery.getEntryDate(), qPrdBaseBuChangeDO.entryDate, prdBaseBuChangeQuery.getEntryDate())
                .andEq(null != prdBaseBuChangeQuery.getOldJoinDate(), qPrdBaseBuChangeDO.oldJoinDate, prdBaseBuChangeQuery.getOldJoinDate())
                .andEq(null != prdBaseBuChangeQuery.getNewJoinDate(), qPrdBaseBuChangeDO.newJoinDate, prdBaseBuChangeQuery.getNewJoinDate())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getCooperateType()), qPrdBaseBuChangeDO.cooperateType, prdBaseBuChangeQuery.getCooperateType())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getJobGrade()), qPrdBaseBuChangeDO.jobGrade, prdBaseBuChangeQuery.getJobGrade())
                .andEq(null != prdBaseBuChangeQuery.getJobGradeActiveDate(), qPrdBaseBuChangeDO.jobGradeActiveDate, prdBaseBuChangeQuery.getJobGradeActiveDate())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getSalaryType()), qPrdBaseBuChangeDO.salaryType, prdBaseBuChangeQuery.getSalaryType())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getSalaryCycle()), qPrdBaseBuChangeDO.salaryCycle, prdBaseBuChangeQuery.getSalaryCycle())
                .andEq(null != prdBaseBuChangeQuery.getOldBuId(), qPrdBaseBuChangeDO.oldBuId, prdBaseBuChangeQuery.getOldBuId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getOldBuName()), qPrdBaseBuChangeDO.oldBuName, prdBaseBuChangeQuery.getOldBuName())
                .andEq(null != prdBaseBuChangeQuery.getNewBuId(), qPrdBaseBuChangeDO.newBuId, prdBaseBuChangeQuery.getNewBuId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getNewBuName()), qPrdBaseBuChangeDO.newBuName, prdBaseBuChangeQuery.getNewBuName())
                .andEq(null != prdBaseBuChangeQuery.getOldRoleId(), qPrdBaseBuChangeDO.oldRoleId, prdBaseBuChangeQuery.getOldRoleId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getOldRoleCode()), qPrdBaseBuChangeDO.oldRoleCode, prdBaseBuChangeQuery.getOldRoleCode())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getOldRoleName()), qPrdBaseBuChangeDO.oldRoleName, prdBaseBuChangeQuery.getOldRoleName())
                .andEq(null != prdBaseBuChangeQuery.getNewRoleId(), qPrdBaseBuChangeDO.newRoleId, prdBaseBuChangeQuery.getNewRoleId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getNewRoleCode()), qPrdBaseBuChangeDO.newRoleCode, prdBaseBuChangeQuery.getNewRoleCode())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getNewRoleName()), qPrdBaseBuChangeDO.newRoleName, prdBaseBuChangeQuery.getNewRoleName())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getChangeDesc()), qPrdBaseBuChangeDO.changeDesc, prdBaseBuChangeQuery.getChangeDesc())
                .andEq(null != prdBaseBuChangeQuery.getApplyUserId(), qPrdBaseBuChangeDO.applyUserId, prdBaseBuChangeQuery.getApplyUserId())
                .andEq(StringUtils.isNotBlank(prdBaseBuChangeQuery.getApplyUserName()), qPrdBaseBuChangeDO.applyUserName, prdBaseBuChangeQuery.getApplyUserName())
                .andEq(null != prdBaseBuChangeQuery.getApplyDate(), qPrdBaseBuChangeDO.applyDate, prdBaseBuChangeQuery.getApplyDate())
                .andEq(null != prdBaseBuChangeQuery.getProcInstStatus(), qPrdBaseBuChangeDO.procInstStatus, prdBaseBuChangeQuery.getProcInstStatus())

                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 用户id
        if (null != prdBaseBuChangeQuery.getUserId()) {
            predicates.add(qPrdBaseBuChangeDO.userId.eq(prdBaseBuChangeQuery.getUserId()));
        }
        // 员工id
        if (null != prdBaseBuChangeQuery.getEmpId()) {
            predicates.add(qPrdBaseBuChangeDO.empId.eq(prdBaseBuChangeQuery.getEmpId()));
        }
        // 员工名称
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getEmpName())) {
            predicates.add(qPrdBaseBuChangeDO.empName.eq(prdBaseBuChangeQuery.getEmpName()));
        }
        // 原上级id
        if (null != prdBaseBuChangeQuery.getOldPEmpId()) {
            predicates.add(qPrdBaseBuChangeDO.oldPEmpId.eq(prdBaseBuChangeQuery.getOldPEmpId()));
        }
        // 原上级用户Id
        if (null != prdBaseBuChangeQuery.getOldPUserId()) {
            predicates.add(qPrdBaseBuChangeDO.oldPUserId.eq(prdBaseBuChangeQuery.getOldPUserId()));
        }
        // 原上级名称
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getOldPEmpName())) {
            predicates.add(qPrdBaseBuChangeDO.oldPEmpName.eq(prdBaseBuChangeQuery.getOldPEmpName()));
        }
        // 新上级id
        if (null != prdBaseBuChangeQuery.getNewPEmpId()) {
            predicates.add(qPrdBaseBuChangeDO.newPEmpId.eq(prdBaseBuChangeQuery.getNewPEmpId()));
        }
        // 新上级用户Id
        if (null != prdBaseBuChangeQuery.getNewPUserId()) {
            predicates.add(qPrdBaseBuChangeDO.newPUserId.eq(prdBaseBuChangeQuery.getNewPUserId()));
        }
        // 新上级名称
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getNewPEmpName())) {
            predicates.add(qPrdBaseBuChangeDO.newPEmpName.eq(prdBaseBuChangeQuery.getNewPEmpName()));
        }
        // 主能力
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getMainAbility())) {
            predicates.add(qPrdBaseBuChangeDO.mainAbility.eq(prdBaseBuChangeQuery.getMainAbility()));
        }
        // 次能力
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getAuxAbility())) {
            predicates.add(qPrdBaseBuChangeDO.auxAbility.eq(prdBaseBuChangeQuery.getAuxAbility()));
        }
        // 当量系数
        if (null != prdBaseBuChangeQuery.getDlRatio()) {
            predicates.add(qPrdBaseBuChangeDO.dlRatio.eq(prdBaseBuChangeQuery.getDlRatio()));
        }
        // 入职日期
        if (null != prdBaseBuChangeQuery.getEntryDate()) {
            predicates.add(qPrdBaseBuChangeDO.entryDate.eq(prdBaseBuChangeQuery.getEntryDate()));
        }
        // 原加入日期
        if (null != prdBaseBuChangeQuery.getOldJoinDate()) {
            predicates.add(qPrdBaseBuChangeDO.oldJoinDate.eq(prdBaseBuChangeQuery.getOldJoinDate()));
        }
        // 新加入日期
        if (null != prdBaseBuChangeQuery.getNewJoinDate()) {
            predicates.add(qPrdBaseBuChangeDO.newJoinDate.eq(prdBaseBuChangeQuery.getNewJoinDate()));
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getCooperateType())) {
            predicates.add(qPrdBaseBuChangeDO.cooperateType.eq(prdBaseBuChangeQuery.getCooperateType()));
        }
        // 职级
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getJobGrade())) {
            predicates.add(qPrdBaseBuChangeDO.jobGrade.eq(prdBaseBuChangeQuery.getJobGrade()));
        }
        // 职级生效日期
        if (null != prdBaseBuChangeQuery.getJobGradeActiveDate()) {
            predicates.add(qPrdBaseBuChangeDO.jobGradeActiveDate.eq(prdBaseBuChangeQuery.getJobGradeActiveDate()));
        }
        // 发薪方式
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getSalaryType())) {
            predicates.add(qPrdBaseBuChangeDO.salaryType.eq(prdBaseBuChangeQuery.getSalaryType()));
        }
        // 发薪周期
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getSalaryCycle())) {
            predicates.add(qPrdBaseBuChangeDO.salaryCycle.eq(prdBaseBuChangeQuery.getSalaryCycle()));
        }
        // 原buId
        if (null != prdBaseBuChangeQuery.getOldBuId()) {
            predicates.add(qPrdBaseBuChangeDO.oldBuId.eq(prdBaseBuChangeQuery.getOldBuId()));
        }
        // 原bu名称
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getOldBuName())) {
            predicates.add(qPrdBaseBuChangeDO.oldBuName.eq(prdBaseBuChangeQuery.getOldBuName()));
        }
        // 新buid
        if (null != prdBaseBuChangeQuery.getNewBuId()) {
            predicates.add(qPrdBaseBuChangeDO.newBuId.eq(prdBaseBuChangeQuery.getNewBuId()));
        }
        // 新bu名称
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getNewBuName())) {
            predicates.add(qPrdBaseBuChangeDO.newBuName.eq(prdBaseBuChangeQuery.getNewBuName()));
        }
        // 原角色id
        if (null != prdBaseBuChangeQuery.getOldRoleId()) {
            predicates.add(qPrdBaseBuChangeDO.oldRoleId.eq(prdBaseBuChangeQuery.getOldRoleId()));
        }
        // 原角色编码
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getOldRoleCode())) {
            predicates.add(qPrdBaseBuChangeDO.oldRoleCode.eq(prdBaseBuChangeQuery.getOldRoleCode()));
        }
        // 原角色名称
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getOldRoleName())) {
            predicates.add(qPrdBaseBuChangeDO.oldRoleName.eq(prdBaseBuChangeQuery.getOldRoleName()));
        }
        // 新角色id
        if (null != prdBaseBuChangeQuery.getNewRoleId()) {
            predicates.add(qPrdBaseBuChangeDO.newRoleId.eq(prdBaseBuChangeQuery.getNewRoleId()));
        }
        // 新角色编码
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getNewRoleCode())) {
            predicates.add(qPrdBaseBuChangeDO.newRoleCode.eq(prdBaseBuChangeQuery.getNewRoleCode()));
        }
        // 新角色名称
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getNewRoleName())) {
            predicates.add(qPrdBaseBuChangeDO.newRoleName.eq(prdBaseBuChangeQuery.getNewRoleName()));
        }
        // 变更说明
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getChangeDesc())) {
            predicates.add(qPrdBaseBuChangeDO.changeDesc.eq(prdBaseBuChangeQuery.getChangeDesc()));
        }
        // 申请人id
        if (null != prdBaseBuChangeQuery.getApplyUserId()) {
            predicates.add(qPrdBaseBuChangeDO.applyUserId.eq(prdBaseBuChangeQuery.getApplyUserId()));
        }
        // 申请人
        if (StringUtils.isNotEmpty(prdBaseBuChangeQuery.getApplyUserName())) {
            predicates.add(qPrdBaseBuChangeDO.applyUserName.eq(prdBaseBuChangeQuery.getApplyUserName()));
        }
        // 申请日期
        if (null != prdBaseBuChangeQuery.getApplyDate()) {
            predicates.add(qPrdBaseBuChangeDO.applyDate.eq(prdBaseBuChangeQuery.getApplyDate()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        long res = select(PrdBaseBuChangeVO.class)
                .where(bulidPredicate(prdBaseBuChangeQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdBaseBuChangePayload prdBaseBuChangePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdBaseBuChangeDO);

        // 用户id
        if (null != prdBaseBuChangePayload.getUserId()) {
            update.set(qPrdBaseBuChangeDO.userId, prdBaseBuChangePayload.getUserId());
        }
        // 员工id
        if (null != prdBaseBuChangePayload.getEmpId()) {
            update.set(qPrdBaseBuChangeDO.empId, prdBaseBuChangePayload.getEmpId());
        }
        // 员工名称
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getEmpName())) {
            update.set(qPrdBaseBuChangeDO.empName, prdBaseBuChangePayload.getEmpName());
        }
        // 原上级id
        if (null != prdBaseBuChangePayload.getOldPEmpId()) {
            update.set(qPrdBaseBuChangeDO.oldPEmpId, prdBaseBuChangePayload.getOldPEmpId());
        }
        // 原上级用户Id
        if (null != prdBaseBuChangePayload.getOldPUserId()) {
            update.set(qPrdBaseBuChangeDO.oldPUserId, prdBaseBuChangePayload.getOldPUserId());
        }
        // 原上级名称
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getOldPEmpName())) {
            update.set(qPrdBaseBuChangeDO.oldPEmpName, prdBaseBuChangePayload.getOldPEmpName());
        }
        // 新上级id
        if (null != prdBaseBuChangePayload.getNewPEmpId()) {
            update.set(qPrdBaseBuChangeDO.newPEmpId, prdBaseBuChangePayload.getNewPEmpId());
        }
        // 新上级用户Id
        if (null != prdBaseBuChangePayload.getNewPUserId()) {
            update.set(qPrdBaseBuChangeDO.newPUserId, prdBaseBuChangePayload.getNewPUserId());
        }
        // 新上级名称
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getNewPEmpName())) {
            update.set(qPrdBaseBuChangeDO.newPEmpName, prdBaseBuChangePayload.getNewPEmpName());
        }
        // 主能力
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getMainAbility())) {
            update.set(qPrdBaseBuChangeDO.mainAbility, prdBaseBuChangePayload.getMainAbility());
        }
        // 次能力
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getAuxAbility())) {
            update.set(qPrdBaseBuChangeDO.auxAbility, prdBaseBuChangePayload.getAuxAbility());
        }
        // 当量系数
        if (null != prdBaseBuChangePayload.getDlRatio()) {
            update.set(qPrdBaseBuChangeDO.dlRatio, prdBaseBuChangePayload.getDlRatio());
        }
        // 入职日期
        if (null != prdBaseBuChangePayload.getEntryDate()) {
            update.set(qPrdBaseBuChangeDO.entryDate, prdBaseBuChangePayload.getEntryDate());
        }
        // 原加入日期
        if (null != prdBaseBuChangePayload.getOldJoinDate()) {
            update.set(qPrdBaseBuChangeDO.oldJoinDate, prdBaseBuChangePayload.getOldJoinDate());
        }
        // 新加入日期
        if (null != prdBaseBuChangePayload.getNewJoinDate()) {
            update.set(qPrdBaseBuChangeDO.newJoinDate, prdBaseBuChangePayload.getNewJoinDate());
        }
        // 合作方式
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getCooperateType())) {
            update.set(qPrdBaseBuChangeDO.cooperateType, prdBaseBuChangePayload.getCooperateType());
        }
        // 职级
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getJobGrade())) {
            update.set(qPrdBaseBuChangeDO.jobGrade, prdBaseBuChangePayload.getJobGrade());
        }
        // 职级生效日期
        if (null != prdBaseBuChangePayload.getJobGradeActiveDate()) {
            update.set(qPrdBaseBuChangeDO.jobGradeActiveDate, prdBaseBuChangePayload.getJobGradeActiveDate());
        }
        // 发薪方式
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getSalaryType())) {
            update.set(qPrdBaseBuChangeDO.salaryType, prdBaseBuChangePayload.getSalaryType());
        }
        // 发薪周期
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getSalaryCycle())) {
            update.set(qPrdBaseBuChangeDO.salaryCycle, prdBaseBuChangePayload.getSalaryCycle());
        }
        // 原buId
        if (null != prdBaseBuChangePayload.getOldBuId()) {
            update.set(qPrdBaseBuChangeDO.oldBuId, prdBaseBuChangePayload.getOldBuId());
        }
        // 原bu名称
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getOldBuName())) {
            update.set(qPrdBaseBuChangeDO.oldBuName, prdBaseBuChangePayload.getOldBuName());
        }
        // 新buid
        if (null != prdBaseBuChangePayload.getNewBuId()) {
            update.set(qPrdBaseBuChangeDO.newBuId, prdBaseBuChangePayload.getNewBuId());
        }
        // 新bu名称
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getNewBuName())) {
            update.set(qPrdBaseBuChangeDO.newBuName, prdBaseBuChangePayload.getNewBuName());
        }
        // 原角色id
        if (null != prdBaseBuChangePayload.getOldRoleId()) {
            update.set(qPrdBaseBuChangeDO.oldRoleId, prdBaseBuChangePayload.getOldRoleId());
        }
        // 原角色编码
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getOldRoleCode())) {
            update.set(qPrdBaseBuChangeDO.oldRoleCode, prdBaseBuChangePayload.getOldRoleCode());
        }
        // 原角色名称
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getOldRoleName())) {
            update.set(qPrdBaseBuChangeDO.oldRoleName, prdBaseBuChangePayload.getOldRoleName());
        }
        // 新角色id
        if (null != prdBaseBuChangePayload.getNewRoleId()) {
            update.set(qPrdBaseBuChangeDO.newRoleId, prdBaseBuChangePayload.getNewRoleId());
        }
        // 新角色编码
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getNewRoleCode())) {
            update.set(qPrdBaseBuChangeDO.newRoleCode, prdBaseBuChangePayload.getNewRoleCode());
        }
        // 新角色名称
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getNewRoleName())) {
            update.set(qPrdBaseBuChangeDO.newRoleName, prdBaseBuChangePayload.getNewRoleName());
        }
        // 变更说明
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getChangeDesc())) {
            update.set(qPrdBaseBuChangeDO.changeDesc, prdBaseBuChangePayload.getChangeDesc());
        }
        // 申请人id
        if (null != prdBaseBuChangePayload.getApplyUserId()) {
            update.set(qPrdBaseBuChangeDO.applyUserId, prdBaseBuChangePayload.getApplyUserId());
        }
        // 申请人
        if (StringUtils.isNotEmpty(prdBaseBuChangePayload.getApplyUserName())) {
            update.set(qPrdBaseBuChangeDO.applyUserName, prdBaseBuChangePayload.getApplyUserName());
        }
        // 申请日期
        if (null != prdBaseBuChangePayload.getApplyDate()) {
            update.set(qPrdBaseBuChangeDO.applyDate, prdBaseBuChangePayload.getApplyDate());
        }
        // 申请日期
        if (null != prdBaseBuChangePayload.getProcInstId()) {
            update.set(qPrdBaseBuChangeDO.procInstId, prdBaseBuChangePayload.getProcInstId());
        }
        // 申请日期
        if (null != prdBaseBuChangePayload.getProcInstStatus()) {
            update.set(qPrdBaseBuChangeDO.procInstStatus, prdBaseBuChangePayload.getProcInstStatus());
        }
        // 处理要设置成空的字段
        List<String> nullFields = prdBaseBuChangePayload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qPrdBaseBuChangeDO.procInstStatus);
            }
            // 派发类型
            if (nullFields.contains("procInstId")) {
                update.setNull(qPrdBaseBuChangeDO.procInstId);
            }
            // 派发事由ID
            if (nullFields.contains("submitTime")) {
                update.setNull(qPrdBaseBuChangeDO.submitTime);
            }

        }
        long res = update.where(qPrdBaseBuChangeDO.id.eq(prdBaseBuChangePayload.getId()))
                .execute();
        return res;

    }

}

