package com.elitesland.tw.tw5.server.prd.humanresources.eval.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置表
 */

@RestController
@RequestMapping("/api/prdEvaluateConfig")
@RequiredArgsConstructor
@Api(value = "评价配置表", tags = {"评价配置表"})
public class PrdEvaluateConfigController {

    private final PrdEvaluateConfigService prdEvaluateConfigService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-评价配置表")
    public TwOutputUtil<PrdEvaluateConfigVO> get(@PathVariable Long id) {

        PrdEvaluateConfigVO res = prdEvaluateConfigService.get(id);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("getByCondition")
    @ApiOperation("根据评价条件查询主数据-评价配置表")
    public TwOutputUtil<PrdEvaluateConfigVO> getByCondition(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        PrdEvaluateConfigVO res = prdEvaluateConfigService.getByCondition(prdEvaluateConfigQuery);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-评价配置表")
    public TwOutputUtil<Long> save(@RequestBody PrdEvaluateConfigPayload prdEvaluateConfigPayload) {

        PrdEvaluateConfigVO res = prdEvaluateConfigService.save(prdEvaluateConfigPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-评价配置表")
    public TwOutputUtil<Long> update(@RequestBody PrdEvaluateConfigPayload prdEvaluateConfigPayload) {

        PrdEvaluateConfigVO res = prdEvaluateConfigService.update(prdEvaluateConfigPayload);
        return TwOutputUtil.ok(res.getId());

    }

    @PostMapping("updateState")
    @ApiOperation("修改-评价配置表状态")
    public TwOutputUtil<Long> updateState(@RequestBody PrdEvaluateConfigPayload prdEvaluateConfigPayload) {

        Long res = prdEvaluateConfigService.updateByCondition(prdEvaluateConfigPayload);
        return TwOutputUtil.ok(res);

    }

    @DeleteMapping("del")
    @ApiOperation("删除-评价配置表")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdEvaluateConfigService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-评价配置表")
    public TwOutputUtil<PagingVO<PrdEvaluateConfigVO>> page(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        PagingVO<PrdEvaluateConfigVO> res = prdEvaluateConfigService.page(prdEvaluateConfigQuery);
        return TwOutputUtil.ok(res);

    }


}

